

#include <stdarg.h>

void pr(char *fmt, ... ){
        char buf[128]; // resulting string limited to 128 chars
        va_list args;
        va_start (args, fmt );
        vsnprintf(buf, 128, fmt, args);
        va_end (args);
        Serial.println(buf);

}





#include <SerialCommand.h>


extern void __builtin_avr_delay_cycles(unsigned long __n);

// start and end half periods in processor cycles

#define STARTVALUE 120
#define ENDVALUE 260

int scanperiod=ENDVALUE;


// pins which drive the transmit transducer
// PWM on pins 9 and 10 (Timer 1)
#define OUT_PIN0 9
#define OUT_PIN1 10




// using Analogue input 1 for receiver input

#define ANINPUT 1




#define BUFFER_SIZE 1024


unsigned char buffer[BUFFER_SIZE];
volatile unsigned char * bufferp=buffer;
unsigned char * bufferlt=buffer+(BUFFER_SIZE-1);

 







void dumpdata(void)
{
 int i;

 for(i=0;i<BUFFER_SIZE;i++)
 {
  pr("%d",buffer[i]);
 }
}





//*** Process serial port commands

SerialCommand sCmd;



void cmdunrecognized(const char *command)
{
 Serial.println("What?"); 
}  


void cmdgetdata(void)
{
 scanperiod=STARTVALUE;
}




#define USPERIOD 195



// array with pairs of numebers 
// phase 0 count
// phase 1 count
// terminates with a 0 for the phase 0 count
// BUT the traling phase 1 count is loaded and has to be big enough
// for the interrupt to occur and turn off pwm - otherwise a trailing glitch
// is generated.




// pulse with phase change
unsigned int waveformdata[]=
{
// 0
USPERIOD,
USPERIOD,

 
 //1
USPERIOD,
USPERIOD,

 //2
USPERIOD,
USPERIOD,


 //3
//USPERIOD,
//USPERIOD,


 //4
USPERIOD,
USPERIOD,


 //5
USPERIOD,
USPERIOD,

 // stop
 0,
USPERIOD, // this one needs to be large

};


void setpwmfrequency(int phase1,int phase2)
{
 int i;

 for(i=0;i<sizeof(waveformdata)/sizeof(unsigned int);i+=2)
 {
  waveformdata[i]=phase1;
  waveformdata[i+1]=phase2;
 }
 waveformdata[i-2]=0;
}



unsigned int * waveform=waveformdata;




unsigned int wavepointer;
volatile unsigned int wavecount;

ISR(TIMER1_OVF_vect) 
{

}



void gopingpwm(void)
{
 pinMode(OUT_PIN0,OUTPUT);
 pinMode(OUT_PIN1,OUTPUT);

 digitalWrite(OUT_PIN0,1);
 
 TCCR1B = 0x0; // stop the clock
 TCNT1=0;
 TIFR1 = _BV(ICF1) | _BV(TOV1);  // clear any pending capture or overflow interrupts

 TCCR1A = _BV(COM1A1) | _BV(COM1B1) | _BV(COM1B0);    // put timer1 in normal mode

// TIMSK1 |= _BV(TOIE1);

 wavepointer=0;
 wavecount=100;
 ICR1=waveform[wavepointer]+waveform[wavepointer+1];
 OCR1A=waveform[wavepointer+1];
 OCR1B=waveform[wavepointer+1];
 wavepointer+=2;

 TCCR1A = _BV(COM1A1) | _BV(COM1B1) | _BV(COM1B0) | _BV(WGM11);

 OCR1A=waveform[wavepointer+1];
 OCR1B=waveform[wavepointer+1];
 
 TCCR1B = _BV(CS10) | _BV(WGM13) | _BV(WGM12); // start the clock
 

}

void clearpwm(void)
{
 TCCR1A = 0; // normal mode disconnect outputs
 TCCR1B = 0x1; // normal mode 
}



void shortpause(void)
{
 __builtin_avr_delay_cycles(USPERIOD*100);
 __builtin_avr_delay_cycles(USPERIOD*100);
 __builtin_avr_delay_cycles(USPERIOD*100);
 __builtin_avr_delay_cycles(USPERIOD*100);
 __builtin_avr_delay_cycles(USPERIOD*100);
 __builtin_avr_delay_cycles(USPERIOD*100);
}




void setup() 
{
 Serial.begin(9600);
 while (!Serial) { ; /* wait for serial port to connect. Needed for native USB */}


 sCmd.addCommand("get",cmdgetdata);  
 
 sCmd.setDefaultHandler(cmdunrecognized);  


 ADCSRA =  bit (ADEN);                      // turn ADC on
 ADCSRA |= bit (ADPS1); // | bit (ADPS0); //| bit (ADPS2);  // Prescaler of 128
 ADMUX  =  bit(ADLAR) | bit (REFS0) | (ANINPUT);    // AVcc and select input port 1

//Clear ADTS2..0 in ADCSRB
 ADCSRB &=~(bit(ADTS2) | bit(ADTS1) | bit(ADTS0));
}



void loop() 
{
 if(scanperiod<ENDVALUE)
 {
  setpwmfrequency(scanperiod,scanperiod-1);


  TIMSK0 &= ~_BV(TOIE0); // disable timer0 overflow interrupt

  shortpause();

  gopingpwm();

  shortpause();

  bufferp=buffer;

  ADCSRA |= bit (ADSC) | bit(ADATE);
loop1:;

  if(ADCSRA & bit(ADIF))
  {
   if(bufferp>=bufferlt)
   {
    ADCSRA &= ~ (bit (ADSC) | bit (ADIE) | bit(ADATE));

    goto loop2;
   }
   bufferp++;
   *bufferp=ADCH;
   ADCSRA|= bit(ADIF);
  }
  goto loop1;
 
loop2:;


  clearpwm();
 
  TIMSK0 |= _BV(TOIE0); // enable timer0 overflow interrupt

  pr("-1");
  pr("%d",scanperiod);
  dumpdata();
  scanperiod++;
 }
  
 if(Serial.available()>0) 
 {
  sCmd.readSerial();
 }

 delay(500);
}



