/*
* File:         special.c
* RCS:          $Header: $
* Description:  Exerciser application program for Twain
* Owner:        TWAIN Working Group
* Author:       TWAIN Working Group
* Created:      Jan 15,92
* Modified:     June 1993
* Language:     C
* Package:      N/A
* Status:       Test tool
*
* (c) Copyright 1992, Hewlett-Packard Company, all rights reserved.
*
*	Copyright  1998 TWAIN Working Group: Adobe Systems Incorporated, 
*	Canon Information Systems, Eastman Kodak Company, 
*	Fujitsu Computer Products of America, Genoa Technology, 
*	Hewlett-Packard Company, Intel Corporation, Kofax Image Products, 
*	JFL Peripheral Solutions Inc., Ricoh Corporation, and Xerox Corporation.  
*	All rights reserved.
*
* This code now uses triplets.c for all communication to the data source.
*/

//----------------------------------------------------------------------
//                          I n c l u d e s
//----------------------------------------------------------------------


#include "stdafx.h"

#include <windows.h>         // Req. for twain.h type defs and ...
#include <commdlg.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "os.h"
#include "wimp.h"
#include "wos.h"
#include "poll.h"

#include "twain.h"
#include "twndebug.h"

/*
#ifdef WIN32
#include "res_32.h"
#else
#include "res_16.h"
#endif

*/

#include "table.h"
#include "dca_glue.h"        // for function prototypes of glue code
#include "dca_type.h"        // contains function protos for this module
#include "dca_acq.h"         // contains buffered glue code function prototypes
#include "dca_app.h"
//#include "twacker.h"
#include "special.h"
#include "captest.h"
//#include "ctl3d.h"
//#include "triplets.h"








HWND g_hMainDlg = NULL;






/*
* Function: MatchTwainInt
* Author: TWAIN Working Group
* Input:
*		pTable - Pointer to a Table entry that contain the value for the initialization
*		uiTableSize - Maximum of item in table 
*		uiCap -	ID for the current capability 
*		pString - 
* Output:
*		TW_BOOL -	TRUE is successful
* Comments:
*/

TW_BOOL MatchTwainInt(pTABLEENTRY pTable, TW_UINT32 uiTableSize,
												TW_INT32 uiCapId, LPSTR pString)

{
	TW_BOOL result = FALSE;
	TW_UINT16 i = 0;

	ASSERT(pTable);
	ASSERT(pString);

	for(i = 0; i < uiTableSize; i++)
	{
		if (pTable[i].ItemId == uiCapId)
		{
			lstrcpy(pString, pTable[i].pszItemName);
			result = TRUE;
			break;
		}   
	}   

	return  result;
}   




/*
* FUNCTION: AltTWItemSize
* ARGS:    ItemType    constant which serves as an index to appropiate
*                      data type
* RETURNS: Result      size of item in bytes
* NOTES:   The routine provides a look-up table to get actual size in bytes of 
* a particular data type.  Using the sizeof call should give the correct
* results on any machine type.  The value for the ItemType parm are found
* in the twain.h file and are indicated by TWTY_XXXX.. (TWTY_UINT16...)
* 
* This routine is provided to allow the Source to use this code intact.  The
* Source does not link to the TWA_GLUE.C module and thus does not have access
* to the TWItemSize array.
*/   
TW_UINT16 AltTWItemSize(TW_INT16 ItemType)
{
	TW_UINT16 result = sizeof(TW_UINT16);

	switch (ItemType)
	{
		case TWTY_INT8:
			result = sizeof(TW_INT8);
			break;
		case TWTY_UINT8:
			result = sizeof(TW_UINT8);
			break;
		case TWTY_INT16:
			result = sizeof(TW_INT16);
			break;
		case TWTY_UINT16:
			result = sizeof(TW_UINT16);
			break;
		case TWTY_INT32:
			result = sizeof(TW_INT32);
			break;
		case TWTY_UINT32:
			result = sizeof(TW_UINT32);
			break;
		case TWTY_FIX32:
			result = sizeof(TW_FIX32);
			break;
		case TWTY_FRAME:
			result = sizeof(TW_FRAME);
			break;
		case TWTY_STR32:
			result = sizeof(TW_STR32);
			break;
		case TWTY_STR64:
			result = sizeof(TW_STR64);
			break;
		case TWTY_STR128:
			result = sizeof(TW_STR128);
			break;
		case TWTY_STR255:
			result = sizeof(TW_STR255);
			break;
		default:
			break;
	}
	return(result);
}


