//********************************************************************************
//*
//* File:         dca_acq.h
//* RCS:          $Header: $
//* Description:  Acquire code
//* Author:       TWAIN Working Group
//* Created:      Feb 5,92
//* Modified:     "
//* Language:     C
//* Package:      N/A
//* Status:       Test tool
//*
//* (c) Copyright 1992, Hewlett-Packard Company, all rights reserved.
//*
//*	Copyright  1998 TWAIN Working Group: Adobe Systems Incorporated, 
//*	Canon Information Systems, Eastman Kodak Company, 
//*	Fujitsu Computer Products of America, Genoa Technology, 
//*	Hewlett-Packard Company, Intel Corporation, Kofax Image Products, 
//*	JFL Peripheral Solutions Inc., Ricoh Corporation, and Xerox Corporation.  
//*	All rights reserved.
//*
//********************************************************************************

#ifndef _inc_dca_acq_h
#define _inc_dca_acq_h

//----------------------------------------------------------------------
//							V a r i a b l e s
//----------------------------------------------------------------------

extern char				Filename[256];

//----------------------------------------------------------------------
//							F u n c t i o n s
//----------------------------------------------------------------------


BOOL TWSetup (HWND hWnd, TW_INT16 Flag);
BOOL ProcessTWMessage (LPMSG, HWND);
void TWTransferImage (HWND hWnd);
void LogMessage(char msg[]);
void CloseConnection(HANDLE bitmap);
void SetAcqFlag (TW_INT16 Flag); 



int TWavailable(void);


#define TWLASTBLOCK     1
#define TWLASTCANCELLED 2
#define TWLASTFAILED    3


typedef os_error *(*TWendfn)(void);
typedef os_error *(*TWtransfn)(int size,int last,int bpr,int rows);
typedef os_error *(*TWallocfn)(int size);
typedef os_error *(*TWinfofn)(int xpix,int ypix,int bpp,int xres,
                                                        int yres,int planar);
typedef os_error *(*TWpalfn)(int * pword,int n);

typedef os_error *(*TWfilesetupfn)(int code);



typedef struct TWAcquireblockstr
{
 int       settransfertype:1;
 int       setarea:1;
 int       autofeed:1;

 int       transfertype; /* set to TWSX_NATIVE/TWSX_MEMORY/TWSX_FILE */

 char *    filename;

 struct 
 {
  int       x0;
  int       x1;
  int       y0;
  int       y1;
 } area;


 TWendfn        TWend;
 TWtransfn      TWtrans;
 TWallocfn      TWalloc;
 TWinfofn       TWinfo;
 TWpalfn        TWpal;
 TWfilesetupfn  TWfilesetup;

 union
 {
  struct 
  {
   void * lpdib;

  } native;

  struct
  {
   char * buffer;
   int    size;

  } memxfer;

 } memory;


} TWAcquireblockstr;




os_error * TWAcquire(wimp_w handle,BOOL Show,TW_INT16 Flag,TWAcquireblockstr * TWAcquireblock);

void       TWAcquireDefault(TWAcquireblockstr * TWAcquireblock);

void       TWGetCompleteImage(void);


void TWTerminate(void);



#endif //_inc_dca_acq_h

