//
// File:         twa_acq.c
// Description:  Capability negotiation for Twacker
// Author:       TWAIN Working Group
// Created:      Feb 5,92
// Modified:     "
// Language:     C
// Package:      N/A
// Status:       Test tool
//
// (c) Copyright 1992, Hewlett-Packard Company, all rights reserved.
//
/*	Copyright  1998 TWAIN Working Group: Adobe Systems Incorporated, 
*	Canon Information Systems, Eastman Kodak Company, 
*	Fujitsu Computer Products of America, Genoa Technology, 
*	Hewlett-Packard Company, Intel Corporation, Kofax Image Products, 
*	JFL Peripheral Solutions Inc., Ricoh Corporation, and Xerox Corporation.  
*	All rights reserved.
*/
//----------------------------------------------------------------------
//                            I n c l u d e s
//----------------------------------------------------------------------

#include "stdafx.h"


#include <windows.h>            // Req. for twain.h type defs and ...
#include <memory.h>
#include <stdio.h>              // needed for wsprintf  
#include <string.h>
#include <time.h>

#include "os.h"
#include "deb.h"
#include "xmath.h"
#include "wimp.h"
#include "fsx.h"
#include "wos.h"


#if defined(WIN32) || defined(WIN64)
#else
#include <toolhelp.h>
#endif

#include "twain.h"            // needed for TWAIN definitions
#include "twndebug.h"

#include "table.h"
#include "dca_glue.h"    			       	// for function prototypes of glue code
#include "dca_acq.h"            			// contain TWAIN sample support code
#include "dca_app.h"
#include "captest.h"
//#include "twacker.h"

#ifdef NULL
#undef NULL                      
#endif
#define NULL 0

// to allow compatibility between 32 and 16 bit _llseek
#if defined(WIN32) || defined(WIN64)
#define FILE_BEGIN      0
#define FILE_CURRENT    1
#define FILE_END        2
#endif

#if defined(WIN32) || defined(WIN64)
#define TW_HUGE
#else
#define TW_HUGE huge
#endif

static TW_INT16 AcqFlag = 0;





static TWAcquireblockstr * TWAcquireblockp;



/******************************************************************************/

static int unitsmul;
static int unitsdiv;


static os_error * acqgetunits(HWND hWnd,int & mul,int & div)
{
 os_error * err;
 TW_CAPABILITY  cap;
 TW_UINT16           twRC;
 pTW_ONEVALUE        pOneV;
 TW_UINT16           Units;


 err=NULL;

 //Get Units and calculate PelsPerMeter

 cap.Cap = ICAP_UNITS;
 cap.ConType = TWON_DONTCARE16;
 cap.hContainer = NULL;
             
 twRC=(*lpDSM_Entry)(&appID, 
                     &dsID, 
                     DG_CONTROL, 
                     DAT_CAPABILITY, 
                     MSG_GETCURRENT, 
                     (TW_MEMREF)&cap);
            
 if(twRC!=TWRC_SUCCESS)
 {
  ShowRC_CC(ML_ERROR,hWnd,1,twRC,1,
            "ICAP_UNITS",
            "DG_CONTROL/DAT_CAPABILITY/MSG_GETCURRENT");

  mul=div=1;
  
 }
 else
 {
  pOneV = (pTW_ONEVALUE)GlobalLock(cap.hContainer);
  Units = (TW_UINT16)(pOneV->Item);
  GlobalUnlock(cap.hContainer);
  GlobalFree((HANDLE)cap.hContainer);
                    
  switch(Units)
  {
   case       TWUN_INCHES:
                          mul=72000;
                          div=1;
                          break;

   case       TWUN_POINTS:
                          mul=1000;
                          div=1;
                          break;

   case        TWUN_PICAS:
                          mul=12000;
                          div=1;
                          break;

   case        TWUN_TWIPS:
                          mul=50;
                          div=1;
                          break;

   case  TWUN_CENTIMETERS:
                          mul=72000*100;
                          div=254;
                          break;

         case TWUN_PIXELS:
                  default:
                          mul=div=1;
                          break;
  }
 }

 return(err);
}




static void icapunits(TW_FIX32 * icaps,int ourunits)
{
 icaps->Whole=scale(ourunits,unitsdiv,unitsmul);
 ourunits-=scale(icaps->Whole,unitsmul,unitsdiv);
 icaps->Frac=scale(ourunits,unitsdiv*0x10000,unitsmul);
}

static int ourunits(TW_FIX32 * icaps)
{
 return(scale(icaps->Whole,unitsmul,unitsdiv)+scale(icaps->Frac,unitsmul,0x10000*unitsdiv));
}




static void acqsetarea(void)
{
 TW_IMAGELAYOUT ImageLayout;

 icapunits(&ImageLayout.Frame.Top,TWAcquireblockp->area.y1);
 icapunits(&ImageLayout.Frame.Bottom,TWAcquireblockp->area.y0);
 icapunits(&ImageLayout.Frame.Left,TWAcquireblockp->area.x0);
 icapunits(&ImageLayout.Frame.Right,TWAcquireblockp->area.x1);

 ImageLayout.DocumentNumber=1;
 ImageLayout.PageNumber=1;
 ImageLayout.FrameNumber=1;

 CallDSMEntry(&appID,&dsID,DG_IMAGE,DAT_IMAGELAYOUT,MSG_SET,
                                                    (TW_MEMREF)&ImageLayout);
}





static void acqgetarea(void)
{
 TW_IMAGELAYOUT ImageLayout;

 if(CallDSMEntry(&appID,&dsID,DG_IMAGE,DAT_IMAGELAYOUT,MSG_GET,
                                    (TW_MEMREF)&ImageLayout)==TWRC_SUCCESS)
 {
  cprintf("unitsmul %d unitsdiv %d",unitsmul,unitsdiv);

  TWAcquireblockp->area.y1=ourunits(&ImageLayout.Frame.Top);
  TWAcquireblockp->area.y0=ourunits(&ImageLayout.Frame.Bottom);
  TWAcquireblockp->area.x0=ourunits(&ImageLayout.Frame.Left);
  TWAcquireblockp->area.x1=ourunits(&ImageLayout.Frame.Right);
 }
}




static os_error * acqgetpalette(HWND hWnd,TW_IMAGEINFO * info)
{
 os_error    *  err;
 int            nc=0;
 int            paltab[256];
 TW_CAPABILITY  cap;
 TW_UINT16      twRC;
 TW_UINT16      PixelFlavor;   
 pTW_ONEVALUE   pOneV;
 TW_UINT16      index;
 TW_PALETTE8    pal;



 err=NULL;

                // Setup Palette -- if the palettes are B/W or shades of gray, the color
                // table is built here.  If the image is 8 bit color, a call to the
                // source is made to retrieve the correct set of colors.  If the call 
                // fails, the color table is constructed with 256 shades of gray inorder
                // to provide some image reference

 switch (info->PixelType)
 {
  case TWPT_BW:
                        nc=2;
                                                       
                        //Get CAP_PIXELFLAVOR to determine colors
                        //fill in the palette information
                        cap.Cap = ICAP_PIXELFLAVOR;
                        cap.ConType = TWON_DONTCARE16;
                        cap.hContainer = NULL;
                        
                        twRC = (*lpDSM_Entry)(&appID, 
                                    &dsID, 
                                    DG_CONTROL, 
                                    DAT_CAPABILITY, 
                                    MSG_GETCURRENT, 
                                    (TW_MEMREF)&cap);
            
            
                        if (twRC != TWRC_SUCCESS)
                        {   

                                ShowRC_CC(ML_INFO,hWnd, 1, twRC, 1,
                                "MSG_GET",
                                "ICAP_PIXELFLAVOR");
                        
                            PixelFlavor = TWPF_CHOCOLATE;
                        }
                        else
                        {
                            if (cap.ConType != TWON_ONEVALUE)
                            {
                                PixelFlavor = TWPF_CHOCOLATE;
                            }
                            else
                            {                            
                                pOneV = (pTW_ONEVALUE)GlobalLock(cap.hContainer);
                                PixelFlavor = (TW_UINT16)(pOneV->Item);
                                GlobalUnlock(cap.hContainer);
                            }                       
                            GlobalFree((HANDLE)cap.hContainer);
                        }
                        if (PixelFlavor == 0)
                        {
                            //0=Black
                         paltab[0]=0;
                         paltab[1]=0xFFFFFF00;
                        }
                        else
                        {
                            //ICAP_PIXELFLAVOR == 1
                            //0=White

                         paltab[0]=0xFFFFFF00;
                         paltab[1]=0;
                        }
                        break;
                    
                    case TWPT_GRAY:
                        nc=256;
                        for (index=0; index<256; index++)
                        {
                         paltab[index]=(index<<8);
                         paltab[index]|=(index<<16);
                         paltab[index]|=(index<<24);
                        }
                        break;

                    case TWPT_RGB:
                        nc=0;
                        break;
                    
                    case TWPT_PALETTE:
                    case TWPT_CMY:
                    case TWPT_CMYK:
                    case TWPT_YUV:
                    case TWPT_YUVK:
                    case TWPT_CIEXYZ:
                    default:
                        //fill in the palette information
                        twRC = (*lpDSM_Entry)(&appID, 
                                    &dsID, 
                                    DG_IMAGE, 
                                    DAT_PALETTE8, 
                                    MSG_GET, 
                                    (TW_MEMREF)&pal);
                        
                        if (twRC != TWRC_SUCCESS)
                        {

                                ShowRC_CC(ML_ERROR,hWnd, 1, twRC, 1,
                                "",
                                "DG_IMAGE/DAT_PALETTE8/MSG_GET -- defaulting to 256 gray image palette");
                            
                            
                            nc=256;
                            for (index=0; index<pal.NumColors; index++)
                            {
                             paltab[index]=(index<<8);
                             paltab[index]|=(index<<16);
                             paltab[index]|=(index<<24);
                            }   
                        }
                        else
                        {
                            nc=pal.NumColors;
                            
                            for (index=0; index<pal.NumColors; index++)
                            {
                                paltab[index]=(pal.Colors[index].Channel1)<<8;
                                paltab[index]|=(pal.Colors[index].Channel2)<<16;
                                paltab[index]|=(pal.Colors[index].Channel3)<<24;

                            }   
                        }
                        break;              
                }   //end switch(PixelType)


 if(nc && TWAcquireblockp->TWpal) err=TWAcquireblockp->TWpal(paltab,nc);
 
 return(err);
}





//----------------------------------------------------------------------
//                            F u n c t i o n s
//----------------------------------------------------------------------

static void DoNativeTransfer(HWND hWnd);
static void DoFileTransfer(HWND hWnd);
static void DoMemTransfer(HWND hWnd);


/////////////////////////////////////////////////////////////////////////////
// FUNCTION: SetAcqFlag
// 
// ARGS:     
//			Flag -
// RETURNS: None
// 
// AcqFlag = 0 Do Not Accept MSG_XFERREADY
//           1 Disable/CloseDS/CloseDSM
//           2 Disable Only
//           3 Do Not Disable - only if ShowUI=TRUE 
//
void SetAcqFlag(TW_INT16 Flag)
{
	AcqFlag = Flag;
	return;
}

/////////////////////////////////////////////////////////////////////////
//  FUNCTION: TWAcquire
// 
//  ARGS:    
//		hWnd - handle to window
//		Show -
//		Flag - 
//  RETURNS: TRUE is successful
// 
//  NOTES: - opendsm, open the Source Manager
//            - opends, open the Source
//            - enable Source
//            - wait for a message from Source (usually XFERREADY)
//       Flag =  0 Do Not Accept MSG_XFERREADY
//               1 Disable/CloseDS/CloseDSM
//               2 Disable Only
//               3 Do Not Disable - only if ShowUI=TRUE
//


static os_error * TWAcquire2(HWND hWnd,BOOL Show,TW_INT16 Flag,TWAcquireblockstr * TWAcquireblock)
{
	TW_INT16 result=TRUE;

	ASSERT(hWnd);

	LogMessage("TWAcquire entry\r\n");

 TWClearError();

 if(!TWavailable() && !TWIsTWSelectOpen() && !TWIsDSOpen())
 {
  AcqFlag=0;    //Not ready to transfer yet

	 LogMessage("TWAcquire entry2\r\n");

  TWAcquireblockp=TWAcquireblock;

 	if(TWOpenDSM((wimp_w)hWnd)==TRUE)
 	{
		// Please note that another Source may change the system default while
		// your not looking and simply getting the default will not guarentee
		// you get what you want.  Suggest saving the dsID structure privately
		// after you open it to assure subsequent connections are to your
		// intended Source -- ed
		// Also note the the DSM will maintain a static list of all Sources in
		// the system at the moment it is opened.  Changes in available Sources
		// while the DSM is open may cause unpredictable results. -- ed

 		if(TWOpenDS()==TRUE)
 		{
 			if(TWXferMech(hWnd,TWAcquireblockp->transfertype)==TWRC_SUCCESS)
 			{
    	LogMessage("TWAcquire xfer 1\r\n");

	 			if(TWAutofeedMenu(hWnd,TWAcquireblockp->autofeed)==TWRC_SUCCESS)
	 			{
     	LogMessage("TWAcquire xfer 2\r\n");

      if(TWAcquireblock->setarea) acqsetarea();

 					if(!TWIsDSEnabled())
 					{
      	LogMessage("TWAcquire xfer 3\r\n");

	 					result=TWEnableDS((TW_BOOL)Show);

	 					AcqFlag=Flag;
						//AcqFlag = 0 Do Not Accept MSG_XFERREADY
						//          1 Disable/CloseDS/CloseDSM
						//          2 Disable Only
						//          3 Do Not Disable - only if ShowUI=TRUE
	 				}
	 			}
	 		}
 			else
 			{
 				if(TWCloseDS())
 				{
 					if(TWCloseDSM(NULL))
 					{
 						AcqFlag=0;                        
 					}
		 			else
      {

      }
	 			}
	 			return(TWError());
	 		}
	 	}
 		else
 		{
 			LogMessage("OpenDS failed -- TWAcquire\r\n");
 			TWCloseDSM(NULL);
	 		return(TWError());
	 	}

 		/*
 		* Cannot Enable Source
 		*/
 		if(result==FALSE) 
 		{    
 			if(TWCloseDS())
 			{
 				if(TWCloseDSM(NULL))
 				{
 					AcqFlag = 0;                        
 				}
				 else
     {

		 		}
		 	}
		 	else
		 	{

	 		}
	 	} 
	 }
 	else
 	{
 		return(TWError());
 	}
 }

	return(TWError());
}   


os_error * TWAcquire(wimp_w handle,BOOL Show,TW_INT16 Flag,TWAcquireblockstr * TWAcquireblock)
{
 os_error * err;

 enablewindow(handle,0,1);

 err=TWAcquire2((HWND)handle,Show,Flag,TWAcquireblock);

 enablewindow(handle,1,1);

 return(err);
}



void TWAcquireDefault(TWAcquireblockstr * TWAcquireblock)
{
 memset(TWAcquireblock,0,sizeof(TWAcquireblockstr));
}







/*
* Function: TWSetup
* Author: Nancy Ltourneau / J.F.L. Peripheral Solutions / TWAIN Working Group
* Date: July 98
* Input:
*		hWnd - handle to window
*		Flag - 
* Output:
*		TRUE is successful
*Comments: 
*		- opendsm, open the Source Manager
*		- opends, open the Source
*		- enable Source
*		- wait for a message from Source (usually XFERREADY)
*		Flag =  0 Do Not Accept MSG_XFERREADY
*						1 Disable/CloseDS/CloseDSM
*						2 Disable Only
*						3 Do Not Disable - only if ShowUI=TRUE
*/
BOOL TWSetup (HWND hWnd, TW_INT16 Flag)
{
	TW_INT16 result = TRUE;

	ASSERT(hWnd);

	LogMessage("TWSetup entry\r\n");

	AcqFlag = 0;    //Not ready to transfer yet
	if (TWOpenDSM ((wimp_w)hWnd) == TRUE)
	{
		/*
		* Please note that another Source may change the system default while
		* your not looking and simply getting the default will not guarentee
		* you get what you want.  Suggest saving the dsID structure privately
		* after you open it to assure subsequent connections are to your
		* intended Source -- ed
		* Also note the the DSM will maintain a static list of all Sources in
		* the system at the moment it is opened.  Changes in available Sources
		* while the DSM is open may cause unpredictable results. -- ed
		*/

		if(TWOpenDS()==TRUE)
		{
			TW_CAPABILITY twCapability;
			pTW_ONEVALUE pOneValue = NULL;
			TW_INT16 rc = TWRC_FAILURE;

			memset(&twCapability, 0, sizeof(TW_CAPABILITY));

			twCapability.Cap = CAP_ENABLEDSUIONLY;
			twCapability.ConType = TWON_DONTCARE16;
			twCapability.hContainer = NULL;

			rc=CallDSMEntry(&appID,
						&dsID,
						DG_CONTROL,
						DAT_CAPABILITY,
						MSG_GET,
						(TW_MEMREF)&twCapability);

			/* 
			* Look if CAP_ENABLEDSUIONLY is supported. 
			* If yes, look if the value is TRUE.
			*/
			if(rc==TWRC_SUCCESS)
			{
				pOneValue = (pTW_ONEVALUE)GlobalLock(twCapability.hContainer);
				if(pOneValue && pOneValue->Item == TRUE)
				{
					if (!TWIsDSEnabled())
					{
						result = TWEnableDSUIOnly();

						AcqFlag = Flag;
						/*
						* AcqFlag = 0 Do Not Accept MSG_XFERREADY
						*						1 Disable/CloseDS/CloseDSM
						*						2 Disable Only
						*/
					}
				}
				else
				{
					result = FALSE;
					ShowRC_CC(ML_ERROR,hWnd, 0, 0, 0,
								"Cannot Enable Source\nThe value of CAP_ENABLEDSUIONLY is FALSE", 
								"TWAIN Error");
				}
				GlobalUnlock(twCapability.hContainer);
				GlobalFree(twCapability.hContainer);
			}
			else
			{
				result = FALSE;
				ShowRC_CC(ML_ERROR,hWnd, 0, 0, 0,
							"Cannot Enable Source\nCAP_ENABLEDSUIONLY is not supported", 
							"TWAIN Error");
			}
		}
		else
		{
			LogMessage("OpenDS failed -- TWSetup\r\n");
			TWCloseDSM(NULL);
			return(FALSE);
		}

		/*
		* Cannot Enable Source
		*/
		if (result == FALSE) 
		{    
			if (TWCloseDS())
			{
				if (TWCloseDSM(NULL))
				{
//					CheckSpecialMenu(hWnd, TW_APP_CLOSESM);
					AcqFlag = 0;                        
				}
				else
				{
//					CheckSpecialMenu(hWnd, TW_APP_CLOSEDS);                 
				}
			}
			else
			{
//			CheckSpecialMenu(hWnd, TW_APP_DISABLE);              
			}
		} 
	}
	else
	{
		return(FALSE);
	}

	return(result);  
}   

////////////////////////////////////////////////////////////////////////////
// FUNCTION: ProcessTWMessage
//
//
// ARGS:     lpMsg  Pointer to Windows msg retrieved by GetMessage
//           hWnd   Application's main window handle
//
// RETURNS: TRUE  if application should process message as usual
//              FALSE if application should skip processing of this message
//
// NOTES:   1). be sure both Source Manager and Source are open
//              2). two way message traffic:
//                  - relay windows messages down to Source's modeless dialog
//                  - retrieve TWAIN messages from the Source
//
// COMMENT: ProcessSourceMessage is designed for applications that can only
// have one Source open at a time.  If you wish your application to have more
// than one Source open at a time please consult the TWAIN ToolKit for
// event handling instructions.
//
BOOL ProcessTWMessage(LPMSG lpMsg, HWND hWnd)
{
	TW_UINT16  twRC = TWRC_NOTDSEVENT;
	TW_EVENT   twEvent;

	memset(&twEvent, 0, sizeof(TW_EVENT));

	ASSERT(lpMsg);
	ASSERT(hWnd);
	// Only ask Source Manager to process event if there is a Source connected.

	if((TWIsDSMOpen()) && (TWIsDSOpen()))
	{
#ifdef _DEBUG
  cprintf("twmessage %d",clock());
#endif
		// A Source provides a modeless dialog box as its user interface.
		// The following call relays Windows messages down to the Source's
		// UI that were intended for its dialog box.  It also retrieves TWAIN
		// messages sent from the Source to our  Application.
		//

		twEvent.pEvent = (TW_MEMREF)lpMsg;

		twRC = CallDSMEntry(&appID,
						&dsID, 
						DG_CONTROL, 
						DAT_EVENT,
						MSG_PROCESSEVENT, 
						(TW_MEMREF)&twEvent);

		switch (twEvent.TWMessage)
		{
			case MSG_XFERREADY:
				//If AcqFlag >0 then we are in state 5
				if (AcqFlag)
				{
					TWTransferImage(hWnd);
				}
				else
				{
					ShowRC_CC(ML_ERROR,hWnd, 0, 0, 0, 
								"Received while not in state 5", 
								"MSG_XFERREADY");
				}
				break;

			case MSG_CLOSEDSREQ:
			case MSG_CLOSEDSOK:
				/*
				* Disable, CloseDS, CloseDSM    
				*/
				LogMessage("CloseDSReq\r\n");
				if (TWDisableDS())
				{
					if (TWCloseDS())
					{
						if (TWCloseDSM(NULL))
						{
							/*
							* SUCCESS
							*/
//							CheckSpecialMenu(hWnd, TW_APP_CLOSESM);
						}
						else
						{ 
//							CheckSpecialMenu(hWnd, TW_APP_CLOSEDS);
						}
					}
					else 
					{
//						CheckSpecialMenu(hWnd, TW_APP_DISABLE);
					}
				}
				break;
			
		// No message from the Source to the App break;
		// possible new message
			case MSG_NULL:
			default:
				break;
		}   
	} 
	// tell the caller what happened
	return (twRC==TWRC_DSEVENT);           // returns TRUE or FALSE
} 

/*
* Function: TWTransferImage
* Input:     
*		hWnd - Handle to the Main Window
* Output: none
* Note:
*		1). delete any bit maps laying around
*		2). mention those who do not want Native need CAP nego. ICAP_XFERMECH
*		3). get a little information about image, for form, I do not use it
*		4). set up a for form loop to pull image(s) from the Source
*		5). call for GetCompleteImage from Source
*		6). be sure to send a MSG_ENDXFER as a seperator between images
*		7). after the images are transfered I like to shut down the Source
* Comment: 
*		Setup for a transfer in the routine called as a response to
* XFERREADY.  Then has a nested loop do/while on the routine which
* actually pulls in the image or GetCompleteImage.  The GetCompleteImage
* routine also deals with the cancel, xferdone, success messages from
* Source.
*/
VOID TWTransferImage(HWND hWnd)
{
	ASSERT(hWnd);

 cprintf("transfer image");

	/* 
	* Do MSG_GET for the ICAP_XFERMECH capability when it's call in the
	* Special Menu to know the Transfer Mode
	*/
	if(!TWAcquireblockp->settransfertype)
	{
		TW_CAPABILITY twCapability;
		pTW_ENUMERATION pEnumeration = NULL;		
		TW_UINT16 index = 0, i = 0;
		TW_STR64 buffer;
		TW_UINT16 ModeType = 0;

		memset(buffer, 0, sizeof(TW_STR64));		
		memset(&twCapability, 0, sizeof(TW_CAPABILITY));
		twCapability.Cap = ICAP_XFERMECH;

		/*
		* Call the triplet with MSG_GET to get the current Value of 
		* ICAP_XFERMECH
		*/
		CallDSMEntry(&appID,
					&dsID,
					DG_CONTROL,
					DAT_CAPABILITY,
					MSG_GET,
					(TW_MEMREF)&twCapability);

		pEnumeration = (pTW_ENUMERATION)GlobalLock(twCapability.hContainer);

		for (index = 0;index < pEnumeration->NumItems; index++)
		{
			if(index == pEnumeration->CurrentIndex)
			{
				for(i = 0; i < MAX_SETUPXFERTYPE; i++)
				{
					if(*(TW_UINT16*)&pEnumeration->ItemList[index*(sizeof(TW_UINT16))] == SetupXferType[i].ItemId)
					{
						TRACE("Value = %s.\n", SetupXferType[i].pszItemName);
						ModeType = SetupXferType[i].ItemId;
						break;
					}
				}
			}
		}
		GlobalUnlock(twCapability.hContainer);
		GlobalFree(twCapability.hContainer);

		if(ModeType == TWSX_MEMORY)
		{
			DoMemTransfer(hWnd);
		}
		else if(ModeType == TWSX_FILE)
		{
			DoFileTransfer(hWnd);
		}
		else if(ModeType == TWSX_NATIVE)
		{
			DoNativeTransfer(hWnd);
		}
	}
	/*
	*	Look the check Menu in File Menu to know the Transfer Mode
	*/
	else
	{
		/*
		* Tell the Source what type of transfer you want.
		*/
		if(TWAcquireblockp->transfertype==TWSX_MEMORY)
		{
			DoMemTransfer(hWnd);
		}
		else
  if(TWAcquireblockp->transfertype==TWSX_FILE)
		{
			DoFileTransfer(hWnd);
		}
		else
		{
			DoNativeTransfer(hWnd);
		}
	}

	if(AcqFlag==0)
	{
		if(!TWIsDSMOpen())
		{
//			CheckSpecialMenu(hWnd, TW_APP_CLOSESM);             	
		}
	}
	else 
 if (AcqFlag==1)
	{
		if(!TWIsDSMOpen())
		{
//			CheckSpecialMenu(hWnd, TW_APP_CLOSESM);             	
			AcqFlag = 0;                    
		}
	}
	else
 if(AcqFlag==2) 
	{ 
		/*
		* Only Disable for Special...Transfer 
		*/
		if(TWDisableDS())
		{
//			CheckSpecialMenu(hWnd, TW_APP_DISABLE);             
			AcqFlag = 0;
		}
	}
	else
 if(AcqFlag==3)
	{ 
		/*
		* Do not Disable 
		*/
//		CheckSpecialMenu(hWnd, TW_APP_TRANSFER);                        
	}

	return;
}   

/*
* Function: DoNativeTransfer -- 
* Author: TWAIN Working Group
* Input:     
*		hWnd - Handle to the Window
* Output: none
* Comment: 
*/
static void DoNativeTransfer(HWND hWnd)
{
 os_error          * err;
	TW_PENDINGXFERS     twPendingXfer;
	TW_UINT16           twRC = TWRC_FAILURE;
	TW_UINT16           twRC2 = TWRC_FAILURE;
	TW_UINT32           hBitMap = NULL;
	HANDLE              hbm_acq = NULL;     // handle to bit map from Source to ret to App
	char buffer[2048];

	LPBITMAPINFOHEADER lpdib = NULL;

	memset(&twPendingXfer, 0, sizeof(TW_PENDINGXFERS));
	memset(buffer, 0, sizeof(char[2048]));

	ASSERT(hWnd);

 cprintf("native txfer");

	/*
	* Do until there are no more pending transfers
	* explicitly initialize the our flags
	*/

	twPendingXfer.Count=0;
	do 
	{
#ifdef _DEBUG

			ShowImageInfo(hWnd);
			ShowImageLayout(hWnd);
			ShowCapability(hWnd, ICAP_PIXELFLAVOR);
			ShowCapability(hWnd, ICAP_PIXELTYPE);

#endif

		/*
		* Initiate Native Transfer
		*/
		twRC=CallDSMEntry(&appID,
						&dsID, 
						DG_IMAGE,
						DAT_IMAGENATIVEXFER, 
						MSG_GET, 
						(TW_MEMREF)&hBitMap);

		switch (twRC)
		{
			case TWRC_XFERDONE:  // Session is in State 7
				ShowRC_CC(ML_FULL,hWnd, 0, 0, 0, "TWRC_XFERDONE", 
							"DG_IMAGE/DAT_IMAGENATIVEXFER/MSG_GET");

				hbm_acq=(HBITMAP)hBitMap;

				/*
				* Acknowledge the end of the transfer 
				* and transition to state 6/5
				*/
				twRC2=CallDSMEntry(&appID,
									&dsID, 
									DG_CONTROL,
									DAT_PENDINGXFERS, 
									MSG_ENDXFER,
									(TW_MEMREF)&twPendingXfer);

				if (twRC2 != TWRC_SUCCESS)
				{
						ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
									"", 
									"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER");

				}

				wsprintf(buffer,"Pending Xfers = %d\r\n",twPendingXfer.Count);
				LogMessage(buffer);

				if(twPendingXfer.Count==0)
				{	
					if(hbm_acq && (lpdib=(LPBITMAPINFOHEADER)GlobalLock(hbm_acq))!=NULL)
					{
						CloseConnection(NULL);

						GlobalUnlock(hbm_acq);
					}
				}

				if(hbm_acq>=(HANDLE)VALID_HANDLE)
				{
     TWAcquireblockp->memory.native.lpdib=(LPBITMAPINFOHEADER)GlobalLock(hbm_acq);
     err=TWAcquireblockp->TWtrans(GlobalSize(hbm_acq),TWLASTBLOCK,0,0);
					GlobalUnlock(hbm_acq);
     GlobalFree(hbm_acq);
				}
				else
				{
					err=TWAcquireblockp->TWtrans(0,TWLASTFAILED,0,0);
				}

				/* 
				* showRC_CC is a safe operation here since there will be no triplet
				* calls generated 
				*/
				if(AutoFeedOn())
				{
					wsprintf(buffer,"Images = %d",twPendingXfer.Count);
					ShowRC_CC(ML_INFO,NULL,0,0,0,buffer,"Pending Transfers");
				}
				break;

			/*
			* the user canceled or wants to rescan the image
			* something wrong, abort the transfer and delete the image
			* pass a null ptr back to App
			*/
			case TWRC_CANCEL:   // Session is in State 7
					ShowRC_CC(ML_ERROR,hWnd, 0, 0, 0, "TWRC_CANCEL", 
								"DG_IMAGE/DAT_IMAGENATIVEXFER/MSG_GET");                


				/*
				* Source (or User) Canceled Transfer
				* transistion to state 6/5
				*/
				twRC2 = CallDSMEntry(&appID,
								&dsID, 
								DG_CONTROL,
								DAT_PENDINGXFERS, 
								MSG_ENDXFER,
								(TW_MEMREF)&twPendingXfer);

				if (twRC2 != TWRC_SUCCESS)
				{
						ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
									"", 
									"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER");             

				}

				if(twPendingXfer.Count == 0)
				{

					CloseConnection(NULL);

				}

				err=TWAcquireblockp->TWtrans(0,TWLASTCANCELLED,0,0);
				break;

			case TWRC_FAILURE:  //Session is in State 6
				/*
				* The transfer failed
				*/
					ShowRC_CC(ML_ERROR,hWnd, 1, TWRC_FAILURE, 1, 
								"", "DG_IMAGE/DAT_IMAGENATIVEXFER/MSG_GET");                


				/*
				* Abort the image
				* Enhancement: Check Condition Code and attempt recovery
				*/
				twRC2 = CallDSMEntry(&appID,
								&dsID, 
								DG_CONTROL,
								DAT_PENDINGXFERS, 
								MSG_ENDXFER,
								(TW_MEMREF)&twPendingXfer); 

				if(twRC2!=TWRC_SUCCESS)
				{
						ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
									"", 
									"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER");             

				}

				if(twPendingXfer.Count==0)
				{
					CloseConnection(NULL);

				}

				err=TWAcquireblockp->TWtrans(0,TWLASTFAILED,0,0);
				break;

			default:    //Sources should never return any other RC
					ShowRC_CC(ML_ERROR,hWnd, 0, 0, 0, "Unknown Return Code", 
								"DG_IMAGE/DAT_IMAGENATIVEXFER/MSG_GET");
				/*
				* Abort the image
				* Enhancement: Check Condition Code and attempt recovery instead
				*/
				twRC2 = CallDSMEntry(&appID,
								&dsID, 
								DG_CONTROL,
								DAT_PENDINGXFERS, 
								MSG_ENDXFER,
								(TW_MEMREF)&twPendingXfer);

				if (twRC2 != TWRC_SUCCESS)
				{
						ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
									"", 
									"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER");

				}

				if (twPendingXfer.Count == 0)
				{
					CloseConnection(NULL);
				}

				err=TWAcquireblockp->TWtrans(0,TWLASTFAILED,0,0);
				break;
		}   

	} while (twPendingXfer.Count != 0);

	AcqFlag = 0;
	return;
}   

/*
* Function: DoFileTransfer -- 
* Author: TWAIN Working Group
* Input:     
*		hWnd - Handle to the Window
* Output: none
* Comment: 
*/

static void DoFileTransfer(HWND hWnd)
{
	TW_PENDINGXFERS     twPendingXfer;
	TW_UINT16           twRC = TWRC_FAILURE;
	TW_UINT16           twRC2 = TWRC_FAILURE;
	TW_SETUPFILEXFER    setup;
//	TW_SETUPFILEXFER    SetupMsgGet;
	HANDLE              hbm_acq = NULL;     // handle to bit map from Source to ret to App
	HFILE               hFile = NULL;
	OFSTRUCT            of;
	char                buffer[2048];
 os_error          * err;

	memset(&twPendingXfer, 0, sizeof(TW_PENDINGXFERS));
	memset(&setup, 0, sizeof(TW_SETUPFILEXFER));
	memset(&of, 0, sizeof(OFSTRUCT));
	memset(buffer, 0, sizeof(char[2048]));

	ASSERT(hWnd);

	/*
	* Do until there are no more pending transfers
	* explicitly initialize the our flags
	*/

	twPendingXfer.Count=0;  
	do
	{

#ifdef _DEBUG
			ShowImageInfo(hWnd);
			ShowImageLayout(hWnd);
			ShowCapability(hWnd, ICAP_PIXELFLAVOR);
			ShowCapability(hWnd, ICAP_PIXELTYPE);
#endif

  TWAcquireblockp->TWfilesetup(1);
  fs_checkextension(TWAcquireblockp->filename,"bmp");

		lstrcpy(setup.FileName,TWAcquireblockp->filename);
		setup.Format=TWFF_BMP;
		setup.VRefNum=0;

		/*
		* create the file and close
		*/
		if((hFile=OpenFile(setup.FileName,&of,OF_CREATE))==HFILE_ERROR)
		{
			twRC=TWRC_FAILURE;
			ShowRC_CC(ML_ERROR,hWnd,0,twRC,0,"Unable to create file for file transfer",
			"Application Error");
		}
		else
		{
			_lclose(hFile);    

			if ((twRC=CallDSMEntry(&appID,
							&dsID, 
							DG_CONTROL,
							DAT_SETUPFILEXFER, 
							MSG_SET, 
							(TW_MEMREF)&setup)) != TWRC_SUCCESS)
			{
					ShowRC_CC(ML_ERROR,hWnd,1,twRC,1,"", 
								"DG_CONTROL/DAT_SETUPFILEXFER/MSG_SET");                

			}
			else
			{ 
				/*
				* Initiate File Transfer
				*/

				twRC=CallDSMEntry(&appID,
								&dsID, 
								DG_IMAGE,
								DAT_IMAGEFILEXFER, 
								MSG_GET, 
								(TW_MEMREF)NULL);
			}   
		}

		switch (twRC)
		{
			case TWRC_XFERDONE:
			{
					/*
					* Successful Transfer
					*/

					ShowRC_CC(ML_FULL,hWnd, 0, 0, 0,
									"TWRC_XFERDONE",
									"DG_IMAGE/DAT_IMAGEFILEXFER/MSG_GET");              


     err=TWAcquireblockp->TWtrans(0,TWLASTBLOCK,0,0);

     fs_delete(setup.FileName);
     TWAcquireblockp->TWfilesetup(0);

					/*
					* Acknowledge the end of the transfer
					* and transition to state 6/5
					*/
					twRC2 = CallDSMEntry(&appID,
									&dsID, 
									DG_CONTROL,
									DAT_PENDINGXFERS, 
									MSG_ENDXFER,
									(TW_MEMREF)&twPendingXfer);

					if (twRC2 != TWRC_SUCCESS)
					{
							ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
										"", 
										"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER");             

					}

					if (twPendingXfer.Count == 0)
					{
						CloseConnection(NULL);
					}


					if (!AutoFeedOn())
					{
						AcqFlag = 1;
					}

					/*
					* showRC_CC is a safe operation here since there will be no triplet
					* calls generated 
					*/
					if(AutoFeedOn())
					{
						wsprintf(buffer,"Images = %d",twPendingXfer.Count);
						ShowRC_CC(ML_INFO,NULL,0,0,0,buffer,"Pending Transfers");
					}
				}   
				break;

			/*
			* the user canceled or wants to rescan the image
			* something wrong, abort the transfer and delete the image
			* pass a null ptr back to App
			*/
			case TWRC_CANCEL:
				/*
				* The Source is in state 7
				* transistion to state 6/5
				*/
					ShowRC_CC(ML_ERROR,hWnd, 0, 0, 0,
								"TWRC_CANCEL",
								"DG_IMAGE/DAT_IMAGEFILEXFER/MSG_GET");              


				twRC2 = CallDSMEntry(&appID,
								&dsID, 
								DG_CONTROL,
								DAT_PENDINGXFERS, 
								MSG_ENDXFER,
								(TW_MEMREF)&twPendingXfer); 

				if (twRC2 != TWRC_SUCCESS)
				{
						ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
									"", 
									"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER");             

				}

				if (twPendingXfer.Count == 0)
				{
					CloseConnection(NULL);

				}

				err=TWAcquireblockp->TWtrans(0,TWLASTCANCELLED,0,0);
				break;

			case TWRC_FAILURE:
				/*
				* The transfer failed
				* Determine Condition Code
				*/
					ShowRC_CC(ML_ERROR,hWnd, 1, TWRC_FAILURE, 1,
								"", "DG_IMAGE/DAT_IMAGEFILEXFER/MSG_GET");              

				/*
				* Abort the image
				* Enhancement: Check Condition Code and attempt recovery instead
				*/
				twRC2 = CallDSMEntry(&appID,
								&dsID, 
								DG_CONTROL,
								DAT_PENDINGXFERS, 
								MSG_ENDXFER,
								(TW_MEMREF)&twPendingXfer); 

				if (twRC2 != TWRC_SUCCESS)
				{
						ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
									"", 
									"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER"); 

				}

				if (twPendingXfer.Count == 0)
				{
					CloseConnection(NULL);
				}

				err=TWAcquireblockp->TWtrans(0,TWLASTFAILED,0,0);
				break;

			default:
					ShowRC_CC(ML_ERROR,hWnd, 0, 0, 0,
								"Unknown Failure",
								"DG_IMAGE/DAT_IMAGEFILEXFER/MSG_GET");              


				/*
				* Abort the image
				*/
				twRC2 = CallDSMEntry(&appID,
								&dsID, 
								DG_CONTROL,
								DAT_PENDINGXFERS, 
								MSG_ENDXFER,
								(TW_MEMREF)&twPendingXfer);

				if (twRC2 != TWRC_SUCCESS)
				{
						ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
									"", 
									"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER"); 

				}

				if (twPendingXfer.Count == 0)
				{
					CloseConnection(NULL);

				}

			 err=TWAcquireblockp->TWtrans(0,TWLASTFAILED,0,0);

				/*
				* showRC_CC is a safe operation here since there will be no triplet
				* calls generated 
				*/
				if(AutoFeedOn())
				{
					wsprintf(buffer,"Images = %d",twPendingXfer.Count);
					ShowRC_CC(ML_INFO,NULL,0,0,0,buffer,"Pending Transfers");
				}
				break;
		}   

	} while (twPendingXfer.Count != 0 && twRC!=TWRC_FAILURE);
    
	return;
}   

/*
* Function: DoMemTransfer -- 
* Author: TWAIN Working Group
* Input:     
*		hWnd - Handle to the Window
* Output: none
* Comment: 
*/
static void DoMemTransfer(HWND hWnd)
{
 os_error * err;
	TW_PENDINGXFERS			twPendingXfer;
	TW_UINT16           twRC2 = TWRC_FAILURE;
	TW_UINT16           twRC = TWRC_FAILURE;
	TW_IMAGEMEMXFER     xfer;
	TW_SETUPMEMXFER     setup;
	TW_IMAGEINFO        info;
	TW_PALETTE8         pal;
	LPBITMAPINFO        pdib = NULL;
	unsigned char TW_HUGE  *ptr = NULL;
	TW_UINT16           index = 0;
	TW_UINT32           size = 0;
	TW_CAPABILITY       cap;
	TW_UINT16           PixelFlavor = 0;   
	pTW_ONEVALUE        pOneV = NULL;
	TW_UINT16           Units = 0;
	float               XRes = 0, YRes = 0;
	char                buffer[2048];
	int                 blocks = 0;
 int                 xres;
 int                 yres;



 cprintf("do mem transfer");


	memset(&twPendingXfer, 0, sizeof(TW_PENDINGXFERS));
	memset(&xfer, 0, sizeof(TW_IMAGEMEMXFER));
	memset(&setup, 0, sizeof(TW_SETUPMEMXFER));
	memset(&info, 0, sizeof(TW_IMAGEINFO));
	memset(&pal, 0, sizeof(TW_PALETTE8));
	memset(&cap, 0, sizeof(TW_CAPABILITY));
	memset(buffer, 0, sizeof(char[2048]));

	ASSERT(hWnd);

	LogMessage("DoMemTransfer\r\n");
	/*
	* set the cursor to wait as a memory transfer may take a long time based on
	* the size of the transfered chunks.  Smaller buffers will produce very slow
	* transfers, especially when thunking
	*/

	/*
	* Do until there are no more pending transfers
	* explicitly initialize the our flags
	*/
	twPendingXfer.Count=0;
	do
	{
#ifdef _DEBUG

			ShowImageInfo(hWnd);
			ShowImageLayout(hWnd);
			ShowCapability(hWnd, ICAP_PIXELFLAVOR);
			ShowCapability(hWnd, ICAP_PIXELTYPE);

#endif
        
		twRC = CallDSMEntry(&appID,
						&dsID, 
						DG_IMAGE, 
						DAT_IMAGEINFO,
						MSG_GET, 
						(TW_MEMREF)&info);

		if (twRC != TWRC_SUCCESS)
		{  
				ShowRC_CC(ML_ERROR,hWnd, 1, twRC, 1,
							"Memory Transfer",
							"DG_IMAGE/DAT_IMAGEINFO/MSG_GET");              

		}
		else
		{  
   size=(int)info.ImageWidth*(int)info.ImageLength*
        (int)info.BitsPerPixel /* *(int)dcImageInfo.SamplesPerPixel */;

   size/=8;

   acqgetunits(hWnd,unitsmul,unitsdiv);
   acqgetarea();

   xres=scale(info.XResolution.Whole,72000*unitsdiv,unitsmul);
   xres+=scale(info.XResolution.Frac,1125*unitsdiv,1024*unitsmul);
   yres=scale(info.YResolution.Whole,72000*unitsdiv,unitsmul);
   yres+=scale(info.YResolution.Frac,1125*unitsdiv,1024*unitsmul);

   if(TWAcquireblockp->TWinfo)
   {
    err=TWAcquireblockp->TWinfo((int)info.ImageWidth,
                              (int)info.ImageLength,
                              (int)info.BitsPerPixel /* *(int)dcImageInfo.SamplesPerPixel */,
                              (int)xres,
                              (int)yres,
                              (int)info.Planar);

   }

   if(!err) err=acqgetpalette(hWnd,&info); 
                         /* at least give a chance for image to be set up */

				twRC = CallDSMEntry(&appID,
								&dsID, 
								DG_CONTROL,
								DAT_SETUPMEMXFER, 
								MSG_GET, 
								(TW_MEMREF)&setup);

				if (twRC != TWRC_SUCCESS)
				{
						ShowRC_CC(ML_ERROR,hWnd, 1, twRC, 1,
									"",
									"DG_CONTROL/DAT_SETUPMEMXFER/MSG_GET");

				}
				else
				{
     err=TWAcquireblockp->TWalloc((int)setup.Preferred);
     TWAcquireblockp->memory.memxfer.size=(int)setup.Preferred;

     xfer.Memory.Flags=TWMF_APPOWNS  | TWMF_POINTER;
     xfer.Memory.Length=TWAcquireblockp->memory.memxfer.size;
     xfer.Memory.TheMem=TWAcquireblockp->memory.memxfer.buffer;

					/*
					* transfer the data -- loop until done or canceled 
					*/
					do
					{
						twRC = CallDSMEntry(&appID,
										&dsID, 
										DG_IMAGE,
										DAT_IMAGEMEMXFER, 
										MSG_GET, 
										(TW_MEMREF)&xfer);

						switch (twRC)
						{
							case TWRC_SUCCESS:
           err=TWAcquireblockp->TWtrans((int)xfer.BytesWritten,
                                               0, 
                                               (int)xfer.BytesPerRow,
                                               (int)xfer.Rows);
								break;
    
							case TWRC_XFERDONE:
								/*
								* Successful Transfer
								*/


           err=TWAcquireblockp->TWtrans((int)xfer.BytesWritten,
                                               1, 
                                               (int)xfer.BytesPerRow,
                                               (int)xfer.Rows);


									ShowRC_CC(ML_FULL,hWnd, 0, 0, 0,
												"TWRC_XFERDONE",
												"DG_IMAGE/DAT_IMAGEMEMXFER/MSG_GET");               


								

								/*
								* Acknowledge the end of the transfer
								* and transition to state 6/5
								*/
								twRC2 = CallDSMEntry(&appID,
												&dsID, 
												DG_CONTROL,
												DAT_PENDINGXFERS, 
												MSG_ENDXFER,
												(TW_MEMREF)&twPendingXfer);

								if (twRC2 != TWRC_SUCCESS)
								{
										ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
													"", 
													"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER");             

								}

								if (twPendingXfer.Count == 0)
								{
									CloseConnection(NULL);
								}

//								SendMessage(hWnd, PM_XFERDONE, (WPARAM)hbm_acq, 0);

								/*
								* showRC_CC is a safe operation here since there will be no triplet
								* calls generated 
								*/
								if(AutoFeedOn())
								{
									wsprintf(buffer,"Images = %d",twPendingXfer.Count);
									ShowRC_CC(ML_INFO,NULL,0,0,0,buffer,"Pending Transfers");
								}
								break;
    
							case TWRC_CANCEL:
								

								/*
								* The Source is in state 7
								* transistion to state 6/5
								*/
									ShowRC_CC(ML_ERROR,hWnd, 0, 0, 0,
												"TWRC_CANCEL",
												"DG_IMAGE/DAT_IMAGEMEMXFER/MSG_GET");               


								twRC2 = CallDSMEntry(&appID,
											&dsID, 
											DG_CONTROL,
											DAT_PENDINGXFERS, 
											MSG_ENDXFER,
											(TW_MEMREF)&twPendingXfer);

								if (twRC2 != TWRC_SUCCESS)
								{
										ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
													"", 
													"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER");             

								}
        

								if(twPendingXfer.Count==0)
								{
									CloseConnection(NULL);

								}

					   err=TWAcquireblockp->TWtrans(0,TWLASTCANCELLED,0,0);
								break;
                            
							case TWRC_FAILURE:
								

								/*
								* The transfer failed
								* Enhancement: Check Condition Code and attempt recovery
								*/
									ShowRC_CC(ML_ERROR,hWnd, 1, TWRC_FAILURE, 1,
												"",
												"DG_IMAGE/DAT_IMAGEMEMXFER/MSG_GET");               


								twRC2 = CallDSMEntry(&appID,
												&dsID, 
												DG_CONTROL,
												DAT_PENDINGXFERS, 
												MSG_ENDXFER,
												(TW_MEMREF)&twPendingXfer);

								if (twRC2 != TWRC_SUCCESS)
								{
										ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
													"", 
													"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER");             

								}


								if (twPendingXfer.Count == 0)               
								{
									CloseConnection(NULL);

								}

					   err=TWAcquireblockp->TWtrans(0,TWLASTFAILED,0,0);
								break;
                            
							default:
								

        ShowRC_CC(ML_ERROR,hWnd, 0, 0, 0,
												"Unknown Return Code",
												"DG_IMAGE/DAT_IMAGEMEMXFER/MSG_GET");               

								/*
								* Abort the image
								*/
								twRC2 = CallDSMEntry(&appID,
												&dsID, 
												DG_CONTROL,
												DAT_PENDINGXFERS, 
												MSG_ENDXFER,
												(TW_MEMREF)&twPendingXfer);

								if (twRC2 != TWRC_SUCCESS)
								{
										ShowRC_CC(ML_ERROR,hWnd, 1, twRC2, 1, 
													"", 
													"DG_CONTROL / DAT_PENDINGXFERS / MSG_ENDXFER");             

								}


								if (twPendingXfer.Count == 0)
								{
									CloseConnection(NULL);

								}

								err=TWAcquireblockp->TWtrans(0,TWLASTFAILED,0,0);

								/*
								* showRC_CC is a safe operation here since there will be no triplet
								* calls generated 
								*/
								if(AutoFeedOn())
								{
									wsprintf(buffer,"Images = %d",twPendingXfer.Count);
									ShowRC_CC(ML_INFO,NULL,0,0,0,buffer,"Pending Transfers");
								}
								break;
						} // switch
					} while (twRC == TWRC_SUCCESS);
				} 
			} 
		  
	} while (twPendingXfer.Count != 0);

	return;
}   

///////////////////////////////////////////////////////////////////////////////
// FUNCTION: LogMessage -- 
//
// ARGS:     msg
//
// RETURNS: none
//
// NOTES:
//
// COMMENTS: 
//	Writes debug strings to log file at c:\twacker.log.  Only
// runs when code is compiled in debug mode. 
//
void LogMessage(char msg[])
{ 
 cprintf("TWAIN:%s",msg);
}

//////////////////////////////////////////////////////////////////////
// FUNCTION: CloseConnection -- 
//
// ARGS:     hWnd
//
// RETURNS: none
//
// NOTES:
//
// COMMENTS: 
//		Disables the data source UI, closes the data source,
// and closes the DSM
//
void CloseConnection(HANDLE bitmap)
{	
	if (TWDisableDS())
	{
		if (TWCloseDS())
		{
			if (TWCloseDSM(bitmap))
			{
				//SUCCESS
				//CheckSpecialMenu(hWnd, TW_APP_CLOSESM);
				AcqFlag = 0;                    
			}
			else
			{
				//CheckSpecialMenu(hWnd, TW_APP_CLOSEDS);                 
				AcqFlag = 0;                    
			}
		}
		else
		{
			AcqFlag = 0;                                
			//CheckSpecialMenu(hWnd, TW_APP_DISABLE);             
		} 
	}

 if(TWAcquireblockp && TWAcquireblockp->TWend) TWAcquireblockp->TWend();

	return;
}



/***********************************************************************
 * FUNCTION:    TWTerminate
 * 
 * ARGS:    none
 * 
 * RETURNS: none
 *
 * NOTES:    To properly back out of a connection to a Source:
 *                TWDisableDS      disable the Source
 *                TWCloseDS        close the Source
 *                TWCloseDSM       close the Source Manager
 *
 * The simple parameterless calls do not support multiple connections.
 */

void TWTerminate(void)
{
 TWDisableDS();     /* this is required by 'the rules' */
 TWCloseDS();
 TWCloseDSM(NULL);

 if(TWAcquireblockp && TWAcquireblockp->TWend) TWAcquireblockp->TWend();
}


