
#/*->c.zmath */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "os.h"
#include "wimp.h"



#include "xmath.h"

#include "etc.h"

#include "transform.h"

#include "zmath.h"



int zpythag(int a,int b)
{
 big a2;
 big b2;
 big sum;

 if(b==0) return(ABS(a));
 else
 if(a==0) return(ABS(b));
 else
 {
  bigmul(&a2,a,a);
  bigmul(&b2,b,b);
  bigadd(&a2,&b2,&sum);
  return(bigsquareroot(&sum));
 }
}


static int ctab[91]=
{
    0x10000,
    0xFFF6,
    0xFFD8,
    0xFFA6,
    0xFF60,
    0xFF06,
    0xFE98,
    0xFE17,
    0xFD82,
    0xFCD9,
    0xFC1C,
    0xFB4B,
    0xFA67,
    0xF970,
    0xF865,
    0xF746,
    0xF615,
    0xF4D0,
    0xF378,
    0xF20D,
    0xF08F,
    0xEEFF,
    0xED5B,
    0xEBA6,
    0xE9DE,
    0xE803,
    0xE617,
    0xE419,
    0xE208,
    0xDFE7,
    0xDDB3,
    0xDB6F,
    0xD919,
    0xD6B3,
    0xD43B,
    0xD1B3,
    0xCF1B,
    0xCC73,
    0xC9BB,
    0xC6F3,
    0xC41B,
    0xC134,
    0xBE3E,
    0xBB39,
    0xB826,
    0xB504,
    0xB1D5,
    0xAE97,
    0xAB4C,
    0xA7F3,
    0xA48D,
    0xA11B,
    0x9D9B,
    0x9A10,
    0x9679,
    0x92D5,
    0x8F27,
    0x8B6D,
    0x87A8,
    0x83D9,
    0x8000,
    0x7C1C,
    0x782F,
    0x7438,
    0x7039,
    0x6C30,
    0x681F,
    0x6406,
    0x5FE6,
    0x5BBE,
    0x578E,
    0x5358,
    0x4F1B,
    0x4AD8,
    0x4690,
    0x4241,
    0x3DEE,
    0x3996,
    0x3539,
    0x30D8,
    0x2C74,
    0x280C,
    0x23A0,
    0x1F32,
    0x1AC2,
    0x164F,
    0x11DB,
    0xD65,
    0x8EF,
    0x477,
    0x0,
};





int zcos(int a)
{
 if(a<0) a=-a;
 while(a>360) a-=360;

 if(a<=90)           return(ctab[a]);
 if(a>90 && a<=180)  return(-ctab[180-a]);
 if(a>180 && a<=270) return(-ctab[a-180]);
                     return(ctab[360-a]);
}


int zcos2(int a)
{
 int c0;
 int c1;
 int f;

 c0=zcos(a/0x10000);
 c1=zcos(a/0x10000+1);

 f=a & 0xFFFF;

 return(scale(c0,0x10000-f,0x10000)+scale(c1,f,0x10000));
}



int zsin(int a)
{
 return(zcos(90-a));
}


int zsin2(int a)
{
 return(zcos2(90*0x10000-a));
}


int ztan(int a)
{
 return(scale(0x10000,zsin(a),zcos(a)));
}



int ztan2(int a)
{
 return(scale(0x10000,zsin2(a),zcos2(a)));
}




static int ttab[65]=
{
         0,
         0,
         1,
         2,
         3,
         4,
         5,
         6,
         7,
         8,
         8,
         9,
        10,
        11,
        12,
        13,
        14,
        14,
        15,
        16,
        17,
        18,
        18,
        19,
        20,
        21,
        22,
        22,
        23,
        24,
        25,
        25,
        26,
        27,
        27,
        28,
        29,
        30,
        30,
        31,
        32,
        32,
        33,
        33,
        34,
        35,
        35,
        36,
        36,
        37,
        37,
        38,
        39,
        39,
        40,
        40,
        41,
        41,
        42,
        42,
        43,
        43,
        44,
        44,
        45,
};



int zatan2(int y,int x)
{
 int xa;
 int ya;
 int t;

 xa=ABS(x);
 ya=ABS(y);

 if(xa>ya)
 {
  t=scale(64,ya,xa);
  t=ttab[t];
 }
 else
 {
  t=scale(64,xa,ya);
  t=ttab[t];
  t=90-t;
 }

 if(x<0 && y>=0)  t=180-t; /* t+=90; */
 if(x<0 && y<0)   t-=180;  /* t+=180; */
 if(x>=0 && y<0)  t=-t;    /* t-=90;*/  /* t+=270; */

 return(t);
}



static int ttab2[65]=
{
    0x0,
    0xE52A,
    0x1CA37,
    0x2AF0B,
    0x3938A,
    0x47797,
    0x55B17,
    0x63DEE,
    0x72001,
    0x80135,
    0x8E172,
    0x9C09E,
    0xA9EA1,
    0xB7B63,
    0xC56CE,
    0xD30CB,
    0xE0947,
    0xEE02C,
    0xFB569,
    0x1088EB,
    0x115AA1,
    0x122A7C,
    0x12F86C,
    0x13C465,
    0x148E58,
    0x15563C,
    0x161C04,
    0x16DFA8,
    0x17A11E,
    0x186060,
    0x191D65,
    0x19D829,
    0x1A90A7,
    0x1B46D9,
    0x1BFABE,
    0x1CAC53,
    0x1D5B95,
    0x1E0885,
    0x1EB321,
    0x1F5B69,
    0x200160,
    0x20A507,
    0x21465F,
    0x21E56B,
    0x22822E,
    0x231CAC,
    0x23B4E9,
    0x244AE9,
    0x24DEB1,
    0x257046,
    0x25FFAC,
    0x268CEB,
    0x271807,
    0x27A106,
    0x2827EF,
    0x28ACC8,
    0x292F98,
    0x29B066,
    0x2A2F37,
    0x2AAC14,
    0x2B2703,
    0x2BA00A,
    0x2C1732,
    0x2C8C82,
    0x2D0000,
};






int zatan22(int y,int x)
{
 int xa;
 int ya;
 int t;
 int f;

 xa=ABS(x);
 ya=ABS(y);

 if(xa>ya)
 {
  t=scale(64,ya,xa);
  f=64*ya-t*xa;
  t=scale(ttab2[t],xa-f,xa)+scale(ttab2[t+1],f,xa);
 }
 else
 {
  t=scale(64,xa,ya);
  f=64*xa-t*ya;
  t=scale(ttab2[t],ya-f,ya)+scale(ttab2[t+1],f,ya);
  t=90*0x10000-t;
 }

 if(x<0 && y>=0)  t=180*0x10000-t;
 if(x<0 && y<0)   t-=180*0x10000;
 if(x>=0 && y<0)  t=-t;

 return(t);
}










static int lntab[256+1]=
{
   0x0,
   0x171,
   0x2E0,
   0x44E,
   0x5BA,
   0x725,
   0x88E,
   0x9F7,
   0xB5D,
   0xCC3,
   0xE27,
   0xF8A,
   0x10EB,
   0x124B,
   0x13AA,
   0x1508,
   0x1664,
   0x17BF,
   0x1919,
   0x1A71,
   0x1BC8,
   0x1D1E,
   0x1E73,
   0x1FC6,
   0x2119,
   0x226A,
   0x23BA,
   0x2508,
   0x2656,
   0x27A2,
   0x28ED,
   0x2A37,
   0x2B80,
   0x2CC8,
   0x2E0F,
   0x2F54,
   0x3098,
   0x31DC,
   0x331E,
   0x345F,
   0x359F,
   0x36DE,
   0x381B,
   0x3958,
   0x3A94,
   0x3BCE,
   0x3D08,
   0x3E41,
   0x3F78,
   0x40AF,
   0x41E4,
   0x4319,
   0x444C,
   0x457F,
   0x46B0,
   0x47E1,
   0x4910,
   0x4A3F,
   0x4B6C,
   0x4C99,
   0x4DC5,
   0x4EEF,
   0x5019,
   0x5142,
   0x526A,
   0x5391,
   0x54B7,
   0x55DC,
   0x5700,
   0x5824,
   0x5946,
   0x5A68,
   0x5B89,
   0x5CA8,
   0x5DC7,
   0x5EE5,
   0x6003,
   0x611F,
   0x623A,
   0x6355,
   0x646F,
   0x6588,
   0x66A0,
   0x67B7,
   0x68CE,
   0x69E4,
   0x6AF8,
   0x6C0C,
   0x6D20,
   0x6E32,
   0x6F44,
   0x7055,
   0x7165,
   0x7274,
   0x7383,
   0x7490,
   0x759D,
   0x76AA,
   0x77B5,
   0x78C0,
   0x79CA,
   0x7AD3,
   0x7BDB,
   0x7CE3,
   0x7DEA,
   0x7EF0,
   0x7FF6,
   0x80FB,
   0x81FF,
   0x8302,
   0x8405,
   0x8507,
   0x8608,
   0x8709,
   0x8809,
   0x8908,
   0x8A06,
   0x8B04,
   0x8C01,
   0x8CFE,
   0x8DFA,
   0x8EF5,
   0x8FEF,
   0x90E9,
   0x91E2,
   0x92DB,
   0x93D2,
   0x94CA,
   0x95C0,
   0x96B6,
   0x97AB,
   0x98A0,
   0x9994,
   0x9A87,
   0x9B7A,
   0x9C6C,
   0x9D5E,
   0x9E4F,
   0x9F3F,
   0xA02E,
   0xA11E,
   0xA20C,
   0xA2FA,
   0xA3E7,
   0xA4D4,
   0xA5C0,
   0xA6AB,
   0xA796,
   0xA881,
   0xA96A,
   0xAA53,
   0xAB3C,
   0xAC24,
   0xAD0C,
   0xADF2,
   0xAED9,
   0xAFBE,
   0xB0A4,
   0xB188,
   0xB26C,
   0xB350,
   0xB433,
   0xB515,
   0xB5F7,
   0xB6D9,
   0xB7BA,
   0xB89A,
   0xB97A,
   0xBA59,
   0xBB38,
   0xBC16,
   0xBCF4,
   0xBDD1,
   0xBEAD,
   0xBF8A,
   0xC065,
   0xC140,
   0xC21B,
   0xC2F5,
   0xC3CF,
   0xC4A8,
   0xC580,
   0xC658,
   0xC730,
   0xC807,
   0xC8DE,
   0xC9B4,
   0xCA8A,
   0xCB5F,
   0xCC34,
   0xCD08,
   0xCDDC,
   0xCEAF,
   0xCF82,
   0xD054,
   0xD126,
   0xD1F7,
   0xD2C8,
   0xD399,
   0xD469,
   0xD538,
   0xD607,
   0xD6D6,
   0xD7A4,
   0xD872,
   0xD93F,
   0xDA0C,
   0xDAD9,
   0xDBA5,
   0xDC70,
   0xDD3B,
   0xDE06,
   0xDED0,
   0xDF9A,
   0xE063,
   0xE12C,
   0xE1F5,
   0xE2BD,
   0xE385,
   0xE44C,
   0xE513,
   0xE5D9,
   0xE69F,
   0xE765,
   0xE82A,
   0xE8EF,
   0xE9B3,
   0xEA77,
   0xEB3B,
   0xEBFE,
   0xECC1,
   0xED83,
   0xEE45,
   0xEF06,
   0xEFC8,
   0xF088,
   0xF149,
   0xF209,
   0xF2C8,
   0xF387,
   0xF446,
   0xF505,
   0xF5C3,
   0xF680,
   0xF73E,
   0xF7FB,
   0xF8B7,
   0xF973,
   0xFA2F,
   0xFAEA,
   0xFBA5,
   0xFC60,
   0xFD1A,
   0xFDD4,
   0xFE8E,
   0xFF47,
   0x10000,
};


static int exptab[256+1]=
{
   0x10000,
   0x100B2,
   0x10164,
   0x10217,
   0x102CA,
   0x1037D,
   0x10431,
   0x104E6,
   0x1059B,
   0x10651,
   0x10707,
   0x107BD,
   0x10874,
   0x1092C,
   0x109E4,
   0x10A9C,
   0x10B56,
   0x10C0F,
   0x10CC9,
   0x10D84,
   0x10E3F,
   0x10EFA,
   0x10FB6,
   0x11073,
   0x11130,
   0x111EE,
   0x112AC,
   0x1136B,
   0x1142A,
   0x114E9,
   0x115AA,
   0x1166A,
   0x1172C,
   0x117ED,
   0x118B0,
   0x11972,
   0x11A36,
   0x11AFA,
   0x11BBE,
   0x11C83,
   0x11D48,
   0x11E0E,
   0x11ED5,
   0x11F9C,
   0x12064,
   0x1212C,
   0x121F5,
   0x122BE,
   0x12388,
   0x12452,
   0x1251D,
   0x125E8,
   0x126B4,
   0x12781,
   0x1284E,
   0x1291C,
   0x129EA,
   0x12AB9,
   0x12B88,
   0x12C58,
   0x12D28,
   0x12DF9,
   0x12ECB,
   0x12F9D,
   0x13070,
   0x13143,
   0x13217,
   0x132EC,
   0x133C1,
   0x13496,
   0x1356C,
   0x13643,
   0x1371A,
   0x137F2,
   0x138CB,
   0x139A4,
   0x13A7E,
   0x13B58,
   0x13C33,
   0x13D0E,
   0x13DEA,
   0x13EC7,
   0x13FA4,
   0x14082,
   0x14161,
   0x14240,
   0x1431F,
   0x14400,
   0x144E1,
   0x145C2,
   0x146A4,
   0x14787,
   0x1486A,
   0x1494E,
   0x14A33,
   0x14B18,
   0x14BFE,
   0x14CE4,
   0x14DCB,
   0x14EB3,
   0x14F9B,
   0x15084,
   0x1516E,
   0x15258,
   0x15343,
   0x1542E,
   0x1551A,
   0x15607,
   0x156F4,
   0x157E2,
   0x158D1,
   0x159C1,
   0x15AB0,
   0x15BA1,
   0x15C92,
   0x15D84,
   0x15E77,
   0x15F6A,
   0x1605E,
   0x16153,
   0x16248,
   0x1633E,
   0x16434,
   0x1652C,
   0x16624,
   0x1671C,
   0x16815,
   0x1690F,
   0x16A0A,
   0x16B05,
   0x16C01,
   0x16CFE,
   0x16DFB,
   0x16EF9,
   0x16FF8,
   0x170F7,
   0x171F7,
   0x172F8,
   0x173FA,
   0x174FC,
   0x175FF,
   0x17702,
   0x17807,
   0x1790C,
   0x17A11,
   0x17B18,
   0x17C1F,
   0x17D27,
   0x17E2F,
   0x17F38,
   0x18042,
   0x1814D,
   0x18259,
   0x18365,
   0x18472,
   0x1857F,
   0x1868E,
   0x1879D,
   0x188AC,
   0x189BD,
   0x18ACE,
   0x18BE0,
   0x18CF3,
   0x18E07,
   0x18F1B,
   0x19030,
   0x19146,
   0x1925C,
   0x19373,
   0x1948C,
   0x195A4,
   0x196BE,
   0x197D8,
   0x198F3,
   0x19A0F,
   0x19B2C,
   0x19C49,
   0x19D67,
   0x19E86,
   0x19FA6,
   0x1A0C6,
   0x1A1E8,
   0x1A30A,
   0x1A42D,
   0x1A550,
   0x1A675,
   0x1A79A,
   0x1A8C0,
   0x1A9E7,
   0x1AB0E,
   0x1AC37,
   0x1AD60,
   0x1AE8A,
   0x1AFB5,
   0x1B0E0,
   0x1B20D,
   0x1B33A,
   0x1B468,
   0x1B597,
   0x1B6C7,
   0x1B7F7,
   0x1B929,
   0x1BA5B,
   0x1BB8E,
   0x1BCC2,
   0x1BDF7,
   0x1BF2C,
   0x1C063,
   0x1C19A,
   0x1C2D2,
   0x1C40B,
   0x1C544,
   0x1C67F,
   0x1C7BB,
   0x1C8F7,
   0x1CA34,
   0x1CB72,
   0x1CCB1,
   0x1CDF1,
   0x1CF31,
   0x1D073,
   0x1D1B5,
   0x1D2F8,
   0x1D43D,
   0x1D582,
   0x1D6C7,
   0x1D80E,
   0x1D956,
   0x1DA9E,
   0x1DBE8,
   0x1DD32,
   0x1DE7D,
   0x1DFC9,
   0x1E116,
   0x1E264,
   0x1E3B3,
   0x1E503,
   0x1E654,
   0x1E7A5,
   0x1E8F8,
   0x1EA4B,
   0x1EB9F,
   0x1ECF5,
   0x1EE4B,
   0x1EFA2,
   0x1F0FA,
   0x1F253,
   0x1F3AD,
   0x1F507,
   0x1F663,
   0x1F7C0,
   0x1F91E,
   0x1FA7C,
   0x1FBDC,
   0x1FD3C,
   0x1FE9E,
   0x20000,
};




int zpow(int x,int y)
{
 int e;
 int l;


 if(x<=0) return(0);

 e=0;

 while(x<0x10000)
 {
  x=x<<1;
  e--;
 }

 while(x>0x20000)
 {
  x=x>>1;
  e++;
 }

 l=e*0x10000+lntab[(x-0x10000)/0x100];

 l=scale(l,y,0x10000);

 e=0;

 while(l<0x0)
 {
  l+=0x10000;
  e--;
 }

 while(l>0x10000)
 {
  l-=0x10000;
  e++;
 }

 if(e<0) x=exptab[l/0x100]>>(-e);
 else    x=exptab[l/0x100]<<(e);

 return(x);
}






#define tumul ttmul




static transformstr tr_identity=
{
 0x10000,
 0,
 0,
 0x10000,
 0,
 0
};





/* r=t1 x t2 */

void ztr_multiply(transformstr * r,transformstr * t1,transformstr * t2)
{
 r->a=ttmul(t1->a,t2->a)+ttmul(t1->b,t2->c);
 r->b=ttmul(t1->a,t2->b)+ttmul(t1->b,t2->d);
 r->c=ttmul(t1->c,t2->a)+ttmul(t1->d,t2->c);
 r->d=ttmul(t1->c,t2->b)+ttmul(t1->d,t2->d);
 r->e=tumul(t2->a,t1->e)+tumul(t2->c,t1->f)+t2->e;
 r->f=tumul(t2->b,t1->e)+tumul(t2->d,t1->f)+t2->f;
}




void ztr_setidentity(transformstr * t)
{
 *t=tr_identity;
}




void ztr_setrotationa(transformstr * t,int angle)
{
 ztr_setidentity(t);
 t->a=t->d=zcos2(angle);
 t->b=zsin2(angle);
 t->c=-t->b;
}



void ztr_setshift(transformstr * t,int dx,int dy)
{
 ztr_setidentity(t);
 t->e=dx;
 t->f=dy;
}




static void ztr_set(coordstr * coord,int n,transformstr * t)
{
 int i;
 int tempx;
 int tempy;

 for(i=0;i<n;i++)
 {
  tempx=tumul(t->a,coord[i].x)+tumul(t->c,coord[i].y)+t->e;

  tempy=tumul(t->b,coord[i].x)+tumul(t->d,coord[i].y)+t->f;
  coord[i].x=tempx;
  coord[i].y=tempy;
 }
}






void tr_box(wimp_box * i,wimp_box * o,transformstr * tr)
{
 coordstr cx[4];
 int      n;

 cx[0].x=i->x0;
 cx[0].y=i->y0;
 cx[1].x=i->x1;
 cx[1].y=i->y0;
 cx[2].x=i->x1;
 cx[2].y=i->y1;
 cx[3].x=i->x0;
 cx[3].y=i->y1;

 ztr_set(cx,4,tr);

 o->x0=o->x1=cx[0].x;
 o->y0=o->y1=cx[0].y;

 for(n=1;n<4;n++)
 {
  o->x0=MIN(o->x0,cx[n].x);
  o->x1=MAX(o->x1,cx[n].x);
  o->y0=MIN(o->y0,cx[n].y);
  o->y1=MAX(o->y1,cx[n].y);
 }
}




void getmaxbox(int * x0,int * y1,int * x1,int * y0,int angle)
{
 wimp_box     i;
 wimp_box     o;
 transformstr tr;

 i.x0=*x0;
 i.x1=*x1;
 i.y0=*y0;
 i.y1=*y1;

 ztr_setrotationa(&tr,angle);
 tr_box(&i,&o,&tr);

 *x0=o.x0;
 *x1=o.x1;
 *y0=o.y0;
 *y1=o.y1;
}






void getmaxboxp(int * x0,int * y1,int * x1,int * y0,int angle,int x,int y)
{
 wimp_box     i;
 wimp_box     o;
 transformstr tr1;
 transformstr tr2;
 transformstr tr3;
 transformstr tr4;

 i.x0=*x0;
 i.x1=*x1;
 i.y0=*y0;
 i.y1=*y1;

 ztr_setshift(&tr1,-x,-y);
 ztr_setrotationa(&tr2,angle);
 ztr_setshift(&tr3,x,y);

 ztr_multiply(&tr4,&tr1,&tr2);
 ztr_multiply(&tr1,&tr4,&tr3);

 tr_box(&i,&o,&tr1);

 *x0=o.x0;
 *x1=o.x1;
 *y0=o.y0;
 *y1=o.y1;
}



