/*->c.vm */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "xmath.h"
#include "etc.h"
#include "scrap.h"
#include "deb.h"


#include "constants.h"
#include "str.h"


#include "vm.h"




#ifdef USEVM


/* vm */

typedef struct blockstr
{
 int               daddr;  /* address on disc            */
 int               size;   /* size                       */
 struct blockstr * bnext;  /* next block in this bucket  */
 struct blockstr * bprev;
 struct blockstr * next;   /* next higher adjacent block */
 struct blockstr * prev;   /* prev lower  adjacent block */
 int               free;
 int               bucket;

} blockstr;


#define MAXBUCKETS 30

static blockstr * buckets[MAXBUCKETS];

static int blocks;
static int maxextent;

static blockstr * maxblock;

static fshandle vmfh;      /* file handle */
static int vmfn;      /* scrap file number */

static int laddr;



static blockstr * tempbp;


/* these rotuines ensure that we always have 1 spare block in hand */
/* and can page a chunk out, without calling flex for more memory  */


void vmmemory(void)
{
 if(!tempbp)  
 {
  salloc((void**)&tempbp,sizeof(blockstr));
 }
}


os_error * vminit(void)
{
 vmmemory();
 return(NULL);
}


static os_error * bdestroy(blockstr * bp)
{
 os_error * err;

 if(tempbp && ((char*)bp)<((char*)tempbp))
 {
  err=sfree((void**)&tempbp);
  tempbp=bp;
 }
 else
 {
  err=sfree((void**)&bp);
 }

 blocks--;

 return(err);
}


static os_error * bcreate(blockstr ** bp)
{
 os_error * err;

/* flex_check(); */

 err=NULL;

 if(tempbp) 
 {
  *bp=tempbp;
  tempbp=NULL;
 }
 else
 {
  err=salloc((void**)bp,sizeof(blockstr));
 }

 blocks++;

 (*bp)->bucket=-1;

 return(err);
}


static os_error * vmend(void);

static os_error * vmterminate(int eventn,wimp_w userhandle,void * data,int data1)
{
/* dprintf(1,"vm terminate"); */


 vmend();
 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}


static os_error * vmend(void)
{
 os_error * err;
 char     * name;

 err=NULL;

 cprintf("vmend");

 if(vmfh)
 {
  err=fs_close(vmfh,err);
  name=sc_name(vmfn);
  fs_delete(name);
  err=sc_remove(vmfn,err);
  vmfh=0;
  remevent(EVENT_ENDPROGRAM,vmterminate,0);
 }

 return(err);
}


static os_error * vmstart(void)
{
 os_error * err;
 char     * name;

 cprintf("vmstart ****");

 err=sc_create(&vmfn);

 if(!err)
 {
  name=sc_name(vmfn);

  cprintf("name %s",name);

  err=fs_open(name,'u',&vmfh);
  if(!err)
  {
   addevent(EVENT_ENDPROGRAM,vmterminate,0);
  }
  else
  {
   err=sc_remove(vmfn,err);
  }
 }

 maxblock=NULL;

 return(err);
}




#ifdef MEMDBUG

static void vmdebug(char * name)
{
 blockstr * bp;
 int        bsum;
 int        xsum;
 int        count;

 bp=maxblock;
 bsum=xsum=0;
 count=blocks+1;

 printf(" %s blocks=%d extent=%d\n",name,blocks,maxextent);
 while(bp && count--)
 {
/*  dprintf(0,"bp=%x next=%x prev=%x size=%d free=%d daddr=%d\n",bp,bp->next,bp->prev,bp->size,bp->free,bp->daddr); */

  xsum+=bp->size;
  bsum++;


  bp=bp->prev;
 }

 if(blocks!=bsum) printf("**blocks error blocks=%d sum=%d",blocks,bsum);
 if(maxextent!=xsum) printf("**sum error extent=%d sum=%d",maxextent,xsum);
}



static void vmcheck(void)
{
 blockstr * bp;
 blockstr * prev;

 bp=maxblock;

 while(bp)
 {
  prev=bp->prev;

  if(prev)
  {
   if((prev->daddr+prev->size)>bp->daddr) dprintf(5,"block overlap");
   if(prev->daddr>bp->daddr) dprintf(6,"block out of order");
  }

  bp=prev;
 }
}


void vmbigcheck(void)
{
 vmdebug("xxxxxxxxx");
 vmcheck();
}


#endif





static int findbucket(int size)
{
 int i;

 i=0;
 while(size>=(1<<i)) i++;

 return(i-1);
}


#ifdef MEMDBUG

static void bcheck(char * at)
{
 int i;
 blockstr * bp;

 for(i=0;i<MAXBUCKETS;i++)
 {
  bp=buckets[i];
  while(bp)
  {
   if(bp->bucket!=i) dprintf(7,"block in wrong chain %d %d",bp->bucket,i);
   else
   if(i!=findbucket(bp->size)) dprintf(7,"size mismatch");
   else
   if(bp->bnext==bp) dprintf(7,"block next == block"); 
   else
   if(bp->bnext && (bp->bnext)->bprev!=bp) 
      dprintf(7,"block next prev!=block next=%x prev=%x bp=%x",
                    bp->next,(bp->bnext)->bprev,bp);
   else
   if(!bp->free) dprintf(7,"non free block in chain");
   else 
   {
    bp=bp->bnext;
    continue;
   }

   bp=bp->bnext;
   dprintf(0,"%s",at);
  }
 }
}

#endif



/* put a block in correct bucket chain */

static void bucket(blockstr * bp)
{
 int chain;

 chain=findbucket(bp->size);

 bp->bprev=NULL;
 bp->bnext=buckets[chain];
 if(buckets[chain]) buckets[chain]->bprev=bp;
 buckets[chain]=bp;
 bp->free=1;
 bp->bucket=chain;

}


static void unbucket(blockstr * bp)
{
 int        chain;
 blockstr * bprev;
 blockstr * bnext;

 chain=findbucket(bp->size);
 bnext=bp->bnext;
 bprev=bp->bprev;

 if(!bprev) buckets[chain]=bnext;
 else       bprev->bnext=bnext;

 if(bnext)  bnext->bprev=bprev;

 bp->free=0;

}



static os_error * findblock(int size,int * addr)
{
 os_error * err;
 int        chain;
 blockstr * bp;
 blockstr * newblock;
 blockstr * best;
 int        diff;
 int        delta;


/* dprintf(0,"find block in "); */

 err=NULL;

 size=(size+0x3FF) & (~0x3FF);

 chain=findbucket(size);


 best=NULL;
 diff=-1;
 bp=buckets[chain];
 while(bp)
 {                           /* find best fit here */
  delta=bp->size-size;

  if(delta>=0)
  {
   if(diff==-1 || delta<diff)   {best=bp;diff=delta;}
  }
  bp=bp->bnext;
 }
 bp=best;


 if(!bp)
 {
  while(++chain<MAXBUCKETS)
  {
   bp=buckets[chain];
   while(bp)            /* certain to be true after 1 block */
   {
    if(bp->size>=size) break;
    bp=bp->bnext;
   }
   if(bp) break;
  }
 }


 if(bp) /* got a free block, split */
 {
/*  if(!bp->free) dprintf(6,"using non-free block %x",bp); */

  unbucket(bp);

  if(bp->size>size)
  {
   bcreate(&newblock);
   newblock->size=bp->size-size;
   newblock->daddr=bp->daddr+size;
   newblock->bprev=newblock->bnext=NULL;

   newblock->prev=bp;
   newblock->next=bp->next;
   bp->next=newblock;
   if(newblock->next) (newblock->next)->prev=newblock;

   bucket(newblock);
  }

  bp->size=size;
 }
 else
 {
  bcreate(&bp);

  if(maxblock) maxblock->next=bp;
  bp->prev=maxblock;
  bp->next=NULL;
  bp->free=0;
  bp->bnext=bp->bprev=NULL;
  bp->daddr=maxextent;
  bp->size=size;
  maxextent+=size;
  maxblock=bp;
 }

 *addr=(int)bp;

/* dprintf(0,"find block out"); */

 return(err);
}




os_error * vmclear(int addr)
{
 os_error * err;
 blockstr * bp;
 blockstr * next;
 blockstr * prev;

 err=NULL;

 bp=(blockstr *)addr;

 prev=bp->prev;
 next=bp->next;

 if(prev)
 {
  if(prev->free)
  {
   unbucket(prev);
   prev->next=next;
   if(next) next->prev=prev;
   prev->size+=bp->size;
   if(bp==maxblock) maxblock=prev;

   bdestroy(bp);

   bp=prev;
   next=bp->next;
   prev=bp->prev;
  }
 }


 if(next)
 {
  if(next->free)
  {
   unbucket(next);
   bp->next=next->next;
   if(next->next) (next->next)->prev=bp;
   bp->size+=next->size;
   bdestroy(next);
  }

  bucket(bp);
 }
 else  /* bp is the last block, modify file */
 {
  maxextent-=bp->size;
  maxblock=bp->prev;
  if(maxblock) maxblock->next=NULL;
  bdestroy(bp);
  if(!blocks) err=vmend();
  else        err=fs_setfileextent(vmfh,maxextent);
 }

/* vmdebug("clear"); */

 return(err);
}



os_error * vmload(void ** data,int size,int addr)
{
 os_error * err;
 blockstr * bp;

 bp=(blockstr *)addr;
  if(size>bp->size)
  {
/*   dprintf(5,"block size load error free=%d",bp->free); */
  }

 fs_seek(vmfh,laddr=bp->daddr);
 err=fs_read(vmfh,*data,size); 
 if(!err)
 {
  vmclear(addr);
 }

 return(err);
}




os_error * vmsave(void ** data,int size,int * addr)
{
 os_error * err;
 blockstr * bp;

 /* dprintf(0,"vmsave data=%x size=%d",*data,size); */

 err=NULL;

 if(!blocks) err=vmstart();
 if(!err)
 {
  err=findblock(size,addr);
  if(!err)
  {
   bp=(blockstr*)(*addr);
   fs_seek(vmfh,laddr=bp->daddr);
   err=fs_write(vmfh,*data,size); 

  /* if(size>bp->size) dprintf(5,"block size error "); */

  }
 }

/* vmdebug("save"); */

 return(err);
}


void vmgetsize(int * used,int * max)
{
 os_error * err;
// os_regset  rx;
 char   temp[256];
 char * p;
 int   seencolon;

 err=NULL;

 *used=0;
 *max=100*1024*1024;

 if(blocks) 
 {
  *used=maxextent;

  p=sc_name(vmfn);

//  rx.r[0]=37;
//  rx.r[1]=(int)p;
//  rx.r[2]=(int)temp;
//  rx.r[3]=0;
//  rx.r[4]=0;
//  rx.r[5]=sizeof(temp);

//  err=os_swix(OS_FSControl,&rx);
  if(!err)
  {
/*   dprintf(1,"name=%s",temp); */

   p=temp;
   seencolon=0;
   while(*p) 
   {
    if(*p=='.' && seencolon==2) break;
    else
    if(*p==':') seencolon++;
    p++;
   }

   if(*p)
   {
    *p=0;

//    rx.r[0]=49;
//    rx.r[1]=(int)temp;

//    err=os_swix(OS_FSControl,&rx);

 /*   dprintf(2,"r0=%d r1=%d r2=%d",rx.r[0],rx.r[1],rx.r[2]); */

    if(!err)
    {
//     *max=rx.r[0]+maxextent;
    }
   }
  }
 }
}


#endif

