
/*->c.viewr */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"

#include "err.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "colour.h"
#include "deb.h"
#include "sprx.h"
#include "osunits.h"
#include "dbhi.h"


#include "str.h"
#include "reslink.h"
#include "file.h"

#include "chunk.h"

#include "view.h"
#include "viewo.h"
#include "viewr.h"

#include "pr.h"
#include "im.h"
#include "cx.h"
#include "tools.h"
#include "target.h"
#include "cms.h"




void setcoords(viewredrawstr * v)
{
 viewstr * view;
 filestr * file;

 view=v->view;
 file=v->file;

 v->yloz=ourunits(v->ylox,view);
 v->yhiz=ourunits(v->yhix,view);
 v->xloz=ourunits(v->xlox,view);
 v->xhiz=ourunits(v->xhix,view);

 v->yps=0;
 v->xps=0;

 v->xpe=v->xhi=v->xps+file->width;
 v->xlo=v->xps;

 if(v->xhi>v->xhiz) v->xhi=v->xhiz;
 if(v->xlo<v->xloz) v->xlo=v->xloz;

 v->xlos=v->xlo-v->xps;
 v->xhis=v->xhi-v->xps;


 v->yhi=v->ype=v->yps+file->height;
 v->ypo=v->ylo=v->yps;


 if(v->yhi>v->yhiz) v->yhi=v->yhiz;
 if(v->ylo<v->yloz) v->ylo=v->yloz;

 v->ylos=v->ylo-v->yps;
 v->yhis=v->yhi-v->yps;
}





#ifdef MEMDBUG

imchunkstr * spchunk;

void spcheck(char * when)
{
 if(spchunk)
 {
  if(spchunk->data)
  {
   if(spchunk->crc!=crcchunk(spchunk)) 
                  dprintf(0,"chunk crc error at %s",when);
   else           dprintf(0,"chunk OK");
  }
  else dprintf(0,"no spchunk data");

 }
 else dprintf(0,"no spchunk");
}

#endif



static os_error * redrawimage(viewredrawstr * v)
{
 os_error * err;
 viewstr  * view;
 filestr  * file;
 int        xplot;
 int        yplot;
 int        xplotpx;
 int        yplotpx;
 int        ytop;
 imagestr * scrim;
 imagestr * orgim;
 int        chunk;
 sprite_header * sph;
 imchunkstr * chunkp;
 sprite_id    sid;

 err=NULL;
 view=v->view;
 file=v->file;

/* dprintf(0,"redraw in "); */


 if(view->im)
 {
  scrim=view->im;
  orgim=((file->frames[view->frame].xim)->sim[IM]);
  chunkp=scrim->imchunk;

  for(chunk=0;chunk<scrim->imchunks;chunk++,chunkp++)
  {
   xplot=v->ox+osunits(view->tr.e,view);
   yplot=v->oy-osunits(view->tr.f,view);
//   yplot=yos2pix(yplot);
//   yplot-=chunkp->el;
//   yplot=ypix2os(yplot);

   xplotpx=xplot;
   yplotpx=yplot;

   gros2pix(&xplotpx,&yplotpx);
   yplotpx+=chunkp->el;

   yplot=yos2pix(yplot);
   yplot-=chunkp->el;
   yplot=ypix2os(yplot)-1;

   ytop=v->oy-osunits(view->tr.f,view);
   ytop=yos2pix(ytop);
   ytop-=chunkp->sl;
   ytop=ypix2os(ytop)+1;

   if(
      (ytop<=v->redrawstr.g.y1  && ytop>=v->redrawstr.g.y0) ||
      (yplot<=v->redrawstr.g.y1 && yplot>=v->redrawstr.g.y0)||
      (v->redrawstr.g.y1<=ytop  && v->redrawstr.g.y1>=yplot)||
      (v->redrawstr.g.y0<=ytop  && v->redrawstr.g.y0>=yplot)
     )
   {
    if(!chunkp->chunk)  /* convert a chunk */
    {
    /* dprintf(0,"convert in%d",view->data.dither); */
     convert(scrim,orgim,&view->tr,chunkp->sl,chunkp->el,view->data.dither);
   /*  dprintf(0,"convert out"); */
#ifdef MEMDBUG
     chunkp->crc=crcchunk(chunkp);
     if(!chunk) spchunk=chunkp;
#endif
    }

   /* dprintf(0,"redraw vmens in "); */
    err=ivmchunkensurer(&chunkp->chunk,chunkp->size);
   /* dprintf(0,"redraw vmens out"); */
    if(!err)
    {
     sph=(sprite_header*)(chunkp->chunk)->data;
     memset(sph,0,sizeof(sprite_header));

     if(sph)
     {
      sph->next=sizeof(sprite_header)+scrim->wwidth*4*scrim->ypix;
      sprintf(sph->name,"plot");
      sph->width=scrim->wwidth-1;                /* words - 1 */
      sph->height=(chunkp->el-chunkp->sl)-1;     /* height -1 */
      sph->lbit=0;
      sph->rbit=(scrim->xpix*scrim->bpp-1) % 32; 
      sph->image=sizeof(sprite_header);
      sph->mask=sph->image;

      if(scrim->bpp<=8) sph->mode=cvdu.mode;
      else
      {
       sph->mode=1+(scrim->xdpi<<1)+(scrim->ydpi<<14);
       if(scrim->bpp==16) sph->mode|=(5<<27);
       else               sph->mode|=(6<<27);
      }

//      sph->mode=1+(scrim->xdpi<<1)+(scrim->ydpi<<14)+((3+1)<<27);


                                    /* plot the chunk  */
      sid.s.addr=(sprite_area *)sph;
      sid.tag=sprite_id_addr;

      sprite_put_givenpx((sprite_area*)0xFF,&sid,0,xplotpx,yplotpx);

      /* ivmchunkdestroy(chunkp); */
     }
    }
   }
  }
 }

/* dprintf(0,"redraw out"); */

 if(err) viewopencrash(view);

 return(err);
}




static os_error * viewredrawsub(viewredrawstr * v,int more)
{
 os_error     * err;
 viewstr      * view;
 filestr      * file;

 view=v->view;
 file=v->file;

 err=NULL;

 while(more && !err)
 {
  v->ox=v->redrawstr.box.x0-v->redrawstr.scx;
  v->oy=v->redrawstr.box.y1-v->redrawstr.scy;

  v->ylox=-(v->redrawstr.g.y1-v->oy)-cvdu.extray;
  v->yhix=-(v->redrawstr.g.y0-v->oy)+cvdu.extray;
  v->xlox=v->redrawstr.g.x0-v->ox-cvdu.extrax;
  v->xhix=v->redrawstr.g.x1-v->ox+cvdu.extrax;

  setcoords(v);

  if(v->layer==VRBACK || !v->layer) err=redrawimage(v);

  if(v->layer==VRSELECT || !v->layer) 
  {
   if(tooltable[tool].redraw) tooltable[tool].redraw(v);
  }

  if(v->layer==VRTARGET || !v->layer) 
  {
   targetredraw(v);
  }

  if(v->layer==VRPRINT || !v->layer)
  {
   if(view->data.printmargin) redrawprint(v);
  }

  wimp_get_rectangle(&v->redrawstr,&more);
 }
 return(err);
}



os_error * viewredraw(wimp_w handle,uservalue userhandle)
{
 os_error     * err;
 viewredrawstr  v;
 int            more;
 viewstr      * view;
 filestr      * file;

 view=(viewstr*)userhandle;
 file=view->file;
 v.redrawstr.w=handle;
 v.view=view;
 v.file=file;
 v.layer=VRBACK;
 v.isprinter=0;

 err=wimp_redraw_wind(&v.redrawstr,&more);
 if(!err) err=viewredrawsub(&v,more);

 return(err);
}


/*****************************************************************************/
/* printer redraws */

/* 
   The idea is to work out a scaling factor that results in one pixel from the
   image hitting one pixel on screen. When we print, we reverse scale by
   that factor.
   Ideally the mode of the sprite should have the same aspect ratio
   as the current screen mode, and a number of colours to match the printer.
   The palette/mode of the sprite should be chosen to match the image
   and the printer.
 */


static imagestr     * primage;
static transformstr   prtr;

static int prxpix;
static int prypix;

int    prxdpi;
int    prydpi;
int    prsxdpi;
int    prsydpi;

static int prmode;


/* redrawstr.g.x0=box[0]; */




os_error * viewprintredraw(int invert,wimp_redrawstr * redrawstr)
{
 os_error      * err;
 int             xplot;
 int             yplot;
 int             xplotpx;
 int             yplotpx;
 int             ytop;
 imagestr      * orgim;
 framestr      * fr;
 int             chunk;
 sprite_header * sph;
 imchunkstr    * chunkp;
 int             ox;
 int             oy;
// int             i;
// int           * p;
// char            temp[256*2*4+sizeof(sprite_header)];
// sprite_header * sphp;
 sprite_id       sid;

 err=NULL;


// cprintf("cvdu xdpi %d ydpi %d",cvdu.xdpi,cvdu.ydpi);

 ox=0;
 oy=bosunits(scale(prfile->height,prydpi,prsydpi));
 oy&=cvdu.masky;

 ox=redrawstr->box.x0-redrawstr->scx;
 oy=redrawstr->box.y1-redrawstr->scy;


 {
  fr=&prfile->frames[prview->frame];
  orgim=((fr->xim)->sim[IM]);
  chunkp=primage->imchunk;

  for(chunk=0;chunk<primage->imchunks;chunk++,chunkp++)
  {
   xplot=ox+osunits(orgim->tr.e,prview);

//   yplot=oy-(180*chunkp->el)/primage->ydpi;
//   ytop =oy-(180*chunkp->sl)/primage->ydpi;

 /*  yplot=oy-deltay*((chunkp->el*psypix)/prypix);
   ytop =oy-deltay*((chunkp->sl*psypix)/prypix); */

//   yplot-=osunits(orgim->tr.f,prview);


   yplot=oy-osunits(orgim->tr.f,prview);
   xplotpx=xplot;
   yplotpx=yplot;

   gros2pix(&xplotpx,&yplotpx);
//   yplot=yos2pix(yplot);
   yplotpx+=chunkp->el;
//   yplot=ypix2os(yplot);
//   grpix2os(&xplot,&yplot);

   ytop=oy-osunits(orgim->tr.f,prview);
   ytop=yos2pix(ytop);
   ytop-=chunkp->sl;
   ytop=ypix2os(ytop);




//   cprintf("******");
//   cprintf("xplot=%d yplot=%d ytop=%d\n",xplot,yplot,ytop);
//   cprintf("gx0=%d gx1=%d gy0=%d gy1=%d\n",
//                           redrawstr->g.x0,redrawstr->g.x1,
//                           redrawstr->g.y0,redrawstr->g.y1);

//   cprintf("sl=%d el=%d ydpi=%d chunks=%d\n",chunkp->sl,chunkp->el,primage->ydpi,primage->chunks);


   if(
      (ytop<=redrawstr->g.y1  && ytop>=redrawstr->g.y0) ||
      (yplot<=redrawstr->g.y1 && yplot>=redrawstr->g.y0)||
      (redrawstr->g.y1<=ytop  && redrawstr->g.y1>=yplot)||
      (redrawstr->g.y0<=ytop  && redrawstr->g.y0>=yplot)
     )
   {
//           cprintf("xp %d yp %d",xplot,yplot);
    
    if(!chunkp->chunk)  /* convert a chunk */
    {
     convert(primage,orgim,&prtr,chunkp->sl,chunkp->el,0);
#ifdef MEMDBUG
     chunkp->crc=crcchunk(chunkp);
     if(!chunk) spchunk=chunkp;
#endif
    }

    err=ivmchunkensurer(&chunkp->chunk,chunkp->size);
    if(!err)
    {
     sph=(sprite_header*)(chunkp->chunk)->data;
     memset(sph,0,sizeof(sprite_header));

     if(sph)
     {
      sprintf(sph->name,"plot");
      sph->width=primage->wwidth-1;              /* words - 1 */
      sph->height=(chunkp->el-chunkp->sl)-1;     /* height -1 */
      sph->lbit=0;
      sph->rbit=(primage->xpix*primage->bpp-1) % 32; 
      sph->image=sizeof(sprite_header);
      sph->next=sph->image+primage->wwidth*4*primage->ypix;
      sph->mask=sph->image;
      sph->mode=prmode;
  
      sid.s.addr=(sprite_area *)sph;
      sid.tag=sprite_id_addr;

      if(primage->bpp<=8)
      {
       sprite_put_scaledpx((sprite_area*)0xFF,&sid,0,xplotpx,yplotpx,NULL,primage->ipal.word);
      }
      else
      {
       sprite_put_givenpx((sprite_area*)0xFF,&sid,0,xplotpx,yplotpx);
      }
     }
     ivmchunkdestroy(&chunkp->chunk);
    }
   }
  }
 }




 return(err);

 USE(invert);
}




os_error * viewprintzoom(int command)
{
 return(NULL);
 USE(command);
}





os_error * viewcreateprintimage(wimp_redrawstr * r)
{
 os_error * err;
 int        sxdpi;
 int        sydpi;
 int        frame;
 imagestr * im;
 int        obpp;

 err=NULL;

 prsxdpi=sxdpi=cvdu.xdpi; // 180/cvdu.deltax;   /* screen res */
 prsydpi=sydpi=cvdu.ydpi; // 180/cvdu.deltay;


 if(prfile->frames)
 {
  frame=prview->frame;
  im=((prfile->frames[frame].xim)->sim[IM]);
  if(im)
  {
   prxdpi=im->xdpi;
   prydpi=im->ydpi;

   prxpix=scale(im->xpix,sxdpi,im->xdpi);
   prypix=scale(im->ypix,sydpi,im->ydpi);


//   if(im->bpp>8 && (!ISOS35)) obpp=8;
//   else                       
   {
    if(im->bpp==24) obpp=32;
    else            obpp=im->bpp;
   }

   err=imnew(prxpix,prypix,obpp,&primage);

   primage->xdpi=sxdpi;
   primage->ydpi=sydpi;

   tr_setidentity(&prtr);

   tr_setscale(&prtr,im->xdpi,sxdpi,im->ydpi,sydpi);

   cmsprinterprofile(r,&primage->profile);

//   cprintf("setscale %d %d %d %d",im->xdpi,sxdpi,im->ydpi,sydpi);


//   if(im->bpp>8 && (!ISOS35)) imospal(primage);
//   else
     primage->ipal=im->ipal;

   if(obpp>8)
   {
    prmode=1+(sxdpi<<1)+(sydpi<<14);
    if(obpp==16) prmode|=(5<<27);
    else         prmode|=(6<<27);
   }
   else
   if(cvdu.xdpi==cvdu.ydpi) /* sqaure */
   {
    if(obpp==8) prmode=28;
    else
    if(obpp==4) prmode=27;
    else
    if(obpp==2) prmode=26;
    else        prmode=25;
   }
   else               /* rect */
   {
    if(obpp==8) prmode=15;
    else
    if(obpp==4) prmode=12;
    else
    if(obpp==2) prmode=4;
    else        prmode=0;
   }
  }
 }
 return(err);
}


os_error * viewdeleteprintimage(void)
{
 os_error * err;

 err=imtrash(&primage);

 return(err);
}


/****************************************************************************/


os_error * viewupdatelayer(filestr * file,wimp_box * box,int layer)
{
 os_error     * err;
 viewredrawstr  v;
 int            more;
 viewstr      * view;

 err=NULL;

 view=file->view;
 while(view)
 {
  v.redrawstr.w=view->handle;
  v.redrawstr.box=*box;

  v.view=view;
  v.file=file;
  v.layer=layer;
  v.isprinter=0;

  err=wimp_update_wind(&v.redrawstr,&more);
  if(!err) err=viewredrawsub(&v,more);

  view=view->next;
 }
 return(err);
}



/* find the frame, use the transform to find out how big the sprite */
/* is in screen coords.                                             */
/* create an image of the correct size                              */

os_error * viewcreateimage(viewstr * view,filestr * file)
{
 os_error * err;
 int        sxdpi;
 int        sydpi;
 int        ssxdpi;
 int        ssydpi;
 int        frame;
 imagestr * im;
 boxstr     ibox;
 int        xpix;
 int        ypix;
 int        dbpp;
 int        dln2bpp;

 err=NULL;


 dln2bpp=cvdu.ln2bpp;
 dbpp=1<<dln2bpp;

// cprintf("++++dbpp=%d",dbpp);


 sxdpi=cvdu.xdpi; // 180/cvdu.deltax;
 sydpi=cvdu.ydpi; // 180/cvdu.deltay;

 ssxdpi=scale(sxdpi,view->data.zoom.mul,view->data.zoom.div);
 ssydpi=scale(sydpi,view->data.zoom.mul,view->data.zoom.div);


 if(file->frames)
 {
  frame=view->frame;

  im=((file->frames[frame].xim)->sim[IM]);
  if(im)
  {
   ibox.w=scale(im->xpix,72000,im->xdpi);
   ibox.h=scale(im->ypix,72000,im->ydpi);
   ibox.x=0;
   ibox.y=0;

/*   xpix=(ibox.w*ssxdpi)/72000;
   ypix=(ibox.h*ssydpi)/72000; */

   xpix=scale(im->xpix,ssxdpi,im->xdpi);
   ypix=scale(im->ypix,ssydpi,im->ydpi);

//   cprintf("imnew xpix %d ypix %d bpp %d imx=%d imy=%d",xpix,ypix,dbpp,im->xpix,im->ypix);

   err=imnew(xpix,ypix,dbpp,&view->im);
   if(!err)
   {
    view->im->xdpi=sxdpi;
    view->im->ydpi=sydpi;

    tr_setscale(&view->tr,im->xdpi,ssxdpi,im->ydpi,ssydpi);
    view->tr.e=im->tr.e;
    view->tr.f=im->tr.f;

    cmsmonitorprofile(&(view->im)->profile);

    if(dbpp<=8)
    {
     view->im->ipal.ncolours=(1<<dbpp);
     genpalette(dln2bpp,&view->im->ipal.ncolours,view->im->ipal.word);
     genpal256(view->im->ipal.word,dln2bpp,&view->im->ipal.ncolours);
    }
    else
    {
     view->im->ipal.ncolours=0;
    }
   }
  }
 }

 return(err);
}




os_error * viewcreateimagefile(filestr * file)
{
 viewstr * view;

 view=file->view;
 while(view)
 {
  viewcreateimage(view,file);
  view=view->next;
 }

 return(NULL);
}



os_error * viewcreateimagefileframe(filestr * file,int fn)
{
 viewstr * view;

 view=file->view;
 while(view)
 {
  if(view->frame==fn)
  {
   viewcreateimage(view,file);
  }
  view=view->next;
 }

 return(NULL);
}


os_error * viewdeleteimage(viewstr * view,filestr * file)
{
 os_error * err;

 err=NULL;

/* dprintf(0,"view im trash 1"); */

 if(view->im) err=imtrash(&view->im);

/* dprintf(0,"view im trash 2"); */

 return(err);

 USE(file);
}



os_error * viewdeleteimagefile(filestr * file)
{
 viewstr * view;

 view=file->view;
 while(view)
 {
  viewdeleteimage(view,file);
  view=view->next;
 }

 return(NULL);
}




os_error * viewdeleteimagefileframe(filestr * file,int fn)
{
 viewstr * view;

 view=file->view;
 while(view)
 {
  if(view->frame==fn) viewdeleteimage(view,file);
  view=view->next;
 }

 return(NULL);
}


os_error * viewrecreateall(void)
{
 filestr * file;
 viewstr * view;

 file=firstfile;
 while(file)
 {
  view=file->view;
  while(view)
  {
   viewdeleteimage(view,file);
   viewcreateimage(view,file);
   view=view->next;
  }
  file=file->next;
 }

 return(NULL);
}




