/*->c.viewo */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "colour.h"
#include "flex.h"
#include "transform.h"

#include "err.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "key.h"
#include "deb.h"
#include "dbhi.h"

#include "etc.h"

#include "str.h"
#include "reslink.h"
#include "file.h"

#include "rulers.h"
#include "tools.h"
#include "infopal.h"
#include "view.h"
#include "configx.h"

#include "viewo.h"
#include "viewr.h"



os_error * setviewextent(viewstr * view,filestr * file)
{
 os_error       * err;
 wimp_redrawstr   eblock;

 eblock.box.x0=-view->vpshift-view->vshift;
 eblock.box.y1=+view->hpshift+view->hshift;

 eblock.box.x1=osunits(file->width,view);
 eblock.box.y0=-osunits(file->height,view);   /* height        */

 eblock.w=view->handle;

 err=wimp_set_extent(&eblock);

 view->extent=eblock.box;

 setextentrulers(view,file);

 return(err);
}



os_error * setviewextentfile(filestr * file)
{
 os_error * err;
 viewstr  * view;

 err=NULL;

 view=file->view;
 while(view)
 {
  err=setviewextent(view,file);
  viewopenshift(view,file,0,0);
  view=view->next;
 }

 return(err);
}


/* called by rulers - so don't update ruler extents */

os_error * updateviewextent(viewstr * view,filestr * file)
{
 wimp_redrawstr eblock;

 view->extent.x0=-view->vpshift-view->vshift;
 view->extent.y1=+view->hpshift+view->hshift;

 eblock.w=view->handle;
 eblock.box=view->extent;

 return(wimp_set_extent(&eblock));
 USE(file);
}




/* handle is pane handle, return handle of pane behind it */

wimp_w viewprevpane(viewstr * view,filestr * file,wimp_w handle)
{

 int last;

 last=0;

 if(view->tools)
	{
  if(view->tools==handle) last=1;
	}

 if(view->info)
 {
  if(last) return(view->info);
  if(view->info==handle) last=1;
 }

 if(view->vruler)
 {
  if(last) return(view->vruler);
  if(view->vruler==handle) last=1;
 }

 if(view->hruler)
 {
  if(last) return(view->hruler);
  if(view->hruler==handle) last=1;
 }


 if(last) return(view->handle);

 return(0);

 USE(file);
}






os_error * viewopen(wimp_w handle,uservalue userhandle,wimp_openstr * o)
{
 os_error * err;
 viewstr  * view;
 filestr  * file;
 windowstr  oldwindow;


 view=(viewstr*)userhandle;
 file=view->file;

 err=NULL;

	oldwindow=view->window;

 getw(view->handle,&view->window);


 o->behind=(wimp_w)-1;

 if(view->tools)
 {
  opentoolspane(view,o,&oldwindow);
  o->behind=view->tools;
 }

 if(view->info)
 {
  openinfopalpane(view,o,&oldwindow);
  o->behind=view->info;
 }

 o->behind=(wimp_w)-1;

 if(view->vruler)
 {
  openvruler(view,o);
  o->behind=view->vruler;
 }

 if(view->hruler)
 {
  openhruler(view,o);
 }

 return(err);
 USE(handle);
}





os_error * viewopenpanes(viewstr * view)
{
 os_error    * err;
 wimp_wstate   wstate;

 err=wimp_get_wind_state(view->handle,&wstate);
 if(!err) err=viewopen(view->handle,(uservalue)view,&wstate.o);

 return(err);
}



os_error * viewopenshift(viewstr * view,filestr * file,int dx,int dy)
{
 os_error    * err;
 wimp_wstate   wstate;

 err=wimp_get_wind_state(view->handle,&wstate);
/* wstate.o.behind=-1; */
 wstate.o.x+=dx;
 wstate.o.y+=dy;
 if(!err) err=wimp_open_wind(&wstate.o);
 if(!err) err=viewopen(view->handle,(uservalue)view,&wstate.o);

 // change here is that viewopen() is called when the main window has been opened
 // by outside events. viewopen() no longer calls wimp_open_wind() since
 // it has already been opened
 // so we wimp_open_wind() which opens the window and then call viewopen()
 // to open the panes


 return(err);
 USE(file);
}




os_error * viewopencrash(viewstr * view)
{
 os_error    * err;
 wimp_wstate   wstate;

 err=wimp_get_wind_state(view->handle,&wstate);

 wstate.o.box.x0=0;
 wstate.o.box.x1=0;
 wstate.o.box.y0=cvdu.screeny-40;
 wstate.o.box.y1=cvdu.screeny-40;

// if(!err) err=viewopen(view->handle,(int)view,&wstate.o);
 if(!err) err=wimp_open_wind(&wstate.o);

 return(err);
}




os_error * viewopenbehind(viewstr * view,filestr * file,wimp_w b)
{
 os_error    * err;
 wimp_wstate   wstate;


 err=wimp_get_wind_state(view->handle,&wstate);
 wstate.o.behind=b;
// if(!err) err=viewopen(view->handle,(int)view,&wstate.o);
 if(!err) err=wimp_open_wind(&wstate.o);

 return(err);
 USE(file);
}



static int countviews(void)
{
 int       count;
 filestr * file;

 count=0;

 file=firstfile;
 while(file)
 {
  count+=file->viewn;
  file=file->next;
 }

 return(count);
}

#define STEPINC 4
#define STEPX   40
#define STEPY   40


/* opening a new view */

os_error * popupview(viewstr * view,filestr * file)
{
 os_error    * err;
 wimp_wstate   wstate;
 int           count;


 count=countviews()-1;

 cprintf("count %d",count);
 setviewextent(view,file);

 err=wimp_get_wind_state(view->handle,&wstate);

 if(windowx0<windowx1 && windowy1>windowy0)
 {
  wstate.o.box.x0=windowx0;
  wstate.o.box.x1=windowx1;
  wstate.o.box.y0=windowy0;
  wstate.o.box.y1=windowy1;
 }

 cprintf("x0 %d x1 %d",windowx0,windowx1);

 centerwindow3(&wstate.o,count);
 wstate.o.behind=(wimp_w)-1;

// err=centerwindow(&wstate,view->handle,count);

// wstate.o.behind=-1;

/* wstate.o.x=view->extent.x0;
 wstate.o.y=-view->extent.y0;

 delta=(count/STEPINC)*STEPX;
 wstate.o.box.x0+=delta;
 wstate.o.box.x1+=delta;
 delta=(count%STEPINC)*STEPY;
 wstate.o.box.y0-=delta;
 wstate.o.box.y1-=delta; */

// if(!err) err=viewopen(view->handle,(int)view,&wstate.o);

 if(!err) err=wimp_open_wind(&wstate.o);
// wstate.o.behind=-1;
// if(!err) err=wimp_open_wind(&wstate.o);
// wstate.o.behind=-1;
// if(!err) err=wimp_open_wind(&wstate.o);

 if(!err) err=viewopen(view->handle,(uservalue)view,&wstate.o);

 return(err);
}



os_error * gotoframe(viewstr * view,filestr * file,int fn)
{
 os_error * err;

 err=NULL;

 if(fn<file->framen && fn>=0)
 {
  viewdeleteimage(view,file);
  scrapframe(file,view,menuview->frame);
  view->frame=fn;
  err=loadframe(file,view,fn);
  viewcreateimage(view,file);
  refreshview(view);
  infopalupdateview(view);
 }
 return(err);
}



os_error * nextframe(void)
{
 os_error * err;
 int        fn;

 err=NULL;

 fn=menuview->frame;

 if(menufile->framen>1 && fn<(menufile->framen-1))
 {
  viewdeleteimage(menuview,menufile);
  scrapframe(menufile,menuview,fn);
  menuview->frame=++fn;
  err=loadframe(menufile,menuview,fn);
  viewcreateimage(menuview,menufile);
  refreshview(menuview);
  refreshrulersu(menuview);
  infopalupdateview(menuview);
 }

 return(err);
}


os_error * prevframe(void)
{
 os_error * err;
 int        fn;

 err=NULL;

 fn=menuview->frame;

 if(menufile->framen>1 && fn>0)
 {
  viewdeleteimage(menuview,menufile);
  scrapframe(menufile,menuview,fn);
  menuview->frame=--fn;
  err=loadframe(menufile,menuview,fn);
  viewcreateimage(menuview,menufile);
  refreshview(menuview);
  refreshrulersu(menuview);
  infopalupdateview(menuview);
 }

 return(err);
}


