/*->c.view */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <ctype.h>


#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "akbd.h"
#include "transform.h"


#include "err.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "conf.h"
#include "colour.h"
#include "deb.h"
#include "dbhi.h"


#include "resource.h"

#include "str.h"
#include "constants.h"


#include "reslink.h"

#include "file.h"
#include "main.h"

#include "rulers.h"
#include "tools.h"
#include "infopal.h"
#include "select.h"
#include "units.h"
#include "page.h"
#include "pr.h"
#include "info.h"
#include "undo.h"
#include "edit.h"
#include "configx.h"

#include "magnify.h"
#include "tw.h"

#include "viewo.h"
#include "viewr.h"

#include "view.h"



static os_error * closeview(wimp_w handle,uservalue userhandle);
static os_error * closeviews(viewstr * view,filestr * file);


filestr * menufile;
viewstr * menuview;

int       tool;


/* minimum width of vdi window   */

#define MINWWIDTH  40

/* minimum height of vdi window  */

#define MINWHEIGHT 40


viewdatastr defviewdata=
{
 0, /* rulers      */
 1, /* zoom        */
 1,
 80, /* def zoom   */
 100,
 2,  /* zoom opt   */
 0, /* units       */
 0, /* tools       */
 0, /* info pal    */
 0, /* dither      */

};


/*****************************************************************************/

#define BASEFACTOR ((0x10000+200)/400)

int bosunits(int ourunits)
{
// return(ourunits/400);
 return(fastdiv400(ourunits));
}


int osunits(int ourunits,viewstr * view)
{
// if(view->scalefactor==400) return(fastdiv400(ourunits));
// else                       return(ourunits/view->scalefactor);
 if(view->scalefactor==BASEFACTOR) return(fastdiv400(ourunits));
 else                              return(ttmul(ourunits,view->scalefactor));
}


int bourunits(int osunits)
{
 return(osunits*400);
}


int ourunits(int osunits,viewstr * view)
{
// if(view->scalefactor==400) return(osunits*400);
// else                       return(osunits*view->scalefactor);
 if(view->scalefactor==BASEFACTOR) return(osunits*400);
 else                       return(scale(osunits,0x10000,view->scalefactor));
}


int dosunits(int osunits) 
{
 return(osunits*256);
}


int dourunits(int ourunits,viewstr * view)
{
 return(osunits(256*ourunits,view));
}


void setviewscalefactor(viewstr * view)
{
// view->scalefactor=(400*view->data.zoom.div)/view->data.zoom.mul;
 view->scalefactor=scale(0x10000,view->data.zoom.mul,400*view->data.zoom.div);
}



/*****************************************************************************/

/* final act of getting rid of view structure */

static os_error * deleteview(viewstr * view,filestr * file)
{
 os_error * err;
 viewstr  * next;
 viewstr  * prev;

 next=view->next;
 prev=view->prev;

 if(next) next->prev=prev;
 if(prev) prev->next=next;
 if(view==file->view) file->view=next;

 file->viewn--;

 err=sfree((flex_ptr)&view);

 return(err);
}



static os_error * viewicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;


 menuview=(viewstr*)userhandle;
 menufile=menuview->file;

 opentools(menuview);
 openinfopal(menuview);
 viewopenpanes(menuview);

 if(tooltable[tool].viewicon) err=tooltable[tool].viewicon(handle,userhandle,m);

 return(err);

 USE(handle);
}



/* all key presses may end up here, either direct, or via info palette */

os_error * viewkey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 os_error * err;
 int        ch;

 err=NULL;
 ch=*key;

 menuview=(viewstr*)userhandle;
 menufile=menuview->file;

 switch(ch)
 {
  case CTRL_N:
              err=newdocument();
              break;
 
  case CTRL_O:
              err=fileopen();
              break;

  case  CTRL_F4:
             err=closeview(handle,(uservalue)menuview);
             break;

  case   F10:
             err=twainacquire();
             break;

  case SHFT_F10:
             err=twainselect();
             break;

  case    F3:
             if(menufile->frames) err=filepopsave();
             break;

 case CTRL_P:
             if(menufile->frames) err=popprint(menuview);
             break;

 case SHFT_PAGEUP:
             err=nextframe();
             break;

 case SHFT_PAGEDOWN:
             err=prevframe();
             break;

 case CTSH_P:
             prupdate(menuview,menufile);
             menuview->data.printmargin^=1;
             prupdate(menuview,menufile);
             break;

 case CTRL_R:
             setrulers(menuview->data.rulers ^ 1);
             break;

 case CTSH_I:
             err=popfileinfo();
             break;

 case CTRL_T:
             settools(menuview->data.tools ^ 1);
             break;

 case CTRL_I:
             setinfopal(menuview->data.infopal ^ 1);
             break;


 case CTRL_Z:
             err=imageundo();
             break;

 case CTRL_Y:
             err=imageredo();
             break;

	case	CTRL_C:
													err=cbcopy();
													break;

	case CTRL_V:
													err=cbpaste();
													break;


  default:
          err=scrollkey(handle,key);
          return(err);
 }

 *key=-1;
 return(err);

 USE(handle);
 USE(icon);

}


/* called from inside dboxes */

os_error * viewsubkey(viewstr * view,int * key)
{
 os_error * err;
 int        ch;

 err=NULL;
 ch=*key;

 menuview=view;
 menufile=menuview->file;

 switch(ch)
 {

 case CTRL_R:
             setrulers(menuview->data.rulers ^ 1);
             break;


 case CTRL_T:
             settools(menuview->data.tools ^ 1);
             break;

 case CTSH_I:
             setinfopal(menuview->data.infopal ^ 1);
             break;


 case CTRL_Z:
             err=imageundo();
             break;

 case CTRL_Y:
             err=imageredo();
             break;


  default:
          return(err);
 }

 *key=-1;
 return(err);

}


static os_error * newview(void)
{
 os_error * err;

 err=createnewview(menufile,menuview);

 return(err);
}


static os_error * viewunits(int units)
{
 menuview->data.units=units;
 refreshrulers(menuview,menufile);
 infopalupdateview(menuview);
 return(NULL);
}


os_error * viewsetup(void)
{
 tickmenust(MVIEW,ID_VIEW_PRINTMARGINS,menuview->data.printmargin);
 tickmenust(MVIEW,ID_VIEW_RULERS,menuview->data.rulers);
 tickmenust(MVIEW,ID_VIEW_TOOLBOX,menuview->data.tools);
 tickmenust(MVIEW,ID_VIEW_INFOPALETTE,menuview->data.infopal);

 unshademenust(MVIEW,ID_VIEW_NEXTFRAME,menufile->framen>1 && 
                       menuview->frame<(menufile->framen-1));

 unshademenust(MVIEW,ID_VIEW_PREVIOUSFRAME,menufile->framen>1 && 
                       menuview->frame>0);

 unitssetup(viewunits,menuview->data.units,MVIEW,5);

 return(NULL);
}


os_error * viewdynamic(int * menu,char * handle)
{
 os_error * err;

 err=NULL;


 switch(menu[0])
 {

  case -1:
          err=viewsetup();
          break;


 }

 return(err);

 USE(handle);
}






void prupdate(viewstr * view,filestr * file)
{
 refreshwindow(view->handle);
 USE(file);
}


void prupdateall(void)
{
 filestr * file;
 viewstr * view;

 file=firstfile;
 while(file)
 {
  view=file->view;

  while(view)
  {
   if(view->data.printmargin) prupdate(view,file);
   view=view->next;
  }
  file=file->next;
 }
}


void prupdatefile(filestr * file)
{
 viewstr * view;

 view=file->view;

 while(view)
 {
  if(view->data.printmargin) prupdate(view,file);
  view=view->next;
 }
}


os_error * viewdecode(int * menu,wimp_w window)
{
 os_error * err;

 err=NULL;

 switch(menu[0])
 {
  case ID_VIEW_NEWVIEW:         /* new view */
         err=newview();
         break;


  case ID_VIEW_PRINTMARGINS:         /* printer margins */
         prupdate(menuview,menufile);
         menuview->data.printmargin^=1;
         prupdate(menuview,menufile);
         break;


  case ID_VIEW_RULERS:         /* rulers */
         setrulers(menuview->data.rulers ^ 1);
         break;


  case ID_VIEW_TOOLBOX:         /* toolbox */
         settools(menuview->data.tools ^ 1);
         break;


  case ID_VIEW_INFOPALETTE:         /* info palette */
         setinfopal(menuview->data.infopal ^ 1);
         break;


  case 5:
         err=unitsdecode(menu+1,window);
         break;


  case ID_VIEW_NEXTFRAME:
         err=nextframe();
         break;

  case ID_VIEW_PREVIOUSFRAME:
         err=prevframe();
         break;

 }

 return(err);
}








static void makeviewtitle(viewstr * view,filestr * file)
{
 char * modded[2]={""," *"};


 if(file->viewn>1)
  tsprintf(sizeof(view->name),view->name,"%s%s %d",
            fs_leaf(file->sname),modded[file->modded],file->viewn);
 else 
  tsprintf(sizeof(view->name),view->name,"%s%s",
            fs_leaf(file->sname),modded[file->modded]); 

 writetitle(view->handle,view->name);
}



static os_error * updatealltitles(filestr * file)
{
 viewstr * view;

 view=file->view;
 while(view)
 {
  makeviewtitle(view,file);
//  refreshwindowtitle(view->handle);
  view=view->next;
 }

 return(NULL);
}


#ifdef NEVER

static void viewactcallback(uservalue userhandle)
{
 viewstr * view;
 int       ahandle;

 view=(viewstr*)userhandle;

 cprintf("actcallback");
 getactive(&ahandle);
 if(view->handle==ahandle)
 {
  opentools(view);
  openinfopal(view);
  viewopenpanes(view);
 }
}


#endif


static os_error * viewact(wimp_w handle,uservalue userhandle,wimp_w otherhandle,int code)
{
 viewstr * view;

 view=(viewstr*)userhandle;

 return(NULL);
 
 USE(otherhandle);
 USE(handle);
 USE(code);
}







/* we are going to close this view */

static os_error * closeviewlo(viewstr * view,filestr * file)
{
 os_error * err;

 err=closerulers(view,file);
 err=closeinfopal(view,file);
 err=closetools(view,file);

 viewdeleteimage(view,file);

 remwindowmenu(view->handle,MMAIN);
 remclickevent(viewicon,view->handle,(uservalue)view);
 remcloseevent(closeview,view->handle,(uservalue)view);
 remopenevent(viewopen,view->handle,(uservalue)view);
 remredrawevent(viewredraw,view->handle,(uservalue)view);
 remkeyevent(viewkey,view->handle,(uservalue)view);
 remactevent(viewact,view->handle,(uservalue)view);

 remdataload(view->handle,(uservalue)view,loaddocv);
 remdataloadpost(view->handle,(uservalue)view,loaddocpostv);
 remdataloadtype(view->handle,(uservalue)view,loaddoctypev);

 closedown(&view->handle);

 err=deleteview(view,file);
 if(!err) 
 {
  if((file->viewn)==0) err=closedoc(file);
  else                 err=updatealltitles(file);
 }
 return(err);
}


void closeallfiles(void)
{
 filestr * nextfile;
 viewstr * nextview;

 nextfile=firstfile;
 while(nextfile)
 {
  nextview=nextfile->view;
  while(nextview)
  {
   closeviewlo(nextview,nextfile);
   nextview=nextview->next;
  }
  nextfile=nextfile->next;
 }
}



/* return 1 to keep window open */

static int closeviewstuff(viewstr * view,filestr * file)
{

#ifdef NEVER
 mousestr mouse;

 getpointer(&mouse);

 if((mouse.buttons & 0x1) && mouse.icon==-3)
 {
  char   string[256];
  char * p=fs_leaf(file->sname);
  int    len=p-file->sname;

  strcpy(string,file->sname);
  string[len-1]=0;
//  os_cli(string);

  return(isshift);
 }
 else 
 {
  return(0);
 }

#endif

 return(0);
 USE(file);
 USE(view);
}



/* return 1 to keep window open */

static int closeviewotherstuff(viewstr * view,filestr * file)
{
 int result;



#ifdef _DEBUG 
 flex_checkheap("dcs");
 wimp_check("dcs");
 poll_check("dcs");
 fs_scanstats();

#endif



 if(file->viewn==1 && file->modded)
 {
  confirmparent(view->handle,CONDCS,&result,"{FS08}");

  if(result==1)
  {
   filepopsave();
   return(1);
  }
  else
  if(result==-1)
  {
   return(1);
  }
 }
 return(0);
 USE(view);
}



/* hi level close view, sort out last views and save */

static os_error * closeviews(viewstr * view,filestr * file)
{
 os_error * err;

 err=NULL;

 if(!closeviewstuff(view,file))
 {
  if(!closeviewotherstuff(view,file))
  {
   event(EVENT_VCLOSE,view,0);
   err=closeviewlo(view,file);
  }
 }

 return(err);
}


static os_error * closeview(wimp_w handle,uservalue userhandle)
{
 os_error * err;
 viewstr  * view;
 filestr  * file;
 view=(viewstr*)userhandle;
 file=view->file;
 err=closeviews(view,file);

 zerofilesquit(err);
 return(err);
 USE(handle);
}



static os_error * createviewwindow(viewstr * view,filestr * file)
{
 os_error  * err;

 err=createwindow(TMAIN,&view->handle);

 cprintf("create view %d",view->handle);

 return(err);

 USE(file);
}




/* use the contents of the new structure to create a new file */

os_error * createnewview(filestr * file,viewstr * pview)
{
 os_error * err;
 viewstr  * view;
 viewstr  * oview;

 err=salloc((flex_ptr)&view,sizeof(viewstr));
 if(!err)
 {
  oview=file->view;
  if(oview) oview->prev=view;
  view->next=oview;
  file->view=view;

  file->viewn++;

  view->file=file;

  view->data=defviewdata;

  view->frame=pview?pview->frame:0;

  view->toolsxshift=toolsxshift;
  view->toolsyshift=toolsyshift;
  view->infoxshift=infoxshift;
  view->infoyshift=infoyshift;

  setviewscalefactor(view);

  err=createviewwindow(view,file);
  if(!err)
  {
   wimp_setwindowbackground(view->handle,CCWIMPBASE+WIMPWHITE);
   wimp_setwindowflags(view->handle,WINDOWNOSCROLLCHILD /*|WINDOWAUTOCENTRE*/,0);


   updatealltitles(file);
   
   addwindowmenu(view->handle,MMAIN);
   addclickevent(viewicon,view->handle,(uservalue)view);
   addcloseevent(closeview,view->handle,(uservalue)view);
   addopenevent(viewopen,view->handle,(uservalue)view);
   addredrawevent(viewredraw,view->handle,(uservalue)view);
   addkeyevent(viewkey,view->handle,(uservalue)view);
   addactevent(viewact,view->handle,(uservalue)view);

   adddataload(view->handle,(uservalue)view,loaddocv);
   adddataloadpost(view->handle,(uservalue)view,loaddocpostv);
   adddataloadtype(view->handle,(uservalue)view,loaddoctypev);



			getw(view->handle,&view->window);


			cprintf("create view 2");

   if(!err) err=createrulers(view,file);

   if(!err) err=openinfopal(view);

   if(!err) err=magnifyinit(view,file);

			cprintf("create view 3");

   if(!err) err=opentools(view);

   event(EVENT_VOPEN,view,0);


   if(!err) err=popupview(view,file);

   setfocus(view->handle);

   if(!err) err=viewcreateimage(view,file);
  }
 }
 return(err);
}


os_error * newviewdata(filestr * file)
{

 USE(file);

 return(NULL);
}



os_error * refreshview(viewstr * view)
{
// cprintf("refreshview %x",view->handle);

 return(refreshwindow(view->handle));
}


os_error * refreshviewfileframe(filestr * file,int fn)
{
 viewstr * view;

// cprintf("refreshviewfileframe %d",fn);

 view=file->view;
 while(view)
 {
  if(view->frame==fn) refreshview(view);
  view=view->next;
 }

 return(NULL);
}



os_error * viewfileframeshift(filestr * file,int fn,int x,int y)
{
 viewstr  * view;
 framestr * frame;
 imagestr * im;

 frame=&file->frames[fn];
 im=((frame->xim)->sim[IM]);

 im->tr.e=x;
 im->tr.f=y;

 view=file->view;
 while(view)
 {
  if(view->frame==fn)
  {
   view->tr.e=x;
   view->tr.f=y;
  }
  view=view->next;
 }

 return(NULL);
}




os_error * viewfileframedpi(filestr * file,int fn,int xdpi,int ydpi)
{
 framestr * frame;
 imagestr * im;

 frame=&file->frames[fn];
 im=((frame->xim)->sim[IM]);

/* frame->xdpi=xdpi;
 frame->ydpi=ydpi; */

 if(im)
 {
  im->xdpi=xdpi;
  im->ydpi=ydpi;
 }

 return(NULL);
}




os_error * viewrefreshall(void)
{
 filestr * file;
 viewstr * view;

 file=firstfile;
 while(file)
 {
  view=file->view;
  while(view)
  {
   refreshview(view);
   view=view->next;
  }
  file=file->next;
 }

 return(NULL);
}



viewstr * viewfromwindow(wimp_w window)
{
 filestr * file;
 viewstr * view;

 file=firstfile;
 while(file)
 {
  view=file->view;
  while(view)
  {
   if(view->handle==window) return(view);
   view=view->next;
  }
  file=file->next;
 }

 return(NULL);
}





void demodify(viewstr * view,filestr * file)
{
 file->modded=0;
 updatealltitles(file);
 USE(view);
}



static os_error * modevent(int eventn,wimp_w userhandle,void * data,int data1)
{
 viewstr * view;
 filestr * file;

 if(eventn==EVENT_FRAMEMODDED)
 {
  view=(viewstr*)data;
  file=view->file;

  if(!file->modded)
  {
   file->modded=1;
   updatealltitles(file);
  }
  infopalupdatefileframe(file,view->frame);


 }

 return(NULL);

 USE(userhandle);
 USE(data1);
}




static os_error * modechange(wimp_msgstr * msg,int * ack)
{
 return(viewrecreateall());
 USE(msg);
 USE(ack);
}


static os_error * palchange(wimp_msgstr * msg,int * ack)
{
 os_error * err;

 err=viewrecreateall();
 viewrefreshall();

 USE(msg);
 USE(ack);

 return(err);
}


os_error * viewinit(void)
{
 os_error * err;

          err=addmessage(palchange,wimp_PALETTECHANGE);
 if(!err) err=addmessage(modechange,wimp_MMODECHANGE);
 if(!err) err=addevent(EVENT_FRAMEMODDED,modevent,0);
 if(!err) err=rulersinit();
 if(!err) err=toolsinit(); 

 return(err);
}



os_error * closeviewnotframe(filestr * file,int fn)
{
 viewstr * view;

 view=file->view;

 while(view)
 {
  if(view->frame!=fn) closeviewlo(view,file);
  view=view->next;
 }

 return(NULL);
}

