/*->c.user */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "bf.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "mlo.h"

#include "units.h"
#include "bits.h"
#include "conf.h"
#include "config.h"
#include "pane.h"
#include "deb.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewr.h"
#include "im.h"
#include "edit.h"
#include "long.h"
#include "undo.h"

#include "fx.h"
#include "user.h"


#include "conv.h"


static filterstr * filtertable;
static int         filter;
static int         filters; /* how many ? */

static filterstr   wokfilter;

extern dboxstr filterbox;

static os_error * addone(void)
{
 os_error * err;

 if(filtertable)
  err=flex_extend((flex_ptr)&filtertable,sizeof(filterstr)*(filters+1));
 else
  err=flex_alloc((flex_ptr)&filtertable,sizeof(filterstr)*(filters+1));

 memset(&filtertable[filters],0,sizeof(filterstr));

 filters++;

 return(err);
}


static os_error * remone(int whichone)
{
 os_error * err;

 err=flex_midextend((flex_ptr)&filtertable,sizeof(filterstr)*(whichone+1),
                                          -(signed int)sizeof(filterstr));

 filters--;

 return(err);
}



static os_error * createone(void)
{
 os_error * err;

 err=addone();

 if(!err)
 {
  strcpy(filtertable[0].name,"Unity");
  filtertable[0].array[2][2]=1;
  filtertable[0].shift=0;
  filtertable[0].scale=1;
 }

 return(err);
}


static char * path="<HKEY_LOCAL_MACHINE\\Software\\DavidPilling\\DPScan\\>\\Filters.txt";


static os_error * load(void)
{
 os_error  * err;
 int         eof;
 char        string[256];
 filterstr * filterp;
 int         i;
 buffer      bf;





 err=bf_open(path,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  eof=0;

  while(!eof)
  {
   err=bf_getstring(&bf,string,sizeof(string),&eof);
   if(err) break;

   if(string[0]=='/' || string[0]==0) continue; /* !!! */

   err=addone();
   if(err) break;

   filterp=&filtertable[filters-1];

   xzstrncpy(filterp->name,string,sizeof(filterp->name));

   for(i=0;i<FMAXY;i++)
   {
    err=bf_getstring(&bf,string,sizeof(string),&eof);


    if(eof || err) break;

    sscanf(string,"%d,%d,%d,%d,%d",
              &filterp->array[i][0],
              &filterp->array[i][1],
              &filterp->array[i][2],
              &filterp->array[i][3],
              &filterp->array[i][4]);
   }

   err=bf_getstring(&bf,string,sizeof(string),&eof);
   if(err) break;

   sscanf(string,"%d,%d",&filterp->shift,&filterp->scale);
  }
  err=bf_close(&bf,err);
 }

 return(err);
}


static os_error * save(void)
{
 os_error  * err;
 int         i;
 int         j;
 buffer      bf;


          err=bf_open(path,'w',DEFBUFFSIZE,&bf);
 if(!err) err=stdfileheader(&bf,fs_leaf(path));
 if(!err)
 {
  for(i=0;i<filters;i++)
  {
   err=bf_printf(&bf,"//\n//\n%s\n",filtertable[i].name);
   if(err) break;

   for(j=0;j<FMAXY;j++)
   {
    err=bf_printf(&bf,"%d,%d,%d,%d,%d\n",
                        filtertable[i].array[j][0],
                        filtertable[i].array[j][1],
                        filtertable[i].array[j][2],
                        filtertable[i].array[j][3],
                        filtertable[i].array[j][4]);

    if(err) break;
   }
   if(err) break;

   err=bf_printf(&bf,"%d,%d\n",filtertable[i].shift,
                               filtertable[i].scale);
   if(err) break;
  }
  err=bf_closec(&bf,err,path,0xFFF);
 }

 return(err);
}


/****************************************************************************/

static char tempname[FNAMELEN];


static int findfiltername(char * name)
{
 int i;

 for(i=0;i<filters;i++)
  if(!cstrcmp(name,filtertable[i].name)) break;

 if(i>=filters) return(-1);
 else           return(i);
}

static os_error * rdrenname(int * value,char * string)
{
 xzstrncpy(tempname,string,sizeof(tempname));
 return(NULL);
 USE(value);
}

static os_error * renameclose(int code)
{
 os_error * err;
 int        n;

 err=NULL;


 if(code==DBOK || code==DBAPPLY)
 {
  n=strlen(tempname)+1;
  if(n<=1 || n>=FNAMELEN) err=geterror(EC00);
  else
  {
   n=findfiltername(tempname);
   if(n!=-1 && n!=filter) err=geterror(EC01);
   else
   {
    strcpy(filtertable[filter].name,tempname);
    strcpy(wokfilter.name,tempname);
   }

   dbwritevalues(&filterbox);
  }
 }
 return(err);
}


static os_error * newnameclose(int code)
{
 os_error * err;
 int        n;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  n=strlen(tempname)+1;
  if(n<=1 || n>=FNAMELEN) err=geterror(EC00);
  else
  {
   n=findfiltername(tempname);
   if(n!=-1) err=geterror(EC01);
   else
   {
    err=addone();
    n=filters-1;

    dbreadvalues(&filterbox);
    filtertable[filter]=wokfilter;
    filtertable[n]=filtertable[filter];
    strcpy(filtertable[n].name,tempname);
    filter=n;
    wokfilter=filtertable[filter];
    dbwritevalues(&filterbox);
   }
  }
 }
 return(err);
}


static os_error * wrnewname(int value,char * string)
{
 strcpy(string,"");
 return(NULL);
 value=value;
}


static os_error * wroldname(int value,char * string)
{
 strcpy(string,filtertable[filter].name);
 return(NULL);
 USE(value);
}


static dbiconstr newboxicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0, NULL ,0,


   12, NULL,         DBWRITE,  0,   0,     -1, -1, -1,  -1,rdrenname,wrnewname,

    3, NULL,         DBTEXT,   0,   0,      0,  0,  0,   0,     NULL,wroldname,

   -1, NULL,         0,        0,   0,      0,  0,  0,  0,  0,      0
};



static dboxstr newbox=
{
 0,
 TNEWUSER,
 DBFIX,
 0,
 newnameclose,
 NULL,
 NULL,
 NULL,
 newboxicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};



static dbiconstr rencolicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0, NULL ,0,

   12, NULL,         DBWRITE,  0,   0,     -1, -1, -1,  -1,rdrenname,wrnewname,

    3, NULL,         DBTEXT,   0,   0,      0,  0,  0,   0,    NULL,wroldname,


   -1, NULL,         0,        0,   0,      0,  0,  0,  0,  0,      0
};



static dboxstr renbox=
{
 0,
 TRENUSER,
 DBFIX,
 0,
 renameclose,
 NULL,
 NULL,
 NULL,
 rencolicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};



static os_error * delfilter(void)
{
 os_error * err;
 int        result=0;

 if(filters==1) err=geterror(EC02);
 else           err=confirmparent(filterbox.handle,CONDC,&result,"{EC03}");

 if(!err)
 {
  if(result==1)
  {
   err=remone(filter);
   if(!err)
   {
    if(filter>0) filter--;
    wokfilter=filtertable[filter];
    dbwritevalues(&filterbox);
   }
  }
 }
 return(err);
}



static os_error * newfilter(wimp_w parent)
{
 os_error * err;

 err=NULL;

 if(newbox.handle) dbclose(&newbox,DBCANCEL);
 
 err=dodboxparent(&newbox,1,parent);


 return(err);
}


static os_error * renfilter(wimp_w parent)
{
 os_error * err;

 err=NULL;

 if(newbox.handle) dbclose(&renbox,DBCANCEL);
 
 err=dodboxparent(&renbox,1,parent);
 
 return(err);
}


/****************************************************************************/

static os_error * openfiltermenu(void);

static os_error * filtericon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {

  case 102:       
          err=openfiltermenu();
          break;


  case  5:
          err=delfilter();
          break;

  case  6:
          err=newfilter(handle);
          break;

  case 36:
          err=renfilter(handle);
          break;
 }

 return(err);
 USE(handle);
 USE(userhandle);
 USE(m);
}

static os_error * filterclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  filtertable[filter]=wokfilter;
  err=save();
 }

 return(err);
}


static os_error * wrname(int value,char * string)
{
 strcpy(string,wokfilter.name);
 return(NULL);
 USE(value);
}

static os_error * wrf(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}


static os_error * rdf(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}



static dbiconstr filtericondefs[]=
{

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

  101, NULL,         DBTEXT,  0,   0,      0,  0,  0,   0,     NULL,wrname,

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0, NULL,0,

 /* N   &V           Type     Grp   Flags          R   L   D   U    In  Out */

    7, &wokfilter.array[0][0], DBWRITE,  0,  0,    8, 33, 12, -1,   rdf, wrf,
    8, &wokfilter.array[0][1], DBWRITE,  0,  0,    9,  7, 13, -1,   rdf, wrf,
    9, &wokfilter.array[0][2], DBWRITE,  0,  0,   10,  8, 14, -1,   rdf, wrf,
   10, &wokfilter.array[0][3], DBWRITE,  0,  0,   11,  9, 15, -1,   rdf, wrf, 
   11, &wokfilter.array[0][4], DBWRITE,  0,  0,   12, 10, 16, -1,   rdf, wrf,

   12, &wokfilter.array[1][0], DBWRITE,  0,  0,   13, 11, 17,  7,   rdf, wrf,
   13, &wokfilter.array[1][1], DBWRITE,  0,  0,   14, 12, 18,  8,   rdf, wrf,
   14, &wokfilter.array[1][2], DBWRITE,  0,  0,   15, 13, 19,  9,   rdf, wrf,
   15, &wokfilter.array[1][3], DBWRITE,  0,  0,   16, 14, 20, 10,   rdf, wrf,
   16, &wokfilter.array[1][4], DBWRITE,  0,  0,   17, 15, 21, 11,   rdf, wrf,

   17, &wokfilter.array[2][0], DBWRITE,  0,  0,   18, 16, 22, 12,   rdf, wrf,
   18, &wokfilter.array[2][1], DBWRITE,  0,  0,   19, 17, 23, 13,   rdf, wrf,
   19, &wokfilter.array[2][2], DBWRITE,  0,  0,   20, 18, 24, 14,   rdf, wrf,
   20, &wokfilter.array[2][3], DBWRITE,  0,  0,   21, 19, 25, 15,   rdf, wrf,
   21, &wokfilter.array[2][4], DBWRITE,  0,  0,   22, 20, 26, 16,   rdf, wrf,

   22, &wokfilter.array[3][0], DBWRITE,  0,  0,   23, 21, 27, 17,   rdf, wrf,
   23, &wokfilter.array[3][1], DBWRITE,  0,  0,   24, 22, 28, 18,   rdf, wrf,
   24, &wokfilter.array[3][2], DBWRITE,  0,  0,   25, 23, 29, 19,   rdf, wrf,
   25, &wokfilter.array[3][3], DBWRITE,  0,  0,   26, 24, 30, 20,   rdf, wrf,
   26, &wokfilter.array[3][4], DBWRITE,  0,  0,   27, 25, 31, 21,   rdf, wrf,

   27, &wokfilter.array[4][0], DBWRITE,  0,  0,   28, 26, 32, 22,   rdf, wrf,
   28, &wokfilter.array[4][1], DBWRITE,  0,  0,   29, 27, 32, 23,   rdf, wrf,
   29, &wokfilter.array[4][2], DBWRITE,  0,  0,   30, 28, 33, 24,   rdf, wrf,
   30, &wokfilter.array[4][3], DBWRITE,  0,  0,   31, 29, 33, 25,   rdf, wrf,
   31, &wokfilter.array[4][4], DBWRITE,  0,  0,   32, 30, 33, 26,   rdf, wrf,

   32, &wokfilter.scale      , DBWRITE,  0,  0,   33, -1, -1, 27,   rdf, wrf,
   33, &wokfilter.shift      , DBWRITE,  0,  0,    7, 32, -1, 29,   rdf, wrf,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};


static dboxstr filterbox=
{
 0,
 TUSER,
 DBFIX,
 0,
 filterclose,
 filtericon,
 NULL,
 NULL,
 filtericondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};



os_error * userfilter(wimp_w parent)
{
 os_error * err;

 err=NULL;

 if(filterbox.handle) dbclose(&filterbox,DBCANCEL);
 
 if(!filters) err=createone();

 if(!err) 
 {
  filter=MIN(filter,(filters-1));
  wokfilter=filtertable[filter];
 }

 err=dodboxparent(&filterbox,1,parent);

 return(err);
}


/* better to show 0 filters than abend program load */

os_error * userinit(void)
{
 load();
 return(NULL);
}


/*****************************************************************************/


#define UFILTERBASE 0x100

static os_error * openfilterdecode(int * menu,wimp_w window)
{
 os_error * err;
 int        index;

 err=NULL;

 index=menu[0]-UFILTERBASE-1;

 if(index>=0 && index<filters && index!=filter)
 {
  dbreadvalues(&filterbox);
  filtertable[filter]=wokfilter;
  filter=index;
  wokfilter=filtertable[filter];
  dbwritevalues(&filterbox);
 }
 return(err);

 USE(window);
}


static os_error * openfiltermenu(void)
{
 os_error * err;
 int        i;

 err=NULL;

 err=createusermenu(MUSERF,openfilterdecode,NULL);
 if(!err)
 {
  for(i=0;i<filters;i++)
  {
   err=addusermenu(MUSERF,filtertable[i].name,i==filter?MTICK:0,UFILTERBASE+1+i);
   if(err) break;
  }
 }

 completeusermenu(MUSERF,"User");

 openupmenu(menuview->handle,MUSERF);

 return(err);
}



os_error * userdynamic(int * menu,char * handle)
{
 os_error * err;
 int        i;
 int unshade;


 cprintf("user dynamic");

 err=NULL;

          err=createusermenu(MUSERF,NULL,NULL);
 if(!err) err=addusermenu(MUSERF,"Edit...",wimp_MSEPARATE,UFILTERBASE);

 if(!err)
 {
  unshade=(menufile->frames && menufile->framen);
  unshade=unshade?0:MSHADE;


  for(i=0;i<filters;i++)
  {
   err=addusermenu(MUSERF,filtertable[i].name,unshade,UFILTERBASE+1+i);
   if(err) break;
  }
 }

 if(!err) 
 {
  completeusermenu(MUSERF,"User");
  linkmenu(MUSERF,MFILTER,0);
 }

 return(err);
 USE(menu);
 USE(handle);
}



static os_error * douserfilter(viewstr * view,filestr * file,
                             spanstr ** sp,int ylo,int yhi,int filter)
{
 os_error  * err;
 imagestr  * dim;
 imagestr  * sim;
 ximagestr * dxim;
 ximagestr * sxim;

 err=NULL;

 if(file->frames && file->framen)
 {
  sxim=file->frames[view->frame].xim;
  sim=(sxim->sim[IM]);

  longprocstart(NULL,0,sim->ypix,view);

  err=viewdeleteimagefileframe(file,view->frame);

  undostart(sxim);

  if(undosteps) err=ximcopy(sxim,&dxim);
  else          dxim=sxim;

  if(!err)
  {
   dim=(dxim->sim[IM]);

   err=conv(sim,dim,&filtertable[filter],sp,ylo,yhi);

   if(undosteps)
   {
    if(err) ximtrash(&dxim);
    else
    {
     undolink(sxim,dxim);
     file->frames[view->frame].xim=dxim;
    }
   }
  }

  viewcreateimagefileframe(file,view->frame);
  refreshviewfileframe(file,view->frame);
  modifyview(view);
  longprocend();
 }
 return(err);
}


os_error * userdecode(int * menu,wimp_w handle)
{
 os_error * err;
 spanstr  * sp;
 int        ylo;
 int        yhi;
 int        index;

 err=NULL;

 index=menu[0];

 cprintf("userdecode %d",index);

 if(index==UFILTERBASE) err=userfilter(handle);
 else
 {
  index=index-UFILTERBASE-1;
  if(index>=0 && index<filters)
  {
   err=setupfilterarea(menuview,&sp,&ylo,&yhi);
   if(!err)
   {
    err=douserfilter(menuview,menufile,&sp,ylo,yhi,index);

    freefilterarea(&sp);
   }
  }
 }
 return(err);
}

