/*->c.units */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "etc.h"
#include "transform.h"
#include "poll.h"
#include "dbhi.h"


#include "err.h"
#include "reslink.h"

#include "xmath.h"

#include "xext.h"


#include "str.h"
#include "constants.h"
#include "view.h"
#include "file.h"

#include "units.h"








/*****************************************************************************/


typedef struct unitstr
{
 int    id;
 int    dim;
 char * names;
 int    mul;
 int    div;

} unitstr;



typedef struct uvarstr
{
 int num;
 int div;
 int unit;


} uvarstr;



#define TNULL  0x0
#define TVALUE 0x1
#define TUNIT  0x2
#define TTOK   0x3


#define DNONE   0x0
#define DLENGTH 0x1
#define DANGLE  0x2



#define UNONE   (-1)
#define UFRAC   (-2)





#define MAXTYPES 11





/* warning there is a max name size of 8 bytes in unitname() */

static unitstr units[MAXTYPES]=
{
 PIXELS, DLENGTH, "/px",       1,          1,
 MILIMS, DLENGTH, "mm/m/M",    360000,   127,
 INCHES, DLENGTH, "in/i/\"/I", 72000,      1,
 POINTS, DLENGTH, "pt/p/P",    1000,       1,
 PICAS,  DLENGTH, "pi/PI",     12000,      1,
 CENTIMS,DLENGTH, "cm/c/C",    3600000,  127,
 DIDOT,  DLENGTH, "di/d/D",    10656,     10,
 CICERO, DLENGTH, "ci/CI",     127872,    10,
 FOOT,   DLENGTH, "ft/\'",     12*72000,   1,
 YARD,   DLENGTH, "yd",        3*12*72000, 1,
 TWIPS,  DLENGTH, "tw",        50,         1,
};





static int pow10(int n)
{
 int i;
 int scale;

 scale=1;
 for(i=0;i<n;i++) scale*=10;

 return(scale);
}




static unitstr * uptr(int unit)
{
 if(unit>=0 && unit<MAXTYPES) return(units+unit);
 else                         return(NULL);
}




static int ucmp(char * target,char * list)
{
 int    f;
 int    s;
 char * t;
 int    match;

 t=target;
 match=1;

 while(1)
 {
  s=*list++;

  if(match)
  {
   f=*t++;
   if(f==0 && (s==0 || s=='/') && match) return(0);
   if(f!=s) match=0;
  }

  if(s=='/')
  {
   t=target;
   match=1;
  }
  else
  if(s==0) break;
 }

 return(1);
}



static unitstr * unameptr(char * name)
{
 int    i;

 for(i=0;i<MAXTYPES;i++)
 {
  if(!ucmp(name,units[i].names))
  {
   return(units+i);
  }
 }

 return(NULL);
}




char * unitname(int unit)
{
 unitstr      * u;
 static char    name[8];
 char         * p;
 char         * q;
 int            c=0;

 u=uptr(unit);
 if(u)
 {
  p=u->names;
  q=name;

  while(1)
  {
   while(1)
   {
    c=(*q++=*p++);
    if(c==0 || c=='/') break;
   }

   if(c=='/')
   {
    if(q>(name+1))
    {
     *(q-1)=0;
     break;
    }
    else
    {
     q=name;
    }
   }
   else break;
  }
 }
 else *name=0;

 return(name);
}






static void uconvert(uvarstr * uleft,int unit)
{
 big        big1;
 big        big2;
 unitstr  * u;

 u=uptr(unit);

 bigmul(&big1,uleft->num,u->mul);
 bigmul(&big2,uleft->div,u->div);

 bignormalise(&big1,&big2);

 uleft->num=big1.hi;
 uleft->div=big2.hi;

 uleft->unit=unit;
}




static int    current;      /* +,-,/,* ...   */
static int    currenttype;  /* TVALUE, TUNIT */
static char * currentp;



static os_error * getexpression(uvarstr * uleft);


static os_error * nexttoken(void)
{
 os_error * err;
 int        c=0;


 err=NULL;

 while(1)
 {
  if((c=*currentp)!=' ') break;
  currentp++;
 }

 if(c==0)
 {
  current=currenttype=c;
 }
 else
 if(c=='+' || c=='-' || c=='*' || c=='*' || c=='(' || c==')')
 {
  current=c;
  currenttype=TTOK;
  currentp++;
 }
 else
 if((c>='0' && c<='9') || c=='.' || c==',' || c=='#')
 {
  current=c;
  currenttype=TVALUE;
  currentp++;
 }
 else
 {
  current=c;
  currenttype=TUNIT;
  currentp++;
 }

 return(err);
}





static os_error * getitem(uvarstr * uleft)
{
 os_error * err=NULL;
 int        dp;
 int        hex;

 if(currenttype==TVALUE)
 {
  uleft->num=0;
  uleft->div=1;
  uleft->unit=UNONE;
  dp=0;
		hex=10;

  while(1)
  {
			if(hex==16 && tolower(current)>='a' && tolower(current)<='f')
			{
    uleft->num=uleft->num*hex+tolower(current)-'a'+10;
    if(dp) uleft->div*=hex;
			}
   if(current>='0' && current<='9')
   {
    uleft->num=uleft->num*hex+current-'0';
    if(dp) uleft->div*=hex;
   }
   else
   if(current=='.' || current==',')
   {
    if(dp)
    {
     err=geterror(EREPDEC);
     break;
    }
    dp=1;
   }
			else
			if(current=='#')
			{
				hex=16;
			}

   err=nexttoken();

			if(hex==16 && tolower(current)>='a' && tolower(current)<='f' && currenttype==TUNIT) continue;

   if(currenttype!=TVALUE) break;
  }
 }
 else
 {
  err=generror(0,"Missing number"); // situation 123- is bad input, after reading the - we want something, and have to give an error for nothing
	}


 return(err);
}




static os_error * getvalue(uvarstr * uleft)
{
 os_error * err;
 int        savetoken;

 err=NULL;

 savetoken=current;
 if(current=='-' || current=='+') err=nexttoken();
 if(!err)
 {
  if(current=='(')
  {
   err=nexttoken();
   if(!err)
   {
    err=getexpression(uleft);
    if(!err)
    {
     if(current!=')') err=geterror(EBB);
     else             err=nexttoken();
    }
   }
  }
  else err=getitem(uleft);

  if(savetoken=='-') uleft->num=-uleft->num;
 }

 return(err);
}




static os_error * getproduct(uvarstr * uleft)
{
 os_error * err;
 uvarstr    uright={0,0,0};
 int        savetok;
 big        big1;
 big        big2;
 int        unit;


 err=getvalue(uleft);

 while(current=='*' || current=='/')
 {
  unit=0; /* compiler */

  savetok=current;
  err=nexttoken();
  if(!err) err=getvalue(&uright);
  if(err) break;

  if(uleft->unit==UFRAC && uright.unit==UFRAC) unit=UNONE;
  else
  if(uleft->unit==UFRAC && uright.unit==UNONE) unit=UFRAC;
  else
  if(uleft->unit==UNONE && uright.unit==UFRAC) unit=UFRAC;
  else
  if(uleft->unit==UNONE && uright.unit==UNONE) unit=UNONE;
  else
  {
   if(uright.unit==UNONE)                  unit=uleft->unit;
   else
   if(uleft->unit==UNONE && savetok=='*')  unit=uright.unit;
   else
   if(savetok=='/' &&uptr(uleft->unit)->dim==uptr(uright.unit)->dim)unit=UNONE;
   else
   {
    err=geterror(EID);
   }
  }

  if(savetok=='*')
  {
   bigmul(&big1,uleft->num,uright.num);
   bigmul(&big2,uleft->div,uright.div);
   bignormalise(&big1,&big2);

   uleft->num=big1.hi;
   uleft->div=big2.hi;
  }
  else 
  {
   bigmul(&big1,uleft->num,uright.div);
   bigmul(&big2,uleft->div,uright.num);
   bignormalise(&big1,&big2);

   uleft->num=big1.hi;
   uleft->div=big2.hi;
  }

  uleft->unit=unit;
 }

 return(err);
}


static os_error * getproduct1(uvarstr * uleft)
{
 os_error * err;
 char       string[32];
 int        n;
 unitstr  * u;

 err=getproduct(uleft);

 n=0;
 while(currenttype==TUNIT)
 {
  string[n]=(char)current;
  string[n+1]=0;
  err=nexttoken();
  n++;
 }

 if(n) /* got units, find match */
 {
  if(n==1 && string[0]=='%')
  {
   if(uleft->unit==UNONE)
   {
    uleft->unit=UFRAC;
    uleft->div*=100;
   }
   else
   {
    err=geterror(EPCD);
   }
  }
  else
  {
   u=unameptr(string);
   if(u)
   {
    if(uleft->unit==UNONE)
    {
     uconvert(uleft,u->id);
    }
   }
   else
   {
    err=geterror(EBU);
   }
  }
 }

 return(err);
}






static os_error * getterm(uvarstr * uleft)
{
 os_error * err;
 uvarstr    uright={0,0,0};
 int        savetok;
 big        big1;
 big        big2;
 big        big3;


 err=getproduct1(uleft);

 while(current=='+' || current=='-')
 {
  savetok=current;
  err=nexttoken();
  if(!err) err=getproduct1(&uright);
  if(err) break;


  if(uleft->unit==UFRAC) err=geterror(EPCL);
  else
  if(uright.unit==UFRAC)
  {
   if(savetok=='+') uright.num=uright.div+uright.num;
   else             uright.num=uright.div-uright.num;

   bigmul(&big1,uleft->num,uright.num);
   bigmul(&big2,uleft->div,uright.div);

   bignormalise(&big1,&big2);

   uleft->num=big1.hi;
   uleft->div=big2.hi;
  }
  else
  {
   if(uleft->unit==UNONE && uright.unit!=UNONE) uconvert(uleft,uright.unit);
   else
   if(uleft->unit!=UNONE && uright.unit==UNONE) uconvert(&uright,uleft->unit);
   else
   if(uleft->unit!=UNONE && uright.unit!=UNONE)
   {
    /* dims better match */

    if(uptr(uleft->unit)->dim!=uptr(uright.unit)->dim) err=geterror(EBD);
    else                                               uleft->unit=uright.unit;
   }

   bigmul(&big1,uleft->num,uright.div);
   bigmul(&big2,uright.num,uleft->div);

   if(savetok=='+') bigadd(&big1,&big2,&big3);
   else             bigsub(&big1,&big2,&big3);

   bigmul(&big1,uright.div,uleft->div);

   bignormalise(&big3,&big1);

   uleft->num=big3.hi;
   uleft->div=big1.hi;
  }
 }

 return(err);
}




static os_error * getexpression(uvarstr * uleft)
{
 os_error * err;

 err=getterm(uleft);

 return(err);
}







static os_error * stringtounitsv(char * string,int * value,int unit)
{
 os_error * err;
 uvarstr    uleft;

 currentp=string;
 nexttoken();

 uleft.num=0;
 uleft.div=1;
 uleft.unit=UNONE;

 err=getexpression(&uleft);
 if(!err)
 {
  if(current!=0) err=geterror(EBADVAL);
  else
  {
   if(unit!=UNONE && uleft.unit==UNONE) uconvert(&uleft,unit);

   value[0]=uleft.num;
   value[1]=uleft.div;

   if(uleft.div==0) err=geterror(EBADVAL);
  }
 }

 return(err);
}





/* write a number to an icon in the correct units */

/* we use units of 1/72000ths of an inch = 1/1000 pt = 2.54/72000 mm */

/* a routine which reads in numbers as in/mm/pt or default */
/* and outputs our units return -1 on error                */



static os_error * stringtounits(char * string,int * value,int unit)
{
 os_error * err;
 int        temp[2];

 err=stringtounitsv(string,temp,unit);
 if(!err) *value=temp[0]/temp[1];
 else     *value=-1;

 return(err);
}




os_error * stringtonumberdp(char * string,int * value,int base)
{
 os_error * err;
 int        temp[2];

 err=stringtounitsv(string,temp,UNONE);
 if(!err) *value=(temp[0]*pow10(base))/(temp[1]);
 else     *value=-1;

 return(err);
}


/* base on 0x10000   */
/* i.e. 0x10000 == 1 */

os_error * stringtonumberxdp(char * string,int * value,int dp,int base)
{
 os_error * err;
 err=stringtonumberdp(string,value,dp);
 *value=scale(*value,0x10000,pow10(base+dp));
 return(err);
}


os_error * stringtonumber(char * string,int * value)
{
 return(stringtounits(string,value,UNONE));

}




os_error * readpc(int * value,char * string)
{
 return(stringtonumberxdp(string,value,2,2));
}




/****************************************************************************/


/* a routine which can print in/mm/pt's from our units */

static char * unitstostring(int value,int unit)
{
 int         big;
 int         lit;
 char      * minus;
 int         ru;
 int         n;
 int         c;
 char      * p;
 unitstr   * u;
 static char string[16];


 u=uptr(unit);

 if(value<0)
 {
  minus="-";
  value=-value;
 }
 else minus="";


 lit=scale(value,u->div,u->mul/1000);
 big=lit/1000;


 lit=lit % 1000;
 ru=lit % 10;
 lit=lit/10;
 if(ru>5) lit++;
 if(lit==100) {big++;lit=0;}

 if(lit<10 && lit)
 {
  n=sprintf(string,"%s%d.0%d",minus,big,lit);
 }
 else
 {
  while(lit && ((lit % 10)==0)) lit/=10;
  if(lit) n=sprintf(string,"%s%d.%d",minus,big,lit);
  else    n=sprintf(string,"%s%d",big?minus:"",big);
 }

 p=u->names;
 while(1)
 {
  c=*p++;
  if(c=='/') c=0;
  string[n++]=(char)c;
  if(!c) break;
 }

 return(string);
}



char * numbertostring(int value)
{
 static char string[16];
 sprintf(string,"%d",value);
 return(string);
}



/* number based on 10^dp */
/* 1000 -> 100.0         */

char * numbertostringdp(int value,int dp)
{
 static char string[16];
 int    lit;
 char * p;
 int    write;
 int    minus;


 if(value<0) {minus=1;value=-value;}
 else        minus=0;


 p=string+sizeof(string)-1;
 *p--=0;
 write=0;

 while(value || dp>=0)
 {
  lit=value%10;
  value/=10;

  if(write || dp<=0 || lit)
  {
   *p--=(char)('0'+lit);
   write=1;
  }

  if(dp==1 && write) *p--='.';

  dp--;
 }

 if(minus) *p--='-';

 return(p+1);
}



/* value is based on 0x10000 */

char * numbertostringxdp(int value,int dp,int base)
{
 return(numbertostringdp(scale(value,pow10(dp+base),0x10000),dp));
}



os_error * writeangle(int value,char * string)
{
 strcpy(string,numbertostringxdp(-value,2,0));
 return(NULL);
}



os_error * writeskew(int value,char * string)
{
 strcpy(string,numbertostringxdp(-value,2,0));
 return(NULL);
}


os_error * writepc(int value,char * string)
{
 strcpy(string,numbertostringxdp(value,2,2));
 return(NULL);
}



/****************************************************************************/



static int viewdpi(viewstr * view,int x)
{
 int         dpi;
 filestr  *  file;
 int         frame;
 framestr *  fr;
 imagestr *  im;

 file=view->file;
 if(file->framen)
 {
  frame=view->frame;
  fr=&file->frames[frame];
  im=((fr->xim)->sim[IM]);

  if(x) dpi=im->xdpi;
  else  dpi=im->ydpi;
 }
 else
 {
  if(x) dpi=defdocdata.xres;
  else  dpi=defdocdata.yres;
 }

 return(dpi);
}







char * viewunitstostring(int value,viewstr * view,int x)
{
 char static string[16];

 if(view->data.units==PIXELS) 
 {
  sprintf(string,"%d",scale(value,viewdpi(view,x),72000));
  return(string);
 }
 else
 {
  return(unitstostring(value,view->data.units));
 }
}




os_error * viewstringtounits(char * string,int * value,viewstr * view,int x)
{
 units[PIXELS].mul=72000;
 units[PIXELS].div=viewdpi(view,x);

 return(stringtounits(string,value,view->data.units));
}

