/*->c.undo */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "bbc.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "redraw.h"
#include "colour.h"
#include "units.h"
#include "save.h"
#include "bits.h"
#include "hourglass.h"
#include "deb.h"

#include "mlo.h"

#include "str.h"
#include "constants.h"

#include "view.h"
#include "viewr.h"

#include "file.h"

#include "im.h"

#include "edit.h"

#include "undo.h"



int undosteps;



os_error * imageundo(void)
{
 os_error  * err;
 int         fn;
 ximagestr * xim;

 err=NULL;

 fn=menuview->frame;

 if(menufile->framen && menufile->frames)
 {
  xim=menufile->frames[fn].xim;

  if(xim->undo)
  {
   err=viewdeleteimagefileframe(menufile,fn);

   menufile->frames[fn].xim=xim->undo;

   viewcreateimagefileframe(menufile,fn);

   refreshviewfileframe(menufile,fn);

   modifyview(menuview);
  }
 }

 return(NULL);
}


int imagecanundo(void)
{
 os_error  * err;
 int         fn;
 ximagestr * xim;

 err=NULL;

 fn=menuview->frame;

 if(menufile->framen && menufile->frames)
 {
  xim=menufile->frames[fn].xim;

 /* dprintf(3,"im=%x fn=%d",menufile->frames[fn].im,fn); */

  if(xim->undo)
  {
   return(1);
  }
 }

 return(0);
}


os_error * imageredo(void)
{
 os_error  * err;
 int         fn;
 ximagestr * xim;

 err=NULL;

 fn=menuview->frame;

 if(menufile->framen && menufile->frames)
 {
  xim=menufile->frames[fn].xim;

  if(xim->redo)
  {
   err=viewdeleteimagefileframe(menufile,fn);

   menufile->frames[fn].xim=xim->redo;

   viewcreateimagefileframe(menufile,fn);

   refreshviewfileframe(menufile,fn);

   modifyview(menuview);
  }
 }

 return(NULL);
}



int imagecanredo(void)
{
 os_error  * err;
 int         fn;
 ximagestr * xim;

 err=NULL;

 fn=menuview->frame;

 if(menufile->framen && menufile->frames)
 {
  xim=menufile->frames[fn].xim;

  if(xim->redo)
  {
   return(1);
  }
 }

 return(0);
}



/* throw away any redos from this image */

os_error * redotrash(ximagestr * xim)
{
 os_error  * err;
 ximagestr * prev;
 ximagestr * cur;

 err=NULL;

 prev=cur=xim;

 while(cur->redo)
 {
  prev=cur;
  cur=cur->redo;
 }

 while(cur!=xim)
 {
  ximtrash(&prev->redo);
  cur=prev;
  prev=prev->undo;
 }

 return(err);
}



/* throw away any undos from this image */

os_error * undotrash(ximagestr * xim)
{
 os_error  * err;
 ximagestr * next;
 ximagestr * cur;

 err=NULL;

 next=cur=xim;

 while(cur->undo)
 {
  next=cur;
  cur=cur->undo;
 }

 while(cur!=xim)
 {
  ximtrash(&next->undo);
  cur=next;
  next=next->redo;
 }

 return(err);
}




/* going to do something to an image */
/* throw away any redos              */
/* trim undo queue to length         */

os_error * undostart(ximagestr * xim)
{
 os_error    * err;
 ximagestr   * p;
 int           count;

 err=redotrash(xim);
 if(!err)
 {
  p=xim;
  count=1;

  while(p->undo && count<undosteps) 
  {
   p=p->undo;
   count++;
  }

  if(count>=undosteps) {err=undotrash(p);/*dprintf(0,"undo trash");*/}
 }

 return(err);
}



os_error * undolink(ximagestr * oldhead,ximagestr * newhead)
{

 newhead->redo=NULL;
 newhead->undo=oldhead;
 oldhead->redo=newhead;

 return(NULL);
}


