/*->c.tw */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "colour.h"
#include "deb.h"
#include "dbhi.h"
#include "bitrev.h"
#include "ram.h"
#include "scrap.h"


#include "constants.h"
#include "str.h"

#include "view.h"
#include "viewr.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "select.h"
#include "edit.h"
#include "config.h"
#include "rulers.h"
#include "cms.h"


#include "twain.h"
#include "dca_glue.h"        // for function prototypes of glue code
#include "dca_type.h"        // contains function protos for this module
#include "dca_acq.h"         // contains buffered glue code function prototypes
#include "dca_app.h"



#include "tw.h"



/****************************************************************************/

static os_error * getinfo(framestr * frame)
{
 char   string[256];
 char * p;

 p=string;

 p+=sprintf(p,"Imported image\n");
 p+=sprintf(p,"%d x %d pixels %d bpp",frame->fxpix,frame->fypix,frame->fbpp);

 return(infowrite(string,frame));
}





/*****************************************************************************/

static filestr         * acqfile;
static viewstr         * acqview;




/* open select source dialogue */

os_error * twainselect(void)
{
 os_error * err;

 err=TWSelectSource((wimp_w)menuview->handle);


 return(err);
}

/****************************************************************************/
/* code for acquiring images */

static TWAcquireblockstr acqblock;

static imagestr        * acqimage;




/****************************************************************************/

static int twsh;


static os_error * acqfilesetup(int code)
{
 os_error * err;

 err=NULL;

 if(code==1)
 {
  if(!twsh)  err=sc_create(&twsh);
  acqblock.filename=sc_namex(twsh);
 }
 else
 if(code==0)
 {
  err=sc_remove(twsh,NULL);
  twsh=0;
 }

 return(err);
}



static os_error * acqfilexfer(int last)
{
 os_error * err;


 err=NULL;

 if(last==TWLASTBLOCK)
 { 
            err=loaddocv(acqblock.filename,BMP,uservalue(acqview),1);
   if(!err) err=loaddocpostv(uservalue(acqview));

 }

 return(err);
}



/****************************************************************************/


// native transfer - pointer to dib

static os_error * acqsprite(int last,int length)
{
 os_error * err;

 err=NULL;

 if(last==TWLASTBLOCK)
 { 
  err=ramnextreadfile(acqblock.memory.native.lpdib,length);
 	if(!err)
 	{
            err=loaddocv("Scan",DIB,uservalue(acqview),1);
   if(!err) err=loaddocpostv(uservalue(acqview));

   ramreadoff();
 	}
 }


 return(err);
}


/****************************************************************************/
/* code for direct memxfers */

static int        memline;
static int        memplanar;
static int        memplane;



static void acqmemxferpalette(int * paltab,int nc)
{
 int i;

 if(acqimage)
 {
  for(i=0;i<nc;i++) acqimage->ipal.word[i]=paltab[i];
 }
}


static os_error * acqsetmemxfer(int xpix,int ypix,int bpp,int xres,
                                                          int yres,int planar)
{
 os_error * err;
 int        fn;

 err=NULL;

 memline=0;
 memplanar=planar;
 memplane=0;


 if(!acqfile->frames) 
 {
  err=addframe(acqfile,&fn,0);
  acqview->frame=fn;
 }
 else
 {
  fn=acqview->frame;
  scrapframe(acqfile,acqview,fn);
  viewdeleteimagefileframe(acqfile,fn);
 }

 if(!err)
 {
  acqfile->frames[fn].fxpix=xpix;
  acqfile->frames[fn].fypix=ypix;

  acqfile->frames[fn].offset=0;
  acqfile->frames[fn].fbpp=bpp;
  acqfile->frames[fn].fxdpi=xres;
  acqfile->frames[fn].fydpi=yres;
  acqfile->frames[fn].xim=NULL;
  strcpy(acqfile->frames[fn].name,"scan");

/*  acqfile->frames[fn].tr.e=acqblock.area.x0;
  acqfile->frames[fn].tr.f=acqblock.area.y1; */

  err=ximnew(acqfile->frames[fn].fxpix,acqfile->frames[fn].fypix,
             acqfile->frames[fn].fbpp, &acqfile->frames[fn].xim);

  getinfo(&acqfile->frames[fn]);

  if(!err)
  {
   acqimage=((acqfile->frames[fn].xim)->sim[IM]);
   acqimage->xdpi=acqfile->frames[fn].fxdpi;
   acqimage->ydpi=acqfile->frames[fn].fydpi;
   acqimage->tr.e=acqblock.area.x0;
   acqimage->tr.f=acqblock.area.y1;

   cmsscannerprofile(&acqimage->profile);

   imsetgreypal(acqimage,bpp);
  }
 }

 return(err);
}


/* just received a chunk */

static os_error * acqmemxfer(int size,int last,int bpr,int rows)
{
 os_error * err;
 int      * idata;
 char     * p;
 int        i;
 int        j;
 char     * q;
 int        bytes;

 err=NULL;

 for(i=0;i<rows;i++)
 {
/*  if(memline>=acqimage->ypix) dprintf(0,"too many lines");
  if(bpr>acqimage->wwidth*4) dprintf(0,"too many bytes %d %d",bpr,acqimage->wwidth*4); */

  if(memline>=acqimage->ypix && memplanar) 
  {
   memplane++;
   memline=0;
  }

  err=imfind1w(acqimage,memline,&idata);
  if(err) break;

  p=((char*)acqblock.memory.memxfer.buffer)+bpr*i;


  if(memplanar)
  {
   bytes=MIN(bpr,acqimage->xpix);
   q=(char*)idata;
   q+=memplane;
   while(bytes--)
   {
    *q=*p++;
    q+=3;
   }
  }
  else
  {
   memcpy(idata,p,MIN(bpr,(acqimage->wwidth*4)));

   if(acqimage->bpp==1)
   {
    q=(char*)idata;
    for(j=0;j<bpr;j++,q++) *q=bitrev[*q];
   }
  }

  memline++;
 }


 if(!err)
 {
  if(last==1)
  {
   viewcreateimagefileframe(acqfile,acqview->frame);
   refreshviewfileframe(acqfile,acqview->frame);
   /* infopalupdatefileframe(acqfile,acqview->frame); */
   refreshrulersu(acqview);
   modifyview(acqview);
  }
  else
  if(last==-1) /* failed */
  {
   scrapframe(acqfile,acqview,acqview->frame);
  }
 }


 return(err);

 USE(size);
}



/*****************************************************************************/




static os_error * acqend(void)
{
 if(acqblock.transfertype==TWSX_MEMORY)
 {
  if(acqblock.memory.memxfer.buffer)
                        sfree((flex_ptr)&acqblock.memory.memxfer.buffer);

 }




 return(NULL);
}


static os_error * acqinfo(int xpix,int ypix,int bpp,int xres,
                                                    int yres,int planar)
{
 if(acqblock.transfertype==TWSX_MEMORY)
 {
  acqsetmemxfer(xpix,ypix,bpp,xres,yres,planar);
 }

 return(NULL);
}

static os_error * acqpalette(int * paltab,int nc)
{

 cprintf("acq palette %d",nc);

 if(acqblock.transfertype==TWSX_MEMORY)
 {
  acqmemxferpalette(paltab,nc);
 }

 return(NULL);
}



static os_error * acqtransfer(int size,int last,int bpr,int rows)
{
 os_error * err;

 err=NULL;

 if(acqblock.transfertype==TWSX_NATIVE) err=acqsprite(last,size);
 else
 if(acqblock.transfertype==TWSX_MEMORY) err=acqmemxfer(size,last,bpr,rows);
 else
 if(acqblock.transfertype==TWSX_FILE)  err=acqfilexfer(last);

 return(err);
}


#define SPARE 0x1000

static os_error * acqalloc(int size)
{
 os_error * err;

 err=NULL;

 if(acqblock.transfertype==TWSX_MEMORY)
 {
  err=salloc((flex_ptr)&acqblock.memory.memxfer.buffer,size);

 }

 return(err);
}




static os_error * closeevent(int eventn,wimp_w userhandle,
                                                        void * data,int data1)
{
 viewstr * view;
 filestr * file;

 if(eventn==EVENT_FCLOSE)
 {
  file=(filestr*)data;

  if(file==acqfile)
  {

   TWTerminate();
  }
 }
 else
 if(eventn==EVENT_VCLOSE)
 {
  view=(viewstr*)data;

  if(view==acqview)
  {

   TWTerminate();
  }
 }

 return(NULL);

 USE(userhandle);
 USE(data1);
}



os_error * twainacquire(void)
{
 os_error  * err;

 err=NULL;


 acqfile=menufile;
 acqview=menuview;

 TWAcquireDefault(&acqblock);


 if(selection)  /* there is a selected area that we want */
 {
  acqblock.setarea=1;
  acqblock.area.x0=sbox.x;
  acqblock.area.y1=sbox.y;
  acqblock.area.x1=sbox.x+sbox.w;
  acqblock.area.y0=sbox.y+sbox.h;
 }


 acqblock.transfertype=TWSX_MEMORY;


 acqblock.settransfertype=1;

 acqblock.TWend=acqend;
 acqblock.TWalloc=acqalloc;
 acqblock.TWtrans=acqtransfer;
 acqblock.TWinfo=acqinfo;
 acqblock.TWfilesetup=acqfilesetup;

 acqblock.TWpal=acqpalette;

 err=TWAcquire((wimp_w)acqview->handle,1,1,&acqblock);



 return(err);
}


/*****************************************************************************/

static os_error * twainterminate(int eventn,wimp_w userhandle,
                                                        void * data,int data1)
{

 TWTerminate();

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}


os_error * twaininit(void)
{
 TW_IDENTITY AppIdentity;

 AppIdentity.Id=0;/* init to 0, but Source Manager will assign real value */

 AppIdentity.Version.MajorNum=1;
 AppIdentity.Version.MinorNum=0;
 AppIdentity.Version.Language=TWLG_ENG;
 AppIdentity.Version.Country=TWCY_UNITEDKINGDOM;
 strcpy(AppIdentity.Version.Info,wimpt_programname());

 AppIdentity.ProtocolMajor=TWON_PROTOCOLMAJOR;
 AppIdentity.ProtocolMinor=TWON_PROTOCOLMINOR;
 AppIdentity.SupportedGroups=DG_IMAGE | DG_CONTROL;

 strcpy(AppIdentity.Manufacturer,"David Pilling");
 strcpy(AppIdentity.ProductFamily,wimpt_programname());
 strcpy(AppIdentity.ProductName,wimpt_programname());

 /* pass app particulars to glue code */
 
// TWInitialize(&AppIdentity,(HWND)taskhandle);
 TWInitialize(&AppIdentity,0);

 addevent(EVENT_ENDPROGRAM,twainterminate,0);

 addevent(EVENT_FCLOSE,closeevent,0);
 addevent(EVENT_VCLOSE,closeevent,0);

 return(NULL);
}

