/*->c.tools */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "flex.h"
#include "bbc.h"
#include "transform.h"

#include "wos.h"
#include "colour.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "deb.h"
#include "osunits.h"
#include "pane.h"
#include "dbhi.h"


#include "str.h"
#include "reslink.h"
#include "file.h"

#include "viewo.h"
#include "view.h"


#include "tools.h"
#include "infopal.h"

#include "select.h"
#include "pointer.h"
#include "magnify.h"
#include "rotate.h"

/*****************************************************************************/

int autoscroll(viewstr * view,wimp_mousestr * m,int vlock,int hlock)
{
 windowstr window;
 int       width;
 int       height;
 int       xshift;
 int       yshift;
 int       mag;
 int       scx;
 int       scy;

 getw(view->handle,&window);

 window.x0+=view->vshift+view->vpshift;
 window.y1-=view->hshift+view->hpshift;

 scx=window.scx;
 scy=window.scy;

 width=(window.x1-window.x0)/8;
 height=(window.y1-window.y0)/8;

 xshift=yshift=0;

 if(m->x<(window.x0+width))
 {
  xshift=(m->x-(window.x0+width));  /* 0..-width */
 }

 if(m->x>(window.x1-width))         /* 0..width */
 {
  xshift=(m->x-(window.x1-width));
 }

 if(xshift && width)
 {
  mag=(ABS(xshift)*16)/width;
  if(mag<12) xshift=xshift/(12-mag);
  else       xshift=xshift*2*(mag-11);
 }


 if(m->y<(window.y0+height))
 {
  yshift=(m->y-(window.y0+height));
 }

 if(m->y>(window.y1-height))
 {
  yshift=(m->y-(window.y1-height));
 }


 if(yshift && height)
 {
  mag=(ABS(yshift)*16)/height;
  if(mag<12) yshift=yshift/(12-mag);
  else       yshift=yshift*2*(mag-11);
 }

 if(ABS(xshift)<cvdu.deltax) xshift=0;
 if(ABS(yshift)<cvdu.deltay) yshift=0;


 if(hlock) yshift=0;
 if(vlock) xshift=0;


 if(xshift || yshift)
 {
  viewopenshift(view,view->file,xshift,yshift);
  getw(view->handle,&window);
  return(window.scx!=scx || window.scy!=scy);
 }
 else
  return(0);
}



os_error * rbox(viewredrawstr * v,boxstr * box)
{
 viewstr * view;

 view=v->view;

 bbc_move(v->ox+osunits(v->xps+box->x,view),v->oy-osunits(v->yps+box->y,view));

 bbc_draw(v->ox+osunits(v->xps+box->x,view),
                                  v->oy-osunits(v->yps+box->y+box->h,view));
 bbc_draw(v->ox+osunits(v->xps+box->x+box->w,view),
                                  v->oy-osunits(v->yps+box->y+box->h,view));
 bbc_draw(v->ox+osunits(v->xps+box->x+box->w,view),
                                  v->oy-osunits(v->yps+box->y,view));
 bbc_draw(v->ox+osunits(v->xps+box->x,view),
                                  v->oy-osunits(v->yps+box->y,view));

 return(NULL);
}


os_error * rline(viewredrawstr * v,boxstr * box)
{
 viewstr * view;

 view=v->view;

 bbc_move(v->ox+osunits(v->xps+box->x,view),v->oy-osunits(v->yps+box->y,view));

 bbc_draw(v->ox+osunits(v->xps+box->x+box->w,view),
                                  v->oy-osunits(v->yps+box->y+box->h,view));

 return(NULL);
}



os_error * rcircle(viewredrawstr * v,boxstr * box)
{
 viewstr * view;

 view=v->view;

 bbc_move(v->ox+osunits(v->xps+box->x,view),v->oy-osunits(v->yps+box->y,view));

 bbc_plot(144+5,v->ox+osunits(v->xps+box->x+box->w,view),
                v->oy-osunits(v->yps+box->y,view));

 return(NULL);
}



/****************************************************************************/


#define TOOLICONBASE 102

#define MAXTOOLS 4



toolstr tooltable[MAXTOOLS]=
{
 TINFOPALP,picon,pkey,pviewicon,pviewkey,pselect,predraw,pfill,NULL,
 TINFOPALR,picon,pkey,rviewicon,rviewkey,rselect,rredraw,pfill,NULL,
 TINFOPALS,sicon,skey,sviewicon,sviewkey,sselect,sredraw,sfill,sinit,
 TINFOPALM,micon,mkey,mviewicon,mviewkey,mselect,mredraw,mfill,NULL,

};


static viewstr * toolsview;
static filestr * toolsfile;

static os_error * remtools(viewstr * view,filestr * file);


static os_error * dragwindow(wimp_mousestr * m)
{
 os_error   * err;
 wimp_dragstr drg;
 windowstr    window;

 err=getw(m->w,&window);
 if(!err)
 {
  drg.window=m->w;
  drg.type=wimp_MOVE_WIND;

  err=wimp_drag_box(&drg);
 }
 return(err);
}



static os_error * toolstitleicon(wimp_mousestr * m)
{
 if(m->bbits==VBDRAGS || m->bbits==VBDRAGA)
 {
  dragwindow(m);
 }

 return(NULL);
}



static os_error * toolsicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;


 switch(m->i)
 {
  case -1:        /* title bar */
         err=toolstitleicon(m);
         break;

//  case 1:        /* close icon */
//         err=remtools(toolsview,toolsfile);
//         break;

 default:
         if(m->i>=TOOLICONBASE && m->i<(MAXTOOLS+TOOLICONBASE))
         {
          if(tooltable[tool].select) tooltable[tool].select(0,toolsview);

          if(toolsview->data.infopal)
          {
           closeinfopal(toolsview,toolsfile);
          }

          deselect(handle,TOOLICONBASE+tool);
          tool=m->i-TOOLICONBASE;
          select(handle,TOOLICONBASE+tool);

          if(toolsview->data.infopal)
          {
											openinfopal(toolsview);
          }

          if(tooltable[tool].select) tooltable[tool].select(1,toolsview);
         }
         break;
 }

 return(err);

 USE(handle);
 USE(userhandle);
}






/* called when pane opened by wimp */

static os_error * toolswopen(wimp_w handle,uservalue userhandle,wimp_openstr * o)
{
 os_error   * err;
 windowstr    window;
 windowstr    vwindow;

 err=wimp_open_wind(o);

 if(!err) err=getw(toolsview->tools,&window);
 if(!err) err=getw(toolsview->handle,&vwindow);

 if(!err)
 {
  toolsview->toolsxshift=window.x0-vwindow.x0;
  toolsview->toolsyshift=vwindow.y0-window.y0;

  err=viewopenbehind(toolsview,toolsfile,window.bhandle);
 }

 return(err);

 USE(handle);
 USE(userhandle);
}







// this is here to stop ALT+F4 caret in info pal closing it

static os_error * toolswclose(wimp_w handle,uservalue userhandle)
{

// cprintf("infowclose");

 return(NULL);

 USE(handle);
 USE(userhandle);
}





os_error * opentools(viewstr * view)
{
 os_error   * err;
// wimp_openstr r;
 windowstr    window;
	filestr    * file;
 wimp_wstate  wst;
	int          w;
 int          h;
	wimp_w       prevpane;


 err=NULL;

	file=view->file;

 if(!(view->data.tools && view->tools))
 {
  if(toolsview) closetools(toolsview,toolsfile);

  if(view->data.tools)
  {
   err=createwindowparent(TTOOLBOX,&view->tools,view->handle);
   if(!err)
   {
    addclickevent(toolsicon,view->tools,NULL);
    addopenevent(toolswopen,view->tools,0);
    addcloseevent(toolswclose,view->tools,(uservalue)view);
    wimp_setwindowflags(view->tools,WINDOWPANE,WINDOWPANE);
    toolsview=view;
    toolsfile=file;
    select(view->tools,TOOLICONBASE+tool);

    if(tooltable[tool].select) tooltable[tool].select(1,toolsview);

    err=wimp_get_wind_state(view->tools,&wst);
    if(!err)
    {
     w=wst.o.box.x1-wst.o.box.x0;
     h=wst.o.box.y1-wst.o.box.y0;

     wst.o.box.x0=view->window.x0+view->toolsxshift;
     wst.o.box.y0=view->window.y0-view->toolsyshift;
					wst.o.box.y1=ypix2os(yos2pix(wst.o.box.y0)+yos2pix(h));

     if(1 /*!infopaloffscreen*/)
     {
      if(!(view->window.wflags & wimp_MINIMISED))
      {
       coerceboxscreen(&wst.o.box,w,h);
      }
     }

     /* set pane size */

     wst.o.box.x1=xpix2os(xos2pix(wst.o.box.x0)+xos2pix(w));
     wst.o.box.y0=ypix2os(yos2pix(wst.o.box.y1)-yos2pix(h));

     prevpane=viewprevpane(view,file,view->tools);
     if(prevpane) 
     {
      getw(prevpane,&window);
      wst.o.behind=window.bhandle;
     }
     else
     {
      wst.o.behind=(wimp_w)-1;
     }

     err=wcheckopen(&wst.o,1/*infopalattached*/);
			 }
		 }
	 }
	}

 return(err);
}




// called from main win open to open info pal after main window is opened

os_error * opentoolspane(viewstr * view,wimp_openstr * o,windowstr * window)
{
 os_error   * err;
 wimp_openstr r;
 windowstr    iwindow;
 int          w;
 int          h;
// wimp_wstate  wst;

 err=NULL;

 if(1)
 {
  err=getw(view->tools,&iwindow);

  if(window)
  {
   if(!(view->window.wflags & wimp_MINIMISED) && !(window->wflags & wimp_MINIMISED))
   {
    if(iwindow.x0>(window->x1+window->x0)/2) 
    {
     view->toolsxshift+=o->box.x1-window->x1;
     view->toolsxshift-=o->box.x0-window->x0;
    }

    if(iwindow.y1>(window->y1+window->y0)/2) 
    {
     view->toolsyshift+=o->box.y0-window->y0;
     view->toolsyshift-=o->box.y1-window->y1;
    }
   }
  } 

  w=(xcoordos2pix(iwindow.x1)-xcoordos2pix(iwindow.x0));
  h=(ycoordos2pix(iwindow.y0)-ycoordos2pix(iwindow.y1));

  r.w=view->tools;
  r.x=0;
  r.y=0;
  r.behind=o->behind;

  r.box.x0=o->box.x0+view->toolsxshift;
  r.box.y0=o->box.y0-view->toolsyshift;

  r.box.x1=xpix2os(xos2pix(r.box.x0)+w);
  r.box.y1=ypix2os(yos2pix(r.box.y0)+h);

  w=xpix2os(w);
  h=ypix2os(h);


  if(1 /*!infopaloffscreen*/)
  {
   if(!(view->window.wflags & wimp_MINIMISED))
   {
    coerceboxscreen(&r.box,w,h);
   }
  }

  err=wcheckopen(&r,1);
 }

 return(err);
}






os_error * closetools(viewstr * view,filestr * file)
{
 os_error * err;

 err=NULL;

 if(view==toolsview && toolsview)
 {
  if(tooltable[tool].select) tooltable[tool].select(0,toolsview);

  if(view->data.tools)
  {
   remclickevent(toolsicon,view->tools,NULL);
   remopenevent(toolswopen,view->tools,0);
   remcloseevent(toolswclose,view->tools,(uservalue)view);

   err=closedown(&view->tools);
   toolsview=NULL;
   toolsfile=NULL;
  }
  else err=NULL;
 }

 return(err);

 USE(file);
}









static os_error * addtools(viewstr * view,filestr * file)
{
 os_error * err;

	err=NULL;

 if(!view->data.tools)
 {
  view->data.tools=1;
  err=opentools(view);
 }

 return(err);
}



static os_error * remtools(viewstr * view,filestr * file)
{
 os_error * err;

	err=NULL;

 if(view->data.tools)
 {
  err=closetools(view,file);
  view->data.tools=0;
  viewopenpanes(view);
 }


 return(err);
}






void settools(int open)
{
 viewstr * view;
 filestr * file;

 view=menuview;
 file=view->file;

 if(open && !view->data.tools) addtools(view,file);
 else
 if(!open && view->data.tools) remtools(view,file);
}



os_error * toolsinit(void)
{
 int i;

 for(i=0;i<MAXTOOLS;i++)
 {
  if(tooltable[i].init) tooltable[i].init();
 }
 return(NULL);
}

