/*->c.tload */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>


#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "fsx.h"
#include "task.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bitrev.h"
#include "deb.h"
#include "dbhi.h"


#include "constants.h"
#include "str.h"

#include "view.h"
#include "file.h"
#include "im.h"



#define NOPUTDEFS

//#include "tiffcomp.h"

typedef	unsigned char u_char;
typedef	unsigned short u_short;
typedef	unsigned int u_int;
typedef	unsigned long u_long;


#define USE_PROTOTYPES 1
#include "prototypes.h"

#include "tiff.h"

#include "tiffio.h"

#include "tfile.h"
#include "tload.h"





typedef u_char RGBvalue;

static  u_long width, height;           /* image width & height */
static  u_short bitspersample;
static  u_short samplesperpixel;
static  u_short photometric;
static  u_short orientation;
/* colormap for pallete images */
static  u_short *redcmap, *greencmap, *bluecmap;
static  int stoponerr;                  /* stop on read error */
static  char *filename;
/* YCbCr support */
static  u_short YCbCrHorizSampling;
static  u_short YCbCrVertSampling;
static  float *YCbCrCoeffs;
static  float *refBlackWhite;

static  u_long **BWmap;
static  u_long **PALmap;

static  u_short alpha;

static  int cmykimage;

static imagestr * maskimage;



static int checkcmap(int n,u_short * r,u_short * g,u_short * b)
{
        while (n-- > 0)
                if (*r++ >= 256 || *g++ >= 256 || *b++ >= 256)
                        return (16);
        TIFFWarning(filename, "Assuming 8-bit colormap");
        return (8);
}



static u_long setorientation(TIFF * tif,u_long h)
{
 u_long y;

        TIFFGetFieldDefaulted(tif, TIFFTAG_ORIENTATION, &orientation);
        switch (orientation) {
        case ORIENTATION_BOTRIGHT:
        case ORIENTATION_RIGHTBOT:      /* XXX */
        case ORIENTATION_LEFTBOT:       /* XXX */
                TIFFWarning(filename, "using bottom-left orientation");
                orientation = ORIENTATION_BOTLEFT;
                /* fall thru... */
        case ORIENTATION_BOTLEFT:
                y = 0;
                break;
        case ORIENTATION_TOPRIGHT:
        case ORIENTATION_RIGHTTOP:      /* XXX */
        case ORIENTATION_LEFTTOP:       /* XXX */
        default:
                TIFFWarning(filename, "using top-left orientation");
                orientation = ORIENTATION_TOPLEFT;
                /* fall thru... */
        case ORIENTATION_TOPLEFT:
                y = h-1;
                break;
        }
        return (y);
}

typedef void (*XtileContigRoutine)
    (imagestr*,int,int,u_char*, RGBvalue*, u_long, u_long, int, int);


#define PACK(r,g,b)     ((u_long)(r)|((u_long)(g)<<8)|((u_long)(b)<<16))

/*
 * Greyscale images with less than 8 bits/sample are handled
 * with a table to avoid lots of shifts and masks.  The table
 * is setup so that put*bwtile (below) can retrieve 8/bitspersample
 * pixel values simply by indexing into the table with one
 * number.
 */

static void makebwmap(RGBvalue * Map,imagestr * image)
{
 int i;
 int c;

 image->ipal.ncolours=(1<<bitspersample);

 for(i=0;i<image->ipal.ncolours;i++)
 {
  c=(Map[i])<<8;
  c=c | (c<<8);
  c=c | (c<<8);

  image->ipal.word[i]=c;
 }
}



/*
 * Palette images with <= 8 bits/sample are handled
 * with a table to avoid lots of shifts and masks.  The table
 * is setup so that put*cmaptile (below) can retrieve 8/bitspersample
 * pixel values simply by indexing into the table with one
 * number.
 */

static void tmakecmap(u_short * rmap,u_short * gmap,u_short * bmap,
                                                  imagestr * image)
{
 int i;
 int c;

 image->ipal.ncolours=(1<<bitspersample);

 for(i=0;i<image->ipal.ncolours;i++)
 {
  c=((rmap[i]&0xFF)<<8);
  c=c | ((gmap[i]&0xFF)<<16);
  c=c | ((bmap[i]&0xFF)<<24);

  image->ipal.word[i]=c;
 }
}




/*
 * The following routines move decoded data returned
 * from the TIFF library into rasters filled with packed
 * ABGR pixels (i.e. suitable for passing to lrecwrite.)
 *
 * The routines have been created according to the most
 * important cases and optimized.  pickTileContigCase and
 * pickTileSeparateCase analyze the parameters and select
 * the appropriate "put" routine to use.
 */


#define	NOP

#define REPEAT8(op)     REPEAT4(op); REPEAT4(op)
#define REPEAT4(op)     REPEAT2(op); REPEAT2(op)
#define REPEAT2(op)     op; op
#define CASE8(x,op)                             \
        switch (x) {                            \
        case 7: op; case 6: op; case 5: op;     \
        case 4: op; case 3: op; case 2: op;     \
        case 1: op;                             \
        }
#define CASE4(x,op)     switch (x) { case 3: op; case 2: op; case 1: op; }

#define UNROLL8(w, op1, op2) {          \
        register u_long x;              \
        for (x = w; x >= 8; x -= 8) {   \
                op1;                    \
                REPEAT8(op2);           \
        }                               \
        if (x > 0) {                    \
                op1;                    \
                CASE8(x,op2);           \
        }                               \
}
#define UNROLL4(w, op1, op2) {          \
        register u_long x;              \
        for (x = w; x >= 4; x -= 4) {   \
                op1;                    \
                REPEAT4(op2);           \
        }                               \
        if (x > 0) {                    \
                op1;                    \
                CASE4(x,op2);           \
        }                               \
}
#define UNROLL2(w, op1, op2) {          \
        register u_long x;              \
        for (x = w; x >= 2; x -= 2) {   \
                op1;                    \
                REPEAT2(op2);           \
        }                               \
        if (x) {                        \
                op1;                    \
                op2;                    \
        }                               \
}
                        

#define SKEW(r,g,b,skew)        { r += skew; g += skew; b += skew; }
#define	SKEW4(r,g,b,a,skew)	{ r += skew; g += skew; b += skew; a+= skew; }

/*
 * 8-bit palette => 8-bit palette
 */
static void
put8bitcmaptile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 while(h-->0)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

  UNROLL8(w,;,*cp++=*pp++);    // was ,,
  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}


/*
 * 4-bit palette => colormap/RGB
 */
static void
put4bitcmaptile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col/=2;

 while(h-->0)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

  UNROLL2(w,*cp++=nybrev[*pp++],;); // was ,)
  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}

/*
 * 2-bit palette => colormap/RGB
 */
static void
put2bitcmaptile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col/=4;

 while(h-->0)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

  UNROLL4(w,*cp++=dbitrev[*pp++],;);  // was ,)
  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}

/*
 * 1-bit palette => colormap/RGB
 */
static void
put1bitcmaptile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col/=8;

 while(h-->0)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

  UNROLL8(w,*cp++=bitrev[*pp++],;);    // was ,)
  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}

/*
 * 8-bit greyscale => colormap/RGB
 */

static void
putgreytile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 while(h-->0)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

  UNROLL8(w,;,*cp++=*pp++); // was ,,
  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}

/*
 * 1-bit bilevel => colormap/RGB
 */

static void
put1bitbwtile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col/=8;

 while(h-->0)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

  UNROLL8(w,*cp++=bitrev[*pp++],;);  // was ,)
  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}

/*
 * 2-bit greyscale => colormap/RGB
 */
static void
put2bitbwtile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col/=4;

 while(h-->0)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

  UNROLL4(w,*cp++=dbitrev[*pp++],;);    // was ,)
  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}

/*
 * 4-bit greyscale => colormap/RGB
 */
static void
put4bitbwtile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col/=2;

 while(h-->0)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

  UNROLL2(w,*cp++=nybrev[*pp++],;);    // was ,)
  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}


/*
 * 8-bit packed samples => RGB
 */
static void
putRGBcontig8bittile(imagestr * image,int y,int col,u_char *  pp,RGBvalue*Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

/* dprintf(7,"contig 8 bit tile map=%x",Map); */

 col*=3;

 fromskew*=samplesperpixel;
 if(Map)
 {
  while(h-->0)
  {
   register u_long x;
   err=imfind1w(image,image->ypix-1-y,&idata);
   if(err) break;

   cp=((char*)(idata))+col;

   for(x=w;x-->0;)
   {
    *cp++=Map[pp[0]];
    *cp++=Map[pp[1]];
    *cp++=Map[pp[2]];
    pp+=samplesperpixel;
   }
   pp+=fromskew;
   if(toskew>=0) y++;
   else          y--;
  }
 }
 else
 {
  while(h-->0)
  {
   err=imfind1w(image,image->ypix-1-y,&idata);
   if(err) break;

   cp=((char*)(idata))+col;


   UNROLL8(w,;,*cp++=pp[0];*cp++=pp[1];*cp++=pp[2];pp+=samplesperpixel);   // was ,,
   pp+=fromskew;
   if(toskew>=0) y++;
   else          y--;
  }
 }
}







/*
 * 8-bit packed samples => RGBA w/ associated alpha
 * (known to have Map == NULL)
 */

//DECLARE ContigPutFunc(putRGBAAcontig8bittile)
static void
putRGBAAcontig8bittile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 int      * mdata;
 char     * cp;
 char     * cm;

 err=NULL;


 cprintf("RGBAA 8 bit tile");

 fromskew*=samplesperpixel;

 while(h-->0) 
 {
  err=imfind2ww(image,image->ypix-1-y,&idata,
                maskimage,image->ypix-1-y,&mdata);
  if(err) break;

  cp=((char*)(idata))+col*3;
  cm=((char*)(mdata))+col;

  UNROLL8(w,;,*cp++=pp[0];*cp++=pp[1];*cp++=pp[2];*cm++=pp[3];pp+=samplesperpixel);   // was ,,

  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}



/*
 * 8-bit packed samples => RGBA w/ unassociated alpha
 * (known to have Map == NULL)
 */
//DECLARE ContigPutFunc(putRGBUAcontig8bittile)
static void
putRGBUAcontig8bittile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)

{
 os_error * err;
 int      * idata;
 int      * mdata;
 char     * cp;
 char     * cm;
 register u_long x;
 uint32     a;

 err=NULL;


 cprintf("RGBUA 8 bit tile");


 fromskew*=samplesperpixel;

 while(h-->0) 
 {
  err=imfind2ww(image,image->ypix-1-y,&idata,
                maskimage,image->ypix-1-y,&mdata);
  if(err) break;

  cp=((char*)(idata))+col*3;
  cm=((char*)(mdata))+col;

 	for(x=w;x-->0;)
  {
   a=pp[3];
	  *cp++=(char)((pp[0]*a)/255);
	  *cp++=(char)((pp[1]*a)/255);
	  *cp++=(char)((pp[2]*a)/255);
	  *cm++=(char)a;
   pp+=samplesperpixel;
 	}

  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}






/*
 * 16-bit packed samples => RGB
 */
static void
putRGBcontig16bittile(imagestr * image,int y,int col,u_char *  pp,RGBvalue*Map,
                                    u_long w,u_long h,int fromskew,int toskew)
{
 register u_short *wp = (u_short *)pp;
 register u_int x;
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col*=3;

 fromskew *= samplesperpixel;
 if(Map)
 {
  while(h-->0)
  {
   err=imfind1w(image,image->ypix-1-y,&idata);
   if(err) break;

   cp=((char*)(idata))+col;

   for(x=w;x-->0;)
   {
    *cp++=Map[wp[0]];
    *cp++=Map[wp[1]];
    *cp++=Map[wp[2]];
    wp+=samplesperpixel;
   }
   if(toskew>=0) y++;
   else          y--;
   wp+=fromskew;
  }
 }
 else 
 {
  while(h-->0)
  {
   err=imfind1w(image,image->ypix-1-y,&idata);
   if(err) break;

   cp=((char*)(idata))+col;

   for(x=w;x-->0;)
   {
    *cp++=(char)wp[0];
    *cp++=(char)wp[1];
    *cp++=(char)wp[2];
    wp+=samplesperpixel;
   }
   if(toskew>=0) y++;
   else          y--;
   wp+=fromskew;
  }
 }
}






/*
 * 16-bit packed samples => RGBA w/ associated alpha
 * (known to have Map == NULL)
 */
//DECLAREContigPutFunc(putRGBAAcontig16bittile)

static void
putRGBAAcontig16bittile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)

{
 register u_short *wp = (u_short *)pp;
 register u_int x;
 os_error * err;
 int      * idata;
 int      * mdata;
 char     * cp;
 char     * cm;

 err=NULL;

 cprintf("RGBUA contig 16 bit tile");

 fromskew *= samplesperpixel;

 while(h-->0)
 {
  err=imfind2ww(image,image->ypix-1-y,&idata,maskimage,image->ypix-1-y,&mdata);
  if(err) break;

  cp=((char*)(idata))+col*3;
  cm=((char*)(mdata))+col;

  for(x=w;x-->0;)
  {
   *cp++=(char)wp[0];
   *cp++=(char)wp[1];
   *cp++=(char)wp[2];
   *cm++=(char)wp[3];
   wp+=samplesperpixel;
  }
  if(toskew>=0) y++;
  else          y--;
  wp+=fromskew;
 }

 USE(Map);

#ifdef NEVER

    int samplesperpixel = img->samplesperpixel;
    uint16 *wp = (uint16 *)pp;

    (void) y;
    fromskew *= samplesperpixel;
    while (h-- > 0) {
	for (x = w; x-- > 0;) {
	    *cp++ = PACKW4(wp[0], wp[1], wp[2], wp[3]);
	    wp += samplesperpixel;
	}
	cp += toskew;
	wp += fromskew;
    }
#endif

}

/*
 * 16-bit packed samples => RGBA w/ unassociated alpha
 * (known to have Map == NULL)
 */
//DECLAREContigPutFunc(putRGBUAcontig16bittile)

static void
putRGBUAcontig16bittile(imagestr * image,int y,int col,u_char *  pp,RGBvalue * Map,
                                  u_long w,u_long h,int fromskew,int toskew)

{
 register u_short *wp = (u_short *)pp;
 register u_int x;
 os_error * err;
 int      * idata;
 int      * mdata;
 char     * cp;
 char     * cm;
 uint32     a;

 err=NULL;

 cprintf("RGBAA contig 16 bit tile");

 fromskew *= samplesperpixel;

 while(h-->0)
 {
  err=imfind2ww(image,image->ypix-1-y,&idata,maskimage,image->ypix-1-y,&mdata);
  if(err) break;

  cp=((char*)(idata))+col*3;
  cm=((char*)(mdata))+col;

  for(x=w;x-->0;)
  {
   a=wp[3]>>4; 

   *cp++=(char)((wp[0]*a)/0x10eff);
   *cp++=(char)((wp[1]*a)/0x10eff);
   *cp++=(char)((wp[2]*a)/0x10eff);
   *cm++=(char)(a>>4);

   wp+=samplesperpixel;
  }

  if(toskew>=0) y++;
  else          y--;
  wp+=fromskew;
 }

 USE(Map);

#ifdef NEVER
    int samplesperpixel = img->samplesperpixel;
    uint16 *wp = (uint16 *)pp;

    (void) y;
    fromskew *= samplesperpixel;
    while (h-- > 0) {
	uint32 r,g,b,a;
	/*
	 * We shift alpha down four bits just in case unsigned
	 * arithmetic doesn't handle the full range.
	 * We still have plenty of accuracy, since the output is 8 bits.
	 * So we have (r * 0xffff) * (a * 0xfff)) = r*a * (0xffff*0xfff)
	 * Since we want r*a * 0xff for eight bit output,
	 * we divide by (0xffff * 0xfff) / 0xff == 0x10eff.
	 */
	for (x = w; x-- > 0;) {
	    a = wp[3] >> 4; 
	    r = (wp[0] * a) / 0x10eff;
	    g = (wp[1] * a) / 0x10eff;
	    b = (wp[2] * a) / 0x10eff;
	    *cp++ = PACK4(r,g,b,a);
	    wp += samplesperpixel;
	}
	cp += toskew;
	wp += fromskew;
    }

#endif

}









/*
 * 8-bit unpacked samples => RGB
 */
static void
putCMYKseparate8bittile(imagestr * image,int y,int col,u_char *  r,u_char *  g,
          u_char * b,u_char * a,RGBvalue * Map,u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col*=4;

/* dprintf(7,"sep 8 bit map=%x",Map); */

 if(Map)
 {
  while(h-->0)
  {
   register u_long x;

   err=imfind1w(image,image->ypix-1-y,&idata);
   if(err) break;

   cp=((char*)(idata))+col;
 
   for(x=w;x>0;x--)
   {
    *cp++=Map[*r++];
    *cp++=Map[*g++];
    *cp++=Map[*b++];
				*cp++=Map[*a++];
   }

   SKEW4(r,g,b,a,fromskew);

   if(toskew>=0) y++;
   else          y--;
  }
 }
 else
 {
  while(h-->0)
  {
   err=imfind1w(image,image->ypix-1-y,&idata);
   if(err) break;

   cp=((char*)(idata))+col;

   UNROLL8(w,;,*cp++=*r++;*cp++=*g++;*cp++=*b++;*cp++=*a++;);    // was ,,

   SKEW4(r,g,b,a,fromskew);

   if(toskew>=0) y++;
   else          y--;
  }
 }

 USE(a);
}







static void
putRGBseparate8bittile(imagestr * image,int y,int col,u_char *  r,u_char *  g,
          u_char * b,u_char * a,RGBvalue * Map,u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col*=3;

/* dprintf(7,"sep 8 bit map=%x",Map); */

 if(Map)
 {
  while(h-->0)
  {
   register u_long x;

   err=imfind1w(image,image->ypix-1-y,&idata);
   if(err) break;

   cp=((char*)(idata))+col;
 
   for(x=w;x>0;x--)
   {
    *cp++=Map[*r++];
    *cp++=Map[*g++];
    *cp++=Map[*b++];
   }

   SKEW(r,g,b,fromskew);

   if(toskew>=0) y++;
   else          y--;
  }
 }
 else
 {
  while(h-->0)
  {
   err=imfind1w(image,image->ypix-1-y,&idata);
   if(err) break;

   cp=((char*)(idata))+col;

   UNROLL8(w,;,*cp++=*r++;*cp++=*g++;*cp++=*b++);    // was ,,

   SKEW(r,g,b,fromskew);

   if(toskew>=0) y++;
   else          y--;
  }
 }

 USE(a);
}






/*
 * 16-bit unpacked samples => RGB
 */
static void
putRGBseparate16bittile(imagestr * image,int y,int col,
                     u_char *  br,u_char *  bg,u_char * bb,u_char * aa,
                     RGBvalue * Map,u_long w,u_long h,int fromskew,int toskew)
{
 register u_short *r = (u_short *)br;
 register u_short *g = (u_short *)bg;
 register u_short *b = (u_short *)bb;
 register u_long x;

 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col*=3;

 if(Map)
 {
  while(h-->0)
  {
   err=imfind1w(image,image->ypix-1-y,&idata);
   if(err) break;

   cp=((char*)(idata))+col;

   for(x=w;x>0;x--)
   {
    *cp++=Map[*r++];
    *cp++=Map[*g++];
    *cp++=Map[*b++];
    SKEW(r,g,b,fromskew);
    if(toskew>=0) y++;
    else          y--;
   }
  }
 }
 else
 {
  while(h-->0)
  {
   err=imfind1w(image,image->ypix-1-y,&idata);
   if(err) break;

   cp=((char*)(idata))+col;

   for(x=0;x<w;x++)
   {
    *cp++=(char)*r++;
    *cp++=(char)*g++;
    *cp++=(char)*b++;
    SKEW(r,g,b,fromskew);
    if(toskew>=0) y++;
    else          y--;
   }
  }
 }

 USE(aa);
}







/*
 * 16-bit unpacked samples => RGBA w/ associated alpha
 */
static void putRGBAAseparate16bittile(imagestr * image,int y,int col,
                     u_char *  br,u_char *  bg,u_char * bb,u_char * ba,
                     RGBvalue * Map,u_long w,u_long h,int fromskew,int toskew)
{
 uint16 *wr = (uint16*) br;
 uint16 *wg = (uint16*) bg;
 uint16 *wb = (uint16*) bb;
 uint16 *wa = (uint16*) ba;

#ifdef NEVER

    (void) img; (void) y;
    while (h-- > 0) {
	for (x = 0; x < w; x++)
	    *cp++ = PACKW4(*wr++, *wg++, *wb++, *wa++);
	SKEW4(wr, wg, wb, wa, fromskew);
	cp += toskew;
    }

#endif
}

/*
 * 16-bit unpacked samples => RGBA w/ unassociated alpha
 */
static void putRGBUAseparate16bittile(imagestr * image,int y,int col,
                     u_char *  br,u_char *  bg,u_char * bb,u_char * ba,
                     RGBvalue * Map,u_long w,u_long h,int fromskew,int toskew)
{
    uint16 *wr = (uint16*) br;
    uint16 *wg = (uint16*) bg;
    uint16 *wb = (uint16*) bb;
    uint16 *wa = (uint16*) ba;

#ifdef NEVER
    (void) img; (void) y;
    while (h-- > 0) {
	uint32 r,g,b,a;
	/*
	 * We shift alpha down four bits just in case unsigned
	 * arithmetic doesn't handle the full range.
	 * We still have plenty of accuracy, since the output is 8 bits.
	 * So we have (r * 0xffff) * (a * 0xfff)) = r*a * (0xffff*0xfff)
	 * Since we want r*a * 0xff for eight bit output,
	 * we divide by (0xffff * 0xfff) / 0xff == 0x10eff.
	 */
	for (x = w; x-- > 0;) {
	    a = *wa++ >> 4; 
	    r = (*wr++ * a) / 0x10eff;
	    g = (*wg++ * a) / 0x10eff;
	    b = (*wb++ * a) / 0x10eff;
	    *cp++ = PACK4(r,g,b,a);
	}
	SKEW4(wr, wg, wb, wa, fromskew);
	cp += toskew;
    }

#endif

}








/*
 * 8-bit unpacked samples => RGBA w/ associated alpha
 */
//DECLARESepPutFunc(putRGBAAseparate8bittile)

static void
putRGBAAseparate8bittile(imagestr * image,int y,int col,u_char *  r,u_char *  g,
          u_char * b,u_char * a,RGBvalue * Map,u_long w,u_long h,int fromskew,int toskew)

{
 os_error * err;
 int      * idata;
 int      * mdata;
 char     * cp;
 char     * cm;

 err=NULL;


 cprintf("RGBAA sep 8 bit tile");

 while(h-->0)
 {
  err=imfind2ww(image,image->ypix-1-y,&idata,maskimage,image->ypix-1-y,&mdata);
  if(err) break;

  cp=((char*)(idata))+col*3;
  cm=((char*)(mdata))+col;

  UNROLL8(w,;,*cp++=*r++;*cp++=*g++;*cp++=*b++;*cm++=*a++);    // was ,,

  SKEW4(r,g,b,a,fromskew);

  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);

#ifdef NEVER
    (void) img; (void) x; (void) y;
    while (h-- > 0) {
	UNROLL8(w, NOP, *cp++ = PACK4(*r++, *g++, *b++, *a++));
	SKEW4(r, g, b, a, fromskew);
	cp += toskew;
    }

#endif
}

/*
 * 8-bit unpacked samples => RGBA w/ unassociated alpha
 */
//DECLARESepPutFunc(putRGBUAseparate8bittile)
static void
putRGBUAseparate8bittile(imagestr * image,int y,int col,u_char *  r,u_char *  g,
          u_char * b,u_char * a,RGBvalue * Map,u_long w,u_long h,int fromskew,int toskew)

{

 cprintf("RGBUA sep 8 bit tile");

#ifdef NEVER
    (void) img; (void) y;
    while (h-- > 0) {
	uint32 rv, gv, bv, av;
	for (x = w; x-- > 0;) {
	    av = *a++;
	    rv = (*r++ * av) / 255;
	    gv = (*g++ * av) / 255;
	    bv = (*b++ * av) / 255;
	    *cp++ = PACK4(rv,gv,bv,av);
	}
	SKEW4(r, g, b, a, fromskew);
	cp += toskew;
    }

#endif
}



/*
 * 8-bit packed CMYK samples w/o Map => RGB
 *
 * NB: The conversion of CMYK->RGB is *very* crude.
 */
static void putRGBcontig8bitCMYKtile(imagestr * image,int y,int col,u_char *  pp,RGBvalue*Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;


 fromskew*=samplesperpixel;
 while (h-- > 0)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

 	UNROLL8(w, NOP,
	    *cp++=pp[0]; // c
	    *cp++=pp[1]; // m
	    *cp++=pp[2]; // y
	    *cp++=pp[3]; // k
	    pp += samplesperpixel);

	 pp+=fromskew;

  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}



/*
 * 8-bit packed CMYK samples w/Map => RGB
 *
 * NB: The conversion of CMYK->RGB is *very* crude.
 */

static void putRGBcontig8bitCMYKMaptile(imagestr * image,int y,int col,u_char *  pp,RGBvalue*Map,
                                  u_long w,u_long h,int fromskew,int toskew)
{
 os_error * err;
 int      * idata;
 char     * cp;
 register u_long x;

 err=NULL;

 fromskew *= samplesperpixel;

 while(h-->0)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

 	for(x=w;x-->0;)
  {
	    *cp++=pp[0]; // c
	    *cp++=pp[1]; // m
	    *cp++=pp[2]; // y
	    *cp++=pp[3]; // k

   pp+=samplesperpixel;
	 }

 	pp+=fromskew;

  if(toskew>=0) y++;
  else          y--;
 }

 USE(Map);
}






#define Code2V(c, RB, RW, CR)   ((((c)-RB)*(float)CR)/(float)(RW-RB))
#define CLAMP(f,min,max) \
    (int)((f)+.5 < (min) ? (min) : (f)+.5 > (max) ? (max) : (f)+.5)

#define LumaRed         YCbCrCoeffs[0]
#define LumaGreen       YCbCrCoeffs[1]
#define LumaBlue        YCbCrCoeffs[2]

static  float D1, D2;
static  float D3, D4;

static void
initYCbCrConversion()
{
        D1 = 2 - 2*LumaRed;
        D2 = D1*LumaRed / LumaGreen;
        D3 = 2 - 2*LumaBlue;
        D4 = D2*LumaBlue / LumaGreen;
}




static void
putRGBContigYCbCrClump(imagestr * image,int y,int col,u_char *  pp,
                           int cw,int ch,u_int n,int fromskew,int toskew)
{
 float Cb, Cr;
 int j, k;

 os_error * err;
 int      * idata;
 char     * cp;

 err=NULL;

 col*=3;

 Cb=Code2V(pp[n],refBlackWhite[2],refBlackWhite[3],127);
 Cr=Code2V(pp[n+1],refBlackWhite[4],refBlackWhite[5],127);

 for(j=0;j<ch;j++)
 {
  err=imfind1w(image,image->ypix-1-y,&idata);
  if(err) break;

  cp=((char*)(idata))+col;

  for(k=0;k<cw;k++)
  {
   float Y, R, G, B;
   Y=Code2V(*pp++,refBlackWhite[0],refBlackWhite[1],255);
   R=Y+Cr*D1;
   B=Y+Cb*D3;
   G=Y-Cb*D4-Cr*D2;

   *cp++=(char)CLAMP(R,0,255);
   *cp++=(char)CLAMP(G,0,255);
   *cp++=(char)CLAMP(B,0,255);
  }
  pp+=fromskew;
  if(toskew>=0) y++;
  else          y--;
 }
}


#undef LumaBlue
#undef LumaGreen
#undef LumaRed
#undef CLAMP
#undef Code2V

/*
 * 8-bit packed YCbCr samples => RGB
 */
static void
putcontig8bitYCbCrtile(imagestr * image,int y,int col,u_char *  pp,
                     RGBvalue * Map,u_long w,u_long h,int fromskew,int toskew)
{
 u_int Coff=YCbCrVertSampling*YCbCrHorizSampling;
 u_long x;
 int    sy;
 int    scol;

 /* XXX adjust fromskew */


/* dprintf(8,"YCbCrVertSampling=%d YCbCrHorizSampling=%d",
            YCbCrVertSampling,YCbCrHorizSampling);
  */

 sy=y;
 scol=col;

 while(h>=YCbCrVertSampling)
 {
  col=scol;

  for(x=w;x>=YCbCrHorizSampling;x-=YCbCrHorizSampling)
  {
   putRGBContigYCbCrClump(image,y,col,pp,(int)YCbCrHorizSampling,
                                (int)YCbCrVertSampling,Coff,0,toskew);
   col+=YCbCrHorizSampling;
   pp+=Coff+2;
  }
  if(x>0)
  {
   putRGBContigYCbCrClump(image,y,col,pp,(int)x,(int)YCbCrVertSampling,Coff,
                                  YCbCrHorizSampling-x,toskew);
   pp+=Coff+2;
  }

  if(toskew>=0) y+=YCbCrVertSampling;
  else          y-=YCbCrVertSampling;

  pp+=fromskew;
  h-=YCbCrVertSampling;
 }

 if(h>0)
 {
  col=scol;

  for(x=w;x>=YCbCrHorizSampling;x-=YCbCrHorizSampling)
  {
   putRGBContigYCbCrClump(image,y,col,pp,(int)YCbCrHorizSampling,h,Coff,0,toskew);
   col+=YCbCrHorizSampling;
   pp+=Coff+2;
  }
  if(x>0)
   putRGBContigYCbCrClump(image,y,col,pp,x,h,Coff,YCbCrHorizSampling-x,toskew);
 }

 USE(Map);
}





/*
 * Select the appropriate conversion routine for packed data.
 */
static XtileContigRoutine DECLARE1(pickTileContigCase, RGBvalue*, Map)
{
 XtileContigRoutine put = 0;

 cprintf("Xtilecontig routine alpha %d bits %d",alpha,bitspersample);

 switch(photometric)
 {
  case PHOTOMETRIC_RGB:
                  	    switch(bitspersample) 
                       {
	                       case 8:
		                             if(!Map) 
                               {
		                              if(alpha==EXTRASAMPLE_ASSOCALPHA)
                                {
                                	put=putRGBAAcontig8bittile;
                                }
                          		    else 
                                if(alpha==EXTRASAMPLE_UNASSALPHA)
                                {
			                              put=putRGBUAcontig8bittile;
                                }
		                              else
                                {
			                              put=putRGBcontig8bittile;
		                              }
                               }
                               else
                               {
		                              put=putRGBcontig8bittile;
                               }
		                             break;

	                      case 16:
		                             put=putRGBcontig16bittile;
                             		if(!Map)
                               {
		                              if(alpha==EXTRASAMPLE_ASSOCALPHA)
                                {
			                              put = putRGBAAcontig16bittile;
                                }
		                              else 
                                if(alpha == EXTRASAMPLE_UNASSALPHA)
                                {
			                              put=putRGBUAcontig16bittile;
		                              }
		                              break;
	                              }
	                              break;
                       }
                       break;

        case PHOTOMETRIC_PALETTE:
                switch (bitspersample) {
                case 8: put = put8bitcmaptile; break;
                case 4: put = put4bitcmaptile; break;
                case 2: put = put2bitcmaptile; break;
                case 1: put = put1bitcmaptile; break;
                }
                break;
        case PHOTOMETRIC_MINISWHITE:
        case PHOTOMETRIC_MINISBLACK:
                switch (bitspersample) {
                case 8: put = putgreytile; break;
                case 4: put = put4bitbwtile; break;
                case 2: put = put2bitbwtile; break;
                case 1: put = put1bitbwtile; break;
                }
                break;
        case PHOTOMETRIC_YCBCR:
                switch (bitspersample) {
                case 8: put = putcontig8bitYCbCrtile; break;
                }
                break;

     	case PHOTOMETRIC_SEPARATED:
	               if(bitspersample==8)
                {
		               if(Map) put=putRGBcontig8bitCMYKtile;
		               else    put=putRGBcontig8bitCMYKMaptile;
	               }
                break;

 }

 if(put==0) TIFFError(filename, "Can not handle format - 1");

 return(put);
}

/*
 * Select the appropriate conversion routine for unpacked data.
 *
 * NB: we assume that unpacked single channel data is directed
 *       to the "packed routines.
 */



typedef void (*XtileSeparateRoutine)
 (imagestr*,int,int,u_char*,u_char*,u_char*,u_char*,RGBvalue*,u_long,u_long,int,int);


static XtileSeparateRoutine DECLARE1(pickTileSeparateCase, RGBvalue*, Map)
{
 XtileSeparateRoutine put = 0;

	cprintf("bitspersample %d photometric %d _RGB %d Map %d",bitspersample,photometric,PHOTOMETRIC_RGB,Map);

 switch(photometric)
 {
  case PHOTOMETRIC_RGB:
                       switch(bitspersample) 
                       {
	                       case 8:
		                             if(!Map) 
                               {
		                              if(alpha==EXTRASAMPLE_ASSOCALPHA)
		                                     	put=putRGBAAseparate8bittile;
                                else
                                if(alpha==EXTRASAMPLE_UNASSALPHA)
			                                     put=putRGBUAseparate8bittile;
		                              else
			                                     put=putRGBseparate8bittile;
                               } 
                               else put=putRGBseparate8bittile;
		                             break;

                        case 16:
                               	put=putRGBseparate16bittile;
	                              	if(!Map) 
                                {
		                               if(alpha==EXTRASAMPLE_ASSOCALPHA)
			                                      put=putRGBAAseparate16bittile;
		                               else 
                                 if(alpha==EXTRASAMPLE_UNASSALPHA)
			                                      put=putRGBUAseparate16bittile;
                                }
                                break;
                       }
																							break;

     	case PHOTOMETRIC_SEPARATED:
	               if(bitspersample==8)
                {
		               if(Map) put=putCMYKseparate8bittile;
		               else    put=putCMYKseparate8bittile;
	               }
                break;

 
 }
 
 if(put==0) TIFFError(filename, "Can not handle format - 2");

 return (put);

 USE(Map);
}





/*
 * Get an tile-organized image that has
 *      PlanarConfiguration contiguous if SamplesPerPixel > 1
 * or
 *      SamplesPerPixel == 1
 */     

static os_error * gtTileContig(TIFF * tif,imagestr * image,
                                RGBvalue *  Map,u_long h,u_long w)
{
 os_error * err;
 u_long col, row, y;
 u_long tw, th;
 u_char *buf;
 int fromskew, toskew;
 u_int nrow;
 XtileContigRoutine put;

 err=NULL;

 put=pickTileContigCase(Map);
 if(put==0) return(0);

 err=salloc((flex_ptr)&buf,TIFFTileSize(tif));
 if(err) return(err);


 TIFFGetField(tif, TIFFTAG_TILEWIDTH, &tw);
 TIFFGetField(tif, TIFFTAG_TILELENGTH, &th);
 y=setorientation(tif,h);

 toskew=(int)((orientation==ORIENTATION_TOPLEFT ? -(signed long)tw + -(signed long)w : -(signed long)tw + w));
 for(row=0;row<h;row+=th)
 {
  nrow=(row+th>h?h-row:th);
  for(col=0;col<w;col+=tw)
  {
   if(TIFFReadTile(tif,buf,col,row,0,0)<0 && stoponerr) break;

   if(col+tw>w)
   {
    /*
     * Tile is clipped horizontally.  Calculate
     * visible portion and skewing factors.
     */
  
    u_long npix = w - col;
    fromskew=tw-npix;
    (*put)(image,y,col,buf,Map,npix,nrow,fromskew,toskew+fromskew);
   }
   else
   {
    (*put)(image,y,col,buf,Map,tw,nrow,0,toskew);
   }
  }
  y+=(orientation==ORIENTATION_TOPLEFT?-(signed int)nrow:nrow);
 }
 sfree((flex_ptr)&buf);

 return(err);
}



/*
 * Get an tile-organized image that has
 *       SamplesPerPixel > 1
 *       PlanarConfiguration separated
 * We assume that all such images are RGB.
 */     

static os_error * gtTileSeparate(TIFF * tif,imagestr * image,
                                             RGBvalue * Map,u_long h,u_long w)
{
 os_error * err;
 u_long col, row, y;
 u_long tw, th;
 u_char *buf;
 u_char *r, *g, *b, *a;
 int tilesize;
 int fromskew, toskew;
 u_int nrow;
 XtileSeparateRoutine put;

 err=NULL;

 put=pickTileSeparateCase(Map);
 if(put==0) return (0);

 tilesize=(int)TIFFTileSize(tif);

 err=salloc((flex_ptr)&buf,4*tilesize);
 if(err) return(err);


 r=buf;
 g=r + tilesize;
 b=g + tilesize;
 a=b + tilesize;

 TIFFGetField(tif, TIFFTAG_TILEWIDTH, &tw);
 TIFFGetField(tif, TIFFTAG_TILELENGTH, &th);
 y=setorientation(tif,h);
 toskew=(orientation==ORIENTATION_TOPLEFT ? -(signed long)tw + -(signed long)w : -(signed long)tw + w);

 for(row=0;row<h;row+=th)
 {
  nrow=(row + th > h ? h - row : th);
  for(col = 0; col < w; col += tw) 
  {
   if(TIFFReadTile(tif,r,col,row,0,0) < 0 && stoponerr)
                                break;
   if(TIFFReadTile(tif,g,col,row,0,1) < 0 && stoponerr)
                                break;
   if(TIFFReadTile(tif,b,col,row,0,2) < 0 && stoponerr)
                                break;
   if((alpha || cmykimage) && TIFFReadTile(tif,a,col,row,0,3) < 0 && stoponerr)
                                break;

   if(col+tw>w)
   {
     /*
      * Tile is clipped horizontally.  Calculate
      * visible portion and skewing factors.
      */

    u_long npix = w - col;
    fromskew = tw - npix;
    (*put)(image,y,col,r,g,b,a,Map,npix,nrow,fromskew,toskew+fromskew);
   }
   else
   {
    (*put)(image,y,col,r,g,b,a,Map,tw,nrow,0,toskew);
   }
  }
  y += (orientation == ORIENTATION_TOPLEFT ? -(signed int)nrow : nrow);
 }

 sfree((flex_ptr)&buf);

 return(err);
}

/*
 * Get a strip-organized image that has
 *      PlanarConfiguration contiguous if SamplesPerPixel > 1
 * or
 *      SamplesPerPixel == 1
 */     
static os_error * gtStripContig(TIFF * tif,imagestr * image,
                                            RGBvalue * Map,u_long h,u_long w)
{
 os_error * err;
 u_long row, y, nrow;
 u_char *buf;
 XtileContigRoutine put;
 u_long rowsperstrip;
 u_long imagewidth;
 int scanline;
 int fromskew, toskew;

 err=NULL;


/* dprintf(0,"gtStripContig h=%d w=%d",h,w); */



 put=pickTileContigCase(Map);
 if(put==0) return (0);


 err=salloc((flex_ptr)&buf,TIFFStripSize(tif));
 if(err) return(err);


 y=setorientation(tif,h);
 toskew = (orientation == ORIENTATION_TOPLEFT ? -(signed long)w + -(signed long)w : -(signed long)w + w);

 TIFFGetFieldDefaulted(tif, TIFFTAG_ROWSPERSTRIP, &rowsperstrip);
 TIFFGetField(tif, TIFFTAG_IMAGEWIDTH, &imagewidth);

 scanline=TIFFScanlineSize(tif);

 fromskew=(w < imagewidth ? imagewidth - w : 0);


 for(row = 0; row < h; row += rowsperstrip)
 {
  nrow = (row + rowsperstrip > h ? h - row : rowsperstrip);

  if (TIFFReadEncodedStrip(tif, TIFFComputeStrip(tif, row, 0),
                    buf, nrow*scanline) < 0 && stoponerr)
                        break;
  (*put)(image,y,0,buf,Map,w,nrow,fromskew,toskew);
  y += (orientation == ORIENTATION_TOPLEFT ? -(signed int)nrow : nrow);
 }

 sfree((flex_ptr)&buf);

 return(err);
}


/*
 * Get a strip-organized image with
 *       SamplesPerPixel > 1
 *       PlanarConfiguration separated
 * We assume that all such images are RGB.
 */

static os_error * gtStripSeparate(TIFF * tif,imagestr * image,
                                             RGBvalue *  Map,u_long h,u_long w)
{
 os_error * err;
 u_char *buf;
 u_char *r, *g, *b, * a;
 u_long row, y, nrow;
 int scanline;
 XtileSeparateRoutine put;
 u_long rowsperstrip;
 u_long imagewidth;
 u_int stripsize;
 int fromskew, toskew;

 err=NULL;

 stripsize=TIFFStripSize(tif);

 err=salloc((flex_ptr)&buf,4*stripsize);
 if(err) return(err);


 r=buf;
 g=r+stripsize;
 b=g+stripsize;
 a=b+stripsize;

 put=pickTileSeparateCase(Map);
 if(put==0)
 {
  TIFFError(filename, "Can not handle format -3 ");
  return (0);
 }

 y=setorientation(tif,h);
 toskew=(orientation==ORIENTATION_TOPLEFT?-(signed long)w+-(signed long)w:-(signed long)w+w);

 TIFFGetFieldDefaulted(tif, TIFFTAG_ROWSPERSTRIP, &rowsperstrip);
 TIFFGetField(tif, TIFFTAG_IMAGEWIDTH, &imagewidth);
 scanline = TIFFScanlineSize(tif);
 fromskew = (w < imagewidth ? imagewidth - w : 0);
 for(row = 0; row < h; row += rowsperstrip)
 {
  nrow = (row + rowsperstrip > h ? h - row : rowsperstrip);
  if(TIFFReadEncodedStrip(tif, TIFFComputeStrip(tif, row, 0),
                    r, nrow*scanline) < 0 && stoponerr)
                        break;

  if(TIFFReadEncodedStrip(tif, TIFFComputeStrip(tif, row, 1),
                    g, nrow*scanline) < 0 && stoponerr)
                        break;
  if(TIFFReadEncodedStrip(tif, TIFFComputeStrip(tif, row, 2),
                    b, nrow*scanline) < 0 && stoponerr)
                        break;
  if((alpha || cmykimage) && TIFFReadEncodedStrip(tif, TIFFComputeStrip(tif, row, 3),
                    a, nrow*scanline) < 0 && stoponerr)
                        break;



  (*put)(image,y,0,r,g,b,a,Map,w,nrow,fromskew,toskew);
  y+=(orientation==ORIENTATION_TOPLEFT?-(signed int)nrow:nrow);
 }

 sfree((flex_ptr)&buf);

 return(err);
}





static os_error * gt(TIFF * tif,int w,int h,imagestr * loadimage)
{
 os_error * err;

 u_short    minsamplevalue;
 u_short    maxsamplevalue;
 u_short    planarconfig;
 RGBvalue * Map;

 err=NULL;

 TIFFGetFieldDefaulted(tif,TIFFTAG_MINSAMPLEVALUE,&minsamplevalue);
 TIFFGetFieldDefaulted(tif,TIFFTAG_MAXSAMPLEVALUE,&maxsamplevalue);
 Map=NULL;

 switch(photometric)
 {
   case PHOTOMETRIC_YCBCR:
                        TIFFGetFieldDefaulted(tif, TIFFTAG_YCBCRCOEFFICIENTS,
                                                             &YCbCrCoeffs);
                        TIFFGetFieldDefaulted(tif, TIFFTAG_YCBCRSUBSAMPLING,
                                  &YCbCrHorizSampling, &YCbCrVertSampling);
                        TIFFGetFieldDefaulted(tif, TIFFTAG_REFERENCEBLACKWHITE,
                                                             &refBlackWhite);
                        initYCbCrConversion();
                        /* fall thru... */
     case PHOTOMETRIC_RGB:
                          if(minsamplevalue==0 && maxsamplevalue==255) break;
                        /* fall thru... */
   case PHOTOMETRIC_MINISBLACK:
   case PHOTOMETRIC_MINISWHITE:
                        {
                         register int x, range;

                         range=maxsamplevalue-minsamplevalue;
                         err=salloc((flex_ptr)&Map,(range+1)*sizeof(RGBvalue));
                         if(err) return(err);

                         if(photometric==PHOTOMETRIC_MINISWHITE)
                         {
                          for(x=0;x<=range;x++)
                          Map[x]=(char)(((range-x)*255)/range);
                         }
                         else 
                         {
                          for(x=0;x<=range;x++) Map[x]=(char)((x*255)/range);
                         }
                         if(photometric!=PHOTOMETRIC_RGB && bitspersample<=8)
                         {
                          /*
                           * Use photometric mapping table to construct
                           * unpacking tables for samples <= 8 bits.
                           */
                          makebwmap(Map,loadimage);

                          /* no longer need Map, free it */
                          sfree((flex_ptr)&Map);
                         }
                         break;
                        }
        case PHOTOMETRIC_PALETTE:

                loadimage->ipal.palclass=CL_RGB;

                if (!TIFFGetField(tif, TIFFTAG_COLORMAP,
                                  &redcmap, &greencmap, &bluecmap)) {
                        TIFFError(filename,
                            "Missing required \"Colormap\" tag");
                        return (0);
                }
                /*
                 * Convert 16-bit colormap to 8-bit (unless it looks
                 * like an old-style 8-bit colormap).
                 */
                if (checkcmap(1<<bitspersample, redcmap, greencmap, bluecmap) == 16) {
                        int i;
                        for (i = (1<<bitspersample)-1; i >= 0; i--) {
#define CVT(x)          (((x) * 255) / ((1L<<16)-1))
                                redcmap[i] = (unsigned short)CVT(redcmap[i]);
                                greencmap[i] =(unsigned short) CVT(greencmap[i]);
                                bluecmap[i] = (unsigned short)CVT(bluecmap[i]);
                        }
                }
                if(bitspersample<=8)
                {
                        /*
                         * Use mapping table and colormap to construct
                         * unpacking tables for samples < 8 bits.
                         */
                        tmakecmap(redcmap,greencmap,bluecmap,loadimage);
                }
                break;


       case PHOTOMETRIC_SEPARATED:
               loadimage->ipal.palclass=CL_CMYK;
															cmykimage=1;
                break;

#ifdef NEVER
	if (td->td_inkset != INKSET_CMYK) {
	    sprintf(emsg, "Sorry, can not handle separated image with %s=%d",
		"InkSet", td->td_inkset);
	    return (0);
	}
	if (td->td_samplesperpixel < 4) {
	    sprintf(emsg, "Sorry, can not handle separated image with %s=%d",
		"Samples/pixel", td->td_samplesperpixel);
	    return (0);
	}

#endif




        }
        TIFFGetField(tif, TIFFTAG_PLANARCONFIG, &planarconfig);
        if (planarconfig == PLANARCONFIG_SEPARATE && samplesperpixel > 1) {
                err=TIFFIsTiled(tif) ?
                    gtTileSeparate(tif,loadimage,Map,h,w) :
                    gtStripSeparate(tif,loadimage,Map,h,w);
        } else {
                err=TIFFIsTiled(tif) ? 
                    gtTileContig(tif,loadimage,Map,h,w) :
                    gtStripContig(tif,loadimage,Map,h,w);
        }
        if(Map) sfree((flex_ptr)&Map);

 return(err);
}




os_error * tiff_loadimages(TIFF * tif,imagestr * loadimage,int rwidth,int rheight)
{
 os_error * err;
 uint16   * sampleinfo;
 uint16     extrasamples;

 u_long     width;
 u_long     height;


 alpha=0;
	cmykimage=0;

 TIFFGetFieldDefaulted(tif,TIFFTAG_BITSPERSAMPLE,&bitspersample);
 switch(bitspersample)
 {
   case 1:
   case 2:
   case 4:
   case 8: 
  case 16:
          break;
  default:
          TIFFError(TIFFFileName(tif),"Sorry, can not handle %d-bit pictures", 
                                                               bitspersample);
          return (0);
 }

 TIFFGetFieldDefaulted(tif,TIFFTAG_SAMPLESPERPIXEL,&samplesperpixel);
 switch(samplesperpixel)
 {
   case 1: 
   case 3: 
   case 4:
          break;
  default:
          TIFFError(TIFFFileName(tif),"Sorry, can not handle %d-channel images",                                                             samplesperpixel);
          return (0);
 }


 TIFFGetFieldDefaulted(tif,TIFFTAG_EXTRASAMPLES,&extrasamples,&sampleinfo);
 if(extrasamples==1)
 {
	 switch (sampleinfo[0]) 
  {
	  case EXTRASAMPLE_ASSOCALPHA:	/* data is pre-multiplied */
	  case EXTRASAMPLE_UNASSALPHA:	/* data is not pre-multiplied */
	                              alpha=sampleinfo[0];
	  break;
	 }
 }


 if(!TIFFGetField(tif,TIFFTAG_PHOTOMETRIC,&photometric))
 {
  switch(samplesperpixel-extrasamples)
  {
    case 1:
           photometric=PHOTOMETRIC_MINISBLACK;
           break;

    case 3: 
    case 4:
           photometric=PHOTOMETRIC_RGB;
           break;


   default:
           TIFFError(TIFFFileName(tif),
                    "Missing needed \"PhotometricInterpretation\" tag");
           return (0);
  }

  TIFFError(TIFFFileName(tif),
                    "No \"PhotometricInterpretation\" tag, assuming %s\n",
                    photometric == PHOTOMETRIC_RGB ? "RGB" : "min-is-black");
 }

 /* XXX maybe should check photometric? */

 TIFFGetField(tif, TIFFTAG_IMAGEWIDTH, &width);
 TIFFGetField(tif, TIFFTAG_IMAGELENGTH, &height);

 /* XXX verify rwidth and rheight against width and height */

 stoponerr=0;
 BWmap=NULL;
 PALmap=NULL;


/* dprintf(2,"rwidth=%d %d height %d %d",rwidth,width,rheight,height); */

 err=gt(tif,rwidth,height,loadimage);

 return(err);
}



os_error * tiff_loadimage(TIFF * tif,imagestr * loadimage,imagestr * xmaskimage,
                                                   int rwidth,int rheight)
{
 os_error * err;

 maskimage=xmaskimage;

 tiffclearerror();

 err=tiff_loadimages(tif,loadimage,rwidth,rheight);
 if(!err) err=tiffgeterror();

 return(err);
}

