/*->c.tfile */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"
#include "deb.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"
#include "bitrev.h"
#include "bits.h"


#include "constants.h"
#include "str.h"
#include "reslink.h"

#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "cms.h"


#define USE_CONST 1
#define USE_PROTOTYPES 1

#include "tiffio.h"

#include "tload.h"
#include "tfile.h"



/*****************************************************************************/

extern ftypestr ftype;
extern dboxstr  configbox;


static int tdbl;
static int dbl;
static int tcolour=COMPRESSION_LZW;
static int colour=COMPRESSION_LZW;
static int tbw=COMPRESSION_CCITTFAX3;
static int bw=COMPRESSION_CCITTFAX3;
static int givewarnings;
static int tgivewarnings;


static char tifferrorstring[256];

static void errorhandler(const char * module,const char * fmt,va_list ap)
{
 int len;


 if(module!=NULL) len=sprintf(tifferrorstring, "%s: ", module);
 else             len=0;

 vsprintf(tifferrorstring+len,fmt,ap);


 cprintf("error handler called %s",tifferrorstring);
}


void tiffclearerror(void)
{
 *tifferrorstring=0;
}


os_error * tiffgeterror(void)
{
 if(*tifferrorstring) return(generror(0,tifferrorstring));
 else                 return(NULL);
}



static void warninghandler(const char * module,const char * fmt,va_list ap)
{
 int  len;
	char warning[256];

	if(givewarnings)
	{
  if(module!=NULL) len=sprintf(warning, "%s: ", module);
  else             len=0;

  vsprintf(warning+len,fmt,ap);

 	messagebox(warning);
	}
}







static os_error * getinfo(framestr * frame,TIFF * tif,improfilestr * profile)
{
 char   string[1024];
 char   string2[256];
 char   string3[256];


 *string=0;

 TIFFSPrintDirectory(tif,string,0);


 if(profile)
 {
  cmsprofilename(profile,string2,sizeof(string2));
  sprintf(string3,"ICC Profile: <%s>",string2);

  xstrslice(string,"ICC Profile: <present>",string3);
 }


// cprintf("info %s",string);


 return(infowrite(string,frame));
}


static os_error * tiff_loadframe(TIFF * tif,filestr * file,int fn)
{
 os_error * err;
 imagestr * loadimage;
 imagestr * maskimage;
 unsigned char                  * iccdata;
 unsigned int                     icclen;


 err=ximnew2(file->frames[fn].fxpix,file->frames[fn].fypix,
            file->frames[fn].fbpp,file->frames[fn].mbpp,&file->frames[fn].xim);

 cprintf("tiffloadframe bpp %d mbpp %d",file->frames[fn].fbpp,file->frames[fn].mbpp);

 if(!err)
 {
  loadimage=((file->frames[fn].xim)->sim[IM]);
  maskimage=((file->frames[fn].xim)->sim[AL]);

  loadimage->xdpi=file->frames[fn].fxdpi;
  loadimage->ydpi=file->frames[fn].fydpi;
  if(maskimage)
  {
   maskimage->xdpi=file->frames[fn].fxdpi;
   maskimage->ydpi=file->frames[fn].fydpi;
  }


  err=tiff_loadimage(tif,loadimage,maskimage,file->frames[fn].fxpix,file->frames[fn].fypix);

  if(!TIFFGetField(tif,TIFFTAG_ICCPROFILE,&icclen,&iccdata))
  {
   iccdata=NULL;
  }

  if(iccdata)
  {
   cmsaddprofile(&loadimage->profile,&iccdata,icclen,CMSADDALLOC);
  }
  else
  {
   if(loadimage->ipal.palclass==CL_CMYK)
   { 
    cmscmykprofile(&loadimage->profile);
   }
   else
   {
    cmsrgbprofile(&loadimage->profile);
   }
  }

  getinfo(&file->frames[fn],tif,&loadimage->profile);
 }

 return(err);
}




static os_error * loadtiff(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;
 int         first;
 int         fn;
 TIFF      * tif;
 unsigned short bitspersample;
 unsigned short samplesperpixel;
 unsigned short   * sampleinfo;
 unsigned short     extrasamples;
 float       xres;
 float       yres;
 int         gotx;
 int         goty;
 unsigned short units;
 unsigned short photometric;

 cprintf("loadtiff");

 tiffclearerror();

 cprintf("clear error++");

 err=NULL;
 first=1;

 tif=TIFFOpen(name,"r");
 if(tif!=NULL)
 {
  cprintf("TIFF open");

  do
  {
   err=addframe(loadfile,&fn,0);
   if(!err)
   {
    TIFFGetField(tif,TIFFTAG_IMAGEWIDTH,&loadfile->frames[fn].fxpix);
    TIFFGetField(tif,TIFFTAG_IMAGELENGTH,&loadfile->frames[fn].fypix);
    TIFFGetFieldDefaulted(tif,TIFFTAG_BITSPERSAMPLE,&bitspersample);
    TIFFGetFieldDefaulted(tif,TIFFTAG_SAMPLESPERPIXEL,&samplesperpixel);
    TIFFGetFieldDefaulted(tif,TIFFTAG_EXTRASAMPLES,&extrasamples,&sampleinfo);

    if(!TIFFGetField(tif,TIFFTAG_PHOTOMETRIC,&photometric))
    {
     switch(samplesperpixel-extrasamples)
     {
      case 1:
             photometric=PHOTOMETRIC_MINISBLACK;
             break;

      case 3: 
      case 4:
             photometric=PHOTOMETRIC_RGB;
             break;


     default:
  //  TIFFError(TIFFFileName(tif),"Missing needed \"PhotometricInterpretation\" tag");
             break;
     }
    }



   cprintf("bitspersample=%d samplesperpixel=%d extra %d",bitspersample,
                                         samplesperpixel,extrasamples);

    samplesperpixel=samplesperpixel-extrasamples;
    if(photometric==PHOTOMETRIC_RGB && samplesperpixel==4) 
    {
     extrasamples++;
     samplesperpixel--;
    }

    if(photometric==PHOTOMETRIC_SEPARATED && samplesperpixel==5) 
    {
     extrasamples++;
     samplesperpixel--;
    }

    if(samplesperpixel>4) samplesperpixel=4;
    if(extrasamples>4)    extrasamples=4;

    sprintf(loadfile->frames[fn].name,"TIFF%d",fn);
    loadfile->frames[fn].offset=0;
    loadfile->frames[fn].fbpp=bitspersample*samplesperpixel;
    loadfile->frames[fn].mbpp=bitspersample*extrasamples;


    xres=yres=90;

    if(!TIFFGetField(tif,TIFFTAG_RESOLUTIONUNIT,&units)) units=RESUNIT_INCH;

    {

    /* dprintf(0,"point 1"); */

     gotx=TIFFGetField(tif,TIFFTAG_XRESOLUTION,&xres);
     goty=TIFFGetField(tif,TIFFTAG_YRESOLUTION,&yres);

     if(gotx || goty)
     {
      if(!gotx) xres=yres;
      if(!goty) yres=xres;

      if(!xres) xres=90;
      if(!yres) yres=90;

     /* dprintf(0,"point 2 x=%f y=%f units=%d",xres,yres,units);  */

      switch(units)
      {
             case RESUNIT_NONE:
                               yres=(90/xres)*yres;
                               xres=90;
                               break;

             case RESUNIT_INCH:
                               break;

       case RESUNIT_CENTIMETER:
                               xres*=2.54;
                               yres*=2.54;
                               break;

                       default:
                               yres=(90/xres)*yres;
                               xres=90;
                               break;
      }
     }
    }

  /*  dprintf(2,"unit=%d xres=%g yres=%g",units,xres,yres);
    dprintf(3,"xpix=%d ypix=%d",loadfile->frames[fn].xpix,
                                loadfile->frames[fn].ypix); */

    loadfile->frames[fn].fxdpi=(int)xres;
    loadfile->frames[fn].fydpi=(int)yres;

    loadfile->frames[fn].xim=NULL;

    if(first)
    {
     err=tiff_loadframe(tif,loadfile,fn);
     first=0;
    }
   }
  } while(TIFFReadDirectory(tif));

  TIFFClose(tif);
 }

 if(!err) err=tiffgeterror();

 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}




static os_error * getframe(filestr * file,int fn)
{
 os_error  * err;
 TIFF      * tif;
 int         count;

 tiffclearerror();

 err=NULL;
 count=0;



 tif=TIFFOpen(file->oname,"r");
 if(tif!=NULL)
 {
  while(count<fn)
  {
   if(!TIFFReadDirectory(tif)) break;
   count++;
  }

/* dprintf(0,"get frame=%d  count=%d",fn,count); */

  err=tiffgeterror();
  if(!err && count==fn) err=tiff_loadframe(tif,file,fn);

  TIFFClose(tif);
 }

 return(err);
}




static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;

 err=NULL;

/* dprintf(0,"load tiff post"); */

 return(err);
 USE(userhandle);
}






static os_error * savetiffim(char * name,int type,imagestr * saveimage)
{
 os_error * err;
 TIFF     * tif;
 float      xres;
 float      yres;
 int        xpix;
 int        ypix;
 int        bpp;
 int        x;
 int        y;
 unsigned short bitspersample;
 unsigned short samplesperpixel;
 int       * idata;
 char      * rowbuff;
 char      * p;
 char      * q;
 int         bytewidth;
 int         compression;
 int         bwimage;
 int         w;
 unsigned char * iccdata;
 unsigned int    icclen;


 err=NULL;

 tiffclearerror();

 xres=(float)saveimage->xdpi;
 yres=(float)saveimage->ydpi;
 ypix=saveimage->ypix;
 xpix=saveimage->xpix;
 bpp=saveimage->bpp;
 compression=colour;
 bwimage=imbw(saveimage);


 if(bpp<=8) bytewidth=(xpix*bpp+7)/8;
 else
 {
  if(saveimage->ipal.palclass==CL_CMYK)
  {
   bytewidth=(xpix*4);
  }
  else
  {
   bytewidth=(xpix*3);
  }
 }


 err=salloc((flex_ptr)&rowbuff,bytewidth);
 if(err) return(err);


 tif=TIFFOpen(name,"w");
 if(tif!=NULL)
 {
  TIFFSetField(tif,TIFFTAG_RESOLUTIONUNIT,(unsigned short)RESUNIT_INCH);
  TIFFSetField(tif,TIFFTAG_XRESOLUTION,xres);
  TIFFSetField(tif,TIFFTAG_YRESOLUTION,yres);

  if(saveimage->bpp<=8)
  {
   bitspersample=saveimage->bpp;
   samplesperpixel=1;

   if(bwimage)
   {
    TIFFSetField(tif,TIFFTAG_PHOTOMETRIC,(unsigned short)
                 (bwimage==-1?PHOTOMETRIC_MINISWHITE:PHOTOMETRIC_MINISBLACK));
    if(bw) compression=bw;
   }
   else
   {
    TIFFSetField(tif,TIFFTAG_PHOTOMETRIC,(unsigned short)PHOTOMETRIC_PALETTE);
   }
  }
  else
  {
   TIFFSetField(tif,TIFFTAG_MAXSAMPLEVALUE,(unsigned short)255);
   TIFFSetField(tif,TIFFTAG_MINSAMPLEVALUE,(unsigned short)0);

   if(saveimage->ipal.palclass==CL_CMYK)
   {
    bitspersample=8;
    samplesperpixel=4;
    TIFFSetField(tif,TIFFTAG_PHOTOMETRIC,(unsigned short)PHOTOMETRIC_SEPARATED);
   }
   else
   {
    bitspersample=8;
    samplesperpixel=3;
    TIFFSetField(tif,TIFFTAG_PHOTOMETRIC,(unsigned short)PHOTOMETRIC_RGB);
   }
  }


  TIFFSetField(tif,TIFFTAG_IMAGEWIDTH,saveimage->xpix);
  TIFFSetField(tif,TIFFTAG_IMAGELENGTH,saveimage->ypix);
  TIFFSetField(tif,TIFFTAG_BITSPERSAMPLE,bitspersample);
  TIFFSetField(tif,TIFFTAG_SAMPLESPERPIXEL,samplesperpixel);
  TIFFSetField(tif,TIFFTAG_PLANARCONFIG,(unsigned short)PLANARCONFIG_CONTIG);

  TIFFSetField(tif,TIFFTAG_ROWSPERSTRIP,(unsigned long)8);
  TIFFSetField(tif,TIFFTAG_COMPRESSION,(unsigned short)compression);


  cmsembedprofile(saveimage,&iccdata,&icclen);
  if(iccdata)
  {
   TIFFSetField(tif,TIFFTAG_ICCPROFILE,icclen,iccdata);
  }

  err=tiffgeterror();
		if(!err)
		{
   if(saveimage->bpp<=8 && !bwimage)
   {
    unsigned short r[256];
    unsigned short g[256];
    unsigned short b[256];
    int            i;

    for(i=0;i<(1<<saveimage->bpp);i++)
    {
     r[i]=((saveimage->ipal.word[i]>> 8)&0xFF)*257;
     g[i]=((saveimage->ipal.word[i]>>16)&0xFF)*257;
     b[i]=((saveimage->ipal.word[i]>>24)&0xFF)*257;
    }

    TIFFSetField(tif,TIFFTAG_COLORMAP,r,g,b);
   }

   for(y=0;y<ypix;y++)
   {
    err=imfind1r(saveimage,y,&idata);
    if(err) break;

    q=(char*)idata;
    p=rowbuff;

    if(bpp==1) for(x=0;x<bytewidth;x++) *p++=bitrev[*q++];
    else
    if(bpp==2) for(x=0;x<bytewidth;x++) *p++=dbitrev[*q++];
    else
    if(bpp==4) for(x=0;x<bytewidth;x++) *p++=nybrev[*q++];
    else
    if(bpp==8) for(x=0;x<bytewidth;x++) *p++=*q++;
    else
    if(bpp==16)
    {
     for(x=0;x<xpix;x++)
     {
      w=*idata++;

      *p++=(char)((w<<3)&0xF8);
      *p++=(char)((w>>2)&0xF8);
      *p++=(char)((w>>7)&0xF8);

      x++;
      if(x>=xpix) break;

      *p++=(char)((w>>13)&0xF8);
      *p++=(char)((w>>18)&0xF8);
      *p++=(char)((w>>23)&0xF8);
     }
    }
    else
    if(bpp==24)
    {
     for(x=0;x<bytewidth;x++) *p++=*q++;
    }
    else
    if(bpp==32) 
    {
     if(samplesperpixel==4)
     {
      for(x=0;x<xpix;x++)
      {
       *p++=*q++;
       *p++=*q++;
       *p++=*q++;
       *p++=*q++;
      }
     }
     else
     {
      for(x=0;x<xpix;x++)
      {
       *p++=*q++;
       *p++=*q++;
       *p++=*q++;
       q++;
      }
     }
    }

    if(TIFFWriteScanline(tif,(unsigned char*)rowbuff,y,0)==-1)
    {
 				cprintf("write scan returns -1");
     break;
 			}
   }
		}
  TIFFClose(tif);
 }

 if(!err) err=tiffgeterror();
 if(!err) err=fs_settype(name,type);

 sfree((flex_ptr)&rowbuff);

 return(err);
}




static os_error * savetiff(char * name,int type)
{
 int        fn;
 imagestr * saveimage;

 fn=menuview->frame;
 saveimage=((menufile->frames[fn].xim)->sim[IM]);

 return(savetiffim(name,type,saveimage));
}



/*****************************************************************************/


static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}



static os_error * configloaded(int eventn,uservalue userhandle,
                                                        void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {

  dbl=ftypegetrun(&ftype); 
  
//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
  colour=tcolour;
		givewarnings=tgivewarnings;
  bw=tbw;
 }

 return(err);
}




static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}







static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,

			18,&tgivewarnings,DBTOGGLE, 0,   0,      1,  0,   0, 0,       NULL, NULL,

    6, &tcolour,     DBRADIO,  0,   0,COMPRESSION_LZW,F2,1,0,NULL,0,     
    7, &tcolour,     DBRADIO,  0,   0,COMPRESSION_PACKBITS,F3,1,0,NULL,0,
   12, &tcolour,     DBRADIO,  0,   0,COMPRESSION_NONE,F4,1,0,NULL,0,
				8,	&tcolour,     DBRADIO,  0,   0,COMPRESSION_DEFLATE,F4,1,0,NULL,0,

    3, &tbw,         DBRADIO2, 0,   0,COMPRESSION_CCITTFAX3,F5,2,0,NULL,0,
    4, &tbw,         DBRADIO2, 0,   0,COMPRESSION_CCITTFAX4,F6,2,0,NULL,0,
   11, &tbw,         DBRADIO2, 0,   0,COMPRESSION_CCITTRLE ,F7,2,0,NULL,0,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TTIFF,
 DBFIX,
 DBGRAB,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);

 tdbl=dbl;
 tbw=bw;
 tcolour=colour;
	tgivewarnings=givewarnings;

 err=dodboxparent(&configbox,1,parent);


 return(err);
}

/****************************************************************************/


static ftypestr ftype=
{
 TIFFTYPE,        /* file type */
 0,               /* flags     */
 loadtiff,        /* load      */
 loadfilepost,    /* loadpost  */
 "{TIFF}",        /* name      */
 "{TIFF}",        /* type name */
 savetiff,        /* save      */
 config,          /* configure */
 0,               /* icon      */
 bits,            /* bit flags */
 getframe,        /* get one frame */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,

 savetiffim,      /* saveim */
 "tif\0""tiff\0""ff0\0", /* extension */

 "TIFF (*.tif)",  /* description */
};




static contokstr coltoks[5]=
{
	"ZIP",COMPRESSION_DEFLATE,
 "LZW",COMPRESSION_LZW,
 "Packbits",COMPRESSION_PACKBITS,
 "None",COMPRESSION_NONE,
 NULL,0
};


static contokstr bwtoks[5]=
{
 "FAX3",COMPRESSION_CCITTFAX3,
 "FAX4",COMPRESSION_CCITTFAX4,
 "RLE",COMPRESSION_CCITTRLE,
 "None",0,
 NULL,0
};


static contag contable[4]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "Colour",CONTOK,&colour,coltoks,NULL,
 "BW",CONTOK,&bw,bwtoks,NULL,
	"Warnings",CONINT,&givewarnings,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "TIFF",
 NULL,
 NULL
};


os_error * tiffinit(void)
{
 os_error * err;

 err=registerfiletype(&ftype);

 if(!err)
 {
  TIFFSetErrorHandler(errorhandler);
  TIFFSetWarningHandler(warninghandler);

  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);
 }

 return(err);
}


