/*->c.target */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "bf.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "mlo.h"

#include "units.h"
#include "bits.h"
#include "conf.h"
#include "config.h"
#include "pane.h"
#include "colour.h"
#include "save.h"
#include "xmath.h"


#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewr.h"
#include "im.h"
#include "tools.h"


#include "target.h"



#define TSNLEN 12

#define TTMARK   0
#define TTSAMPLE 1

#define TSBLOCK  0
#define TSCIRCLE 1
#define TSLINE   2


typedef struct targetobjectstr
{
 int  type;

 char name[TSNLEN];

 int  shape;

 union
 {
  struct
  {
   int x;
   int y;
   int w;
   int h;

  } block;


  struct
  {
   int x;
   int y;
   int r;

  } circle;


  struct
  {
   int x0;
   int y0;
   int x1;
   int y1;

  } line;

 } data;

} targetobjectstr;


static targetobjectstr * targetobject;
static int               targetobjectn;

#define TARGETOBJECTCHUNK (16*sizeof(targetobjectstr))



#define TNLEN 24

typedef struct targetstr
{
 char name[TNLEN];
 int  startobject;
 int  endobject;


} targetstr;


static targetstr * target;
static int         targetn;

#define TARGETCHUNK (4*sizeof(targetstr))


static int currenttarget;
static int displaytarget;



/*****************************************************************************/





/* a token is a non space, followed by a space or zero */

static char * gettok(char * string,int * len)
{
 int    tlen;
 char * p;
 char * q;

 p=string;
 while(*p==' ') p++;
 q=p;
 while(*q>' ') q++;

 tlen=q-p;
 if(*q)
 {
  *q=0;
  tlen++;
 }

 *len=tlen;

 return(p);
}







os_error * targetredraw(viewredrawstr * v)
{
 os_error        * err;
 boxstr            sbox;
 targetstr       * t;
 targetobjectstr * to;
 int               tn;


 err=NULL;

 if(displaytarget)
 {
  seteorcol(WIMPWHITE,WIMPGREEN);

  t=&target[currenttarget];

  for(tn=t->startobject;tn<t->endobject;tn++)
  {
   to=&targetobject[tn];

   if(to->type==TTMARK)
   {
    switch(to->shape)
    {
     case TSBLOCK:
                  sbox.x=to->data.block.x;
                  sbox.y=to->data.block.y;
                  sbox.w=to->data.block.w;
                  sbox.h=to->data.block.h;
                  rbox(v,&sbox);
                  break;



     case TSCIRCLE:
                   sbox.x=to->data.circle.x;
                   sbox.y=to->data.circle.y;
                   sbox.w=to->data.circle.r;
                   sbox.h=to->data.circle.r;
                   rcircle(v,&sbox);
                   break;



     case   TSLINE:
                   sbox.x=to->data.line.x0;
                   sbox.y=to->data.line.y0;
                   sbox.w=to->data.line.x1-to->data.line.x0;
                   sbox.h=to->data.line.y1-to->data.line.y0;
                   rline(v,&sbox);
                   break;

    }
   }
  }
 }

 return(err);
}



static char * path="<HKEY_LOCAL_MACHINE\\Software\\DavidPilling\\DPScan\\>\\Targets";


os_error * targetinit(void)
{
 os_error  * err;
 int         eof;
 char        string[256];
 buffer      bf;
 char      * p;
 int         len;
 int         x;
 int         y;
 int         w;
 int         h;


  return(NULL);

          err=flex_alloc((flex_ptr)&target,TARGETCHUNK);
 if(!err) err=flex_alloc((flex_ptr)&targetobject,TARGETOBJECTCHUNK);

 if(!err) err=bf_open(path,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  eof=0;

  while(!eof)
  {
   err=bf_getstring(&bf,string,sizeof(string),&eof);
   if(err) break;

   p=gettok(string,&len);
   if(len)
   {
    if(strncmp(p,"//",2))
    {
     if(!cstrcmp(p,"block"))
     {
      p=gettok(p+len,&len);
      if(len && sscanf(p,"%d",&x)==1)
      {
       p=gettok(p+len,&len);
       if(len && sscanf(p,"%d",&y)==1)
       {
        p=gettok(p+len,&len);
        if(len && sscanf(p,"%d",&w)==1)
        {
         p=gettok(p+len,&len);
         if(len && sscanf(p,"%d",&h)==1)
         {
          err=flex_chunk((flex_ptr)&targetobject,
                       (targetobjectn+1)*sizeof(targetobjectstr),TARGETCHUNK);
          if(err) break;
          memset(targetobject+targetobjectn,0,sizeof(targetobjectstr));

          targetobject[targetobjectn].type=TTMARK;
          targetobject[targetobjectn].shape=TSBLOCK;
          targetobject[targetobjectn].data.block.x=x;
          targetobject[targetobjectn].data.block.y=y;
          targetobject[targetobjectn].data.block.w=w;
          targetobject[targetobjectn].data.block.h=h;

          targetobjectn++;
          target[targetn-1].endobject=targetobjectn;
         }
        }
       }
      }
     }
     else
     if(!cstrcmp(p,"circle")) 
     {
      p=gettok(p+len,&len);
      if(len && sscanf(p,"%d",&x)==1)
      {
       p=gettok(p+len,&len);
       if(len && sscanf(p,"%d",&y)==1)
       {
        p=gettok(p+len,&len);
        if(len && sscanf(p,"%d",&w)==1)
        {
         err=flex_chunk((flex_ptr)&targetobject,
                      (targetobjectn+1)*sizeof(targetobjectstr),TARGETCHUNK);
         if(err) break;
         memset(targetobject+targetobjectn,0,sizeof(targetobjectstr));

         targetobject[targetobjectn].type=TTMARK;
         targetobject[targetobjectn].shape=TSCIRCLE;
         targetobject[targetobjectn].data.circle.x=x;
         targetobject[targetobjectn].data.circle.y=y;
         targetobject[targetobjectn].data.circle.r=w;

         targetobjectn++;
         target[targetn-1].endobject=targetobjectn;
        }
       }
      }
     }
     else
     if(!cstrcmp(p,"line"))
     {
      p=gettok(p+len,&len);
      if(len && sscanf(p,"%d",&x)==1)
      {
       p=gettok(p+len,&len);
       if(len && sscanf(p,"%d",&y)==1)
       {
        p=gettok(p+len,&len);
        if(len && sscanf(p,"%d",&w)==1)
        {
         p=gettok(p+len,&len);
         if(len && sscanf(p,"%d",&h)==1)
         {
          err=flex_chunk((flex_ptr)&targetobject,
                       (targetobjectn+1)*sizeof(targetobjectstr),TARGETCHUNK);
          if(err) break;
          memset(targetobject+targetobjectn,0,sizeof(targetobjectstr));

          targetobject[targetobjectn].type=TTMARK;
          targetobject[targetobjectn].shape=TSLINE;
          targetobject[targetobjectn].data.line.x0=x;
          targetobject[targetobjectn].data.line.y0=y;
          targetobject[targetobjectn].data.line.x1=w;
          targetobject[targetobjectn].data.line.y1=h;

          targetobjectn++;
          target[targetn-1].endobject=targetobjectn;
         }
        }
       }
      }
     }
     else
     if(!cstrcmp(p,"target"))
     {
      p=gettok(p+len,&len);
      if(len)
      {
       err=flex_chunk((flex_ptr)&target,targetn*sizeof(targetstr),TARGETCHUNK);
       if(err) break;
       memset(target+targetn,0,sizeof(targetstr));
       strcpy(target[targetn].name,p);
       target[targetn].startobject=target[targetn].endobject=targetobjectn;
       targetn++;
      }
     }
     else
     if(!cstrcmp(p,"sample"))
     {
      p=gettok(p+len,&len);
      if(len)
      {
       targetobject[targetobjectn-1].type=TTSAMPLE;
       strcpy(targetobject[targetobjectn-1].name,p);
      }
     }
    }
   }
  }
  err=bf_close(&bf,err);
 }

 return(err);
}






os_error * targetsetup(void)
{
// setmenudynamic(MTARGET,0);

// setmenudynamic(MTARGET,2);

 tickmenust(MTARGET,1,displaytarget);

 return(NULL);
}





static os_error * targetlist(int * handle)
{
 os_error * err;
 int        i;

 err=NULL;

// err=createusermenu(NULL,NULL);
 if(!err)
 {
  for(i=0;i<targetn;i++)
  {
//   err=addusermenu(target[i].name,(i==currenttarget)?wimp_MTICK:0);
   if(err) break;
  }
 }

 if(!err) 
 {
//  *handle=(int)completeusermenu("Target");
//  mwpoint(menus[MTARGET].menuptr,0,*handle);
 }

 return(err);
}





static os_error * setuptargetlist(void)
{
 os_error * err;
 int        i;

 err=NULL;

 for(i=0;i<targetn;i++)
 {
//  tickmenust(usermenuindex,i,i==currenttarget);
 }

 return(err);
}





static int samplearea(viewstr * view,boxstr * sbox,boxstr * area)
{
 int        fn;
 filestr  * file;
 framestr * frame;
 imagestr * im;
 boxstr     box;

 file=view->file;

 if(!file->frames) return(1);

 fn=view->frame;

 frame=&file->frames[fn];
 if(!frame->xim) return(1);
 im=((frame->xim)->sim[IM]);

 box=*sbox;

 box.x-=im->tr.e;
 box.y-=im->tr.f;

 /* convert to pixels */

 box.x=(box.x*im->xdpi+35999)/72000;
 box.y=(box.y*im->ydpi+35999)/72000;
 box.w=(box.w*im->xdpi+35999)/72000;
 box.h=(box.h*im->ydpi+35999)/72000;

 /* clip to image */

 if(box.x>im->xpix)    return(1);
 if(box.y>im->ypix)    return(1);
 if((box.x+box.w)<0)   return(1);
 if((box.y+box.h)<0)   return(1);

 box.w=MIN(im->xpix,(box.x+box.w));
 box.x=MAX(0,box.x);
 box.w-=box.x;

 box.h=MIN(im->ypix,(box.y+box.h));
 box.y=MAX(0,box.y);
 box.h-=box.y;

 if(area) *area=box;

 return(0);
}






static os_error * getsample(boxstr * box,viewstr * view,
                                         int * r,int * g,int * b)
{
 os_error * err;
 boxstr     area;
 int        xlo;
 int        ylo;
 int        xhi;
 int        yhi;
 int        bpp;
 int        mask;
 int        y;
 int        x;
 int      * sdata;
 char     * sp;
 filestr  * file;
 framestr * frame;
 imagestr * im;
 int        fn;
 char       rtab[256];
 char       gtab[256];
 char       btab[256];
 int        rsum;
 int        gsum;
 int        bsum;
 int        nsample;
 int        shift;
 int        w;



 file=view->file;

 fn=view->frame;

 frame=&file->frames[fn];
 im=((frame->xim)->sim[IM]);

 bpp=im->bpp;
 mask=0;    /* compiler */


 rsum=gsum=bsum=0;
 nsample=1;


 if(!samplearea(view,box,&area))
 {
  ylo=area.y;
  yhi=area.y+area.h;
  xlo=area.x;
  xhi=area.x+area.w;

  nsample=(xhi-xlo)*(yhi-ylo);

  if(bpp<=8)
  {
   imsplitpalette(rtab,gtab,btab,im);

   if(bpp==1) mask=0x1;
   else
   if(bpp==2) mask=0x3;
   else
   if(bpp==4) mask=0xF;
   else       mask=0xFF;
  }

  for(y=ylo;y<yhi;y++)
  {
   err=imfind1w(im,y,&sdata);
   if(err) break;
   sp=(char*)sdata;

   switch(bpp)
   {
    case  1:
    case  2:
    case  4:
    case  8:
            sdata+=(xlo*bpp)/32;
            shift=(xlo*bpp)&0x1F;
            w=*sdata;
                                          /* clear 32-shift bits */
            for(x=xlo;x<xhi;x++)
            {
             rsum+=rtab[(w>>shift)&mask];
             gsum+=gtab[(w>>shift)&mask];
             bsum+=btab[(w>>shift)&mask];

             shift+=bpp;
             if(shift>=32)
             {
              w=*sdata;
              shift=0;
             }
            }

            break;


    case 24:
            sp+=3*xlo;

            for(x=xlo;x<xhi;x++)
            {
             rsum+=*sp++;
             gsum+=*sp++;
             bsum+=*sp++;
            }
            break;


   case 16:
           sdata+=(xlo*bpp)/32;
           shift=(xlo*bpp)&0x1F;
           w=*sdata;
                                          /* clear 32-shift bits */

           for(x=xlo;x<xhi;x++)
           {
            rsum+=(w>>shift)&0x1F;
            gsum+=(w>>(shift+5))&0x1F;
            bsum+=(w>>(shift+10))&0x1F;

            shift+=bpp;
            if(shift>=32)
            {
             w=*sdata;
             shift=0;
            }
           }
           break;



   case 32:
           sdata+=xlo;

           for(x=xlo;x<xhi;x++)
           {
            w=*sdata++;
            rsum+=w&0xFF;
            gsum+=(w>>8)&0xFF;
            bsum+=(w>>16)&0xFF;
           }
           break;

   }
  }
 }

 *r=scale(rsum,0x10000,(255*nsample));
 *g=scale(gsum,0x10000,(255*nsample));
 *b=scale(bsum,0x10000,(255*nsample));

 return(NULL);
}





static os_error * savetargetfn(char * name,int type)
{
 os_error        * err;
 buffer            bf;
 boxstr            sbox;
 targetstr       * t;
 targetobjectstr * to;
 int               tn;
 int               r;
 int               g;
 int               b;

 err=bf_open(name,'w',DEFBUFFSIZE,&bf);
 if(!err)
 {
  t=&target[currenttarget];

  bf_printf(&bf,"Target %s\n",t->name);

  for(tn=t->startobject;tn<t->endobject;tn++)
  {
   to=&targetobject[tn];

   if(to->type==TTSAMPLE)
   {
    switch(to->shape)
    {
     case TSBLOCK:
                  sbox.x=to->data.block.x;
                  sbox.y=to->data.block.y;
                  sbox.w=to->data.block.w;
                  sbox.h=to->data.block.h;
                  getsample(&sbox,menuview,&r,&g,&b);
                  bf_printf(&bf,"%s %f %f %f\n",to->name,(double)r/0x10000,
                                                         (double)g/0x10000,
                                                         (double)b/0x10000);
                  break;

    }
   }
  }

  bf_closec(&bf,err,name,type);
 }
 return(err);
}









os_error * targetdynamic(int * menu,int * handle)
{
 os_error * err;

 err=NULL;

 switch(menu[0])
 {
  case 0:
         targetlist(handle);
         break;

  case 2:
//         err=setsave("TargetData",TEXTFILE,savetargetfn,handle);
         break;
 }

 return(err);
}




os_error * targetdecode(int * menu)
{
 os_error * err;

 err=NULL;

 switch(menu[0])
 {
  case 0:        /* select target */
         currenttarget=menu[1];
         setuptargetlist();
         viewrefreshall();
         break;

  case 1:        /* display */
         displaytarget^=1;
         viewrefreshall();
         break;

  case 2:        /* save */
         break;

 }

 return(err);
}




