/*->h.str */



#define USEVM



typedef struct boxstr
{
 int x;
 int y;
 int w;
 int h;
} boxstr;



typedef struct aboxstr
{
 int x0;
 int y0;
 int x1;
 int y1;
} aboxstr;



typedef struct zoomstr
{
 int mul;
 int div;
} zoomstr;


typedef struct spanstr
{
 int xlo;
 int xhi;


} spanstr;



typedef struct
{
 int flags;
 int pause;
 int xmul;
 int xdiv;
 int ymul;
 int ydiv;
 int cx;
 int cy;
 int copies;

 int box0;             /* box to put image in, os units  */
 int box1;             /* 0,1 bottom left hand corner    */
 int box2;             /* 2,3 top right hand corner      */
 int box3;

 int height;           /* real height in 72000'ths */
 int width;            /* real width in 72000'ths  */
} pset;




typedef struct docdatastr
{
 int width;
 int height;
 int xres;
 int yres;




} docdatastr;



#define CL_RGB   0
#define CL_CMYK  1
#define CL_GREY  2
#define CL_ALPHA 3


typedef struct ipalstr
{
 int word[256];
 int ncolours;
 int palclass;

} ipalstr;



typedef struct improfilestr
{
 int index;
 int intent;
 int active;
 int proofing;
 int proofingindex;

} improfilestr;





typedef struct chunkstr
{
 int  * data;
 int    addr;             /* vm address  */

 struct chunkstr * prev;  /* lru queue   */
 struct chunkstr * next;

 unsigned int    modded:1;
 unsigned int    disc:1;           /* on disc ?   */

 int    size;
 int    uses;

 int    crc;

 int    x;
 int    y;
 int    z;

} chunkstr;


typedef struct imchunkstr
{
 chunkstr * chunk;
 int        width;           /* in bytes      */
 int        sl;              /* starting line */
 int        el;              /* end line +1   */
 int        size;

 int        x;
 int        y;
 int        z;

} imchunkstr;


typedef struct imagestr
{
 int               x;
 int               y;
 int               z;

 int               bpp;
 int               xpix;
 int               ypix;
 int               xdpi;
 int               ydpi;
 ipalstr           ipal;
 transformstr      tr;
 improfilestr      profile;

 int               wwidth;  /* width in words */

#ifdef USEVM
 int               imchunks;
 imchunkstr        imchunk[1];
#else
	char              data[4];

#endif


} imagestr;



#define IM 0
#define AL 1


typedef struct ximagestr
{
 struct ximagestr * xnext;
 struct ximagestr * xprev;

 struct ximagestr * redo;
 struct ximagestr * undo;

 imagestr         * sim[2];

} ximagestr;




typedef struct infostr
{
 char * text;
 int    n;
 wimp_w handle;
} infostr;



#define FRAMENAMELEN 32


typedef struct framestr
{
 int            offset;             /* offset in file of this image */
 char           name[FRAMENAMELEN];

 ximagestr    * xim;                /* stores raster form of frame */

 infostr        info;

 int            fbpp;               /* used for original values in file */
 int            mbpp;
 int            fxpix;              /* these values are not changed     */
 int            fypix;
 int            fxdpi;
 int            fydpi;

} framestr;



typedef struct viewdatastr
{
 int              rulers;
 zoomstr          zoom;               /* scale              */
 zoomstr          defzoom;            /* var zoom value 80% */
 int              zoomopt;            /* 50%, 200% etc.     */
 int              units;
 int              tools;
 int              infopal;
 int              printmargin;
 int              dither;

} viewdatastr;


#define FILELEAFMAX 256

#define VIEWNAMELEN 64


#define MAXZOOMS 16   /* power of 2 */
#define ZOOMMASK (MAXZOOMS-1)


typedef struct viewstr
{
 char             name[VIEWNAMELEN];
 struct filestr * file;
 wimp_w           handle;             /* main window handle for this view   */

 struct viewstr * next;               /* pointer to next view for this file */
 struct viewstr * prev;               /* pointer to prev view for this file */

 windowstr        window;             /* current window info */
 wimp_box         extent;             /* window extent       */

 viewdatastr      data;

 int              scalefactor;

 wimp_w           vruler;
 int              vshift;
 wimp_w           hruler;
 int              hshift;
 wimp_w           vpane;
 wimp_w           hpane;
 wimp_w           info;
 int              infoxshift;
 int              infoyshift;
 int              vpshift;
 int              hpshift;

 wimp_w           tools;
 int              toolsxshift;
 int              toolsyshift;

 int              frame;

 imagestr       * im;                 /* used to render image on screen */
 transformstr     tr;

 zoomstr          zoomstack[MAXZOOMS];
 int              zlast;
 int              zfirst;
 int              zcur;

} viewstr;



#define FILENAMELEN (MAX_PATH)


typedef struct filestr
{
 char             sname[FILENAMELEN];
 char             oname[FILENAMELEN];

 int              modded;             /* file modified ?       */

 struct filestr * next;               /* next file in chain    */
 struct filestr * prev;               /* prev file in chain    */

 viewstr        * view;               /* pointer to first view */
 int              viewn;              /* how many views        */

 int              framen;
 framestr       * frames;             /* array of frames       */
 void           * data;               /* array of private data for file type */
 pset             ps;
 int              width;
 int              height;
 int              type;

} filestr;






typedef struct viewredrawstr
{
 wimp_redrawstr redrawstr;
 viewstr      * view;
 filestr      * file;

/*                     Variables for redrawing pages                       */

 int xpo;              /* our coord for x page origin                      */
 int ypo;              /* our coord for y page origin                      */

 int xlo;              /* our coord for left of redraw                     */
 int xhi;              /* our coord for right of redraw                    */
 int ylo;              /* our coord for top of redraw                      */ 
 int yhi;              /* our coord for bot of redraw                      */
 int xps;              /* our coord for left of page                       */
 int xpe;              /* our coord for right of page                      */
 int yps;              /* our coord for top of page                        */
 int ype;              /* our coord for bot of page                        */
 int ox;               /* real OS coords of top left hand corner of window */
 int oy;
 int ylos;             /* ylo-yps */
 int yhis;             /* yhi-yps */
 int xlos;             /* xlo-xps */
 int xhis;             /* xhi-xps */

 int ylox; 
 int yhix;             /* limits on redraw in os units  */
 int xlox;
 int xhix;
 int yloz;
 int yhiz;             /* limits on redraw in our units */
 int xloz;
 int xhiz;

 int  layer;           /* layer to redraw              */
 int  isprinter;       /* going to printer             */

} viewredrawstr;


