
#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <math.h>
#include <time.h>



#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"
#include "bbc.h"
#include "alloc.h"


#include "osunits.h"
#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "filetype.h"
#include "fsx.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "mlo.h"
#include "units.h"
#include "redraw.h"
#include "colour.h"
#include "drag.h"
#include "xmath.h"
#include "config.h"
#include "pane.h"
#include "deb.h"
#include "save.h"
#include "load.h"
#include "getscreen.h"
#include "ram.h"


#include "resource.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewo.h"
#include "viewr.h"
#include "select.h"
#include "im.h"
#include "bm.h"
#include "fx.h"
#include "cmap.h"
#include "edit.h"
#include "resize.h"
#include "format.h"
#include "undo.h"
#include "long.h"
#include "filter.h"
#include "pal.h"

#include "area.h"

#include "snap.h"




extern dboxstr configbox;


static int showpointer;
static int doprocess;
static int snapmode;
static int doclipboard;
static int hotkey=CTRL_F7;
static int movepointer;
static int snapfill;

#define SNAPNOFILL 0
#define SNAPFILL   1


static resizestr rsz={0,1, 100,100,100,100, 96,96,96,96, 0};


static formatstr snapfs={0,8,FPOPT,0,0, 0,0,0,0};

#define SNAPWINDOW   0x0
#define SNAPCONTENTS 0x1
#define SNAPSCREEN   0x2
#define SNAPAREA     0x3


static os_error * dosnapscreen(void)
{
 os_error  * err;
 char      * pdib;
 int         length;
 imagestr  * sim;
 imagestr  * dim;
 ximagestr * sxim;
 ximagestr * xsxim;
 ximagestr * dxim;
 ximagestr * dxim2;
 int         xscale;
 int         yscale;
	wimp_wstate wstate;
 windowstr			window;
	mousestr    mouse;


	getospointer(&mouse);

	if(snapmode==SNAPCONTENTS)
	{
		wimp_get_wind_state(mouse.handle,&wstate);
  err=grabscreen(showpointer,wstate.o.box.x0,wstate.o.box.y0,wstate.o.box.x1,wstate.o.box.y1,&pdib,&length);
	}
 else
 if(snapmode==SNAPSCREEN)
 {
  err=grabscreen(showpointer,0,0,cvdu.screenx,cvdu.screeny,&pdib,&length);
 }
 else
 if(snapmode==SNAPAREA)
 {
  err=grabscreen(showpointer,xcoordpix2os(areax0),ycoordpix2os(areay0),xcoordpix2os(areax1),ycoordpix2os(areay1),&pdib,&length);
 }
	else
	{
		geto(mouse.handle,&window);
  err=grabscreen(showpointer,window.x0,window.y0,window.x1,window.y1,&pdib,&length);
	}


 if(!err)
 {
  cprintf("dib %x",pdib);

  err=ramnextreadfile(pdib,length);
 	if(!err)
 	{
            err=loaddocv("Screen Snap",DIB,(uservalue)menuview,1);
   if(!err) err=loaddocpostv((uservalue)menuview);

   ramreadoff();
  }
  sfree((flex_ptr)&pdib);

  if(doprocess)
  {
   sxim=menufile->frames[menuview->frame].xim;

   if(undosteps) ximcopy(sxim,&xsxim);
   else          xsxim=sxim;
 
   sim=(xsxim->sim[IM]);

   longprocstart(NULL,0,sim->ypix,menuview);

   err=viewdeleteimagefileframe(menufile,menuview->frame);

   reformatxim(xsxim,&dxim,&snapfs);

   rszcalcscale(&rsz,&xscale,&yscale);

   err=zoomxim(dxim,&dxim2,xscale,yscale);

   dim=(dxim2->sim[IM]);
 
   if(rsz.rsmode==RESAMPLE)
   {
    dim->xdpi=rsz.newxdpi;
    dim->ydpi=rsz.newydpi;
   }

   if(undosteps)
   {
    undolink(sxim,dxim2);
   }

   menufile->frames[menuview->frame].xim=dxim2;

   viewcreateimagefileframe(menufile,menuview->frame);

   refreshviewfileframe(menufile,menuview->frame);

   modifyview(menuview);
	 
//    if(palchange) modifypal(fview);

   longprocend();
  }

  if(doclipboard) cbcopy();
	}


 return(err);
}



static void snapz(uservalue userhandle)
{
	report(dosnapscreen());
 
 if(snapfill!=SNAPNOFILL && snapmode==SNAPAREA) 
 {
  closefillwindow();
 }

 USE(userhandle);
}




static os_error * snapfn(wimp_w handle,uservalue userhandle,int key)
{
	wimp_wstate wstate;
	mousestr    mouse;

	if(movepointer || (snapfill!=SNAPNOFILL && snapmode==SNAPAREA))
	{
  if(movepointer)
  {
	  getospointer(&mouse);
	 	wimp_get_wind_state(mouse.handle,&wstate);
	 	setmouse(wstate.o.box.x1,wstate.o.box.y0);
  }

  if(snapfill!=SNAPNOFILL && snapmode==SNAPAREA) 
  {
   openfillwindow((rback<<8)|(gback<<16)|(bback<<24));
  }
		
  addscheduledevent(snapz,0,20);
		return(NULL);
	}
	else
	{
	 return(dosnapscreen());
	}

	USE(handle);
	USE(userhandle);
	USE(key);
}


/**************************************************************************************/


extern dboxstr newkeybox;

static int thotkey;


static os_error * setmode(int newmode)
{
 if(newmode==SNAPAREA) return(openarea());
 else                  return(closearea());

}




static os_error * newkeyclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
		if(hotkey!=thotkey)
		{
   remhotkey(snapfn,configbox.handle,0,keycode2canonical(hotkey));
			hotkey=thotkey;
		 err=addhotkey(snapfn,configbox.handle,0,keycode2canonical(hotkey));
   dbchangevalue(&hotkey,&configbox);
		}
 }


 return(err);
}


static os_error * wrnewkeyname(int value,char * string)
{
 if(value>=0)
  strcpy(string,keylongstringcanonical(keycode2canonical(value)));
 else
  *string=0;

 return(NULL);
}


// we'd like to take TAB out too but there's no key press return from custom icon
// so you end up tabbing away with no way back

static os_error * newkeypress(wimp_w handle,uservalue userhandle,int icon,int * key)
{
	int ccode;

	if(*key==RETPRESS || *key==ESCPRESS) return(NULL);


	ccode=keycode2canonical(*key);

// cprintf("ccode %x %x",ccode,*key);

	if(ccode!=-1)
 {
  thotkey=*key;
  dbchangevalue(&thotkey,&newkeybox);
	}

 *key=-1;

 return(NULL);
 USE(handle);
 USE(userhandle);
 USE(icon);
}



static dbiconstr newkeyicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0, NULL ,0,
    3, &thotkey,     DBTEXT,   0,   0,     -1, -1, -1,  -1,NULL,wrnewkeyname,

   -1, NULL,         0,        0,   0,      0,  0,  0,  0,  0,      0
};


static dboxstr newkeybox=
{
 0,
 TNEWKEY,
 DBFIX,
 DBGRAB,
 newkeyclose,
 NULL,
 newkeypress,
 NULL,
 newkeyicondefs,
 0,
 0,
 0,NULL,
 0,0,
};


static os_error * newkey(wimp_w parent)
{
 os_error  * err;

	thotkey=hotkey;

 err=dodboxparent(&newkeybox,1,parent);

 return(err);
}







static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code!=DBAPPLY)
 {
  remhotkey(snapfn,configbox.handle,0,keycode2canonical(hotkey));
  closearea();
//		cprintf("rem hotkey");
 }

 return(err);
}




static os_error * predrawsub(wimp_w handle,wimp_redrawstr * redrawstr,int more)
{
 os_error * err;

 err=NULL;

 while(more)
 {
  redrawblock(redrawstr,handle,38,(rback<<8)|(gback<<16)|(bback<<24));
  err=wimp_get_rectangle(redrawstr,&more);
 }
 return(err);
}


static os_error * predraw(wimp_w handle,uservalue userhandle)
{
 os_error     * err;
 wimp_redrawstr redrawstr;
 int            more;
 redrawstr.w=handle;
 err=wimp_redraw_wind(&redrawstr,&more);
 if(!err) err=predrawsub(handle,&redrawstr,more);
 return(err);
 USE(userhandle);
}







static os_error * crszfn(resizestr * xrsz)
{
 rsz=*xrsz;
 dbchangevalue(&rsz.rsmode,&configbox);
 return(NULL);
}




static os_error * cfsfn(formatstr * xfsp)
{
 snapfs=*xfsp;
 dbchangevalue(&snapfs.fpal,&configbox);
 return(NULL);
}




static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 10:
          err=resizewindow(&rsz,crszfn,handle);
          break;

  case 15:
          err=formatwindow(&snapfs,cfsfn,handle);
          break;

		case	21:
										err=newkey(handle);
										break;
 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * optfn(int handle,uservalue userhandle,wimp_mousestr * m)
{
 return(setmode(snapmode));
 USE(handle);
 USE(userhandle);
 USE(m);
}




static os_error * wrf(int value,char * string)
{
 return(formatsummary(string,&snapfs));
 USE(value);
}



static os_error * wrsz(int value,char * string)
{
 return(resizesummary(&rsz,string));
 USE(value);
}




static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

//    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
//    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,

    9, &doprocess,   DBTOGGLE, 0,   0,      1, F1,  0, 0, NULL, 0,
    8, &showpointer, DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
   18, &doclipboard, DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
   16, &snapmode,    DBRADIO,  0,   0,SNAPWINDOW,F3,1, 0, (dbreadfn)optfn,0,
   19, &snapmode,    DBRADIO,  0,   0,SNAPCONTENTS,F3,1,0,(dbreadfn)optfn,0,
   23, &snapmode,    DBRADIO,  0,   0,SNAPSCREEN,F3,1,0,  (dbreadfn)optfn,0,
   24, &snapmode,    DBRADIO,  0,   0,SNAPAREA,F3,1,0,    (dbreadfn)optfn,0,
   14, &snapfs.fpal, DBTEXT,   0,   0,      0,  0,  0, 0, NULL,wrf,
   12, &rsz.rsmode,  DBTEXT,   0,   0,      0,  0,  0, 0, NULL,wrsz,
			20, &hotkey,      DBTEXT,   0,   0,      0,  0,  0, 0, NULL,wrnewkeyname,
			22, &movepointer, DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
   25, &snapfill,    DBTOGGLE, 0,   0,SNAPFILL, F2,  0, 0, NULL, 0, 
   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TSNAP,
 DBFIX,
 DBGRAB,
 configclose,
 configicon,
 NULL,
 predraw,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


os_error * snapscreen(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);

 err=dodboxparent(&configbox,1,parent);
	if(!err)
	{
//		cprintf("hot %x code %x",hotkey,keycode2canonical(hotkey));

		err=addhotkey(snapfn,configbox.handle,0,keycode2canonical(hotkey));

  setmode(snapmode);
	}

 return(err);
}





static contag contable[]=
{
 "Mode",CONINT,&snapmode,NULL,NULL,
 "Pointer",CONINT,&showpointer,NULL,NULL,
 "Move",CONINT,&movepointer,NULL,NULL,
 "Clip",CONINT,&doclipboard,NULL,NULL,
 "Process",CONINT,&doprocess,NULL,NULL,
 "Hotkey",CONINT,&hotkey,NULL,NULL,

 "Bpp",CONINT,&snapfs.fbpp,NULL,NULL,
 "Palette",CONINT,&snapfs.fpal,NULL,NULL,
 "Dither",CONINT,&snapfs.fdith,NULL,NULL,
 "Simple",CONINT,&snapfs.fssimple,NULL,NULL,
 "ZigZag",CONINT,&snapfs.fszigzag,NULL,NULL,
 "Exact",CONINT,&snapfs.fsexact,NULL,NULL,

 "Resize",CONINT,&rsz.rsmode,NULL,NULL,
 "Width",CONINT,&rsz.neww,NULL,NULL,
 "Height",CONINT,&rsz.newh,NULL,NULL,
 "XRes",CONINT,&rsz.newxdpi,NULL,NULL,
 "YRes",CONINT,&rsz.newydpi,NULL,NULL,
 "Aspect",CONINT,&rsz.lockar,NULL,NULL,
 "ResizeBy",CONINT,&rsz.rsby,NULL,NULL,
// "YResize",CONINT,&rsz.resizebyy,NULL,NULL,

 NULL,0,NULL,NULL,NULL
};





static conlink configlink=
{
 "Snap",
 NULL,
 NULL
};


os_error * snapinit(void)
{
	os_error * err;

 err=addcontable(contable,&configlink);

	return(err);
}


