/*->c.select */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "bbc.h"
#include "transform.h"

#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "colour.h"
#include "drag.h"
#include "key.h"
#include "deb.h"
#include "dbhi.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"

#include "viewo.h"
#include "viewr.h"
#include "view.h"

#include "undo.h"
#include "tw.h"

#include "tools.h"


#include "select.h"


static viewstr * sview;
static filestr * sfile;

static viewstr * lsview;     /* last view select tool chosen on */


       int    selection;
static int    sdrag;
       boxstr sbox;


static int    hlock;
static int    vlock;
static int    slock;





#define SELSUB 20


/* generate sub box given number and frame curve */

static void setsubbox(boxstr * c,viewstr * view)
{
 int      dim;

 dim=ourunits(SELSUB,view);
 c->w=dim;
 c->h=dim;
}


static void getsubbox(int tag,boxstr * f,boxstr * c)
{
 switch(tag)
 {
  case 0:     /* init */
  case 1:     /* top left */
         c->x=f->x-c->w/2;
         c->y=f->y-c->h/2;
         break;

  case 2:    /* top mid */
         c->x=f->x+f->w/2-c->w/2;
         break;

  case 3:    /* top right */
         c->x=f->x+f->w-c->w/2;
         break;

  case 4:    /* right mid */
         c->y=f->y+f->h/2-c->h/2;
         break;

  case 5:    /* bottom right */
         c->y=f->y+f->h-c->h/2;
         break;

  case 6:    /* bottom mid */
         c->x=f->x+f->w/2-c->w/2;
         break;

  case 7:    /* bottom left */
         c->x=f->x-c->w/2;
         break;

  case 8:    /* left mid */
         c->y=f->y+f->h/2-c->h/2;
         break;
 }
}


int insidebox(int x,int y,boxstr * box)
{
 return(
        x>=box->x &&
        x<=(box->x+box->w) &&
        y>=box->y &&
        y<=(box->y+box->h)
       );
}


/* see if the position is over one of the box handles */

static int findboxhandle(viewstr * view,wimp_mousestr * m)
{
 int          j;
 boxstr       c;
 int          x;
 int          y;
 windowstr    window;

 if(selection && view==sview)
 {
  setsubbox(&c,view);

  getw(view->handle,&window);

  x=ourunits(m->x-window.bx,view);
  y=ourunits(window.by-m->y,view);

  for(j=1;j<9;j++)
  {
   getsubbox(j,&sbox,&c);

   if(insidebox(x,y,&c))
   {
    return(j);
   }
  }

  if(insidebox(x,y,&sbox)) return(0);

 }

 return(-1);
}





static int sdrgx;
static int sdrgy;
static int sorgx;
static int sorgy;
static int scx;
static int scy;
static int omx;
static int omy;


static void supdatebox(void)
{
 wimp_box      box;

 box.x0=osunits(sbox.x,sview)-SELSUB/2-cvdu.extrax;
 box.x1=osunits(sbox.x+sbox.w,sview)+SELSUB/2+cvdu.extrax;
 box.y1=-osunits(sbox.y,sview)+SELSUB/2+cvdu.extray;
 box.y0=-osunits(sbox.y+sbox.h,sview)-SELSUB/2-cvdu.extray;

 viewupdatelayer(sfile,&box,VRSELECT);
}


static os_error * sdragzero(wimp_w handle,uservalue userhandle,wimp_mousestr * mstr)
{
// wimp_mousestr mstr;
 windowstr     window;
 int           scroll;

// wimp_get_point_info(&mstr);
 getw(sview->handle,&window);

 scroll=autoscroll(sview,mstr,vlock,hlock);

 if(mstr->x!=omx || mstr->y!=omy || scroll)
 {
  supdatebox();

  scx=ourunits(mstr->x-window.bx,sview);
  scy=-ourunits(mstr->y-window.by,sview);

  if(hlock)
  {
   sbox.x=MIN(scx,sdrgx);
   sbox.w=ABS(scx-sdrgx);
  }
  else
  if(vlock)
  {
   sbox.y=MIN(scy,sdrgy);
   sbox.h=ABS(scy-sdrgy);
  }
  else
  if(slock)
  {
   sbox.x=sorgx+(scx-sdrgx);
   sbox.y=sorgy+(scy-sdrgy);
  }
  else
  {
   sbox.x=MIN(scx,sdrgx);
   sbox.y=MIN(scy,sdrgy);
   sbox.w=ABS(scx-sdrgx);
   sbox.h=ABS(scy-sdrgy);
  }

  sfill(sview,sfile);

  supdatebox();

  omx=mstr->x;
  omy=mstr->y;
 }

 return(NULL);

 USE(userhandle);
 USE(handle);
}


static os_error * sdragfn(wimp_w handle,uservalue userhandle,wimp_box * box)
{
// remzeroevent(sdragzero,0);
 supdatebox();
 sdrag=0;
 selection=1;
 supdatebox();
 lsview=sview;

 return(NULL);

 USE(handle);
 USE(userhandle);
 USE(box);
}



static os_error * sstartdrag(viewstr * view,wimp_w handle,wimp_mousestr * m)
{
 windowstr window;

 cprintf("sstartdrag");

 hlock=vlock=slock=0;

 sview=view;
 sfile=sview->file;

 getw(handle,&window);

 scx=sdrgx=ourunits(m->x-window.bx,view);
 scy=sdrgy=-ourunits(m->y-window.by,view);

 startdrag2(handle,0,sdragfn,sdragzero);
 userdrag(handle,window.x0,window.y0,window.x1,window.y1);
// addzeroevent(sdragzero,0);
 sdrag=1;
 omx=omy=-1;

 sbox.x=MIN(scx,sdrgx);
 sbox.y=MIN(scy,sdrgy);
 sbox.w=ABS(scx-sdrgx);
 sbox.h=ABS(scy-sdrgy);

 sfill(sview,sfile);

 supdatebox();

 return(NULL);
}


static void clearselection(void)
{
 cprintf("clr selection %d",selection);

 if(selection)
 {
  supdatebox();
  selection=0;
 }
}


static os_error * sstartsubdrag(viewstr * view,wimp_w handle,
                                                   wimp_mousestr * m,int sub)
{
 windowstr window;

 cprintf("startsubdrag");

 hlock=vlock=slock=0;

 sview=view;
 sfile=sview->file;

 getw(handle,&window);

 scx=ourunits(m->x-window.bx,view);
 scy=-ourunits(m->y-window.by,view);

 switch(sub)
 {
  case 0:
         sdrgx=scx;
         sdrgy=scy;
         sorgx=sbox.x;
         sorgy=sbox.y;
         slock=1;
         break;

  case 1:     /* top left */
         sdrgx=sbox.x+sbox.w;
         sdrgy=sbox.y+sbox.h;
         break;

  case 2:    /* top mid */
         vlock=1;
         sdrgy=sbox.y+sbox.h;
         break;

  case 3:    /* top right */
         sdrgx=sbox.x;
         sdrgy=sbox.y+sbox.h;
         break;

  case 4:    /* right mid */
         hlock=1;
         sdrgx=sbox.x;
         break;

  case 5:    /* bottom right */
         sdrgx=sbox.x;
         sdrgy=sbox.y;
         break;

  case 6:    /* bottom mid */
         vlock=1;
         sdrgy=sbox.y;
         break;

  case 7:    /* bottom left */
         sdrgy=sbox.y;
         sdrgx=sbox.x+sbox.w;
         break;

  case 8:    /* left mid */
         hlock=1;
         sdrgx=sbox.x+sbox.w;
         break;
 }

 clearselection();

 startdrag2(handle,0,sdragfn,sdragzero);

 if(hlock) userdrag(handle,window.x0,m->y,window.x1,m->y);
 else
 if(vlock) userdrag(handle,m->x,window.y0,m->x,window.y1);
 else      userdrag(handle,window.x0,window.y0,window.x1,window.y1);

// addzeroevent(sdragzero,0);
 sdrag=1;
 omx=omy=-1;

 if(hlock)
 {
  sbox.x=MIN(scx,sdrgx);
  sbox.w=ABS(scx-sdrgx);
 }
 else
 if(vlock)
 {
  sbox.y=MIN(scy,sdrgy);
  sbox.h=ABS(scy-sdrgy);
 }
 else
 if(!slock)
 {
  sbox.x=MIN(scx,sdrgx);
  sbox.y=MIN(scy,sdrgy);
  sbox.w=ABS(scx-sdrgx);
  sbox.h=ABS(scy-sdrgy);
 }

 supdatebox();

 return(NULL);
}

/*****************************************************************************/

os_error * sredraw(viewredrawstr * v)
{
 os_error * err;
 boxstr     c;
 int        j;

 err=NULL;

 if((selection||sdrag) && sfile==v->file)
 {
  seteorcol(WIMPWHITE,WIMPRED);
  rbox(v,&sbox);
  if(selection)
  {
   setsubbox(&c,sview);
   for(j=1;j<9;j++)
   {
    getsubbox(j,&sbox,&c);
    rbox(v,&c);
   }
  }
 }

 return(err);
}


void sselect(int select,viewstr * view)
{
 if(!select) 
 {
  if(selection)
  {
   lsview=view;
   clearselection();
  }
 }
 else                             /* select */
 if(!selection)
 {
  if(view==lsview)
  {
   selection=1;
   supdatebox();
  }
 }
}


os_error * sfill(viewstr * view,filestr * file)
{
 wimp_w     handle;
 int        fn;

 handle=view->info;
 if(handle)
 {
  if(selection || sdrag)
  {
   writeiconc(handle,5,viewunitstostring(sbox.x,view,1));
   writeiconc(handle,7,viewunitstostring(sbox.y,view,0));
   writeiconc(handle,3,viewunitstostring(sbox.w,view,1));
   writeiconc(handle,8,viewunitstostring(sbox.h,view,0));
  }
  else
  {
   writeiconc(handle,5,"");
   writeiconc(handle,7,"");
   writeiconc(handle,3,"");
   writeiconc(handle,8,"");
  }

  if(file->framen)
  {
   fn=view->frame;
   writeiconfc(handle,17,"%d",fn+1);
   writeiconfc(handle,18,"/%d",file->framen);
  }
  else
  {
   writeicon(handle,17,"0");
   writeicon(handle,18,"/0");
  }


  selectst(handle,21,view->data.dither);
 }

 return(NULL);
}




os_error * sviewkey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 USE(handle);
 USE(userhandle);
 USE(icon);
 USE(key);

 return(NULL);
}



os_error * sviewicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;
 viewstr  * view;
 filestr  * file;
 int        boxhandle;

 err=NULL;

 view=(viewstr*)userhandle;
 file=view->file;

 if(m->bbits==VBDRAGA)
 {
  if((boxhandle=findboxhandle(view,m))>=0)
  {
   err=sstartsubdrag(view,handle,m,boxhandle);
  }
 }
 else
 if(m->bbits==VBCLICKS)
 {
  if((boxhandle=findboxhandle(view,m))>=0)
  {

  }
  else
  {
   clearselection();
   lsview=NULL;
  }
 }
 else
 if(m->bbits==VBDRAGS)
 {
  if((boxhandle=findboxhandle(view,m))>=0)
  {
   err=sstartsubdrag(view,handle,m,boxhandle);
  }
  else
  {
   err=sstartdrag(view,handle,m);
  }
 }

 return(err);

 USE(handle);
 USE(userhandle);
 USE(m);
}


/*****************************************************************************/


static os_error * grabvalues(wimp_w handle,uservalue userhandle)
{
 os_error * err;
 char     * p;
 int        x=0;
 int        y=0;
 int        w=0;
 int        h=0;
 int        f=0;
 int        fn;

 err=NULL;

 sview=(viewstr*)userhandle;
 sfile=sview->file;

          err=iconaddr(handle,5,&p);
 if(!err) err=viewstringtounits(p,&x,sview,1);
 if(!err) err=iconaddr(handle,7,&p);
 if(!err) err=viewstringtounits(p,&y,sview,0);
 if(!err) err=iconaddr(handle,3,&p);
 if(!err) err=viewstringtounits(p,&w,sview,1);
 if(!err) err=iconaddr(handle,8,&p);
 if(!err) err=viewstringtounits(p,&h,sview,0);
 if(!err) err=iconaddr(handle,17,&p);
 if(!err) sscanf(p,"%d",&f);


 if(!err)
 {
  fn=sview->frame;
  if(sfile->framen)
  {
   if(f!=(fn+1)) /* goto page */
   {
    err=gotoframe(sview,sfile,f-1); /* implicit fill */
   }
  }
 }


 if(!err)
 {
  if(!selection || x!=sbox.x || y!=sbox.y || w!=sbox.w || h!=sbox.h)
  {
   clearselection();

   sbox.x=x;
   sbox.y=y;
   sbox.w=w;
   sbox.h=h;

   selection=1;
   supdatebox();
   sfill(sview,sfile);
   lsview=sview;
  }
 }
 return(err);
}


              /* N L R D U */

static char entryiclst[5][5]=
{
          5,          0,           0,           7,            0,
          7,          0,           0,           3,            5,
          3,          0,           0,           8,            7,
          8,          0,           0,          17,            3, 
         17,          0,           0,           0,            8,
};



os_error * skey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 os_error * err;
 int        cicon;
 int        j;
 int        ch;

 err=NULL;
 ch=*key;

 switch(ch)
 {
       case 27:
               break;

   case RETURN:
               err=grabvalues(handle,userhandle);
               break;

    case 0x18E:
    case 0x18F:
    case 0x19C:
    case 0x19D:
    case 0x19E:
    case 0x19F:
               ch&=0x18F;
               for(j=0;j<4;j++) if(entryiclst[j][0]==icon) break;
               cicon=entryiclst[j][(ch-0x18B)];
               if(cicon)
               {
                iecarrot(handle,cicon);
               }
               break;

       default:
               return(NULL);
 }
 *key=-1;

 return(err);

 USE(userhandle);
}





/*****************************************************************************/

os_error * sicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;
 viewstr  * view;
 filestr  * file;

 view=(viewstr*)userhandle;
 file=view->file;


 err=NULL;

 switch(m->i)
 {
  case 21:
          selectst(handle,21,view->data.dither^=1);
          err=viewdeleteimage(view,file);
          viewcreateimage(view,file);
          sfill(view,file);
          refreshview(view);
          break;


  case 19: /* up */
  case 20: /* down */
          if(m->bbits==VBCLICKS)
          {
           if(m->i==19) err=nextframe();
           else         err=prevframe();
          }
          else
          if(m->bbits==VBCLICKA)
          {
           if(m->i==20) err=nextframe();
           else         err=prevframe();
          }
          break;


  case 12: /* undo */
          err=imageundo();
          break;

  case 13: /* redo */
          err=imageredo();
          break;

  case 14: /* acquire */
          err=twainacquire();
          break;

 }

 return(err);

 USE(handle);
 USE(userhandle);
 USE(m);
}


/**************************************************************************/


static os_error * closevent(int eventn,wimp_w userhandle,void * data,int data1)
{
 viewstr * view;

 if(eventn==EVENT_VCLOSE)
 {
  view=(viewstr*)data;

  if(view==lsview)
  {
   lsview=NULL;
  }
 }

 return(NULL);

 USE(userhandle);
 USE(data1);
}



os_error * sinit(void)
{
 addevent(EVENT_VCLOSE,closevent,0);

 return(NULL);
}


/*****************************************************************************/

/* return 0 if there is a good area set up */

int croparea(viewstr * view,boxstr * area)
{
 int        fn;
 filestr  * file;
 framestr * frame;
 imagestr * im;
 boxstr     box;

 file=view->file;

 if(!selection) return(1);
 if(sfile!=file) return(1);
 if(!file->frames) return(1);

 fn=view->frame;

 frame=&file->frames[fn];
 if(!frame->xim) return(1);
 im=((frame->xim)->sim[IM]);

 box=sbox;

 box.x-=im->tr.e;
 box.y-=im->tr.f;

 /* convert to pixels */

 box.x=(box.x*im->xdpi+35999)/72000;
 box.y=(box.y*im->ydpi+35999)/72000;
 box.w=(box.w*im->xdpi+35999)/72000;
 box.h=(box.h*im->ydpi+35999)/72000;

 /* clip to image */

 if(box.x>im->xpix)    return(1);
 if(box.y>im->ypix)    return(1);
 if((box.x+box.w)<0)   return(1);
 if((box.y+box.h)<0)   return(1);

 box.w=MIN(im->xpix,(box.x+box.w));
 box.x=MAX(0,box.x);
 box.w-=box.x;

 box.h=MIN(im->ypix,(box.y+box.h));
 box.y=MAX(0,box.y);
 box.h-=box.y;

 if(area) *area=box;


/* dprintf(0,"crop area x=%d y=%d w=%d h=%d",
       box.x,box.y,box.w,box.h); */


 return(0);
}



/* return 0 if there is a good area set up */

int extendarea(viewstr * view,boxstr * area)
{
 int        fn;
 filestr  * file;
 framestr * frame;
 imagestr * im;
 boxstr     box;

 file=view->file;

 if(!selection) return(1);
 if(sfile!=file) return(1);
 if(!file->frames) return(1);

 fn=view->frame;

 frame=&file->frames[fn];
 if(!frame->xim) return(1);
 im=((frame->xim)->sim[IM]);

 box=sbox;

 box.x-=im->tr.e;
 box.y-=im->tr.f;

 /* convert to pixels */

 box.x=(box.x*im->xdpi+35999)/72000;
 box.y=(box.y*im->ydpi+35999)/72000;
 box.w=(box.w*im->xdpi+35999)/72000;
 box.h=(box.h*im->ydpi+35999)/72000;


 if(box.x>im->xpix) return(1);
 if(box.y>im->ypix) return(1);
 if((box.x+box.w)<0)   return(1);
 if((box.y+box.h)<0)   return(1);

 box.w=MAX(im->xpix,(box.x+box.w));
 box.x=MIN(0,box.x);
 box.w-=box.x;

 box.h=MAX(im->ypix,(box.y+box.h));
 box.y=MIN(0,box.y);
 box.h-=box.y;

 if(area) *area=box;

/* dprintf(0,"crop area x=%d y=%d w=%d h=%d",
       box.x,box.y,box.w,box.h); */

 return(0);
}


