/*->c.rulers */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "bbc.h"
#include "sprite.h"
#include "font.h"
#include "transform.h"

#include "err.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "colour.h"
#include "deb.h"
#include "osunits.h"
#include "dbhi.h"
#include "etc.h"

#include "str.h"
#include "constants.h"
#include "reslink.h"
#include "file.h"
#include "units.h"

#include "viewo.h"
#include "viewr.h"
#include "view.h"

#include "rulers.h"





#define HMARGIN   (xpix2os(xos2pix(48)))
#define VMARGIN   (ypix2os(yos2pix(48)))



/* size of steps on rulers */

int hsteps[4][3] ={ /* mm         in      pts                      */
                    8*720000/254,18000,  10000, /* zone 0 25 -49%  */
                    4*720000/254, 9000,   5000, /* zone 1 50 -100% */
                    2*720000/254, 9000,   5000, /* zone 2 100-149% */
                    1*720000/254, 4500,   2500  /* zone 3 150-   % */


                  };
     
int hbsteps[4][3]={
                    5,            8,      10,   /* zone 0 25 -49%  */
                    5,            8,      10,   /* zone 1 50 -100% */
                    5,            8,      10,   /* zone 2 100-149% */
                   10,           16,      10    /* zone 3 150-   % */
                  };


int ubsteps[4][3]={
                   40,            2,     100,   /* zone 0 25 -49%  */
                   20,            1,      50,   /* zone 1 50 -100% */
                   10,            1,      50,   /* zone 2 100-149% */
                   10,            1,      25    /* zone 3 150-   % */
                  };



/* we are prepared to have markings every 1,2,5 pix         */
/* or multiples thereof                                     */
/* we will have big steps of 10,10,10                       */
/* and inc units by 10,20,50                                */
/* we insist that 1 unit occupy at least 12 OS units screen */


static void getpixsteps(viewstr * view,int h,int * hstep,
                                             int * hbstep,int * ubstep)
{
 filestr  * file;
 int        dpi;
 framestr * frame;
 imagestr * im;
 int        factor;
 int        ospp;
 int        fn;


 file=view->file;
 dpi=90;

 if(file->framen && file->frames)
 {
  fn=view->frame;

  frame=&file->frames[fn];
  im=((frame->xim)->sim[IM]);

  if(h) dpi=im->xdpi;
  else  dpi=im->ydpi;
 }

 /* find os units per pixel */

 ospp=scale(dpi,view->data.zoom.div,view->data.zoom.mul);
 ospp=scale(1,180*0x10000,ospp);  /* os unit per pixel * 0x10000 */


 factor=1;

 while(ospp<(12*0x10000))
 {
  ospp*=10;
  factor*=10;
 }

 /* inc x 10 until you get between 12 & 120 os units per chunk of pixels */

 if(ospp>(5*12*0x10000)) 
 {
  factor/=5;
  *hstep=scale(factor,72000,dpi);
  *ubstep=10*factor;
 }
 else
 if(ospp>(2*12*0x10000)) 
 {
  factor/=2;
  *hstep=scale(factor,72000,dpi);
  *ubstep=10*factor;
 }
 else
 {
  *hstep=scale(factor,72000,dpi);
  *ubstep=10*factor;
 }

 *hbstep=10;
}




/* return the marking zone for current zone */

int mzone(viewstr * view)
{
 int p;

 p=100*view->data.zoom.mul;
 p/=view->data.zoom.div;
 if(p<50)  p=0;
 else
 if(p<100) p=1;
 else
 if(p<150) p=2;
 else
           p=3;

 return(p);
}






static font rulerfonthandle;
static int rulerlead;


os_error * rulerfontstart(void)
{
 os_error    * err;
 font_metric   metric;

 err=font_find("Arial",5*16,5*16,0,0,&rulerfonthandle);
 font_setfont(rulerfonthandle);

 font_getmetric(&metric);

 rulerlead=metric.height-metric.ascent;

 return(err);
}


void rulerfontend(void)
{
 if(rulerfonthandle)
 {
  font_lose(rulerfonthandle);
  rulerfonthandle=0;
 }
}




void rulerprint(int n,int x,int y,int justify)
{
 char      string[8];

 if(n<0) n=-n;

 sprintf(string,"%d",n % 1000);

 if(justify & 1) /* right */
 {
  font_align(FA_RIGHT);
 }
 else
 if(justify & 2) /* centre */
 {
  font_align(FA_CENTRE);
 }
 else
 {
  font_align(FA_LEFT);
 }

 font_paint(string,font_ABS|font_OSCOORDS,x,y+rulerlead);
}



/*****************************************************************************/
                  /***** redraw vertical ruler *****/


static os_error * redrawvruler(wimp_w handle,uservalue userhandle)
{
 os_error       * err;
 viewredrawstr    v;
 int              more;
 int              u;
 int              y;
 int              n;
 int              mz;
 int              nmax;
 int              measure;

 int              hstep;
 int              hbstep;
 int              ubstep;

 viewstr *        view;
 filestr *        file;

 view=(viewstr*)userhandle;
 file=view->file;

 measure=view->data.units;

 if(measure==PIXELS)
 {
  getpixsteps(view,0,&hstep,&hbstep,&ubstep);
 }
 else
 {
  measure--;
  hstep=hsteps[mz=mzone(view)][measure];
  hbstep=hbsteps[mz][measure];
  ubstep=ubsteps[mz][measure];
 }


 v.redrawstr.w=handle;

 err=wimp_redraw_wind(&v.redrawstr,&more);
 if(!err && more)
 {
  rulerfontstart();

  while(more)
  {
   v.view=view;
   v.file=file;

   v.ox=v.redrawstr.box.x0-v.redrawstr.scx;
   v.oy=v.redrawstr.box.y1-v.redrawstr.scy;

   v.ylox=-(v.redrawstr.g.y1-v.oy);
   v.yhix=-(v.redrawstr.g.y0-v.oy);
   v.xlox=v.redrawstr.g.x0-v.ox;
   v.xhix=v.redrawstr.g.x1-v.ox;

   setcoords(&v);
                             
   if(!(v.xps>v.xhiz || v.xpe<v.xloz || v.yps>v.yhiz || v.ype<v.yloz))
   {  
    nmax=(v.ype-v.yps)/(hstep*hbstep);
    n=(v.yhi-v.yps)/(hstep*hbstep);
    if(n<nmax) v.yhi=v.yps+(n+1)*hstep*hbstep; 
    nmax*=ubstep;

    n=(v.ylo-v.yps)/(hstep*hbstep);
    if(n>0)
    {
     n-=1;
     v.ylo=v.yps+n*hstep*hbstep;
    }
    else    v.ylo=v.yps;
    u=0;
    n*=ubstep;

    for(y=v.ylo;y<=v.yhi+hstep;y+=hstep)
    {
     wimp_setcolour(WIMPBLACK);

     if(u==0) bbc_move(v.ox,v.oy-osunits(y,view));
     else     bbc_move(v.ox+3*(VMARGIN >> 2),v.oy-osunits(y,view));
     bbc_draw(v.ox+VMARGIN,v.oy-osunits(y,view)); 

     if(u==0)
     {
      /* centre number on this mark and above */
      if(n) rulerprint(n,v.ox,v.oy-osunits(y,view),0);
      n+=ubstep;
     }

     if(++u==hbstep) u=0;
    }
   }


//  if(v.yhi>=v.yhiz) break;  /* there isn't going to be another page */

   wimp_get_rectangle(&v.redrawstr,&more);
  }

  rulerfontend();
 }

 return(err);
}


/*****************************************************************************/
                  /***** redraw horizontal ruler *****/

static os_error * redrawhruler(wimp_w handle,uservalue userhandle)
{
 os_error       * err;
 viewredrawstr    v;
 int              more;
 int              u;
 int              x;
 int              n;
 int              mz;
 int              nmax;
 int              measure;
 int              hstep;
 int              hbstep;
 int              ubstep;

 viewstr *        view;
 filestr *        file;

 view=(viewstr*)userhandle;
 file=view->file;

 measure=view->data.units;

 if(measure==PIXELS)
 {
  getpixsteps(view,1,&hstep,&hbstep,&ubstep);
 }
 else
 {
  measure--;
  hstep =hsteps[mz=mzone(view)][measure];
  hbstep=hbsteps[mz][measure];
  ubstep=ubsteps[mz][measure];
 }

 v.redrawstr.w=handle;

 err=wimp_redraw_wind(&v.redrawstr,&more);
 if(!err && more)
 {
  rulerfontstart();
  while(more)
  {
   v.view=view;
   v.file=file;

   v.ox=v.redrawstr.box.x0-v.redrawstr.scx;
   v.oy=v.redrawstr.box.y1-v.redrawstr.scy;


   v.ylox=-(v.redrawstr.g.y1-v.oy);
   v.yhix=-(v.redrawstr.g.y0-v.oy);
   v.xlox=v.redrawstr.g.x0-v.ox;
   v.xhix=v.redrawstr.g.x1-v.ox;

   setcoords(&v);

   nmax=(v.xpe-v.xps)/(hstep*hbstep);
   n=(v.xhi-v.xps)/(hstep*hbstep);
   if(n<nmax) v.xhi=v.xps+(n+1)*hstep*hbstep;
   nmax*=ubstep;

   n=(v.xlo-v.xps)/(hstep*hbstep);
   v.xlo=v.xps+n*hstep*hbstep;
   u=0;
   n*=ubstep;

   wimp_setcolour(WIMPBLACK);

   for(x=v.xlo;x<=v.xhi;x+=hstep)
   {
    if(u==0)
    bbc_move(v.ox+osunits(x,view),v.oy);
    else
    bbc_move(v.ox+osunits(x,view),v.oy-(3*(HMARGIN >> 2)));
    bbc_draw(v.ox+osunits(x,view),v.oy-(HMARGIN));

    if(u==0)
    {
     /* centre number on this mark and above */
     rulerprint(n,v.ox+osunits(x,view),v.oy-3*(HMARGIN >> 2),1);
     n+=ubstep;
    }

    if(++u==hbstep) u=0;

   }
   wimp_get_rectangle(&v.redrawstr,&more);
  }
  rulerfontend();
 }

 return(err);
}


/*****************************************************************************/

os_error * refreshrulers(viewstr * view,filestr * file)
{
 os_error * err;

 if(view->data.rulers)
 {
  err=refreshwindow(view->vruler);
  if(!err) err=refreshwindow(view->hruler);
 }
 else err=NULL;

 return(err);
 USE(file);
}



os_error * refreshrulersu(viewstr * view)
{
 if(view->data.rulers && view->data.units==PIXELS)
 {
  return(refreshrulers(view,view->file));
 }
 return(NULL);
}




static os_error * rulersact(wimp_w handle,uservalue userhandle,wimp_w otherhandle,int code)
{
 viewstr * view;

 view=(viewstr*)userhandle;

 setactive(view->handle);

 return(NULL);

 USE(otherhandle);
 USE(handle);
 USE(code);
}







os_error * closerulers(viewstr * view,filestr * file)
{
 os_error * err;

 if(view->data.rulers)
 {
           err=remredrawevent(redrawvruler,view->vruler,(uservalue)view);
  if(!err) err=remredrawevent(redrawhruler,view->hruler,(uservalue)view);
  if(!err) err=remactevent(rulersact,view->vruler,(uservalue)view);
  if(!err) err=remactevent(rulersact,view->hruler,(uservalue)view);

  err=closedown(&view->vruler);
  if(!err) err=closedown(&view->hruler);
  view->vpshift=0;
  view->hpshift=0;
 }
 else err=NULL;

 return(err);
 USE(file);
}



os_error * setextentrulers(viewstr * view,filestr * file)
{
 os_error       * err;
 wimp_redrawstr   eblock;

 if(view->data.rulers)
 {
  eblock.w=view->vruler;
  eblock.box=view->extent;
  eblock.box.y1=0;
  eblock.box.y1-=view->hshift;
  err=wimp_set_extent(&eblock);

  eblock.w=view->hruler;
  eblock.box=view->extent;
  eblock.box.x0=0;
  eblock.box.x0+=view->vshift;
  err=wimp_set_extent(&eblock);
 }
 else err=NULL;

 return(err);
 USE(file);
}



os_error * createrulers(viewstr * view,filestr * file)
{
 os_error * err;

 if(view->data.rulers)
 {
  err=createwindowparent(TVRULER,&view->vruler,view->handle);
  if(!err) err=createwindowparent(THRULER,&view->hruler,view->handle);
  addredrawevent(redrawvruler,view->vruler,(uservalue)view);
  addredrawevent(redrawhruler,view->hruler,(uservalue)view);
  addactevent(rulersact,view->vruler,(uservalue)view);
  addactevent(rulersact,view->hruler,(uservalue)view);

  wimp_setwindowbackground(view->vruler,CCWIMPBASE+WIMPWHITE);
  wimp_setwindowbackground(view->hruler,CCWIMPBASE+WIMPWHITE);
  view->hpshift=HMARGIN;
  view->vpshift=VMARGIN;
 }
 else err=NULL;

 return(err);
 USE(file);
}



static os_error * addrulers(viewstr * view,filestr * file)
{
 os_error * err;

 if(!view->data.rulers)
 {
  view->data.rulers=1;
  err=createrulers(view,file);
  setextentrulers(view,file);
  updateviewextent(view,file);

  viewopenpanes(view);
  viewopenshift(view,file,-VMARGIN,HMARGIN);
 }
 else err=NULL;

 return(err);
}



static os_error * remrulers(viewstr * view,filestr * file)
{
 os_error * err;

 if(view->data.rulers)
 {
  err=closerulers(view,file);
  view->data.rulers=0;
  updateviewextent(view,file);
//  viewopenshift(view,file,VMARGIN,-HMARGIN); - not needed because setextent ensures scroll values legal
 }
 else err=NULL;

 return(err);
}



os_error * openvruler(viewstr * view,wimp_openstr * o)
{
 os_error   * err;
 wimp_openstr r;

 r.w=view->vruler;
 r.x=0;
 r.y=o->y-HMARGIN;
 r.behind=o->behind;
 r.box.x0=o->box.x0+view->vshift;
 r.box.x1=r.box.x0+VMARGIN;
 r.box.y0=o->box.y0;
 r.box.y1=o->box.y1-HMARGIN;

 err=wimp_open_wind_ex(&r);

 return(err);
}




os_error * openhruler(viewstr * view,wimp_openstr * o)
{
 os_error   * err;
 wimp_openstr r;

 r.w=view->hruler;
 r.x=o->x+view->vshift+VMARGIN;
 r.y=0;
 r.behind=o->behind;
 r.box.x0=o->box.x0+view->vshift+VMARGIN;
 r.box.x1=o->box.x1;
 r.box.y1=o->box.y1-view->hshift;
 r.box.y0=r.box.y1-HMARGIN;

 err=wimp_open_wind_ex(&r);

 return(err);
}



void setrulers(int open)
{
 viewstr * view;
 filestr * file;

 view=menuview;
 file=view->file;

 if(open && !view->data.rulers) addrulers(view,file);
 else
 if(!open && view->data.rulers) remrulers(view,file);
}


/*****************************************************************************/

static os_error * modresevent(int eventn,wimp_w userhandle,void * data,int data1)
{
 viewstr  * view;
 filestr  * file;

 if(eventn==EVENT_FRAMERESMODDED)
 {
  view=(viewstr*)data;
  file=view->file;

  if(view->data.rulers && view->data.units==PIXELS)
  {
   refreshrulers(view,file);
  }
 }

 return(NULL);

 USE(userhandle);
 USE(data1);
}


os_error * rulersinit(void)
{
 return(addevent(EVENT_FRAMERESMODDED,modresevent,0));
}


