/*->c.reslink */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "filetype.h"


#include "mlo.h"
#include "transform.h"
#include "poll.h"

#include "dbhi.h"
#include "err.h"
#include "temp.h"
#include "fsx.h"
#include "bf.h"
#include "csv.h"

#include "constants.h"
#include "str.h"


#include "file.h"
#include "main.h"

#include "reslink.h"



static errtag errortable[]=
{
 ENOTTYPE,"{ENOTTYPE}",
 EREPDEC,"{EREPDEC}",
 EREPNEG,"{EREPNEG}",
 EBADVAL,"{EBADVAL}",

 EBU,"{EBU}",
 EBD,"{EBD}",
 EBB,"{EBB}",
 EID,"{EID}",
 EPCD,"{EPCD}",
 EPCL,"{EPCL}", 
 ECR,"{ECR}",


 EBADBITS,"{EBADBITS}",

 EC00,"{EC00}",
 EC01,"{EC01}",
 EC02,"{EC02}",

 EVM00,"{EVM00}",

 ES00,"{ES00}",

 EMODE,"{EMODE}",

 ED00,"{ED00}",

 EICO0,"{EICO0}",

 EFS11,"{FS11}",

 EIC00,"{EIC00}",
 EIC01,"{EIC01}",

 ELAST ,""
};


static errlink errorlink;

static templates temptable[]=
{
 TCONF,0,0,"Confirm",

 TINFO,1,0,"Info",

 TMAIN,0,0,"main",
 THRULER,0,0,"Hruler",
 TVRULER,0,0,"Vruler",
 TTOOLBOX,1,0,"Toolbox",


 TCONFIG,1,0,"Config",
 TCONFIGPANE,0,0,"ConfigPane",
 TJPEG,0,0,"JPEG",
 TGIF,0,0,"GIF",
 TTIFF,0,0,"TIFF",
 TMTV,0,0,"MTV",
 TSPRITE,0,0,"SPRITE",
 TCLEAR,0,0,"CLEAR",
 TPBM,0,0,"PBM",
 TPCX,0,0,"PCX",
 TBMP,0,0,"BMP",


 TINFOPALP,1,0,"InfoPalP",
 TINFOPALR,1,0,"InfoPalR",
 TINFOPALS,1,0,"InfoPalS",
 TINFOPALM,1,0,"InfoPalM",

 TIMINFO,0,0,"ImInfo",
 TMEM,1,0,"Memory",
 TWINDOWS,0,0,"Windows",
 TPAGE,0,0,"Page",

 TRESIZE,0,0,"Resize",

 TGENERAL,0,0,"General",
 TUSER,0,0,"User",
 TNEWUSER,0,0,"NewUser",
 TRENUSER,0,0,"RenUser",
 THIST,1,0,"Histogram",
 TFORMAT,1,0,"Format",
 TNOISE,1,0,"Noise",
 TSKEW,1,0,"Skew",
 TROTATE,1,0,"Rotate",
 TBAL,0,0,"Balance",

 TPROCESS,1,0,"Process",
 TPAL,1,0,"Palette",
 TEPS,1,0,"EPS",
 TPNG,1,0,"PNG",

 TDRAW,1,0,"Draw",

 TICO,1,0,"ICO",

 TCOMPARE,1,0,"Compare",
	TCUR,1,0,"CUR",

 TSNAP,1,0,"SNAP",
	TNEWKEY,1,0,"NewKey",
 TBAR,1,0,"Bar",
 TFILL,1,0,"Fill",
 TCORNER,1,0,"Corner",

 TCMS,1,0,"CMS",
 TPROFILE,1,0,"PROFILE",

 TLAST,0,0,""
};


static templink templatelink;

/*
typedef struct menustr
{
 int            menuno;
 char         * menuname;
 int          * menuptr;
 int            flags;
 int            parent;
 int            entryinparent;
 menudecodefn   decode;
 menudynamicfn  dynamic;
} menustr;

*/




static menustr menutable[]=
{
 MMAIN,   "Main",    NULL,  0,  0,  0,  0,   0, maindecode,maindynamic,
 MFILE,   NULL,      NULL,  0,  0,MMAIN,0,   0, NULL,      NULL,
 MVIEW,   NULL,      NULL,  0,  0,MMAIN,1,   0, NULL,      NULL,
 MEDIT,   NULL,      NULL,  0,  0,MMAIN,2,   0, NULL,      NULL,
 MFILTER, NULL,      NULL,  0,  0,MMAIN,3,   0, NULL,      NULL,
 MCOLOUR, NULL,      NULL,  0,  0,MMAIN,4,   0, NULL,      NULL,
 MMISC,   NULL,      NULL,  0,  0,MMAIN,5,   0, NULL,      NULL,
 MHELP,   NULL,      NULL,  0,  0,MMAIN,6,   0, NULL,      NULL,

 MUNITS,  NULL,      NULL,  0,  0,MVIEW,5,   0, NULL,      NULL,
 MROTCOL, NULL,      NULL,  0,  0,MCOLOUR,0, 0, NULL,      NULL,
 MPAGE,   NULL,      NULL,  0,  0,MFILE,PAGE_M_FILE,  0, NULL,      NULL,
 MUSERF,  NULL,      NULL,  0,  0,  0,  0,   0, NULL,      NULL,

 MGFBASE, "Filter",  NULL,  0,  0,  0,  0,   0, NULL,      NULL,
 MGFILTER,NULL,      NULL,  0,  0,MGFBASE,0, 0, NULL,      NULL,

 MRESBASE,"Res",     NULL,  0,  0,  0,  0,   0, NULL,      NULL,
 MRES,    NULL,      NULL,  0,  0,MRESBASE,0,0, NULL,      NULL,

 MPALBASE,"PAL",     NULL,  0,  0,  0,  0,   0, NULL,      NULL,
 MPAL,    NULL,      NULL,  0,  0,MPALBASE,0,0, NULL,      NULL,

 
 MLAST,   NULL,      NULL,  0,  0,  0,  0,   0, NULL,      NULL,

};




static filetypelink filetypelink;

static filetypetag filetypetable[]=
{
 TEXTFILE,"txt","Text (*.txt)",
 TEXTFILE,"fff","Text (*.txt)",
 OBEY,"obe","Obey (*.obe)",
 OBEY,"feb","Obey (*.obe)",
 DATA,NULL,"Data (*.dat)",
 DATA,"dat","Data (*.dat)",
 DATA,"ffd","Data (*.dat)",
 CSV,"csv","CSV (*.csv)",
 CSV,"dfe","CSV (*.csv)",
 PAL,"pal","RISC OS palette (*.pal)",
 PAL,"fed","RISC OS palette (*.pal)",
 WMETAF,"b2f","Windows meta file (*.wmf)",
 WMETAF,"wmf","Windows meta file (*.wmf)",
 PRNFILE,"prn","Print file (*.prn)",
 ALLFILES,"*","All files (*.*)",

 FTDEFLT,"dat","Data (*.dat)",

 FTLAST,NULL,NULL,
};




static menulink mlink;



os_error * resinit(char * resources)
{
 os_error * err;
 
          err=adderrortable(errortable,&errorlink);
 if(!err) err=addtemplates(resources,NULL,temptable,&templatelink);
 if(!err) err=addmenus(NULL,NULL,menutable,&mlink);
 if(!err) err=addfiletypetable(filetypetable,&filetypelink);

 return(err);
}

