/*->c.resize */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "akbd.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "dbhi.h"

#include "config.h"

#include "str.h"
#include "constants.h"
#include "reslink.h"
#include "units.h"

#include "view.h"
#include "viewr.h"
#include "rulers.h"

#include "im.h"

#include "pointer.h"
#include "filter.h"
#include "bm.h"
#include "edit.h"
#include "long.h"
#include "undo.h"

#include "resize.h"


extern dboxstr resizebox;







static resizestr   crsz={0,0, 0,10,0,10, 0,0,0,0, 0};
static resizestr   rsz;

static resizestr * rszp;

static resizefn    rszfn;



static int newmem;
static int oldmem;

static filestr * rfile;
static viewstr * rview;

static int rbpp;






static int calcsize(int w,int h,int xdpi,int ydpi)
{
 int xpix;
 int ypix;

 xpix=scale(w,xdpi,72000);
 xpix*=rbpp;
 xpix=(xpix+31)/8;

 ypix=scale(h,ydpi,72000);

 return(xpix*ypix);
}



void rszcalcscale(resizestr * rsz,int * xs,int * ys)
{
 int xscale;
 int yscale;

 if(rsz->rsmode==RESIZETO)
 {
  if(rsz->rsby)
  {
//   xscale=scale(rsz->resizebyx,0x10000,100);
//   yscale=scale(rsz->resizebyy,0x10000,100);
   xscale=scale(rsz->neww,0x10000,100);
   yscale=scale(rsz->newh,0x10000,100);
  }
  else
  {
   xscale=scale(rsz->neww,0x10000,rsz->oldw);
   yscale=scale(rsz->newh,0x10000,rsz->oldh);
  }
 }
 else
/* if(rsz->rsmode==RESAMPLE) */
 {
  xscale=scale(rsz->newxdpi,0x10000,rsz->oldxdpi);
  yscale=scale(rsz->newydpi,0x10000,rsz->oldydpi);
 }

 if(rsz->lockar)
 {
  if(xscale) yscale=xscale;
  else       xscale=yscale;
 }

 if(xscale) *xs=xscale;
 else       *xs=0x10000;

 if(yscale) *ys=yscale;
 else       *ys=0x10000;
}




static os_error * memfn(void)
{
 int w;
 int h;
 int xdpi;
 int ydpi;
 int xscale;
 int yscale;

 if(!rszp)
 {
  w=rsz.oldw;
  h=rsz.oldh;
  xdpi=rsz.oldxdpi;
  ydpi=rsz.oldydpi;

  rszcalcscale(&rsz,&xscale,&yscale);
 
  w=scale(w,xscale,0x10000);
  h=scale(h,yscale,0x10000);

  newmem=calcsize(w,h,xdpi,ydpi);

  writeicon(resizebox.handle,18,memstring(newmem));
 }

 return(NULL);
}



static os_error * resizeclose(int code)
{
 os_error  * err;
 int         xscale;
 int         yscale;
 imagestr  * sim;
 imagestr  * dim;
 ximagestr * sxim;
 ximagestr * dxim;
 ximagestr * xsxim;
 int         frame;
 framestr  * frames;


 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(rszp)
  {
   if(rszfn) err=rszfn(&rsz);
  }
  else
  {
   crsz=rsz;

   rszcalcscale(&rsz,&xscale,&yscale);

   if(rfile->frames && rfile->framen)
   {
    frame=rview->frame;
    frames=&rfile->frames[frame];

    sxim=frames->xim;
    sim=(sxim->sim[IM]);

    longprocstart(NULL,0,sim->ypix,rview);
 
    err=viewdeleteimagefileframe(rfile,frame);

    undostart(sxim);

    if(undosteps) ximcopy(sxim,&xsxim);
    else          xsxim=sxim;

    err=zoomxim(xsxim,&dxim,xscale,yscale);

    dim=(dxim->sim[IM]);
 
    if(rsz.rsmode==RESAMPLE)
    {
     dim->xdpi=rsz.newxdpi;
     dim->ydpi=rsz.newydpi;
    }

    if(!err)
    {
     frames->xim=dxim;

     if(undosteps)
     {
      undolink(sxim,dxim);
     }

     viewcreateimagefileframe(rfile,frame);
     refreshviewfileframe(rfile,frame);
     modifyview(rview);
     modifyres(rview);
     refreshrulersu(rview);
    }

    longprocend();
   }
   memfn();
  }
 }
 return(err);
}




static os_error * resizekey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 return(viewsubkey(rview,key));

 USE(handle);
 USE(userhandle);
 USE(icon);
}



static os_error * wrpc(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}



static os_error * owrpc(int value,char * string)
{
 if(rszp) {*string++='-';*string=0;}
 else     strcpy(string,numbertostring(value));
 return(NULL);
}



static os_error * rdpc(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}


static os_error * wrmem(int value,char * string)
{
 if(rszp) {*string++='-';*string=0;}
 else     strcpy(string,memstring(value));
 return(NULL);
}


static os_error * wrux(int value,char * string)
{
 if(rsz.rsby)
 {
  wrpc(value,string);
 }
 else
 {
  if(rszp) strcpy(string,numbertostring(value));
  else
  strcpy(string,viewunitstostring(value,rview,1));
 }
 return(NULL);
}


static os_error * owrux(int value,char * string)
{
 if(rsz.rsby)
 {
  strcpy(string,"100%");
 }
 else
 if(rszp)
 {
  *string++='-';
  *string=0;
 }
 else
 {
  strcpy(string,viewunitstostring(value,rview,1));
 }

 return(NULL);
}



static os_error * wruy(int value,char * string)
{
 if(rsz.rsby)
 {
  wrpc(value,string);
 }
 else
 {
  if(rszp) strcpy(string,numbertostring(value));
  else
  strcpy(string,viewunitstostring(value,rview,0));
 }
 return(NULL);
}



static os_error * owruy(int value,char * string)
{
 if(rsz.rsby)
 {
  strcpy(string,"100%");
 }
 else
 if(rszp) 
 {
  *string++='-';
  *string=0;
 }
 else
 {
  strcpy(string,viewunitstostring(value,rview,0));
 }

 return(NULL);
}




os_error * resizesummary(resizestr * rsz,char * string)
{
 char stringx[32];
 char stringy[32];

 if(rsz->rsmode==RESIZETO)
 {
  if(rsz->rsby)
  {
//   wrpc(rsz->resizebyx,stringx);
//   wrpc(rsz->resizebyy,stringy);
   wrpc(rsz->neww,stringx);
   wrpc(rsz->newh,stringy);
   sprintf(string,"%s x %s %%",stringx,stringy);
  }
  else
  {
   wrpc(rsz->neww,stringx);
   wrpc(rsz->newh,stringy);
   sprintf(string,"%s x %s pix",stringx,stringy);
  }
 }
 else
/* if(rsz->rsmode==RESAMPLE) */
 {
  wrpc(rsz->newxdpi,stringx);
  wrpc(rsz->newydpi,stringy);
  sprintf(string,"%s x %s dpi",stringx,stringy);
 }

 return(NULL);
}




static os_error * rdux(int * value,char * string)
{
 os_error * err;

 if(rsz.rsby)
 {
  err=rdpc(value,string);
 }
 else
 {
  if(rszp) err=stringtonumber(string,value);
  else     err=viewstringtounits(string,value,rview,1);
 }

 return(err);
}



static os_error * rduy(int * value,char * string)
{
 os_error * err;

 if(rsz.rsby)
 {
  err=rdpc(value,string);
 }
 else
 {
  if(rszp) err=stringtonumber(string,value);
  else     err=viewstringtounits(string,value,rview,0);
 }

 return(err);
}




static os_error * optfn(int handle,uservalue userhandle,wimp_mousestr * m)
{

 rsz.rsby^=1;
 dbreadvalues(&resizebox);
 rsz.rsby^=1;

 if(rsz.rsby)
 {
  rsz.neww=(rsz.neww*100)/rsz.oldw;
  rsz.newh=(rsz.newh*100)/rsz.oldh;
 }
 else
 {
  rsz.neww=(rsz.oldw*rsz.neww)/100;
  rsz.newh=(rsz.oldh*rsz.newh)/100;
 }

 dbwritevalues(&resizebox);

 return(NULL);

 USE(handle);
 USE(userhandle);
 USE(m);
}



static os_error * optfn1(int handle,uservalue userhandle,wimp_mousestr * m)
{

 dbshade(1,rsz.rsmode!=RESIZETO,&resizebox);
 dbshade(2,rsz.rsmode!=RESAMPLE,&resizebox);

 return(NULL);

 USE(handle);
 USE(userhandle);
 USE(m);
}







static dbiconstr resizeicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

   20, &rsz.lockar,  DBTOGGLE, 0,   0,      1,   F4, 0, 0,      NULL, 0,
   21, &rsz.rsby,    DBTOGGLE, 1,   0,      1,   F4, 0, 0,(dbreadfn)optfn, 0,

//    3, &rsz.resizebyx,DBWRITE,  0,   0,      -1, -1, 21, -1,     rdpc, wrpc,
//   21, &rsz.resizebyy,DBWRITE,  0,   0,      -1, -1,  4,  3,     rdpc, wrpc,

    4, &rsz.neww,    DBWRITE,  1,   0,      -1, -1,  7, 21,     rdux, wrux,
    7, &rsz.newh,    DBWRITE,  1,   0,      -1, -1, 10,  4,     rduy, wruy,

   10, &rsz.newxdpi, DBWRITE,  2,   0,      -1, -1, 11,  7,     rdpc, wrpc,
   11, &rsz.newydpi, DBWRITE,  2,   0,      -1, -1, -1, 10,     rdpc, wrpc,


   14, &rsz.oldw,    DBTEXT,   0,   0,      0,  0,  0,   0,     NULL, owrux,
   13, &rsz.oldh,    DBTEXT,   0,   0,      0,  0,  0,   0,     NULL, owruy,

   15, &rsz.oldxdpi, DBTEXT,   0,   0,      0,  0,  0,   0,     NULL, owrpc,
   16, &rsz.oldydpi, DBTEXT,   0,   0,      0,  0,  0,   0,     NULL, owrpc,

   18, &newmem,      DBTEXT,   0,   0,      0,  0,  0,   0,     NULL, wrmem,
   19, &oldmem,      DBTEXT,   0,   0,      0,  0,  0,   0,     NULL, wrmem,


//    0, &rsz.rsmode,  DBRADIO,  0,   0, RESIZE,   F1, 1, 0,   NULL, 0,
   31, &rsz.rsmode,  DBRADIO,  0,   0, RESIZETO, F2, 1, 0,(dbreadfn)optfn1, 0,
   30, &rsz.rsmode,  DBRADIO,  0,   0, RESAMPLE, F3, 1, 0,(dbreadfn)optfn1, 0,


   1,  NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
   2,  NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0, NULL ,0,


//   18, &rsz.resizebyx,DBUPDATE,0,   0,     -1, -1, -1, -1,(dbreadfn)memfn,NULL,
//   18, &rsz.resizebyy,DBUPDATE,0,   0,     -1, -1, -1, -1,(dbreadfn)memfn,NULL,
   18, &rsz.neww,     DBUPDATE,0,   0,     -1, -1, -1, -1,(dbreadfn)memfn,NULL,
   18, &rsz.newh,     DBUPDATE,0,   0,     -1, -1, -1, -1,(dbreadfn)memfn,NULL,
   18, &rsz.newxdpi,  DBUPDATE,0,   0,     -1, -1, -1, -1,(dbreadfn)memfn,NULL,
   18, &rsz.newydpi,  DBUPDATE,0,   0,     -1, -1, -1, -1,(dbreadfn)memfn,NULL,
   18, &rsz.rsmode,   DBUPDATE,0,   0,     -1, -1, -1, -1,(dbreadfn)memfn,NULL,
   18, &rsz.lockar,   DBUPDATE,0,   0,     -1, -1, -1, -1,(dbreadfn)memfn,NULL,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};





static dboxstr resizebox=
{
 0,
 TRESIZE,
 DBFIX,
 0,
 resizeclose,
 NULL,
 resizekey,
 NULL,
 resizeicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};




os_error * resizeopen(wimp_w parent)
{
 os_error * err;
 int        fn;
 framestr * frame;
 imagestr * im;

 err=NULL;

 rszp=NULL;
 rsz=crsz;

 rfile=menufile;
 rview=menuview;

 resizebox.type=DBFIX;

 fn=rview->frame;

 frame=&rfile->frames[fn];
 im=((frame->xim)->sim[IM]);

 rbpp=im->bpp;

 rsz.oldw=scale(im->xpix,72000,im->xdpi);
 rsz.oldh=scale(im->ypix,72000,im->ydpi);

 if(!rsz.rsby)
 {
  rsz.neww=rsz.oldw;
  rsz.newh=rsz.oldh;
 }

 rsz.oldxdpi=rsz.newxdpi=im->xdpi;
 rsz.oldydpi=rsz.newydpi=im->ydpi;

 newmem=oldmem=calcsize(rsz.oldw,rsz.oldh,rsz.oldxdpi,rsz.oldydpi);

 if(resizebox.handle) dbclose(&resizebox,DBCANCEL);
 err=dodboxparent(&resizebox,1,parent);

 
 dbshade(1,rsz.rsmode!=RESIZETO,&resizebox);
 dbshade(2,rsz.rsmode!=RESAMPLE,&resizebox);

 memfn();

 return(err);
}





os_error * resizewindow(resizestr * xrszp,resizefn xrszfn,wimp_w parent)
{
 os_error * err;

 resizebox.type=DBFIX;

 rszp=xrszp;
 rszfn=xrszfn;
 rsz=*rszp;

 err=dodboxparent(&resizebox,1,parent);

 
 dbshade(1,rsz.rsmode!=RESIZETO,&resizebox);
 dbshade(2,rsz.rsmode!=RESAMPLE,&resizebox);


 return(err);
}






static contag contable[]=
{
 "Resize",CONINT,&crsz.rsmode,NULL,NULL,
 "Width",CONINT,&crsz.neww,NULL,NULL,
 "Height",CONINT,&crsz.newh,NULL,NULL,
 "XRes",CONINT,&crsz.newxdpi,NULL,NULL,
 "YRes",CONINT,&crsz.newydpi,NULL,NULL,
 "Aspect",CONINT,&crsz.lockar,NULL,NULL,
 "ResizeBy",CONINT,&crsz.rsby,NULL,NULL,
// "YResize",CONINT,&rsz.resizebyy,NULL,NULL,

 NULL,0,NULL,NULL,NULL
};





static conlink configlink=
{
 "Resize",
 NULL,
 NULL
};


os_error * resizeinit(void)
{
	os_error * err;

 err=addcontable(contable,&configlink);

	return(err);
}






/*****************************************************************************/

static int tskewangle;
static int skewangle;
static int tskewmode;
static int skewmode;


#define MAXSKEW 90
#define MINSKEW -90


static os_error * skew(viewstr * view,filestr * file)
{
 os_error  * err;
 imagestr  * sim;
 ximagestr * sxim;
 ximagestr * dxim;
 ximagestr * xsxim;
 int         frame;
 framestr  * frames;

 err=NULL;

 if(file->frames && file->framen)
 {
  frame=view->frame;
  frames=&file->frames[frame];
  sxim=frames->xim;
  sim=(sxim->sim[IM]);

  longprocstart(NULL,0,sim->ypix,view);

  err=viewdeleteimagefileframe(file,frame);

  undostart(sxim);

  if(undosteps) ximcopy(sxim,&xsxim);
  else          xsxim=sxim;


  if(skewmode) err=sheary(xsxim,&dxim,skewangle);
  else         err=shearx(xsxim,&dxim,skewangle);

  if(!err)
  {
   frames->xim=dxim;

   if(undosteps)
   {
    undolink(sxim,dxim);
   }
  }

  viewcreateimagefileframe(file,view->frame);
  refreshviewfileframe(file,view->frame);
  modifyview(view);

  longprocend();
 }
 return(err);
}




static os_error * skewclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(tskewangle && tskewangle<90 && tskewangle>-90)
  {
   skewangle=tskewangle*0x10000;
   skewmode=tskewmode;
   skew(menuview,menufile);
  }
 }
 return(err);
}





static os_error * skewkey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 return(viewsubkey(menuview,key));

 USE(handle);
 USE(userhandle);
 USE(icon);
}







static os_error * wrskew(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdskew(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}


static dbiconstr skewicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0,     NULL ,0,

/* 0, &tskewangle,  DBUPDATE, 0,    0,      1,   -1, -1, 0,     NULL,   0, */

    3, &tskewangle,   DBWRITE,  0, DBASSOCINC,  -1, -1, -1,  -1, rdskew,wrskew,

   11, &tskewangle,   DBINC   ,0,    0,      1,  -1, MAXSKEW,MINSKEW,NULL,0,
   14, &tskewangle,   DBDEC   ,0,    0,      1,  -1, MAXSKEW,MINSKEW,NULL,0,

    5, &tskewmode,   DBRADIO,0,    0,        0,0,1,0,               NULL,   0,
    6, &tskewmode,   DBRADIO,0,    0,        1,0,1,0,               NULL,   0,


   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};


static dboxstr skewbox=
{
 0,
 TSKEW,
 DBFIX,
 0,
 skewclose,
 NULL,
 skewkey,
 NULL, /* skewredraw, */
 skewicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


os_error * skewopen(wimp_w parent)
{
 os_error * err;

 tskewangle=skewangle/0x10000;
 tskewmode=skewmode;

 if(skewbox.handle) dbclose(&skewbox,DBCANCEL);
 err=dodboxparent(&skewbox,1,parent);

 return(err);
}


/*****************************************************************************/

static int trotateangle;
static int rotateangle;


#define MAXROTATE  (90*0x10000)
#define MINROTATE -(90*0x10000)


static os_error * dorotate(viewstr * view,filestr * file)
{
 os_error  * err;
 imagestr  * sim;
 ximagestr * sxim;
 ximagestr * dxim;
 ximagestr * xsxim;
 int         frame;
 framestr  * frames;

 err=NULL;

 if(file->frames && file->framen)
 {
  frame=view->frame;
  frames=&file->frames[frame];
  sxim=frames->xim;
  sim=(sxim->sim[IM]);

  longprocstart(NULL,0,sim->ypix,view);

  err=viewdeleteimagefileframe(file,frame);

  undostart(sxim);

  if(undosteps) ximcopy(sxim,&xsxim);
  else          xsxim=sxim;

  err=rotate(xsxim,&dxim,rotateangle);

  if(!err)
  {
   frames->xim=dxim;

   if(undosteps)
   {
    undolink(sxim,dxim);
   }
  }

  viewcreateimagefileframe(file,view->frame);
  refreshviewfileframe(file,view->frame);
  modifyview(view);

  longprocend();
 }
 return(err);
}





static os_error * rot180(filestr * file,viewstr * view)
{
 os_error  * err;
 imagestr  * sim;
 imagestr  * dim;
 ximagestr * sxim;
 ximagestr * dxim;


 err=NULL;

 if(file->frames && file->framen)
 {
  sxim=file->frames[view->frame].xim;
  sim=(sxim->sim[IM]);

  longprocstart(NULL,0,sim->ypix,rview);

  err=viewdeleteimagefileframe(file,view->frame);
  if(!err)
  {
   undostart(sxim);

   if(undosteps) err=ximcopy(sxim,&dxim);
   else          dxim=sxim;

   if(!err)
   {
    dim=(dxim->sim[IM]);

             err=flipimageh(dim);
    if(!err) err=flipimagev(dim);
    if(!err)
    {
     dim=(dxim->sim[AL]);

     err=flipimageh(dim);
     if(!err) err=flipimagev(dim);
    }


    if(undosteps)
    {
     if(err) ximtrash(&dxim);
     else
     {
      undolink(sxim,dxim);
      file->frames[view->frame].xim=dxim;
     }
    }
   }
  }

  viewcreateimagefileframe(file,view->frame);
  refreshviewfileframe(file,view->frame);
  modifyview(view);

  longprocend();
 }

 return(err);
}



static os_error * rotp90(filestr * file,viewstr * view)
{
 os_error  * err;
 imagestr  * sim;
 ximagestr * dxim;
 ximagestr * sxim;
 ximagestr * xsxim;
 framestr  * frames;


 err=NULL;

 if(file->frames && file->framen)
 {
  frames=&file->frames[view->frame];
  sxim=frames->xim;
  sim=(sxim->sim[IM]);

  longprocstart(NULL,0,sim->ypix,rview);

  err=viewdeleteimagefileframe(file,view->frame);

  undostart(sxim);

  if(undosteps) ximcopy(sxim,&xsxim);
  else          xsxim=sxim;

  rotimagep90(xsxim,&dxim);

  frames->xim=dxim;

  if(undosteps)
  {
   undolink(sxim,dxim);
  }

  viewcreateimagefileframe(file,view->frame);
  refreshviewfileframe(file,view->frame);
  modifyview(view);

  longprocend();
 }

 return(err);
}




static os_error * rotm90(filestr * file,viewstr * view)
{
 os_error  * err;
 imagestr  * sim;
 ximagestr * dxim;
 ximagestr * sxim;
 ximagestr * xsxim;
 framestr  * frames;


 err=NULL;

 if(file->frames && file->framen)
 {
  frames=&file->frames[view->frame];
  sxim=file->frames[view->frame].xim;
  sim=(sxim->sim[IM]);

  longprocstart(NULL,0,sim->ypix,rview);

  err=viewdeleteimagefileframe(file,view->frame);

  undostart(sxim);

  if(undosteps) ximcopy(sxim,&xsxim);
  else          xsxim=sxim;

  rotimagem90(xsxim,&dxim);
  frames->xim=dxim;

  viewcreateimagefileframe(file,view->frame);

  if(undosteps)
  {
   undolink(sxim,dxim);
  }

  refreshviewfileframe(file,view->frame);
  modifyview(view);

  longprocend();
 }

 return(err);
}





static os_error * rotateicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 6:
         err=rotp90(menufile,menuview);
         break;

  case 5:
         err=rotm90(menufile,menuview);
         break;

  case 7:
         err=rot180(menufile,menuview);
         break;
 }

 return(err);

 USE(handle);
 USE(userhandle);
}



static os_error * rotatekey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 return(viewsubkey(menuview,key));

 USE(handle);
 USE(userhandle);
 USE(icon);
}



static os_error * rotateclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(trotateangle)
  {
   rotateangle=trotateangle;
   dorotate(menuview,menufile);
  }
 }
 return(err);
}





static os_error * wrrotate(int value,char * string)
{
 strcpy(string,numbertostringxdp(value,2,0));
 return(NULL);
}

static os_error * rdrotate(int * value,char * string)
{
 os_error * err;
 err=stringtonumberxdp(string,value,2,0);
 return(err);
}


static dbiconstr rotateicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,  DBCANCEL,ESCAPE,0,0,     NULL ,0,

 /*0, &trotateangle,   DBUPDATE, 0,    0,      1,   -1, -1, 0,     NULL,   0,*/

    3, &trotateangle, DBWRITE, 0, DBASSOCINC, -1, -1, -1, -1, rdrotate,wrrotate,

   11, &trotateangle,   DBINC   ,0,    0,  0x10000,  -0x10000, MAXROTATE,MINROTATE,NULL,0,
   14, &trotateangle,   DBDEC   ,0,    0,  0x10000,  -0x10000, MAXROTATE,MINROTATE,NULL,0,


   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};


static dboxstr rotatebox=
{
 0,
 TROTATE,
 DBFIX,
 0,
 rotateclose,
 rotateicon,
 rotatekey,
 NULL /*rotateredraw */,
 rotateicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


os_error * rotateopen(wimp_w parent)
{
 os_error * err;

 trotateangle=rotateangle;

 if(rotatebox.handle) err=dbclose(&rotatebox,DBCANCEL);
 err=dodboxparent(&rotatebox,1,parent);

 return(err);
}


os_error * rotateopenat(wimp_w parent,int angle)
{
 os_error * err;

 trotateangle=angle;

 if(rotatebox.handle) err=dbclose(&rotatebox,DBCANCEL);
 err=dodboxparent(&rotatebox,1,parent);

 return(err);
}