/*->c.pr */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <time.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "fsx.h"
#include "etc.h"
#include "bbc.h"
#include "key.h"
#include "hourglass.h"
#include "colour.h"
#include "xmath.h"
#include "config.h"
#include "osprint.h"
#include "osunits.h"
#include "deb.h"
#include "dbhi.h"


#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "mlo.h"
#include "units.h"

#include "file.h"
#include "view.h"
#include "viewr.h"

#include "pr.h"




static pset defps=
{
 0,
 0,
 1,
 1,
 1,
 1,
 0,
 0,
 1,
 0,
 0,
 0,
 0,
 0,
 0,
};


filestr * prfile;
viewstr * prview;






#define MARGINCOLOUR 1



os_error * redrawprint(viewredrawstr * v)
{
 int       xleft;
 int       xright;
 int       xtop;
 int       xbottom;
 int       righth;
 int       lefth;
 filestr * file;
 viewstr * view;

 
 /* print margins */

 osprintmargins(&xleft,&xright,&xtop,&xbottom,FONTXRES,FONTYRES);

 if(1)
 {
  file=v->file;
  view=v->view;

  file->ps.height=file->height;
  file->ps.width=file->width;

  seteorcol(0,MARGINCOLOUR);

  /* left hand edge  */

  bbc_rectanglefill(v->ox+osunits(v->xps,view),v->oy-osunits(v->yps,view),
                       osunits(xleft,view),-osunits(file->height,view));
  

  lefth=xcoordpix2os(xcoordos2pix(v->ox+osunits(v->xps,view))+
                     xcoordos2pix(osunits(xleft,view)));

  /* right hand edge */

  bbc_rectanglefill(v->ox+osunits(v->xps+xright,view),
                    v->oy-osunits(v->yps,view),
           osunits(file->width-xright,view),-osunits(file->height,view)); 

  righth=(v->ox+(osunits(v->xps+xright,view) & cvdu.maskx))-cvdu.deltax;


  /* bottom edge     */

  bbc_rectanglefill(lefth,v->oy-osunits(v->yps,view),
                    righth-lefth,-osunits(xtop,view));

  /* top edge        */

  bbc_rectanglefill(lefth,v->oy-osunits(v->ype,view),righth-lefth,
                    osunits(file->height-xbottom,view));

 }


 return(NULL);
}





static os_error * imprint(wimp_redrawstr * r,int flags,void * data,uservalue userhandle)
{
 os_error * err;

 err=NULL;

 err=viewcreateprintimage(r);

 if(!err)
 {
  osprintstartdoc(prfile->sname,NULL);
  osprintstartpage();

//  setgcol(0);
//  bbc_rectanglefill(0,0,500,-500);

  viewprintredraw(0,r);


  if(err)     viewdeleteprintimage();
  else    err=viewdeleteprintimage();

  osprintendpage();
  osprintenddoc();
 } 

 return(err);

 USE(flags);
 USE(data);
 USE(userhandle);
}



static os_error * imabort(wimp_w handle,uservalue userhandle,os_error * err,int * result)
{
 cprintf("abx fn");

 USE(handle);
 USE(userhandle);
 USE(err);
 USE(result);


 return(NULL);
}


os_error * popprint(viewstr * view)
{

 prfile=view->file;
 prview=view;


 osprintdbox(view->handle,0,0,imprint,imabort,0,NULL);


 return(NULL);
}




os_error * popprintpagesetup(viewstr * view)
{
 osprintpagedbox(view->handle);

 return(NULL);
}



void prinitps(pset * ps)
{
 *ps=defps;
}



/*****************************************************************************/



static errtag errortable[]=
{
 PR00,"{PR00}",
 PR01,"{PR01}",

 ELAST ,""
};

static errlink errorlink;





static contokstr pstoks[3]=
{
 "Landscape",0,
 "Portrait",PORT,
 NULL,0
};


static contag contable[]=
{
 "cx",   CONINT,&defps.cx,  NULL,NULL,
 "cy",   CONINT,&defps.cy,  NULL,NULL,
 "xmul", CONINT,&defps.xmul,NULL,NULL,
 "xdiv", CONINT,&defps.xdiv,NULL,NULL,
 "ymul", CONINT,&defps.ymul,NULL,NULL,
 "ydiv", CONINT,&defps.ydiv,NULL,NULL,
 "Orientation",CONTOK,&defps,pstoks,NULL,

 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "PRINT",
 NULL,
 NULL
};






/* called on program start up */

os_error * prinit(void)
{
 os_error * err;

// getpagesize();


 err=addcontable(contable,&configlink);

 if(!err) err=adderrortable(errortable,&errorlink);

// if(!err) err=osprintinitdbox();

 return(err);
}



os_error * prinit2(void)
{
 os_error * err;

 err=osprintinitdbox();

 return(err);
}


