/*->c.pointer */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "bbc.h"
#include "transform.h"
#include "akbd.h"

#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "colour.h"
#include "drag.h"
#include "key.h"
#include "deb.h"
#include "dbhi.h"

#include "str.h"
#include "reslink.h"
#include "file.h"

#include "viewo.h"
#include "viewr.h"
#include "view.h"

#include "undo.h"
#include "tw.h"
#include "rulers.h"

#include "tools.h"
#include "infopal.h"
#include "edit.h"
#include "pal.h"
#include "resize.h"


#include "pointer.h"



/*****************************************************************************/
/* code to do drag box */

static viewstr * sview;
static filestr * sfile;

static int       sdrag;
static boxstr    sbox;

static int       sdrgx;
static int       sdrgy;
static int       sorgx;
static int       sorgy;
static int       scx;
static int       scy;
static int       omx;
static int       omy;




static void supdatebox(void)
{
 wimp_box      box;

 box.x0=osunits(sbox.x,sview)-cvdu.extrax;
 box.x1=osunits(sbox.x+sbox.w,sview)+cvdu.extrax;
 box.y1=-osunits(sbox.y,sview)+cvdu.extray;
 box.y0=-osunits(sbox.y+sbox.h,sview)-cvdu.extray;

 viewupdatelayer(sfile,&box,VRSELECT);
}


static os_error * sdragzero(wimp_w handle,uservalue userhandle,wimp_mousestr * mstr)
{
// wimp_mousestr mstr;
 windowstr     window;
 int           scroll;
 framestr    * frame;
 int           fn;
// int           handle;

// wimp_get_point_info(&mstr);
 getw(sview->handle,&window);

 scroll=autoscroll(sview,mstr,0,0);

 if(mstr->x!=omx || mstr->y!=omy || scroll)
 {
  supdatebox();

  scx=ourunits(mstr->x-window.bx,sview);
  scy=-ourunits(mstr->y-window.by,sview);

		if(sdrag==1)
		{
   sbox.x=sorgx+(scx-sdrgx);
   sbox.y=sorgy+(scy-sdrgy);
		}
		else
		{
			sbox.w=scx-sbox.x;
			sbox.h=scy-sbox.y;
		}

  supdatebox();

  omx=mstr->x;
  omy=mstr->y;

  handle=sview->info;
  if(handle)
  {
   fn=sview->frame;
   frame=&sfile->frames[fn];

   writeiconc(handle,5,viewunitstostring(sbox.x,sview,1));
   writeiconc(handle,7,viewunitstostring(sbox.y,sview,0));
  }
 }

 return(NULL);

 USE(handle);
 USE(userhandle);
}


/* end drag */

static os_error * sdragfn(wimp_w handle,uservalue userhandle,wimp_box * wbox)
{
 os_error * err;
 int        fn;
	int        a;

	err=NULL;

	if(sdrag==1)
	{
  supdatebox();
  sdrag=0;

  fn=sview->frame;

  viewfileframeshift(sfile,fn,sorgx+(scx-sdrgx),sorgy+(scy-sdrgy));

  err=refreshviewfileframe(sfile,fn);

  modifyview(sview);
	}
	else
	if(sdrag==2)
	{
  supdatebox();
  sdrag=0;

		a=scaleatan2(sbox.h,sbox.w);

  if(a<0) a=180*0x10000+a;

  if(a<45*0x10000)  a+=90*0x10000;
  else
  if(a>135*0x10000) a-=90*0x10000;

		a=a-90*0x10000;

		err=rotateopenat(handle,a);
	}


 return(err);

 USE(handle);
 USE(userhandle);
 USE(wbox);
}



static int insidebox(int x,int y,boxstr * box)
{
 return(
        x>=box->x &&
        x<=(box->x+box->w) &&
        y>=box->y &&
        y<=(box->y+box->h)
       );
}



static os_error * sstartdrag(viewstr * view,wimp_w handle,wimp_mousestr * m)
{
 windowstr window;
 framestr * frame;
 imagestr * im;
 int        fn;

 sview=view;
 sfile=(filestr*)sview->file;

 getw(handle,&window);

 scx=sdrgx=ourunits(m->x-window.bx,view);
 scy=sdrgy=-ourunits(m->y-window.by,view);

 fn=view->frame;
 frame=&sfile->frames[fn];
 im=((frame->xim)->sim[IM]);

	if(isctrl)
 {
  sdrag=2;

		sbox.x=scx;
		sbox.y=scy;
		sbox.w=0;
		sbox.h=0;

  startdrag2(handle,0,sdragfn,sdragzero);
  userdrag(handle,window.x0,window.y0,window.x1,window.y1);

  omx=omy=-1;

  supdatebox();
	}
	else
	{
  sbox.x=sorgx=im->tr.e;
  sbox.y=sorgy=im->tr.f;
  sbox.w=scale(im->xpix,72000,im->xdpi);
  sbox.h=scale(im->ypix,72000,im->ydpi);

  if(insidebox(scx,scy,&sbox))
  {
   startdrag2(handle,0,sdragfn,sdragzero);
   userdrag(handle,window.x0,window.y0,window.x1,window.y1);

   sdrag=1;
   omx=omy=-1;

   supdatebox();
		}
 }

 return(NULL);
}


/*****************************************************************************/
/*
char * memstring(int size)
{
 static char string[16];
 int K=size/1024;
 int M=K/1024;

 if(!M && !K) sprintf(string,"%d",size);
 else
 if(!M && K) sprintf(string,"%dK",K);
 else
 {
  K-=M*1024;
  K=(K*100)/1024;
  if(K) sprintf(string,"%d.%02dM",M,K);
  else  sprintf(string,"%dM",M);
 }
 return(string);
}
*/

os_error * pfill(viewstr * view,filestr * file)
{
 framestr * frame;
 imagestr * im;
 int        fn;
 wimp_w     handle;
 int        size;


 handle=view->info;
 if(handle)
 {
  if(file->framen)
  {
   fn=view->frame;
   frame=&file->frames[fn];
   im=((frame->xim)->sim[IM]);

   writeiconc(handle,5,viewunitstostring(im->tr.e,view,1));
   writeiconc(handle,7,viewunitstostring(im->tr.f,view,0));
   writeiconc(handle,14,
              viewunitstostring(scale(im->xpix,72000,im->xdpi),view,1));
   writeiconc(handle,15,
              viewunitstostring(scale(im->ypix,72000,im->ydpi),view,0));

   writeiconfc(handle,11,"%d",im->bpp);
   writeiconfc(handle,3 ,"%d",im->xdpi);
   writeiconfc(handle,10,"%d",im->ydpi);

   writeiconfc(handle,20,"%d",fn+1);
   writeiconfc(handle,21,"/%d",file->framen);

   if(im) size=im->wwidth*sizeof(int)*im->ypix;
   else   size=0;

   writeiconc(handle,13,memstring(size));
  }
  else
  {
   writeicon(handle,5,"");
   writeicon(handle,7,"");
   writeicon(handle,14,"");
   writeicon(handle,15,"");

   writeicon(handle,11,"");
   writeicon(handle,3,"");
   writeicon(handle,10,"");
   writeicon(handle,20,"0");
   writeicon(handle,21,"/0");
   writeicon(handle,13,"0");
  }

  writeiconc(handle,25,view->data.dither?"Dither":"None");
  selectst(handle,24,view->data.dither);
 }
 
 return(NULL);
}


os_error * predraw(viewredrawstr * v)
{
 os_error * err;

 err=NULL;

 if(sfile==v->file)
 {
		if(sdrag==1)
		{
   seteorcol(WIMPWHITE,WIMPRED);
   rbox(v,&sbox);
		}
		else
		if(sdrag==2)
		{
   seteorcol(WIMPWHITE,WIMPRED);
   rline(v,&sbox);
		}
 }

 return(NULL);
}


void pselect(int select,viewstr * view)
{

 USE(select);
 USE(view);
}


/*****************************************************************************/

static os_error * grabvalues(wimp_w handle,uservalue userhandle)
{
 os_error * err;
 framestr * frame;
 imagestr * im;
 int        fn;
 char     * p;
 int        x;
 int        y;
 int        f;
 int        xdpi;
 int        ydpi;
 viewstr  * sview;
 filestr  * sfile;

 err=NULL;

 sview=(viewstr*)userhandle;
 sfile=(filestr*)sview->file;

 fn=sview->frame;

 frame=&sfile->frames[fn];

 if(sfile->framen)
 {
  im=((frame->xim)->sim[IM]);

  iconaddr(handle,5,&p);
  viewstringtounits(p,&x,sview,1);
  iconaddr(handle,7,&p);
  viewstringtounits(p,&y,sview,0);
  iconaddr(handle,20,&p);
  sscanf(p,"%d",&f);

  iconaddr(handle,3,&p);
  if((sscanf(p,"%d",&xdpi)!=1) || xdpi==0) xdpi=im->xdpi;
  iconaddr(handle,10,&p);
  if((sscanf(p,"%d",&ydpi)!=1) || ydpi==0) ydpi=im->ydpi;


  if(f!=(fn+1)) /* goto page */
  {
   err=gotoframe(sview,sfile,f-1); /* implicit fill */
  }
  else
  if(x!=im->tr.e || y!=im->tr.f || 
     xdpi!=im->xdpi || ydpi!=im->ydpi)
  {
   if(x!=im->tr.e || y!=im->tr.f) viewfileframeshift(sfile,fn,x,y);
   if(xdpi!=im->xdpi || ydpi!=im->ydpi)
   {
    viewfileframedpi(sfile,fn,xdpi,ydpi);
    err=viewdeleteimagefileframe(sfile,fn);
    viewcreateimagefileframe(sfile,fn);
   }

   err=refreshviewfileframe(sfile,fn);
   refreshrulersu(sview);
   modifyview(sview);
  }
 }
 return(err);
}



#define MAXWI 5



              /* N L R D U */

static char entryiclst[MAXWI][5]=
{
          5,          0,           0,           7,            0,
          7,          0,           0,           3,            5,
          3,          0,           0,          10,            7,
         10,          0,           0,          20,            3,
         20,          0,           0,           0,           10,
};



os_error * pkey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 os_error * err;
 int        cicon;
 int        j;
 int        ch;

 err=NULL;
 ch=*key;

 switch(ch)
 {
       case 27:
               break;

   case RETURN:
               err=grabvalues(handle,userhandle);
               break;

    case 0x18E:
    case 0x18F:
    case 0x19C:
    case 0x19D:
               ch&=0x18F;
               for(j=0;j<MAXWI;j++) if(entryiclst[j][0]==icon) break;
               cicon=entryiclst[j][(ch-0x18B)];
               if(cicon)
               {
                iecarrot(handle,cicon);
               }
               break;

       default:
               return(NULL);
 }
 *key=-1;

 return(err);

 USE(userhandle);
}

/*****************************************************************************/



os_error * pviewkey(wimp_w handle,uservalue userhandle,int icon,int * key)
{

 USE(handle);
 USE(userhandle);
 USE(icon);
 USE(key);

 return(NULL);
}


os_error * pviewicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;
 viewstr  * view;
 filestr  * file;

 err=NULL;

 view=(viewstr*)userhandle;
 file=(filestr*)view->file;
 if(file->framen && file->frames)
 {
  if(m->bbits==VBDRAGS)             err=sstartdrag(view,handle,m);
  else
  if(m->bbits==VBCLICKS && isshift) err=palpick(view,handle,m);
 }

 return(err);
}




os_error * picon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;
 viewstr  * view;
 filestr  * file;

 view=(viewstr*)userhandle;
 file=(filestr*)view->file;


 err=NULL;

 switch(m->i)
 {
  case 24:
          selectst(handle,24,view->data.dither^=1);
          err=viewdeleteimage(view,file);
          viewcreateimage(view,file);
          pfill(view,file);
          refreshview(view);
          break;


  case 22:
  case 23:
          if(m->bbits==VBCLICKS)
          {
           if(m->i==22) err=nextframe();
           else         err=prevframe();
          }
          else
          if(m->bbits==VBCLICKA)
          {
           if(m->i==23) err=nextframe();
           else         err=prevframe();
          }
          break;


  case 28: /* undo */
          err=imageundo();
          break;

  case 29: /* redo */
          err=imageredo();
          break;

  case 30: /* acquire */
          err=twainacquire();
          break;

 }

 return(err);

 USE(handle);
 USE(m);
}

