/*->c.pngim */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"
#include "xmath.h"
#include "deb.h"
#include "bitrev.h"


#include "constants.h"
#include "str.h"
#include "reslink.h"
#include "units.h"

#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "cms.h"


#include "png.h"


#include "pngim.h"





extern ftypestr ftype;
extern dboxstr  configbox;


static int tdbl;
static int dbl;
static int tinterlace;
static int interlace;

static int pngxres=90;
static int pngyres=90;
static int txres;
static int tyres;






/*****************************************************************************/



static os_error * getinfo(framestr * frame)
{
 char   string[256];
 char * p;

 p=string;

 p+=sprintf(p,"PNG file\n");
 p+=sprintf(p,"%d x %d pixels, %d bpp\n",frame->fxpix,
                                         frame->fypix,frame->fbpp);

 if(frame->fbpp<=8)
 {
  p+=sprintf(p,"Palette entries %d.\n",((frame->xim)->sim[IM])->ipal.ncolours);
 }

 return(infowrite(string,frame));
}




static png_color_16 my_background=
{
 0,
 0x0,
 0x0,
 0x0,
 0,
};





static void user_read_data(png_structp png_ptr, png_bytep data,
                                                        png_size_t length)
{
 buffer * bf=(buffer*)png_get_io_ptr(png_ptr);

 bf_read(bf,data,(int)length);
}



static void user_write_data(png_structp png_ptr, png_bytep data,
                                                         png_size_t length)
{
 buffer * bf=(buffer*)png_get_io_ptr(png_ptr);

 bf_write(bf,data,(int)length);
}



static void user_flush_data(png_structp png_ptr)
{
 USE(png_ptr);
}



static void user_error(png_structp png_ptr, png_const_charp error_msg)
{
 os_error * err;

// dprintf(0,"user_error %d",error_msg);

 err=generror(0x600,"PNG:%s",error_msg);
 longjmp(png_ptr->jmpbuf,(int)err);  /* return control to outer routine */
}




static void user_warning(png_structp png_ptr,png_const_charp warning_msg)
{
 USE(png_ptr);
 USE(warning_msg);
}






static os_error * loadpng(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;
 png_bytep   row_buf;
 png_byte  * near_row_buf;
 png_uint_32 rowbytes;
 png_uint_32 y;
 int         channels;
 int         num_pass;
 int         pass;
 png_struct * read_ptr;
 png_info   * info_ptr;
 png_info   * end_info;
 int       * idata;
 imagestr  * loadimage;
 int         fn;
 int         i;
 int         bpp;
 buffer      bf;

// dprintf(0,"loadpng");

 err=NULL;


 row_buf=(png_bytep)0;
 near_row_buf=(png_byte *)0;


 err=bf_open(name,'r',BIGBUFFSIZE,&bf);
 if(!err)
 {
  read_ptr=png_create_read_struct(PNG_LIBPNG_VER_STRING,NULL,NULL,NULL);
  
  png_set_error_fn(read_ptr,NULL,user_error,user_warning);

  if((err=(os_error*)setjmp(read_ptr->jmpbuf))!=NULL)
  {
   png_read_destroy(read_ptr,info_ptr,end_info);
   sfree((flex_ptr)&near_row_buf);
  }
  else
  {
//   png_read_init(&read_ptr);
//   png_info_init(&info_ptr);
//   png_info_init(&end_info);


    info_ptr=png_create_info_struct(read_ptr);
    end_info=png_create_info_struct(read_ptr);


   png_set_read_fn(read_ptr,(voidp)&bf,user_read_data);

   png_read_info(read_ptr,info_ptr);

//#if defined(PNG_READ_tRNS_SUPPORTED) && defined(PNG_WRITE_tRNS_SUPPORTED)
   {
    png_bytep trans;
    int num_trans;
    png_color_16p trans_values;
    if(png_get_tRNS(read_ptr,info_ptr,&trans,&num_trans,&trans_values))
    {
     cprintf("trans %d",num_trans);

    }
   }
//#endif


   /* fill background */
/*
   if(info_ptr->valid & PNG_INFO_bKGD)
        png_set_background(read_ptr, &(info_ptr->background),
              PNG_BACKGROUND_GAMMA_FILE, 1, 1.0);
   else  
        png_set_background(read_ptr, &my_background,
           PNG_BACKGROUND_GAMMA_SCREEN, 0, 1.0);
*/

   /* get rid of 16 bit data */

   if(info_ptr->bit_depth==16) png_set_strip_16(read_ptr);


   if(info_ptr->interlace_type)
   {
    num_pass=png_set_interlace_handling(read_ptr);
   }
   else
   {
    num_pass=1;
   }

   png_read_update_info(read_ptr,info_ptr);

   if((info_ptr->color_type & PNG_COLOR_TYPE_PALETTE)==PNG_COLOR_TYPE_RGB)
                                                       channels=3;
   else                                                channels=1;

   if(info_ptr->color_type & PNG_COLOR_MASK_ALPHA)      channels++;

   cprintf("channels %d type %x valid %x %x",channels,info_ptr->color_type,info_ptr->valid, PNG_INFO_tRNS);



   rowbytes=((info_ptr->width*info_ptr->bit_depth*channels+7)>>3);

   err=salloc((flex_ptr)&near_row_buf,(int)rowbytes);
   if(!err)
   {
    row_buf=(png_bytep)near_row_buf;

    addframe(loadfile,&fn,0);
    loadfile->frames[fn].fxpix=(int)info_ptr->width;
    loadfile->frames[fn].fypix=(int)info_ptr->height;
    sprintf(loadfile->frames[fn].name,"PNG%d",fn);
    loadfile->frames[fn].fbpp=bpp=info_ptr->bit_depth*channels;

    if( (info_ptr->valid & PNG_INFO_pHYs) &&
        (info_ptr->phys_unit_type==PNG_RESOLUTION_METER) &&
		(info_ptr->x_pixels_per_unit>=0) &&
		(info_ptr->y_pixels_per_unit>=0)
		)
    {
     loadfile->frames[fn].fxdpi=
                             scale((int)info_ptr->x_pixels_per_unit,254,10000);
     loadfile->frames[fn].fydpi=
                             scale((int)info_ptr->y_pixels_per_unit,254,10000);
    }
    else
    {
     loadfile->frames[fn].fxdpi=pngxres;
     loadfile->frames[fn].fydpi=pngyres;
    }

    loadfile->frames[fn].xim=NULL;

	if(loadfile->frames[fn].fxdpi<=0 || loadfile->frames[fn].fxdpi>0xFFFF) loadfile->frames[fn].fxdpi=pngxres;
	if(loadfile->frames[fn].fydpi<=0 || loadfile->frames[fn].fydpi>0xFFFF) loadfile->frames[fn].fydpi=pngyres;

	cprintf("xpix %d ypix %d xdpi %x ydpi %x",loadfile->frames[fn].fxpix,loadfile->frames[fn].fypix,
											  loadfile->frames[fn].fxdpi,loadfile->frames[fn].fydpi);

	cprintf("xperunit %x yperunit %x",info_ptr->x_pixels_per_unit,info_ptr->y_pixels_per_unit);

    err=ximnew(loadfile->frames[fn].fxpix,loadfile->frames[fn].fypix,
                                            bpp,&loadfile->frames[fn].xim);

    if(!err)
    {
     loadimage=((loadfile->frames[fn].xim)->sim[IM]);
     loadimage->xdpi=loadfile->frames[fn].fxdpi;
     loadimage->ydpi=loadfile->frames[fn].fydpi;

     cmsrgbprofile(&loadimage->profile);

     if(info_ptr->color_type & PNG_COLOR_MASK_PALETTE)
     {
      loadimage->ipal.ncolours=info_ptr->num_palette;
      for(i=0;i<info_ptr->num_palette;i++)
      {
       loadimage->ipal.word[i]=(info_ptr->palette[i].red<<8) |
                               (info_ptr->palette[i].green<<16) |
                               (info_ptr->palette[i].blue<<24);
      }
     }
     else
     if((info_ptr->color_type & PNG_COLOR_TYPE_PALETTE)==PNG_COLOR_TYPE_GRAY)
     {
      imsetgreypal(loadimage,bpp);
     }

/*     dprintf(0,"trans=%d",info_ptr.num_trans); */


     for(pass=0;pass<num_pass;pass++)
     {
      for(y=0;y<info_ptr->height;y++)
      {
       if(pass>0)
       {
        err=imfind1w(loadimage,(int)y,&idata);
        if(err) break;
        memcpy(row_buf,idata,(int)rowbytes);
       }

       png_read_rows(read_ptr,(png_bytepp)&row_buf,(png_bytepp)0,1);

       err=imfind1w(loadimage,(int)y,&idata);
       if(err) break;
       memcpy(idata,row_buf,(int)rowbytes);
      }
     }


     if(bpp!=24)
     {
      for(y=0;y<info_ptr->height;y++)
      {
       imrevline(loadimage,(int)y);
      }
     }

     png_read_end(read_ptr, end_info);

     getinfo(&loadfile->frames[fn]);
    }

    sfree((flex_ptr)&near_row_buf);
   }

   png_read_destroy(read_ptr,info_ptr,end_info);
  }
  err=bf_close(&bf,err);
 }


 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}





static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;
 err=NULL;
 return(err);
 USE(userhandle);
}


/*****************************************************************************/



static os_error * savepng(char * name,int type)
{
 os_error  * err;
 png_struct  png_ptr;
 png_info    info_ptr;
 int         fn;
 imagestr  * saveimage;
 int         x;
 int         y;
 int         pass;
 int         height;
 int       * idata;
 int         i;
 int         number_passes;
 int         bpp;
 int         xpix;
 char      * p;
 char      * q;
 char      * temp;
 int         wwidth;
 int         owidth;
 int         ch;
 buffer      bf;


 err=NULL;


 memset(&info_ptr,0,sizeof(png_info));
 temp=NULL;

 fn=menuview->frame;
 saveimage=((menufile->frames[fn].xim)->sim[IM]);
 bpp=saveimage->bpp;
 xpix=saveimage->xpix;
 wwidth=((bpp*xpix+31) & ~0x1F)>>3;
	owidth=(bpp==16)?(2*wwidth):wwidth;

 err=bf_open(name,'w',BIGBUFFSIZE,&bf);
 if(!err)
 {
  /* set error handling */

  png_set_error_fn(&png_ptr,NULL,user_error,user_warning);

  if((err=(os_error*)setjmp(png_ptr.jmpbuf))!=NULL)
  {
   sfree((flex_ptr)&temp);
   png_write_destroy(&png_ptr);
   if(info_ptr.palette) sfree((flex_ptr)&info_ptr.palette);
  }
  else
  {
   /* initialize the structures */

   png_info_init(&info_ptr);
   png_write_init(&png_ptr);

   png_set_write_fn(&png_ptr,(voidp)&bf,user_write_data,user_flush_data);


   /* set the file information here */

   info_ptr.width=saveimage->xpix;
   info_ptr.height=height=saveimage->ypix;
   info_ptr.bit_depth=(unsigned char)saveimage->bpp;
   if(info_ptr.bit_depth>8) info_ptr.bit_depth=8;
   info_ptr.color_type=
                    saveimage->bpp>8?PNG_COLOR_TYPE_RGB:PNG_COLOR_TYPE_PALETTE;
   info_ptr.interlace_type=interlace;


   /* set the palette if there is one */

   if(saveimage->bpp<=8)
   {
    info_ptr.valid|=PNG_INFO_PLTE;
    err=salloc((flex_ptr)&info_ptr.palette,256*sizeof(png_color));
    if(!err)
    {
     info_ptr.num_palette=saveimage->ipal.ncolours;
 
     for(i=0;i<saveimage->ipal.ncolours;i++)
     {
      info_ptr.palette[i].red=(saveimage->ipal.word[i]>>8) & 0xFF;
      info_ptr.palette[i].green=(saveimage->ipal.word[i]>>16) & 0xFF;
      info_ptr.palette[i].blue=(saveimage->ipal.word[i]>>24) & 0xFF;
     }
    }
   }


   info_ptr.valid|=PNG_INFO_pHYs;
   info_ptr.x_pixels_per_unit=scale(saveimage->xdpi,10000,254);
   info_ptr.y_pixels_per_unit=scale(saveimage->ydpi,10000,254);
   info_ptr.phys_unit_type=PNG_RESOLUTION_METER;


   /* write the file information */
   png_write_info(&png_ptr, &info_ptr);

   /* turn on interlace handling if you are not using png_write_image() */
   if(interlace) number_passes=png_set_interlace_handling(&png_ptr);
   else          number_passes=1;


   if(!err) err=salloc((flex_ptr)&temp,owidth);
   if(!err)
   {
    for(pass=0;pass<number_passes;pass++)
    {
     for(y=0;y<height;y++)
     {
      err=imfind1r(saveimage,y,&idata);
      if(err) break;

      if(bpp==32)
      {
       q=temp;

       for(x=0;x<xpix;x++)
       {
        ch=*idata++;
        *q++=ch;
        *q++=ch>>8;
        *q++=ch>>16;
       }
      }
      else
      if(bpp==16)
      {
       q=temp;
       for(x=0;x<xpix;x++)
       {
        ch=*idata++;

        *q++=(ch<<3)&0xF8;
        *q++=(ch>>2)&0xF8;
        *q++=(ch>>7)&0xF8;

        x++;
        if(x>=xpix) break;

        *q++=(ch>>13)&0xF8;
        *q++=(ch>>18)&0xF8;
        *q++=(ch>>23)&0xF8;
       }
      }
      else
      if(bpp==24 || bpp==8)
      {
       memcpy(temp,idata,wwidth);
      }
      else
      if(bpp==1)
      {
       q=temp;
       p=(char*)idata;
       for(i=0;i<wwidth;i++) *q++=bitrev[*p++];
      }
      else
      if(bpp==2)
      {
       q=temp;
       p=(char*)idata;
       for(i=0;i<wwidth;i++) *q++=dbitrev[*p++];
      }
      else
      if(bpp==4)
      {
       q=temp;
       p=(char*)idata;
       for(i=0;i<wwidth;i++) *q++=nybrev[*p++];
      }

      png_write_rows(&png_ptr,(png_byte**)&temp,1);
     }
    }

    sfree((flex_ptr)&temp);
   }

   /* write the rest of the file */

   png_write_end(&png_ptr,&info_ptr);

   /* clean up after the write, and free any memory allocated */
   png_write_destroy(&png_ptr);

   /* if you malloced the palette, free it here */
   if(info_ptr.palette) sfree((flex_ptr)&info_ptr.palette);
  }
  bf_closec(&bf,err,name,type);
 }
 return(err);
}



/*****************************************************************************/



static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}




static os_error * configloaded(int eventn,uservalue userhandle,void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {

  dbl=ftypegetrun(&ftype);

//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
  interlace=tinterlace;
  pngxres=txres;
  pngyres=tyres;
 }

 return(err);
}



static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}






static os_error * wrpc(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdpc(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}



static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,
    3, &tinterlace,  DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
    5, &txres,       DBWRITE,  0,   0,      7, -1,  7,-1, rdpc, wrpc,
    7, &tyres,       DBWRITE,  0,   0,     -1,  5, -1, 5, rdpc, wrpc,


   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TPNG,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);
 
 tdbl=dbl;
 tinterlace=interlace;
 txres=pngxres;
 tyres=pngyres;

 err=dodboxparent(&configbox,1,parent);


 return(err);
}

/*****************************************************************************/


static ftypestr ftype=
{
 PNG,             /* file type  */
 0,               /* flags      */
 loadpng,         /* load       */
 loadfilepost,    /* loadpost   */
 "{PNG}",         /* name       */
 "{PNG}",         /* type name  */
 savepng,         /* save       */
 config,          /* configure  */
 0,               /* icon       */
 bits,            /* bit flags  */
 NULL,            /* get frame  */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,            /* file info  */


 NULL,            /* saveim */
 "png\0""b60\0",  /* extension */

 "Portable Network Graphics (*.png)",/* description */
};




static contag contable[5]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "Interlace",CONINT,&interlace,NULL,NULL,
 "DefaultXRes",CONINT,&pngxres,NULL,NULL,
 "DefaultYRes",CONINT,&pngyres,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "PNG",
 NULL,
 NULL
};



os_error * pnginit(void)
{
 os_error * err;

 err=registerfiletype(&ftype);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);
 }

 return(err);
}


