/*->c.pcx */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"
#include "bitrev.h"
#include "deb.h"


#include "constants.h"
#include "str.h"
#include "reslink.h"

#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "units.h"
#include "cms.h"

#include "pcx.h"


extern ftypestr ftype;
extern dboxstr  configbox;



/*****************************************************************************/

/*
**      PCX File Header Structure
*/


static int tdbl;
static int dbl;
static int pcxplanes=1; /* use seemingly correct interlaced planes for 4bpp */

static int pcxxres=90;
static int pcxyres=45;
static int txres;
static int tyres;


typedef char XBYTE;



typedef struct pcxhdr
{
 XBYTE    manufacturer;  /*      10 == ZSoft */
 XBYTE    version;       /*      0 = Paintbrush 2.5
                             ** 2 = 2.8 with palette
                             ** 3 = 2.8 without palette
                             ** 4 = PC Paintbrush for Windows
                             ** 5 = Version 3.0+ and Publishers Paintbrush */

 XBYTE   encode;                 /*      1 = PCX RLE */
 XBYTE   bitsPerPixel;           /* 1, 2, 4, or 8 */
 short   minX;                                   /* Window dimensions */
 short   minY;
 short   maxX;
 short   maxY;
 short   horzDpi;                /* Horizontal dots per inch */
 short   vertDpi;                /* Vertical dots per inch */
 XBYTE   pal1[48];               /* palette */
 XBYTE   junk;
 XBYTE   planes;                 /* number of color planes */
 short   bytesPerLine;           /* number of bytes per scanline */
 short   paltype;                /* 1 = Color, 2 = GrayScale */
 short   hScreenSize;            /* Horizontal Screen Size */
 short   vScreenSize;            /* Vertical Screen Size */
 XBYTE   filler[54];

} PCXHDR;

/*
**      Note: Version 5 images may contain a 256 color palette at the end of the
**      file.  Check for it by checking if the byte 769 bytes before the end of
**      the file is 12.
*/


#define PCXPALSIZE 769

typedef struct pcxpal256
{
 XBYTE         pal2[PCXPALSIZE];
} PCXPAL256;


/*
**      Bit masks for planar decoding
*/
static XBYTE LowMasks[4]  ={ 0x01, 0x02, 0x04, 0x08 };
static XBYTE HighMasks[4] ={ 0x10, 0x20, 0x40, 0x80 };

/*
**      Default 16 color VGA palette
*/

static char DefaultPalette[48]=
{
           0,   0,   0,
           0,   0, 255,
           0, 255,   0,
           0, 255, 255,
         255,   0,   0,
         255,   0, 255,
         255, 255,   0,
         255, 255, 255,
          85,  85, 255,
          85,  85,  85,
           0, 170,   0,
         170,   0,   0,
          85, 255, 255,
         255,  85, 255,
         255, 255,  85,
         255, 255, 255
};


/*
** PcxNextByte(
**   BYTE *byte,              pointer to resultant value
**   int *count,              pointer to repeat count, 1 if no repeat
**   HANDLE fileHandle);      handle of file being read
**
**    Get the next byte from the PCX file, and determine if it is a repeat
**      string or a literal byte.
**
*/


static os_error * PcxNextByte(XBYTE *byte,int *count,buffer * bf)
{
 int value;
 os_error * err;
 *count=1;

 err=bf_getc(bf,&value);
 if(!err)
 {
  /*
   **   Check for a repeat count, indicated by the two high bits being set
   */
   if(0x00c0==(0x00c0 & value))
   {
    *count=0x3f & value;
    err=bf_getc(bf,&value);
   }
   *byte=(char)value;
 }
 return(err);
}





static os_error * getinfo(framestr * frame,PCXHDR * pcxHeader,int pal)
{
 char   string[256];
 char * p;

 p=string;

 p+=sprintf(p,"PC Paintbrush file - %d\n",pcxHeader->version);
 p+=sprintf(p,"%d x %d pixels, %d bpp\n",frame->fxpix,
                                         frame->fypix,frame->fbpp);
 p+=sprintf(p,"%d raw bpp %d plane%c\n",
      pcxHeader->bitsPerPixel,pcxHeader->planes,pcxHeader->planes>1?'s':' ');
 if(pal==0) p+=sprintf(p,"Palette");
 else
 if(pal==1) p+=sprintf(p,"Default palette");
 else
 if(pal==2) p+=sprintf(p,"No palette");

 return(infowrite(string,frame));
}




static os_error * ReadPcxFile(buffer * bf,int len)
{
 os_error               * err;
 char                   * palPtr;
 int                      i, j, colors, count, plane;
 XBYTE                    chr, mask, bit, highbit;
 PCXHDR                   pcxHeader;
 PCXPAL256                pcxPal;
 int                      l, imageBytes, bytesPerScanLine;
 char                   * pixels;

 int                      xpix;
 int                      ypix;
 int                      x;
 int                      y;
 int                      xbytes;

 int                      fn;
 imagestr               * loadimage;
 int                    * idata;
 int                      bpp;
 int                      paltype;


 /*
  **      Read in the header information, and verify it
  */

 err=bf_read(bf,&pcxHeader,sizeof(pcxHeader));
 if(err) return(err);


 if(pcxHeader.manufacturer!=10)
 {
  /* error */

 }

 if(pcxHeader.bitsPerPixel*pcxHeader.planes==1)
 {
  colors=2;
 }
 else
 {
  colors=16;
 }

 /*
  **      Set palPtr to point to the palette for this image
  */
 
 palPtr=(char*)pcxHeader.pal1;
 if(pcxHeader.version==5 && len>PCXPALSIZE)
 {
  bf_seek(bf,len-PCXPALSIZE);
  err=bf_read(bf,&pcxPal,PCXPALSIZE);

  if(!err && pcxPal.pal2[0]==12)
  {
   colors=256;
   palPtr=(char*)&pcxPal.pal2[1];
  }
 }

 xpix=1+pcxHeader.maxX-pcxHeader.minX;
 ypix=1+pcxHeader.maxY-pcxHeader.minY;
 bpp=pcxHeader.bitsPerPixel*pcxHeader.planes;
 if(bpp==3) bpp=4;


 pcxHeader.horzDpi=(short)pcxxres;  /* Horizontal dots per inch */
 pcxHeader.vertDpi=(short)pcxyres;

 addframe(loadfile,&fn,0);
 loadfile->frames[fn].fxpix=xpix;
 loadfile->frames[fn].fypix=ypix;
 sprintf(loadfile->frames[fn].name,"PCX%d",fn);
 loadfile->frames[fn].fbpp=bpp;
 loadfile->frames[fn].fxdpi=pcxHeader.horzDpi;
 loadfile->frames[fn].fydpi=pcxHeader.vertDpi;
 loadfile->frames[fn].xim=NULL;


 err=ximnew(loadfile->frames[fn].fxpix,loadfile->frames[fn].fypix,
                          loadfile->frames[fn].fbpp,&loadfile->frames[fn].xim);
 if(err) return(err);

 loadimage=((loadfile->frames[fn].xim)->sim[IM]);
 loadimage->xdpi=loadfile->frames[fn].fxdpi;
 loadimage->ydpi=loadfile->frames[fn].fydpi;

 cmsrgbprofile(&loadimage->profile);

 /*
  **      Fill in intensities for all palette entry colors.  Note the order
  **      change between PCX and DIB.
  */

  loadimage->ipal.ncolours=colors;
  for(i=0;i<colors;++i)
  {
   loadimage->ipal.word[i]=(palPtr[2]<<24)|
                           (palPtr[1]<<16)|
                           (palPtr[0]<<8);
   palPtr+=3;
  }

  /*
   **      Not all PCX files have a valid palette
   */
 
 if(pcxHeader.version==2 || pcxHeader.version>=4)
 {
  for(i=0;i<colors;i++)
  {
   if(loadimage->ipal.word[i]!=0) break;
  }
 }
 else
 {
  i=colors;
 }

 paltype=0;

 if(i==colors)
 {
  if(colors<=16)
  {
   /*
    **      Use default 16 color palette
    */

   paltype=1;

   if(bpp==1)
   {
    loadimage->ipal.word[0]=0;
    loadimage->ipal.word[1]=0xFFFFFF00;
   }
   else
   for(i=0;i<colors;++i)
   {
    loadimage->ipal.word[i]=(DefaultPalette[i*3+2]<<24)|
                            (DefaultPalette[i*3+1]<<16)|
                            (DefaultPalette[i*3+0]<<8);
   }
  }
  else
  {
   /*
    **      Use default Windows Palette
    */

    /* arrgh ! */
   paltype=2;
  }
 }

 getinfo(&loadfile->frames[fn],&pcxHeader,paltype);

 imzero(loadimage);


 /*
  **      Now to do the actual image reading
  */

 bf_seek(bf,sizeof(pcxHeader));
 bytesPerScanLine=pcxHeader.bytesPerLine*pcxHeader.planes;
 imageBytes=bytesPerScanLine*ypix;

 x=0;
 xbytes=0;
 y=0;
 plane=0;

 err=imfind1w(loadimage,y,&idata);
 if(err) return(err);

 pixels=(char*)idata;

 if(bpp==1)
 {
  for(l=0;l<imageBytes;)
  {
   if((err=PcxNextByte(&chr,&count,bf))!=NULL) return(err);

   for(i=0;i<count;i++)
   {
    *pixels++=bitrev[chr];

    xbytes++;
    if(xbytes>=pcxHeader.bytesPerLine)
    {
     y++;

     if(y>=ypix)
     {
      l=imageBytes;
      break;
     }
     else
     {
      xbytes=0;
      err=imfind1w(loadimage,y,&idata);
      if(err) return(err);
      pixels=(char*)idata;
     }
    }
   }
   l+=count;
  }
 }
 else
 if(bpp==2)
 {
  for(l=0;l<imageBytes;)
  {
   if((err=PcxNextByte(&chr,&count,bf))!=NULL) return(err);

   for(i=0;i<count;i++)
   {
    *pixels++=dbitrev[chr];

    xbytes++;
    if(xbytes>=pcxHeader.bytesPerLine)
    {
     y++;

     if(y>=ypix)
     {
      l=imageBytes;
      break;
     }
     else
     {
      xbytes=0;
      err=imfind1w(loadimage,y,&idata);
      if(err) return(err);
      pixels=(char*)idata;
     }
    }
   }
   l+=count;
  }
 }
 else
 if(bpp==4 && pcxHeader.planes>1)
 {
  imzero(loadimage);
  highbit=LowMasks[plane];
  bit=HighMasks[plane];

  for(l=0;l<imageBytes;)
  {
   if((err=PcxNextByte(&chr,&count,bf))!=NULL) return(err);

   for(i=0;i<count;++i)
   {
    for(j=0;j<8;j+=2)
    {
     mask=(0x80>>j);

     if(chr & mask)
     {
      *pixels|=highbit;
     }

     mask>>=1;
     if(chr & mask)
     {
      *pixels|=bit;
     }

     pixels++;
    }

    xbytes++;
    if(xbytes>=pcxHeader.bytesPerLine)
    {
     plane++;
     xbytes=0;

     if(plane>=pcxHeader.planes)
     {
      plane=0;
      y++;

      if(y>=ypix)
      {
       l=imageBytes;
       break;
      }
      else
      {
       err=imfind1w(loadimage,y,&idata);
       if(err) return(err);
       pixels=(char*)idata;
       highbit=LowMasks[plane];
       bit=HighMasks[plane];
      }
     }
     else
     {
      pixels=(char*)idata;
      highbit=LowMasks[plane];
      bit=HighMasks[plane];
     }
    }
   } 
   l+=count;
  } 
 }
 else
 if(bpp==4)
 {
  for(l=0;l<imageBytes;)
  {
   if((err=PcxNextByte(&chr,&count,bf))!=NULL) return(err);

   for(i=0;i<count;i++)
   {
    *pixels++=nybrev[chr];

    xbytes++;
    if(xbytes>=pcxHeader.bytesPerLine)
    {
     y++;

     if(y>=ypix)
     {
      l=imageBytes;
      break;
     }
     else
     {
      xbytes=0;
      err=imfind1w(loadimage,y,&idata);
      if(err) return(err);
      pixels=(char*)idata;
     }
    }
   }
   l+=count;
  }
 }
 else
 if(bpp==8)
 {
  for(l=0;l<imageBytes;)
  {
   if((err=PcxNextByte(&chr,&count,bf))!=NULL) return(err);

   for(i=0;i<count;++i)
   {
    *pixels++=chr;

    xbytes++;
    if(xbytes>=pcxHeader.bytesPerLine)
    {
     y++;

     if(y>=ypix)
     {
      l=imageBytes;
      break;
     }
     else
     {
      xbytes=0;
      err=imfind1w(loadimage,y,&idata);
      if(err) return(err);
      pixels=(char*)idata;
     }
    }
   }
   l+=count;
  }
 }
 return(err);
}





static os_error * loadpcx(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;
 buffer      bf;
 fstat       stat;

 err=fs_stat(name,&stat);

 err=bf_open(name,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  err=ReadPcxFile(&bf,stat.length);

  err=bf_close(&bf,err);
 }

 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}



static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;

 err=NULL;

 return(err);
 USE(userhandle);
}


/*****************************************************************************/

static int  pcxcount;

static os_error *  pcxputc(buffer * bf,int c)
{
 os_error *  err;
 static int  acc;

 err=NULL;

 if(!pcxcount)
 {
  acc=c;
  pcxcount=1;
 }
 else
 if(c!=acc || pcxcount>=15) 
 {
  if(pcxcount>1 || ((acc & 0xC0)==0xC0))
  {
   bf_putc(bf,0xC0|pcxcount);
  }
  err=bf_putc(bf,acc);

  acc=c;
  pcxcount=1;
 }
 else
 {
  pcxcount++;
 }
 return(err);
}



static os_error * savepcx(char * name,int type)
{
 os_error * err;
 buffer      bf;
 PCXHDR      pcx;

 int         xpix;
 int         ypix;
 int         bpp;
 int         sbpp;
 char      * p;
 int         fn;
 int       * idata;
 imagestr  * saveimage;
 int         x;
 int         y;
 int         i;

 int         bit;
 int         highbit;
 int         plane;
 int         ch;
 int         mask;


 fn=menuview->frame;
 saveimage=((menufile->frames[fn].xim)->sim[IM]);

 xpix=saveimage->xpix;
 ypix=saveimage->ypix;
 bpp=saveimage->bpp;

 pcxcount=0;    /* prime rle coder */

 if(bpp>8)
 {
  err=geterror(EBADBITS);

 }
 else
 {
  err=bf_open(name,'w',DEFBUFFSIZE,&bf);
  if(!err)
  {
   sbpp=(bpp==4)?1:bpp;

   pcx.manufacturer=10;

   if(bpp<8) pcx.version=2;
   else      pcx.version=5;

   pcx.encode=1;
   pcx.bitsPerPixel=(char)sbpp;
   pcx.minX=0;
   pcx.minY=0;
   pcx.maxX=(short)(xpix-1);
   pcx.maxY=(short)(ypix-1);
   pcx.horzDpi=(short)saveimage->xdpi;
   pcx.vertDpi=(short)saveimage->ydpi;

   memset(&pcx.pal1,0,sizeof(pcx.pal1));

   if(bpp<8)
   {
    p=(char*)&pcx.pal1;

    for(i=0;i<saveimage->ipal.ncolours;i++)
    {
     *p++=(char)(saveimage->ipal.word[i]>>8);
     *p++=(char)(saveimage->ipal.word[i]>>16);
     *p++=(char)(saveimage->ipal.word[i]>>24);
    }
   }

   pcx.junk=0;
   pcx.planes=(char)((bpp==4)?4:1);

   pcx.bytesPerLine=(short)(((xpix*sbpp+0x7) & ~0x7)>>3);

   pcx.paltype=1;  /* 1 = Color, 2 = GrayScale */
   pcx.hScreenSize=640;
   pcx.vScreenSize=480;
   memset(&pcx.filler,0,sizeof(pcx.filler));

   err=bf_write(&bf,&pcx,sizeof(pcx));
   if(!err)
   {
    for(y=0;y<ypix;y++)
    {
     err=imfind1r(saveimage,y,&idata);
     if(err) break;
     p=(char*)idata;

     if(bpp==1)
     {
      for(x=0;x<pcx.bytesPerLine;x++)
      {
       pcxputc(&bf,bitrev[*p++]);
      }
     }
     else
     if(bpp==2)
     {
      for(x=0;x<pcx.bytesPerLine;x++)
      {
       pcxputc(&bf,dbitrev[*p++]);
      }
     }
     else
     if(bpp==4 && pcxplanes)
     {
      for(plane=0;plane<4;plane++)
      {
       p=(char*)idata;
       highbit=LowMasks[plane];
       bit=HighMasks[plane];

       for(x=0;x<pcx.bytesPerLine;x++)
       {
        mask=0;

        ch=*p++;
        if(ch & highbit) mask|=0x80;
        if(ch & bit)     mask|=0x40;
        ch=*p++;
        if(ch & highbit) mask|=0x20;
        if(ch & bit)     mask|=0x10;
        ch=*p++;
        if(ch & highbit) mask|=0x08;
        if(ch & bit)     mask|=0x04;
        ch=*p++;
        if(ch & highbit) mask|=0x02;
        if(ch & bit)     mask|=0x01;

        pcxputc(&bf,mask);
       }
      }
     }
     else
     if(bpp==4)
     {
      for(x=0;x<pcx.bytesPerLine;x++)
      {
       pcxputc(&bf,nybrev[*p++]);
      }
     }
     else
     if(bpp==8)
     {
      for(x=0;x<pcx.bytesPerLine;x++)
      {
       pcxputc(&bf,*p++);
      }
     }
    }
    pcxputc(&bf,-1);

    if(bpp==8)
    {
     bf_putc(&bf,12);

     for(i=0;i<saveimage->ipal.ncolours;i++)
     {
      bf_putc(&bf,saveimage->ipal.word[i]>>8);
      bf_putc(&bf,saveimage->ipal.word[i]>>16);
      bf_putc(&bf,saveimage->ipal.word[i]>>24);
     }
    }
   }
   err=bf_closec(&bf,err,name,type);
  }
 }
 return(err);
}


/*****************************************************************************/



static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}




static os_error * configloaded(int eventn,uservalue userhandle,
                                                        void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {

  dbl=ftypegetrun(&ftype);

//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

// cprintf("conf close %d",code);

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
  dbl=tdbl;

// cprintf("new res %d %d",pcxxres,pcxyres);

  pcxxres=txres;
  pcxyres=tyres;
 }

 return(err);
}





static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}






static os_error * wrpc(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdpc(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}




static dbiconstr configicondefs[7]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,
    4, &txres,       DBWRITE,  0,   0,      6, -1,  6,-1, rdpc, wrpc,
    6, &tyres,       DBWRITE,  0,   0,     -1,  4, -1, 4, rdpc, wrpc,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TPCX,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);
 
 tdbl=dbl;
 txres=pcxxres;
 tyres=pcxyres;

 err=dodboxparent(&configbox,1,parent);


 return(err);
}

/*****************************************************************************/


static ftypestr ftype=
{
 PCX,             /* file type  */
 0,               /* flags      */
 loadpcx,         /* load       */
 loadfilepost,    /* loadpost   */
 "{PCX}",         /* name       */
 "{PCX}",         /* type name  */ 
 savepcx,         /* save       */
 config,          /* configure  */
 0,               /* icon       */
 bits,            /* bit flags  */
 NULL,            /* get frame  */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,            /* save info  */

 NULL,            /* saveim */
 "pcx\0""697\0",  /* extension */

 "PC Paintbrush (*.pcx)", /* description */
};



static contag contable[4]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "DefaultXRes",CONINT,&pcxxres,NULL,NULL,
 "DefaultYRes",CONINT,&pcxyres,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "PCX",
 NULL,
 NULL
};



os_error * pcxinit(void)
{
 os_error * err;

 err=registerfiletype(&ftype);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);
 }

 return(err);
}


