/*->c.pbm */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <setjmp.h>


#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"


#include "constants.h"
#include "str.h"

#include "reslink.h"
#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "units.h"
#include "cms.h"

#include "pbm.h"


extern ftypestr ftype;
extern dboxstr  configbox;


static int tdbl;
static int trawbits;
static int dbl;
static int rawbits;

static int pbmxres=90;
static int pbmyres=45;
static int txres;
static int tyres;



static int pbmgettoken(char * string,buffer * bf)
{
 os_error * err;
 int        c;
 char     * p;

 p=string;

 while(1)
 {
  while(1)
  {
   err=bf_getc(bf,&c);
   if(err || c==EOF) return(0);
   if(c>' ') break;
  }
  if(c=='#')
  {
   while(1)
   {
    err=bf_getc(bf,&c);
    if(err || c==EOF) return(0);
    if(c<' ') break;
   }
  }
  else break;
 }

 while(1)
 {
  *p++=(char)c;
  err=bf_getc(bf,&c);
  if(err) return(0);
  if(c<=' ') break;
 }

 *p=0;
 return(1);
}


static char * filename[]=
{
 "Portable bit map",
 "Portable grey map",
 "Portable pixel map"
};


static os_error * getinfo(framestr * frame,int type,int maxval)
{
 char   string[256];
 char * p;

 p=string;

 p+=sprintf(p,"%s - %d\n",filename[type & 3],type);
 p+=sprintf(p,"%d x %d pixels %d bpp\n",frame->fxpix,frame->fypix,frame->fbpp);
 p+=sprintf(p,"Maxval %d. Rawbits %s",maxval,type>3?"Yes":"No");

 return(infowrite(string,frame));
}


static os_error * loadpbm(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;
 buffer      bf;
 int         ptype;
 char        string[16];
 int         xpix;
 int         ypix;
 int         maxval;
 int         bpp;
 int       * idata;
 int         fn;
 imagestr  * loadimage;
 int         x;
 int         y;
 int         val;
 char      * p;
 int       * w;
 int         shift;
 int         word;
 int         pshift;
 int         pword;


 err=bf_open(name,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  if(pbmgettoken(string,&bf))
  {
   if(string[0]=='P')
   {
    ptype=string[1]-'0';
    if(ptype>=1 && ptype<=6)
    {
     pbmgettoken(string,&bf);
     xpix=atoi(string);
     pbmgettoken(string,&bf);
     ypix=atoi(string);

     bpp=1;      /* compiler */
     maxval=255; /* compiler */


     if(ptype==1 || ptype==4) /* PBM */
     {
      bpp=1;
     }
     else
     if(ptype==2 || ptype==5) /* PGM */
     {
      bpp=8;
      pbmgettoken(string,&bf);
      maxval=atoi(string);
     }
     else
     if(ptype==3 || ptype==6) /* PPM */
     {
      bpp=24;
      pbmgettoken(string,&bf);
      maxval=atoi(string);
     }

     addframe(loadfile,&fn,0);
     loadfile->frames[fn].fxpix=xpix;
     loadfile->frames[fn].fypix=ypix;
     sprintf(loadfile->frames[fn].name,"PBM%d",fn);
     bf_tell(&bf,&loadfile->frames[fn].offset);
     loadfile->frames[fn].fbpp=bpp;
     loadfile->frames[fn].fxdpi=pbmxres;
     loadfile->frames[fn].fydpi=pbmyres;
     loadfile->frames[fn].xim=NULL;

     getinfo(&loadfile->frames[fn],ptype,maxval);


     /* now load image data */

     err=ximnew(loadfile->frames[fn].fxpix,loadfile->frames[fn].fypix,
                          loadfile->frames[fn].fbpp,&loadfile->frames[fn].xim);

     if(!err)
     {
      loadimage=((loadfile->frames[fn].xim)->sim[IM]);
      loadimage->xdpi=loadfile->frames[fn].fxdpi;
      loadimage->ydpi=loadfile->frames[fn].fydpi;
      loadimage->ipal.ncolours=0;
      cmsrgbprofile(&loadimage->profile);

      if(ptype==1) /* PBM !rawbits */
      {
       imsetgreypal(loadimage,bpp);

       for(y=0;y<ypix;y++)
       {
        err=imfind1w(loadimage,y,&idata);
        if(err) break;

        w=idata;
        word=0;
        shift=0;

        for(x=0;x<xpix;x++)
        {
         if(shift==32)
         {
          *w++=word;
          word=0;
          shift=0;
         }
         pbmgettoken(string,&bf);
         if(*string=='0') word|=(1<<shift);
         shift++;
        }
        *w=word;
       }
      }
      else
      if(ptype==2) /* PGM !rawbits */
      {
       imsetgreypal(loadimage,bpp);

       for(y=0;y<ypix;y++)
       {
        err=imfind1w(loadimage,y,&idata);
        if(err) break;

        p=(char*)idata;
        for(x=0;x<xpix;x++)
        {
         pbmgettoken(string,&bf);
         val=(atoi(string)*255)/maxval;
         *p++=(char)val;
        }
       }
      }
      else
      if(ptype==3) /* PPM !rawbits */
      {
       for(y=0;y<ypix;y++)
       {
        err=imfind1w(loadimage,y,&idata);
        if(err) break;

        p=(char*)idata;
        for(x=0;x<xpix;x++)
        {
         pbmgettoken(string,&bf);
         val=(atoi(string)*255)/maxval;
         *p++=(char)val;
         pbmgettoken(string,&bf);
         val=(atoi(string)*255)/maxval;
         *p++=(char)val;
         pbmgettoken(string,&bf);
         val=(atoi(string)*255)/maxval;
         *p++=(char)val;
        }
       }
      }
      else
      if(ptype==4) /* PBM rawbits */
      {
       imsetgreypal(loadimage,bpp);

       for(y=0;y<ypix;y++)
       {
        err=imfind1w(loadimage,y,&idata);
        if(err) break;

        w=idata;
        word=0;
        shift=0;
        pshift=-1;
        pword=0;

        for(x=0;x<xpix;x++)
        {
         if(pshift<0)
         {
          bf_getc(&bf,&pword);
          pshift=7;
         }

         word|=((pword>>pshift) & 0x1)<<shift;
         pshift--;
         shift++;
         if(shift>=32)
         {
          *w++=word ^ 0xFFFFFFFF;
          word=0;
          shift=0;
         }
        }
        if(shift) *w=word ^ 0xFFFFFFFF;
       }
      }
      else
      if(ptype==5) /* PGM rawbits */
      {
       imsetgreypal(loadimage,bpp);

       for(y=0;y<ypix;y++)
       {
        err=imfind1w(loadimage,y,&idata);
        if(err) break;

        err=bf_read(&bf,idata,xpix);
        if(err) break;

        if(maxval!=255)
        {
         p=(char*)idata;
         for(x=0;x<xpix;x++) {*p=(char)(((*p)*255)/maxval);p++;}
        }
       }
      }
      else
      if(ptype==6) /* PPM rawbits */
      {
       for(y=0;y<ypix;y++)
       {
        err=imfind1w(loadimage,y,&idata);
        if(err) break;

        err=bf_read(&bf,idata,xpix*3);
        if(err) break;


        if(maxval!=255)
        {
         p=(char*)idata;
         for(x=0;x<xpix;x++)
         {
          *p=(char)(((*p)*255)/maxval);p++;
          *p=(char)(((*p)*255)/maxval);p++;
          *p=(char)(((*p)*255)/maxval);p++;
         }
        }
       }
      }
     }
    }
   }
  }                                                                          
  err=bf_close(&bf,err);
 }

 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}



static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;

 err=NULL;

 return(err);
 USE(userhandle);
}


static os_error * savepbm(char * name,int type)
{
 os_error  * err;
 int         fn;
 imagestr  * saveimage;
 buffer      bf;
 int         y;
 int         x;
 int         ypix;
 int         xpix;
 int       * idata;
 int         bpp;
 int         count;
 char      * p;
 int         shift;
 int         word;
 int         mask;
 int         sstep;
 int         sbyte;

 int         pshift;
 int         pword;


 fn=menuview->frame;
 saveimage=((menufile->frames[fn].xim)->sim[IM]);
 ypix=saveimage->ypix;
 xpix=saveimage->xpix;
 bpp=saveimage->bpp;
 count=0;

 if(bpp==1) {mask=0x1;sstep=1;}
 else
 if(bpp==2) {mask=0x3;sstep=2;}
 else
 if(bpp==4) {mask=0xF;sstep=4;}
 else       {mask=0xFF;sstep=8;}



 {
  err=bf_open(name,'w',DEFBUFFSIZE,&bf);
  if(!err)
  {
   if(imbw(saveimage))    /* save a pbm */
   {
    /* P1 or P4 for rawbits       */
    /* xpix ypix \n               */
    /* maxval    \n               */
    /* 0 1 0 1 0 0 1              */
    /* or 8 bit bytes for rawbits */

    bf_printf(&bf,"%s\n",rawbits?"P4":"P1");
    bf_printf(&bf,"%d %d\n",saveimage->xpix,saveimage->ypix);

    if(rawbits)
    {
     pshift=7;
     pword=0;

     for(y=0;y<ypix;y++)
     {
      err=imfind1r(saveimage,y,&idata);
      if(err) break;

      word=0;   /* compiler */
      shift=32;

      for(x=0;x<xpix;x++)
      {
       if(shift==32)
       {
        word=*idata++;
        shift=0;
        if(saveimage->ipal.word[0]) word^=0xFFFFFFFF;
       }

       sbyte=(word>>shift)&mask;
       shift+=sstep;

       if(!sbyte) pword|=(1<<pshift);
       pshift--;
       if(pshift<0)
       {
        bf_putc(&bf,pword);
        pword=0;
        pshift=7;
       }
      }
      if(err) break;
     }

     if(pshift<7)    /* clean up any bits left */
     { 
      bf_putc(&bf,pword);
     }
    }
    else   /* not rawbits */
    {
     for(y=0;y<ypix;y++)
     {
      err=imfind1r(saveimage,y,&idata);
      if(err) break;

      if(bpp<=8)
      {
       word=0;   /* compiler */
       shift=32;

       for(x=0;x<xpix;x++)
       {
        if(shift==32)
        {
         word=*idata++;
         shift=0;
        }
        sbyte=(word>>shift)&mask;
        sbyte=saveimage->ipal.word[sbyte];
        shift+=sstep;
        bf_printf(&bf,"%c%c",sbyte?'0':'1',count!=30?' ':'\n');
        count+=1;
        if(count>30) count=0;
       }
      }
      if(err) break;
     }
    }
   }
   else
   if(imgrey(saveimage))  /* save a pgm */
   {
    /* P2 or P5 for rawbits */
    /* xpix ypix \n */
    /* maxval    \n */
    /* rgb triplets */

    bf_printf(&bf,"%s\n",rawbits?"P5":"P2");
    bf_printf(&bf,"%d %d\n",saveimage->xpix,saveimage->ypix);
    bf_printf(&bf,"%d\n",255);

    if(rawbits)
    {
     for(y=0;y<ypix;y++)
     {
      err=imfind1r(saveimage,y,&idata);
      if(err) break;

      if(bpp<=8)
      {
       word=0;   /* compiler */
       shift=32;

       for(x=0;x<xpix;x++)
       {
        if(shift==32)
        {
         word=*idata++;
         shift=0;
        }
        sbyte=(word>>shift)&mask;
        shift+=sstep;
        sbyte=saveimage->ipal.word[sbyte];
        bf_putc(&bf,sbyte>>8);
       }
      }
      if(err) break;
     }
    }
    else   /* not rawbits */
    {
     for(y=0;y<ypix;y++)
     {
      err=imfind1r(saveimage,y,&idata);
      if(err) break;

      if(bpp<=8)
      {
       word=0;   /* compiler */
       shift=32;

       for(x=0;x<xpix;x++)
       {
        if(shift==32)
        {
         word=*idata++;
         shift=0;
        }
        sbyte=(word>>shift)&mask;
        shift+=sstep;
        sbyte=saveimage->ipal.word[sbyte];
        bf_printf(&bf,"%3d%c",(sbyte>>8) & 0xFF,count!=15?' ':'\n');
        count+=1;
        if(count>15) count=0;
       }
      }
      if(err) break;
     }
    }
   }
   else                   /* save a ppm */
   {
    /* P3 or P6 for rawbits */
    /* xpix ypix \n */
    /* maxval    \n */
    /* rgb triplets */

    bf_printf(&bf,"%s\n",rawbits?"P6":"P3");
    bf_printf(&bf,"%d %d\n",saveimage->xpix,saveimage->ypix);
    bf_printf(&bf,"%d\n",255);

    if(rawbits)
    {
     for(y=0;y<ypix;y++)
     {
      err=imfind1r(saveimage,y,&idata);
      if(err) break;

      if(bpp<=8)
      {
       word=0;   /* compiler */
       shift=32;

       for(x=0;x<xpix;x++)
       {
        if(shift==32)
        {
         word=*idata++;
         shift=0;
        }
        sbyte=(word>>shift)&mask;
        shift+=sstep;
        sbyte=saveimage->ipal.word[sbyte];
        bf_putc(&bf,sbyte>>8);
        bf_putc(&bf,sbyte>>16);
        bf_putc(&bf,sbyte>>24);
       }
      }
      else
      if(saveimage->bpp==24)
      {
       err=bf_write(&bf,idata,xpix*3);
       if(err) break;
      }
      else
      if(saveimage->bpp==16)
      {
       shift=32;
       mask=0x7FFF;
       sstep=16;
       word=0; /* compiler */

       for(x=0;x<xpix;x++)
       {
        if(shift==32)
        {
         word=*idata++;
         shift=0;
        }
        sbyte=(word>>shift)&mask;
        shift+=sstep;

        bf_putc(&bf,(sbyte<<3)&0xF8);
        bf_putc(&bf,(sbyte>>2)&0xF8);
        bf_putc(&bf,(sbyte>>7)&0xF8);
       }
      }
      else
      if(saveimage->bpp==32)
      {
       for(x=0;x<xpix;x++)
       {
        err=bf_write(&bf,idata,3);
        if(err) break;
        idata++;
       }
      }
      if(err) break;
     }
    }
    else   /* not rawbits */
    {
     for(y=0;y<ypix;y++)
     {
      err=imfind1r(saveimage,y,&idata);
      if(err) break;

      if(bpp<=8)
      {
       word=0;   /* compiler */
       shift=32;

       for(x=0;x<xpix;x++)
       {
        if(shift==32)
        {
         word=*idata++;
         shift=0;
        }
        sbyte=(word>>shift)&mask;
        shift+=sstep;
        sbyte=saveimage->ipal.word[sbyte];
        bf_printf(&bf,"%3d %3d %3d%c",(sbyte>>8) & 0xFF,
                                    (sbyte>>16) & 0xFF,
                                    (sbyte>>24) & 0xFF,count!=15?' ':'\n');
        count+=3;
        if(count>15) count=0;
       }
      }
      else
      if(bpp==24)
      {
       p=(char*)idata;
       for(x=0;x<xpix;x++)
       {
        err=bf_printf(&bf,"%3d %3d %3d%c",p[0],p[1],p[2],count!=15?' ':'\n');
        p+=3;
        if(err) break;
        count+=3;
        if(count>15) count=0;
       }
      }
      else
      if(bpp==16)
      {
       shift=32;
       mask=0x7FFF;
       sstep=16;
      
       for(x=0;x<xpix;x++)
       {
        if(shift==32)
        {
         word=*idata++;
         shift=0;
        }
        sbyte=(word>>shift)&mask;
        shift+=sstep;

        err=bf_printf(&bf,"%3d %3d %3d%c",(sbyte<<3)&0xF8,
                                          (sbyte>>2)&0xF8,
                                          (sbyte>>7)&0xF8,count!=15?' ':'\n');
        count+=3;
        if(count>15) count=0;
       }
      }
      else
      if(bpp==32)
      {
       p=(char*)idata;
       for(x=0;x<xpix;x++)
       {
        err=bf_printf(&bf,"%3d %3d %3d%c",p[0],p[1],p[2],count!=15?' ':'\n');
        p+=4;
        if(err) break;
        count+=3;
        if(count>15) count=0;
       }
      }
      if(err) break;
     }
    }
   }
   err=bf_closec(&bf,err,name,type);
  }
 }
 return(err);
}


/*****************************************************************************/


static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}




static os_error * configloaded(int eventn,wimp_w userhandle,
                                                        void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {

  dbl=ftypegetrun(&ftype);

//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
  dbl=tdbl;
  rawbits=trawbits;
  pbmxres=txres;
  pbmyres=tyres;
 }

 return(err);
}




static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}





static os_error * wrpc(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdpc(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}




static dbiconstr configicondefs[7]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,
    0, &trawbits,    DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
    5, &txres,       DBWRITE,  0,   0,      7, -1,  7,-1, rdpc, wrpc,
    7, &tyres,       DBWRITE,  0,   0,     -1,  5, -1, 5, rdpc, wrpc,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TPBM,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);
 
 tdbl=dbl;
 trawbits=rawbits;
 txres=pbmxres;
 tyres=pbmyres;

 err=dodboxparent(&configbox,1,parent);

 return(err);
}



/****************************************************************************/


static ftypestr ftype=
{
 PBM,             /* file type */
 0,               /* flags     */
 loadpbm,         /* load      */
 loadfilepost,    /* loadpost  */
 "{PBM}",         /* name      */
 "{PBM}",         /* type name */
 savepbm,         /* save      */
 config,          /* configure */
 0,               /* icon      */
 bits,            /* bit flags */
 NULL,            /* get one frame */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,            /* save info  */


 NULL,            /* saveim */
 "pbm\0""69e\0",  /* extension */

 "Portable Bitmap (*.pbm)",/* description */
};



static contag contable[5]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "Rawbits",CONINT,&rawbits,NULL,NULL,
 "DefaultXRes",CONINT,&pbmxres,NULL,NULL,
 "DefaultYRes",CONINT,&pbmyres,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "PBM",
 NULL,
 NULL
};



os_error * pbminit(void)
{
 os_error * err;

 err=registerfiletype(&ftype);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,configloaded,0);
 }

 return(err);
}


