/*->c.pal */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <math.h>


#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"
#include "bbc.h"


#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "filetype.h"
#include "fsx.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "mlo.h"
#include "units.h"
#include "redraw.h"
#include "colour.h"
#include "drag.h"
#include "xmath.h"
#include "config.h"
#include "pane.h"
#include "deb.h"
#include "save.h"
#include "load.h"
#include "bits.h"


#include "resource.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewo.h"
#include "viewr.h"
#include "select.h"
#include "im.h"
#include "bm.h"
#include "fx.h"
#include "cmap.h"
#include "edit.h"


#include "pal.h"


int rback;
int gback;
int bback;
int tback;


int rfront;
int gfront;
int bfront;
int tfront;


int tmask;



/****************************************************************************/


extern dboxstr pbox;

static filestr * pfile;
static viewstr * pview;

#define PRGB  0
#define PHSV  1
#define PCMYK 2

#define WHEEL 10

static int pmode;


static int v0;
static int v1;
static int v2;
static int v3;
static int vb;


static int rv;    /* current rgb and tint values */
static int gv;
static int bv;
static int tv;


static int rpal;
static int gpal;
static int bpal;
static int tpal;
static int palindex;


/****************************************************************************/

static os_error * rgbupdatecross(void);

static int PDX; // 16
static int PDY; // 12

static char * name[3]={
                       "RGB ",
                       "HS  ",
                       "CMYK",
                      };

static void writenames(void)
{
 char * table;

 table=name[pmode];

 writeiconf(pbox.handle, 9,"%c",table[0]);
 writeiconf(pbox.handle,12,"%c",table[1]);
 writeiconf(pbox.handle,25,"%c",table[2]);
 writeiconf(pbox.handle,26,"%c",table[3]);
}

/* a mode change has taken place */

static os_error * mfn(void)
{
 os_error * err;
 int        rgb[3];
 int        temp[4];

 rgb[0]=rv;
 rgb[1]=gv;
 rgb[2]=bv;

 writenames();

 switch(pmode)
 {
  case  PRGB:
             v0=rv;
             v1=gv;
             v2=bv;

             v3=0;
             break;

  case  PHSV:
             rgb2hsv(rgb,temp);
             v0=temp[0];
             v1=temp[1];
             vb=temp[2];

             v2=0;
             v3=0;

             hsv2rgb(temp,rgb);
             break;

  case PCMYK:
             rgb2cmyk(rgb,temp);
             v0=temp[0];
             v1=temp[1];
             v2=temp[2];
             v3=temp[3];
             cmyk2rgb(temp,rgb);
             break;
 }

 rv=rgb[0];
 gv=rgb[1];
 bv=rgb[2];

 dbshade(1,pmode==PHSV,&pbox);
 dbshade(2,pmode==PHSV || pmode==PRGB,&pbox);

 err=dbwritevalues(&pbox);
 wimp_set_icon_state(pbox.handle,202,(wimp_iconflags)0,(wimp_iconflags)0);
 wimp_set_icon_state(pbox.handle,20,(wimp_iconflags)0,(wimp_iconflags)0);
 wimp_set_icon_state(pbox.handle,21,(wimp_iconflags)0,(wimp_iconflags)0);
 wimp_set_icon_state(pbox.handle,22,(wimp_iconflags)0,(wimp_iconflags)0);
 wimp_set_icon_state(pbox.handle,36,(wimp_iconflags)0,(wimp_iconflags)0);
 wimp_set_icon_state(pbox.handle,40,(wimp_iconflags)0,(wimp_iconflags)0);

 if(pmode==PHSV)
 {
  wimp_set_icon_state(pbox.handle,11,(wimp_iconflags)0,(wimp_iconflags)0);
  wimp_set_icon_state(pbox.handle,WHEEL,(wimp_iconflags)0,(wimp_iconflags)0);
 }
 else
 {
  rgbupdatecross();
 }

 return(err);
}



static void initvalues(void)
{
 int        rgb[3];
 int        temp[4];


 rv=(rfront*MAXCV+127)/255;
 gv=(gfront*MAXCV+127)/255;
 bv=(bfront*MAXCV+127)/255;
 tv=(tfront*MAXCV+127)/255;


 rgb[0]=rv;
 rgb[1]=gv;
 rgb[2]=bv;

 switch(pmode)
 {
  case  PRGB:
             v0=rv;
             v1=gv;
             v2=bv;

             v3=0;
             break;

  case  PHSV:
             rgb2hsv(rgb,temp);
             v0=temp[0];
             v1=temp[1];
             vb=temp[2];

             v2=0;
             v3=0;

             hsv2rgb(temp,rgb);
             break;

  case PCMYK:
             rgb2cmyk(rgb,temp);
             v0=temp[0];
             v1=temp[1];
             v2=temp[2];
             v3=temp[3];
             cmyk2rgb(temp,rgb);
             break;
 }

 rv=rgb[0];
 gv=rgb[1];
 bv=rgb[2];
}




static os_error * newrgb(int tint,int vchange)
{
 os_error * err;
 int        rgb[3];
 int        temp[4];

 err=NULL;

 rgb[0]=rv;
 rgb[1]=gv;
 rgb[2]=bv;

 switch(pmode)
 {
  case  PRGB:
             v0=rv;
             v1=gv;
             v2=bv;

             v3=0;
             break;

  case  PHSV:
             rgb2hsv(rgb,temp);
             v0=temp[0];
             v1=temp[1];
             vb=temp[2];

             v2=0;
             v3=0;

             hsv2rgb(temp,rgb);
             break;

  case PCMYK:
             rgb2cmyk(rgb,temp);
             v0=temp[0];
             v1=temp[1];
             v2=temp[2];
             v3=temp[3];
             cmyk2rgb(temp,rgb);
             break;
 }

 rv=rgb[0];
 gv=rgb[1];
 bv=rgb[2];

 dbchangevalue(&v0,&pbox);
 dbchangevalue(&v1,&pbox);

 if(tint) dbchangevalue(&tv,&pbox);


 if(pmode!=PHSV)
 {
  dbchangevalue(&v2,&pbox);
 }

 if(pmode==PCMYK) 
 {
  dbchangevalue(&v3,&pbox);
 }

 wimp_set_icon_state(pbox.handle,36,(wimp_iconflags)0,(wimp_iconflags)0);
 wimp_set_icon_state(pbox.handle,40,(wimp_iconflags)0,(wimp_iconflags)0);

 if(pmode==PHSV && vchange)
 {
  dbchangevalue(&vb,&pbox);
  wimp_set_icon_state(pbox.handle,WHEEL,(wimp_iconflags)0,(wimp_iconflags)0);
 }
 else
 {
  rgbupdatecross();
 }

 return(err);
}



/* one of the colour sliders has changed */

static os_error * vfn(void)
{
 int        rgb[3];
 int        temp[4];

 switch(pmode)
 {
  case  PRGB:
             rv=v0;
             gv=v1;
             bv=v2;
             break;

  case  PHSV:
             temp[0]=v0;
             temp[1]=v1;
             temp[2]=vb;
             hsv2rgb(temp,rgb);
             rv=rgb[0];
             gv=rgb[1];
             bv=rgb[2];
             break;

  case PCMYK:
             temp[0]=v0;
             temp[1]=v1;
             temp[2]=v2;
             temp[3]=v3;
             cmyk2rgb(temp,rgb);
             rv=rgb[0];
             gv=rgb[1];
             bv=rgb[2];
             break;
 }


 wimp_set_icon_state(pbox.handle,36,(wimp_iconflags)0,(wimp_iconflags)0);
 wimp_set_icon_state(pbox.handle,40,(wimp_iconflags)0,(wimp_iconflags)0);

 rgbupdatecross();

 return(NULL);
}



/* called if the V slider changes */

static os_error * bfn(void)
{
 int        rgb[3];
 int        temp[4];


 if(pmode==PHSV)
 {
  temp[0]=v0;
  temp[1]=v1;
  temp[2]=vb;
  hsv2rgb(temp,rgb);
  rv=rgb[0];
  gv=rgb[1];
  bv=rgb[2];

  wimp_set_icon_state(pbox.handle,36,(wimp_iconflags)0,(wimp_iconflags)0);
  wimp_set_icon_state(pbox.handle,40,(wimp_iconflags)0,(wimp_iconflags)0);
 }

 wimp_set_icon_state(pbox.handle,WHEEL,(wimp_iconflags)0,(wimp_iconflags)0);

 return(NULL);
}


/*****************************************************************************/

static int rootsum(int x,int y)
{
 big x2;
 big y2;
 big r2;

 bigmul(&x2,x,x);
 bigmul(&y2,y,y);
 bigadd(&x2,&y2,&r2);
 return(bigsquareroot(&r2));
}


#define CROSSX 8
#define CROSSY 8

#define WNEWCROSS 1
#define WOLDCROSS 2
#define WUPDATE   3


static os_error * redwheel(wimp_redrawstr * redrawstr,wimp_w w,int mode)
{
 os_error * err;
 int        ox;
 int        oy;
 iconstr    icon;
 int        cx;
 int        cy;
 int        rd;
 double     angle;
 int        degrees;
 int        x;
 int        y;
 int        lx;
 int        ly;
 int        r;
 int        g;
 int        b;
 int        h;
 int        v;
 int        s;
 int        rmax;
 static int oldcx;
 static int oldcy;
 int        rgb[3];
 int        hsv[3];


 ox=redrawstr->box.x0-redrawstr->scx;
 oy=redrawstr->box.y1-redrawstr->scy;

  /* colour wheel */
 err=geti(w,WHEEL,&icon);

 if(iconinredraw(redrawstr,&icon))
 {
  cx=(icon.ix0+icon.ix1)/2;
  cy=(icon.iy0+icon.iy1)/2;
  rmax=MIN(icon.ix1-icon.ix0,icon.iy1-icon.iy0)/2
                                  -2*MAX(cvdu.deltax,cvdu.deltay);

  v=(vb*MAXCV)/1000;

  if(mode==WUPDATE)
  for(rd=rmax;rd>=0;rd-=32)
  {
   s=(v*rd)/rmax;

   lx=rd;
   ly=0;

   for(degrees=HUE180/18,angle=PI/18;degrees<=HUE90;
                                         angle+=PI/18,degrees+=HUE180/18)
   {
    x=(int)(rd*cos(angle));
    y=(int)(rd*sin(angle));
   
    if(degrees<HUE60)
    {
     r=v;
     b=v-s;
     g=(s*degrees)/(HUE120-degrees)+v-s;
    }
    else
    {
     g=v;
     b=v-s;
     r=(s*(HUE120-degrees))/degrees+v-s;
    }

    r=(r*255)/MAXCV;
    g=(g*255)/MAXCV;
    b=(b*255)/MAXCV;

    setgcol((b<<24) | (g<<16) | (r<<8));
    bbc_move(ox+cx,oy+cy);
    bbc_move(ox+cx+lx,oy+cy+ly);
    bbc_plot(176+5,ox+cx+x,oy+cy+y);

    setgcol((g<<24) | (b<<16) | (r<<8));
    bbc_move(ox+cx,oy+cy);
    bbc_move(ox+cx+x,oy+cy-y);
    bbc_plot(176+5,ox+cx+lx,oy+cy-ly);

    if(degrees<HUE60)
    {
     g=v;
     r=v-s;
     b=(s*(HUE60-degrees))/(HUE60+degrees)+v-s;
    }
    else
    {
     g=v;
     b=v-s;
     r=(s*(degrees-HUE60))/(HUE180-degrees)+v-s;
    }

    r=(r*255)/MAXCV;
    g=(g*255)/MAXCV;
    b=(b*255)/MAXCV;

    setgcol((b<<24) | (g<<16) | (r<<8));
    bbc_move(ox+cx,oy+cy);
    bbc_move(ox+cx-x,oy+cy+y);
    bbc_plot(176+5,ox+cx-lx,oy+cy+ly);

    setgcol((g<<24) | (b<<16) | (r<<8));
    bbc_move(ox+cx,oy+cy);
    bbc_move(ox+cx-lx,oy+cy-ly);
    bbc_plot(176+5,ox+cx-x,oy+cy-y);

    lx=x;
    ly=y;
   }
  }

  /* now do little cross */


  /* get hsv from rv,gv,bv */

  rgb[0]=rv;
  rgb[1]=gv;
  rgb[2]=bv;
  rgb2hsv(rgb,hsv);
  h=hsv[0];
  s=hsv[1];
  v=hsv[2];

  if(mode==WUPDATE || mode==WNEWCROSS)
  {
   angle=(double)h*PI/((double)HUE180);

   rd=(s*rmax)/MAXCV;

   oldcx=x=(int)(cos(angle)*(double)rd);
   oldcy=y=(int)(sin(angle)*(double)rd);
  }
  else
  {
   x=oldcx;
   y=oldcy;
  }

  seteorcol(0,7);
  bbc_move(ox+cx+x-CROSSX,oy+cy+y);
  bbc_draw(ox+cx+x+CROSSX,oy+cy+y);
  bbc_move(ox+cx+x,oy+cy+y-CROSSY);
  bbc_draw(ox+cx+x,oy+cy+y+CROSSY);
 }
 return(err);
}



static os_error * wheelclick(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;
 windowstr  window;
 iconstr    icon={0,0,0,0};
 int        cx;
 int        cy;
 int        x;
 int        y;
 int        rmax;
 int        r;
 int        h;
 int        s;
 int        rgb[3];
 int        hsv[3];


          err=getw(handle,&window);
 if(!err) err=geti(handle,WHEEL,&icon);

 cx=(icon.ix0+icon.ix1)/2;
 cy=(icon.iy0+icon.iy1)/2;
 rmax=MIN(icon.ix1-icon.ix0,icon.iy1-icon.iy0)/2
                                      -2*MAX(cvdu.deltax,cvdu.deltay);;
/* rmax=(rmax*vb)/1000; */

 x=m->x-window.bx-cx;
 y=m->y-window.by-cy;

 r=rootsum(x,y);
 if(r>rmax) r=rmax;

 if(r<=rmax)
 {
  if(x==0 && y==0) h=0;
  else             h=(int)((((double)HUE180)*atan2((double)y,(double)x))/PI);
  if(h<0) h+=HUE360;
  s=(1000*r)/rmax;


  hsv[0]=h;
  hsv[1]=s;
  hsv[2]=vb;
  hsv2rgb(hsv,rgb);

  rv=rgb[0];
  gv=rgb[1];
  bv=rgb[2];

//    cprintf("r=%d b=%d g=%d h=%d s=%d v=%d",rv,bv,gv,h,s,vb);

  newrgb(0,0);
 }
 return(err);
 userhandle=userhandle;
}



/* called when a value has changed */

static os_error * rgbupdatecross(void)
{
 wimp_redrawstr redrawstr;
 windowstr      window;
 iconstr        icon;
 int            more;

 /* get HSV values */


 if(1)
 {
  redrawstr.w=pbox.handle;

  getw(redrawstr.w,&window);
  geti(redrawstr.w,WHEEL,&icon);

  redrawstr.box.x0=icon.ix0;
  redrawstr.box.x1=icon.ix1;
  redrawstr.box.y0=icon.iy0;
  redrawstr.box.y1=icon.iy1;

  wimp_update_wind(&redrawstr,&more);

  while(more)
  {
   redwheel(&redrawstr,pbox.handle,WOLDCROSS);
   redwheel(&redrawstr,pbox.handle,WNEWCROSS);
   wimp_get_rectangle(&redrawstr,&more);
  }
 }
 return(NULL);
}


static int oldx;
static int oldy;

static os_error * wheeldragzero(wimp_w handle,uservalue userhandle,wimp_mousestr * mstr)
{
// wimp_mousestr mstr;
// wimp_get_point_info(&mstr);
 if(mstr->x!=oldx || mstr->y!=oldy) wheelclick(handle,0,mstr);
 oldx=mstr->x;
 oldy=mstr->y;

 return(NULL);

 USE(userhandle);
}


static os_error * wheeldragend(wimp_w handle,uservalue userhandle,wimp_box * box)
{
 os_error * err;
// err=remzeroevent(wheeldragzero,handle);

 err=NULL;

 return(err);

 USE(userhandle);
 USE(box);
 USE(handle);
}


static os_error * startwheeldrag(wimp_w handle)
{
 os_error  * err;
 windowstr   window;
 iconstr     icon={0,0,0,0};

          err=getw(handle,&window);
 if(!err) err=geti(handle,WHEEL,&icon);

 if(!err) err=userdrag(handle,window.bx+icon.ix0,window.by+icon.iy0,
                                   window.bx+icon.ix1,window.by+icon.iy1);
 if(!err) err=startdrag2(handle,0,wheeldragend,wheeldragzero);

// if(!err) err=addzeroevent(wheeldragzero,handle);

 oldx=oldy=-1;

 return(err);
}

/*****************************************************************************/

static os_error * updatepal(void)
{
 os_error * err;
 imagestr * im;

 if(pfile->frames && pfile->framen)
 {
  im=((pfile->frames[pview->frame].xim)->sim[IM]);
 }
 else return(NULL);

 im->ipal.word[palindex]=(rpal<<8)|(gpal<<16)|(bpal<<24);

 err=viewdeleteimagefileframe(pfile,pview->frame);

 viewcreateimagefileframe(pfile,pview->frame);
 refreshviewfileframe(pfile,pview->frame);
 modifyview(pview);
 return(err);
}




static int getpalparams(wimp_w handle,int * dx,int * dy,int * maxrows,int * maxcols)
{
 int        bpp;
 imagestr * im;
 iconstr    icon;

 if(pfile->frames && pfile->framen)
 {
  im=((pfile->frames[pview->frame].xim)->sim[IM]);
 }
 else return(0);

 geti(handle,4,&icon);

 PDX=(icon.ix1-icon.ix0)/16;
 PDY=(icon.iy1-icon.iy0)/16;


 bpp=im->bpp;

 if(bpp==1)
 {
  *maxcols=2;
  *maxrows=1;
  *dx=4*PDX;
  *dy=4*PDY;
 }
 else
 if(bpp==2)
 {
  *maxcols=2;
  *maxrows=2;
  *dx=4*PDX;
  *dy=4*PDY;
 }
 else
 if(bpp==4)
 {
  *maxcols=4;
  *maxrows=4;
  *dx=2*PDX;
  *dy=2*PDY;
 }
 else
 if(bpp==8)
 {
  *maxcols=16;
  *maxrows=16;
  *dx=PDX;
  *dy=PDY;
 }
 else
 {
  return(0);
 }

 return(1);
}



static os_error * palredraw(wimp_w handle,wimp_redrawstr * r)
{
 os_error * err;
 int        ox;
 int        oy;
 iconstr    icon;
 int        dx;
 int        dy;
 int        x;
 int        y;
 int        ylo;
 int        yhi;
 int        xlo;
 int        xhi;
 int        maxrows;
 int        maxcols;
 imagestr * im;
 int        i;
 int        j;
 int        di;
 int        w;
 int        h;

 err=NULL;

 ox=r->box.x0-r->scx;
 oy=r->box.y1-r->scy;


 if(!getpalparams(handle,&dx,&dy,&maxrows,&maxcols)) return(NULL);

 im=((pfile->frames[pview->frame].xim)->sim[IM]);

 err=geti(handle,4,&icon);
 if(iconinredraw(r,&icon))
 {
  w=icon.ix1-icon.ix0;
  w-=dx*maxcols;
  w/=2;
  h=icon.iy1-icon.iy0;
  h-=dy*maxrows;
  h/=2;

  ox+=icon.ix0+w;
  oy+=icon.iy1-h;

  xlo=r->g.x0-ox;
  if(xlo<0) xlo=0;
  xlo/=dx;
  di=xlo;
  xlo*=dx;

  xhi=r->g.x1-ox;
  xhi/=dx;
  if(xhi>=maxrows) xhi=maxcols;
  else             xhi++;
  xhi*=dx;

  ylo=(oy-r->g.y1);
  if(ylo<0) ylo=0;
  ylo/=dy;
  i=ylo*maxcols;
  ylo*=dy;

  yhi=(oy-r->g.y0);
  yhi/=dy;
  if(yhi>=maxrows) yhi=maxrows;
  else             yhi++;
  yhi*=dy;

  if(xlo<=xhi && ylo<=yhi)
  {
   for(y=ylo;y<yhi;y+=dy)
   {
    j=i+di;
    for(x=xlo;x<xhi;x+=dx)
    {
     setgcol(im->ipal.word[j]);
     bbc_rectanglefill(ox+x,oy-y-dy,dx,dy);
     j++;
    }
    i+=maxcols;
   }
  }
 } 
 return(err);
}


static os_error * setpal(void)
{
 rpal=(rv*255+MAXCV/2)/MAXCV;
 gpal=(gv*255+MAXCV/2)/MAXCV;
 bpal=(bv*255+MAXCV/2)/MAXCV;
 tpal=(tv*255+MAXCV/2)/MAXCV;
 wimp_set_icon_state(pbox.handle,44,(wimp_iconflags)0,(wimp_iconflags)0);  /* update pal icon */
 wimp_set_icon_state(pbox.handle,4,(wimp_iconflags)0,(wimp_iconflags)0);   /* update main pal */
 return(updatepal());
}





static os_error * fload(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error * err;

 err=NULL;

 if(type==PAL)
 {
  err=loadpalette(name,pview);
 }

 return(err);

 USE(userhandle);
 USE(xvolatile);
}




static os_error * palopen(wimp_w handle)
{
 os_error * err;
 loadoptstr opts;
 int        xtype=PAL;
 int        copt;
 char       name[MAX_PATH];

 opts.description="RISC OS Palette (*.pal)";
 opts.ntypes=1;
 opts.types=&xtype;

 name[0]=0;

 err=openloadparent(name,&copt,&opts,1,fload,0,handle);

 return(err);
}






/* save dictionary as text */
                  
static os_error * savepal(char * name,int type)
{
 os_error * err;
 imagestr * im;

 err=NULL;

 if(pfile->frames && pfile->framen)
 {
  im=((pfile->frames[pview->frame].xim)->sim[IM]);
 
  writepalfile(im->ipal.word,im->ipal.ncolours,name);
 }

 return(err);

 USE(type);
}




static os_error * openpalsave(wimp_w handle)
{
 os_error * err;
 TCHAR      path[MAX_PATH];

 xzstrncpyu(path,TEXT("Palette"),NITEM(path));

 err=opensaveparent(path,NITEM(path),PAL,savepal,handle);
 
 return(err);
}







os_error * paldecode(int * menu,wimp_w window)
{
 os_error * err;


 err=NULL;

 switch(menu[0])
 {
  case ID_PAL_IMPORT:
                     err=palopen(window);
                     break;

  case ID_PAL_EXPORT:
                     err=openpalsave(window);
                     break;

 }

 return(err);

 USE(window);
}




os_error *loadpaltype(char * name,int type,mousestr * m,uservalue userhandle,int * method)
{
 if(type==PAL)                          *method=1;
 else                                   *method=0;

 return(NULL);
 USE(userhandle);
 USE(m);
}



os_error * loadpal(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;
 viewstr   * view;

 view=(viewstr*)userhandle;

 err=loadpalette(name,view);

 return(err);

 USE(xvolatile);
 USE(type);
}












static os_error * palicon(wimp_w handle,wimp_mousestr * m)
{
 os_error * err;
 windowstr  window;
 iconstr    icon={0,0,0,0};
 int        dx;
 int        dy;
 int        maxrows;
 int        maxcols;
 int        w;
 int        h;
 int        ox;
 int        oy;
 int        index;
 int        i;
 imagestr * im=NULL;

 if(!getpalparams(handle,&dx,&dy,&maxrows,&maxcols)) return(NULL);

 if(m->bbits==0x1)
 {
  setmenufns(MPAL,paldecode,NULL);
  linkmenu(MPAL,0,0);
  err=openupmenu(handle,MPAL);
 }
 else
 {
  err=getw(handle,&window);
  if(!err) err=geti(handle,4,&icon);
  if(!err)
  {
   ox=window.bx;
   oy=window.by;

   w=icon.ix1-icon.ix0;
   w-=dx*maxcols;
   w/=2;
   h=icon.iy1-icon.iy0;
   h-=dy*maxrows;
   h/=2;

   ox+=icon.ix0+w;
   oy+=icon.iy1-h;

   index=(m->x-ox)/dx;
   if(index<maxcols)
   {
    i=(oy-m->y)/dy;
    if(i<maxrows)
    {
     index+=i*maxcols;

     if(pfile->frames && pfile->framen)
     {
      im=((pfile->frames[pview->frame].xim)->sim[IM]);
 
      index=CUT(index,0,im->ipal.ncolours);

      if(m->bbits==0x1) /* adjust */
      {
       palindex=index;
       err=setpal();
      }
      else
      if(m->bbits==0x4) /* select */
      {
       palindex=index;

       rv=im->ipal.word[palindex];
       rpal=(rv>>8)&0xFF;
       gpal=(rv>>16)&0xFF;
       bpal=(rv>>24)&0xFF;

       rv=(rpal*MAXCV+127)/255;
       gv=(gpal*MAXCV+127)/255;
       bv=(bpal*MAXCV+127)/255;

       wimp_set_icon_state(pbox.handle,44,(wimp_iconflags)0,(wimp_iconflags)0);
       newrgb(0,1);
      }
     }
    }
   }
  }
 }
 return(err);
}



static os_error * predrawsub(wimp_w handle,wimp_redrawstr * redrawstr,int more)
{
 os_error * err;

 err=NULL;

 while(more)
 {
  redrawblock(redrawstr,handle,40,
         (((rv*255)/MAXCV)<<8)|(((gv*255)/MAXCV)<<16)|(((bv*255)/MAXCV)<<24));
  redrawblock(redrawstr,handle,36,(((rv*tv*255)/(MAXCV*MAXCV))<<8)|
                                  (((gv*tv*255)/(MAXCV*MAXCV))<<16)| 
                                  (((bv*tv*255)/(MAXCV*MAXCV))<<24));

  redrawblock(redrawstr,handle,37,(rfront<<8)|(gfront<<16)|(bfront<<24));
  redrawblock(redrawstr,handle,38,(rback<<8)|(gback<<16)|(bback<<24));
  redrawblock(redrawstr,handle,44,(rpal<<8)|(gpal<<16)|(bpal<<24));

  redrawblock(redrawstr,handle,47,(tmask<<8)|(tmask<<16)|(tmask<<24));


  palredraw(handle,redrawstr);

  if(pmode==PRGB)
  {
   redrawslider(redrawstr,202,handle,WIMPRED,  v0,MAXCV);
   redrawslider(redrawstr,20,handle,WIMPGREEN,v1,MAXCV);
   redrawslider(redrawstr,21,handle,WIMPDBLUE,v2,MAXCV);
   redrawslider(redrawstr,22,handle,WIMPGREY3,v3,MAXCV);
   redrawslider(redrawstr,11,handle,WIMPGREY3,vb,MAXCV); 
  }
  else
  if(pmode==PHSV)
  {
   redrawslider(redrawstr,202,handle,WIMPGREY3,v0,MAXCV);
   redrawslider(redrawstr,20,handle,WIMPGREY3,v1,MAXCV);
   redrawslider(redrawstr,21,handle,WIMPGREY3,v2,MAXCV);
   redrawslider(redrawstr,22,handle,WIMPGREY3,v3,MAXCV);
   redrawslider(redrawstr,11,handle,WIMPGREY3,vb,MAXCV); 
  }
  else
  if(pmode==PCMYK)
  {
   redrawslider(redrawstr,202,handle,WIMPLBLUE, v0,MAXCV);
   redrawslider(redrawstr,20,handle,WIMPRED,   v1,MAXCV);
   redrawslider(redrawstr,21,handle,WIMPYELLOW,v2,MAXCV);
   redrawslider(redrawstr,22,handle,WIMPBLACK, v3,MAXCV);
   redrawslider(redrawstr,11,handle,WIMPGREY3, vb,MAXCV); 
  }

  redrawslider(redrawstr,39,handle,WIMPYELLOW,tv,MAXCV);

  err=redwheel(redrawstr,handle,WUPDATE);

  err=wimp_get_rectangle(redrawstr,&more);
 }
 return(err);
}


static os_error * predraw(wimp_w handle,uservalue userhandle)
{
 os_error     * err;
 wimp_redrawstr redrawstr;
 int            more;
 redrawstr.w=handle;
 err=wimp_redraw_wind(&redrawstr,&more);
 if(!err) err=predrawsub(handle,&redrawstr,more);
 return(err);
 USE(userhandle);
}





static os_error * picon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;
 int        buttons;

 err=NULL;

 buttons=m->bbits;


 cprintf("icon %d",m->i);

 switch(m->i)
 {

  case WHEEL:
             if(m->bbits==VBDRAGS) err=startwheeldrag(handle);
             else                  err=wheelclick(handle,userhandle,m);
             break;

  case  4:
          err=palicon(handle,m);
          break;

  case 37:            /* set foreground */
          if(buttons==0x1) /* adjust */
          {
           rfront=(rv*255+MAXCV/2)/MAXCV;
           gfront=(gv*255+MAXCV/2)/MAXCV;
           bfront=(bv*255+MAXCV/2)/MAXCV;
           tfront=(tv*255+MAXCV/2)/MAXCV;
           wimp_set_icon_state(pbox.handle,37,(wimp_iconflags)0,(wimp_iconflags)0);
          }
          else
          {
           rv=(rfront*MAXCV+127)/255;
           gv=(gfront*MAXCV+127)/255;
           bv=(bfront*MAXCV+127)/255;
           tv=(tfront*MAXCV+127)/255;
           err=newrgb(1,1);
          }
          break;

  case 38:            /* set background */
          if(buttons==0x1) /* adjust */
          {
           rback=(rv*255+MAXCV/2)/MAXCV;
           gback=(gv*255+MAXCV/2)/MAXCV;
           bback=(bv*255+MAXCV/2)/MAXCV;
           tback=(tv*255+MAXCV/2)/MAXCV;
           wimp_set_icon_state(pbox.handle,38,(wimp_iconflags)0,(wimp_iconflags)0);
          }
          else
          {
           rv=(rback*MAXCV+127)/255;
           gv=(gback*MAXCV+127)/255;
           bv=(bback*MAXCV+127)/255;
           tv=(tback*MAXCV+127)/255;
           err=newrgb(1,1);
          }
          break;

  case 44:            /* update palette */
          if(buttons==0x1) /* adjust */
          {
           err=setpal();
          }
          else
          {
           rv=(rpal*MAXCV+127)/255;
           gv=(gpal*MAXCV+127)/255;
           bv=(bpal*MAXCV+127)/255;
           tv=(tpal*MAXCV+127)/255;
           err=newrgb(1,1);
          }
          break;


  case 47:
          if(buttons==0x1) /* adjust */
          {
           tmask=(tv*255+MAXCV/2)/MAXCV;
           wimp_set_icon_state(pbox.handle,47,(wimp_iconflags)0,(wimp_iconflags)0);
          }
          else
          {
           tmask=(tback*MAXCV+127)/255;
           err=newrgb(1,0);
          }
          break;

 }

 return(err);
 USE(handle);
 USE(userhandle);
 USE(m);
}


static os_error * modpalevent(int eventn,wimp_w userhandle,void * data,int data1);


static os_error * pclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {


 }

 if(code!=DBAPPLY)
 {
  remevent(EVENT_FRAMEPALMODDED,modpalevent,0);
  remdataload(pbox.handle,(uservalue)pview,loadpal);
  remdataloadtype(pbox.handle,(uservalue)pview,loadpaltype);
  pview=NULL;
  pfile=NULL;
 }

 return(err);
}





static os_error * wrcol(int value,char * string)
{
 strcpy(string,numbertostringdp(value,1));
 return(NULL);
}

static os_error * rdcol(int * value,char * string)
{
 os_error * err;
 err=stringtonumberdp(string,value,1);
/* *value=((*value)*255)/100;  */
 return(err);
}




static dbiconstr picondefs[]=
{
 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    8, &pmode,       DBRADIO , 0,    0,     PRGB, F1, 1, 0,          NULL,NULL,
    7, &pmode,       DBRADIO , 0,    0,     PHSV, F2, 1, 0,          NULL,NULL,
    6, &pmode,       DBRADIO , 0,    0,     PCMYK,F3, 1, 0,          NULL,NULL,

    0, &pmode,       DBUPDATE, 0,   0,     -1, -1, -1, -1, (dbreadfn)mfn,NULL,

 /* N   &V           Type     Grp   Flags    R   L   D   U    In  Out */


   34, &tv,          DBINC   ,0,    0,       10,  -1, 1000,  0,  NULL,   0,
   35, &tv,          DBDEC   ,0,    0,       10,  -1, 1000,  0,  NULL,   0,
   33, &tv,          DBWRITE, 0, DBASSOCINC, -1,  -1,  1, -1,    rdcol,  wrcol,
   39, &tv,          DBSLIDER,0,    0,       1,   -1, 1000,  0,  NULL,   0,
   36, &tv,          DBUPDATE,0,    0,       -1, -1, -1, -1,     NULL,   0,



    3, &v0,          DBINC   ,0,    0,       10,  -1, 1000,  0,  NULL,   0,
    5, &v0,          DBDEC   ,0,    0,       10,  -1, 1000,  0,  NULL,   0,
  201, &v0,          DBWRITE, 0, DBASSOCINC, -1,  -1, 13, 33, rdcol,   wrcol,
  202, &v0,          DBSLIDER,0,    0,       1,   -1, 1000,  0,  NULL,   0,
WHEEL, &v0,          DBUPDATE,0,    0,     -1, -1, -1, -1, (dbreadfn)vfn,NULL,


   14, &v1,          DBINC   ,0,    0,       10,  -1, 1000,  0,  NULL,   0,
   17, &v1,          DBDEC   ,0,    0,       10,  -1, 1000,  0,  NULL,   0,
   13, &v1,          DBWRITE, 0, DBASSOCINC, -1,  -1, 23,   1, rdcol,   wrcol,
   20, &v1,          DBSLIDER,0,    0,       1,   -1, 1000,  0,  NULL,   0,
WHEEL, &v1,          DBUPDATE,0,    0,     -1, -1, -1, -1, (dbreadfn)vfn,NULL,


   15, &v2,          DBINC   ,1,    0,       10,  -1, 1000,  0,  NULL,   0,
   18, &v2,          DBDEC   ,1,    0,       10,  -1, 1000,  0,  NULL,   0,
   23, &v2,          DBWRITE, 1, DBASSOCINC, -1,  -1, 24,  13, rdcol,   wrcol,
   21, &v2,          DBSLIDER,1,    0,       1,   -1, 1000,  0,  NULL,   0,
WHEEL, &v2,          DBUPDATE,0,    0,     -1, -1, -1, -1, (dbreadfn)vfn,NULL,


   16, &v3,          DBINC   ,2,    0,       10,  -1, 1000,  0,  NULL,   0,
   19, &v3,          DBDEC   ,2,    0,       10,  -1, 1000,  0,  NULL,   0,
   24, &v3,          DBWRITE, 2, DBASSOCINC, -1,  -1, 30,  23, rdcol,   wrcol, 
   22, &v3,          DBSLIDER,2,    0,       1,   -1, 1000,  0,  NULL,   0,
WHEEL, &v3,          DBUPDATE,0,    0,     -1, -1, -1, -1, (dbreadfn)vfn,NULL,


   29, &vb,          DBINC   ,0,    0,       10,  -1, 1000,  0,  NULL,   0,
   28, &vb,          DBDEC   ,0,    0,       10,  -1, 1000,  0,  NULL,   0,
   30, &vb,          DBWRITE, 0, DBASSOCINC, -1,  -1, -1,  24, rdcol,   wrcol,
   11, &vb,          DBSLIDER,0,    0,       1,   -1, 1000,  0,  NULL,   0,
WHEEL, &vb,          DBUPDATE,0,    0,     -1, -1, -1, -1, (dbreadfn)bfn,NULL,


   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr pbox=
{
 0,
 TPAL,
 DBFIX,
 DBUPDATECARET,
 pclose,
 picon,
 NULL,
 predraw,
 picondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};



static os_error * modpalevent(int eventn,wimp_w userhandle,void * data,int data1)
{
 viewstr  * view;
 filestr  * file;
 imagestr * im;

 if(eventn==EVENT_FRAMEPALMODDED)
 {
  view=(viewstr*)data;
  file=(filestr*)view->file;

  if(pfile==file && view->frame==pview->frame)
  {

   if(pfile->frames && pfile->framen)
   {
    im=((pfile->frames[pview->frame].xim)->sim[IM]);
   }
   else return(NULL);

   palindex=ROOF(palindex,(im->ipal.ncolours-1));

   wimp_set_icon_state(pbox.handle,4,(wimp_iconflags)0,(wimp_iconflags)0);   /* update main pal */
  }
 }

 return(NULL);

 USE(userhandle);
 USE(data1);
}



os_error * openpal(viewstr * view,filestr * file)
{
 os_error * err;

 err=NULL;

 if(pbox.handle) dbclose(&pbox,DBCANCEL);

 pview=view;
 pfile=file;

 initvalues();

 err=dodboxparent(&pbox,1,view->handle);
 if(!err) 
 {
  writenames();
  dbshade(1,pmode==PHSV,&pbox);
  dbshade(2,pmode==PHSV || pmode==PRGB,&pbox);
 }

 if(!err) err=addevent(EVENT_FRAMEPALMODDED,modpalevent,0);

  adddataload(pbox.handle,(uservalue)view,loadpal);
  adddataloadtype(pbox.handle,(uservalue)view,loadpaltype);


 return(err);
}


static os_error * closevent(int eventn,wimp_w userhandle,void * data,int data1)
{
 viewstr * view;
 filestr * file;


 if(eventn==EVENT_FCLOSE)
 {
  file=(filestr*)data;

  if(file==pfile)
  {
   dbclose(&pbox,DBSMASH);
   pview=NULL;
   pfile=NULL;
  }
 }
 else
 if(eventn==EVENT_VCLOSE)
 {
  view=(viewstr*)data;

  if(view==pview)
  {
   dbclose(&pbox,DBSMASH);
   pview=NULL;
   pfile=NULL;
  }
 }

 return(NULL);

 USE(userhandle);
 USE(data1);
}



static int findpixel(viewstr * view,wimp_mousestr * m,int * x,int * y)
{
 windowstr window;
 framestr * frame;
 imagestr * im;
 int        fn;
 boxstr     sbox;
 filestr  * file;
 int        scx;
 int        scy;

 file=(filestr*)view->file;

 getw(m->w,&window);

 scx=ourunits(m->x-window.bx,view);
 scy=-ourunits(m->y-window.by,view);

 if(!file->frames || !file->framen) return(1);

 fn=view->frame;
 frame=&file->frames[fn];
 im=((frame->xim)->sim[IM]);

 sbox.x=im->tr.e;
 sbox.y=im->tr.f;
 sbox.w=scale(im->xpix,72000,im->xdpi);
 sbox.h=scale(im->ypix,72000,im->ydpi);

 if(insidebox(scx,scy,&sbox))
 {
  scx-=sbox.x;
  scy-=sbox.y;

  scx=(scx*im->xdpi)/72000;
  scy=(scy*im->ydpi)/72000;

  scx=MAX(0,scx);
  scy=MAX(0,scy);
  scx=MIN((im->xpix-1),scx);
  scy=MIN((im->ypix-1),scy);

  *x=scx;
  *y=scy;

  return(0);
 }

 return(1);
}



os_error * palpick(viewstr * view,wimp_w handle,wimp_mousestr * m)
{
 int        x;
 int        y;
 filestr  * file;
 int        fn;
 framestr * frame;
 imagestr * im;
 int        shift;
 int      * data;
 char     * p;
 int        bpp;
 unsigned int w;
 int        r;
 int        g;
 int        b;

 file=(filestr*)view->file;
 fn=view->frame;

 if(file==pfile && fn==pview->frame && pbox.handle)
 {
  if(!findpixel(view,m,&x,&y))
  {
   frame=&file->frames[fn];
   im=((frame->xim)->sim[IM]);
   bpp=im->bpp;

   imfind1r(im,y,&data);

   if(bpp==24)
   {
    p=((char*)data)+x*3;
    r=*p++;
    g=*p++;
    b=*p++;
    rv=(r*MAXCV+127)/255;
    gv=(g*MAXCV+127)/255;
    bv=(b*MAXCV+127)/255;
   }
   else
   {
    data+=(x*bpp+0x1F)/32;
    shift=(x*bpp)&0x1F;
    w=*data;
    w=(w>>shift);

    if(bpp<=8)
    {
     w&=(1<<bpp)-1;
     palindex=w;
     rv=im->ipal.word[palindex];

     r=rpal=(rv>>8)&0xFF;
     g=gpal=(rv>>16)&0xFF;
     b=bpal=(rv>>24)&0xFF;

     rv=(rpal*MAXCV+127)/255;
     gv=(gpal*MAXCV+127)/255;
     bv=(bpal*MAXCV+127)/255;

     wimp_set_icon_state(pbox.handle,44,(wimp_iconflags)0,(wimp_iconflags)0);
    }
    else
    if(bpp==16)
    {
     r=(w<<3)&0xF8;
     g=(w>>2)&0xF8;
     b=(w>>7)&0xF8;
    }
    else
   /* if(bpp==32) */
    {
     r=w&0xFF;
     g=(w>>8)&0xFF;
     b=(w>>16)&0xFF;
    }
   }

   rv=(r*MAXCV+127)/255;
   gv=(g*MAXCV+127)/255;
   bv=(b*MAXCV+127)/255;
   newrgb(0,1);
  }
 }
 return(NULL);

 USE(handle);
}









static contokstr ptoks[]=
{
 "RGB",PRGB,
 "HSV",PHSV,
 "CMYK",PCMYK,
  NULL,0
};


static contag contable[]=
{
 "ForeRed",      CONINT,&rfront,NULL,NULL,
 "ForeGreen",    CONINT,&gfront,NULL,NULL,
 "ForeBlue",     CONINT,&bfront,NULL,NULL,
 "ForeTint",     CONINT,&tfront,NULL,NULL,

 "BackRed",      CONINT,&rback,  NULL,NULL,
 "BackGreen",    CONINT,&gback,  NULL,NULL,
 "BackBlue",     CONINT,&bback,  NULL,NULL,
 "BackTint",     CONINT,&tback,  NULL,NULL,

 "MaskTint",     CONINT,&tmask,  NULL,NULL,

 "ColourModel",  CONTOK,&pmode,ptoks,NULL,
 "Brightness",   CONINT,&vb,     NULL,NULL,

 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "Palette",
 NULL,
 NULL
};


os_error * palinit(void)
{
 os_error * err;

 err=addcontable(contable,&configlink);

 addevent(EVENT_FCLOSE,closevent,0);
 addevent(EVENT_VCLOSE,closevent,0);

 return(err);
}


