/*->c.page */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"

#include "err.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "save.h"
#include "etc.h"
#include "deb.h"
#include "dbhi.h"


#include "resource.h"

#include "constants.h"
#include "str.h"
#include "reslink.h"

#include "view.h"
#include "file.h"
#include "mlo.h"
#include "units.h"

#include "page.h"



#define MUL (72000*10)
#define DIV 254

#define SIZE 12


static int pagews[SIZE]={
               (841*MUL)/DIV,   /* A0 */
               (594*MUL)/DIV,   /* A1 */
               (420*MUL)/DIV,   /* A2 */
               (297*MUL)/DIV,   /* A3 */
               (210*MUL)/DIV,   /* A4 */
               (148*MUL)/DIV,   /* A5 */
               (105*MUL)/DIV,   /* A6 */
               (75*MUL)/DIV,    /* A7 */
               (52*MUL)/DIV,    /* A8 */
               612000,          /* Letter */
               612000,          /* Legal  */
               792000,          /* Tabloid */

              };


static int pagehs[SIZE]={
               (1189*MUL)/DIV,  /* A0 */
               (841*MUL)/DIV,   /* A1 */
               (594*MUL)/DIV,   /* A2 */
               (420*MUL)/DIV,   /* A3 */
               (297*MUL)/DIV,   /* A4 */
               (210*MUL)/DIV,   /* A5 */
               (148*MUL)/DIV,   /* A6 */
               (105*MUL)/DIV,   /* A7 */
               (75*MUL)/DIV,    /* A8 */
               792000,          /* Letter */
               1008000,         /* Legal  */
               1224000,         /* Tabloid */

              };


static int pageids[SIZE]=
{
 ID_FILE_PAGE_A0,
 ID_FILE_PAGE_A1,
 ID_FILE_PAGE_A2,
 ID_FILE_PAGE_A3,
 ID_FILE_PAGE_A4,
 ID_FILE_PAGE_A5,
 ID_FILE_PAGE_A6,
 ID_FILE_PAGE_A7,
 ID_FILE_PAGE_A8,
 ID_FILE_PAGE_LETTER,
 ID_FILE_PAGE_LEGAL,
 ID_FILE_PAGE_TABLOID,
};






static char * extranames[3]={"Letter","Legal","Tabloid"};


void getpagename(int index,char * p)
{
 int sign;

 sign=SGN(index);
 index=ABS(index)-1;

 if(index<9) sprintf(p,"A%d %s",index,(sign<0)?"Landscape":"Portrait");
 else sprintf(p,"%s %s",extranames[index-9],(sign<0)?"Land":"Port");

}


int pageindex(int w,int h)
{
 int i;

 for(i=0;i<SIZE;i++)
 {
  if(pagews[i]==w && pagehs[i]==h) return(i+1);
  else
  if(pagews[i]==h && pagehs[i]==w) return(-(i+1));
 }
 return(0);
}



static pagefn page;
static int    pw;
static int    ph;



static void setuppage(void)
{
 int index;
 int i;

 index=pageindex(pw,ph);

 tickmenust(MPAGE,ID_FILE_PAGE_PORTRAIT,index>0);
 tickmenust(MPAGE,ID_FILE_PAGE_LANDSCAPE,index<0);

 index=ABS(index);

 for(i=0;i<SIZE;i++) tickmenust(MPAGE,pageids[i],(i+1)==index);
}



void setpagemenu(int w,int h,pagefn xpage,int parentmenu,int entryinparent)
{
 ph=h;
 pw=w;
 page=xpage;
 setmenufns(MPAGE,pagedecode,NULL);
 linkmenu(MPAGE,parentmenu,entryinparent);
 setuppage();
}


os_error * pagedecode(int * menu,wimp_w window)
{
 os_error * err;
 int        index;

 err=NULL;

 cprintf("page decode");

 switch(menu[0])
 {
   case ID_FILE_PAGE_PORTRAIT:
          /* portrait  */
          if(pw>ph) SWOP(pw,ph);
          break;

   case ID_FILE_PAGE_LANDSCAPE:
          /* landscape */
          if(ph>pw) SWOP(pw,ph);
          break;

  case  ID_FILE_PAGE_A0:
  case  ID_FILE_PAGE_A1:
  case  ID_FILE_PAGE_A2:
  case  ID_FILE_PAGE_A3:
  case  ID_FILE_PAGE_A4:
  case  ID_FILE_PAGE_A5:
  case  ID_FILE_PAGE_A6:
  case  ID_FILE_PAGE_A7:
  case  ID_FILE_PAGE_A8:
  case  ID_FILE_PAGE_LETTER:
  case  ID_FILE_PAGE_LEGAL:
  case  ID_FILE_PAGE_TABLOID:

          for(index=0;index<SIZE;index++)
           if(pageids[index]==menu[0]) break;

          if(pw>ph)
          {
           pw=pagehs[index];
           ph=pagews[index];
          }
          else
          {
           pw=pagews[index];
           ph=pagehs[index];
          }
          break;
 }

 if(page) err=page(pw,ph);

 setuppage();

 return(err);

 USE(window);
}

/*****************************************************************************/

static unitfn unit;


static int unitdecodetable[4]=
{
 ID_VIEW_UNITS_PIX,
 ID_VIEW_UNITS_MM,
 ID_VIEW_UNITS_IN,
 ID_VIEW_UNITS_PT

};


void unitssetup(unitfn xunit,int units,int parentmenu,int entryinparent)
{
 int i;
 unit=xunit;
 for(i=0;i<4;i++) tickmenust(MUNITS,unitdecodetable[i],units==i);
 setmenufns(MUNITS,unitsdecode,NULL);
 linkmenu(MUNITS,parentmenu,entryinparent);
}


os_error * unitsdecode(int * menu,wimp_w window)
{
 os_error * err;
 int        i;

 err=NULL;

 if(menu[0]>=0)
 {
  for(i=0;i<4;i++)
  {
   if(unitdecodetable[i]==menu[0]) break;
  }

  if(i<4)
  {
   if(unit) err=unit(i);
  }
 }

 return(err);

 USE(window);
}


void getunitname(int units,char * p)
{
 strcpy(p,unitname(units));
}


/*****************************************************************************/

static resfn res;
static int   resuser;


static int restable[][2]=
{
 45,   ID_RES_45,
 90,   ID_RES_90,
 100,  ID_RES_100,
 120,  ID_RES_120,
 180,  ID_RES_180,
 200,  ID_RES_200,
 300,  ID_RES_300,
 400,  ID_RES_400,
 500,  ID_RES_500,
 600,  ID_RES_600,
 1200, ID_RES_1200,
};


#define RESVALUES (sizeof(restable)/(2*sizeof(int)))


void ressetup(resfn xres,int resv,int xuser)
{
 int i;
 int hit;
 int tick;

 res=xres;
 resuser=xuser;

// writemenuf(menus[MRES].menuptr,9,"%d",resv);

 hit=0;

 for(i=0;i<RESVALUES;i++) 
 {
  tick=(restable[i][0]==resv);
  tickmenust(MRES,restable[i][1],tick);
  hit|=tick;
 }

// tickmenust(MRES,i,!hit);

 setmenufns(MRES,resdecode,NULL);
 linkmenu(MRES,0,0);
}


os_error * resdecode(int * menu,wimp_w window)
{
 os_error * err;
 int        i;

 err=NULL;

 for(i=0;i<RESVALUES;i++)
 {
  if(restable[i][1]==menu[0])
  {
   err=res(restable[i][0],resuser);
   break;
  }
 }

 return(err);

 USE(window);
}

