
/*->c.mtv */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"


#include "constants.h"
#include "str.h"
#include "reslink.h"

#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "units.h"
#include "cms.h"

#include "mtv.h"


extern ftypestr ftype;
extern dboxstr  configbox;


static int mtvxres=90;
static int mtvyres=45;
static int txres;
static int tyres;





static os_error * getinfo(framestr * frame)
{
 char   string[256];
 char * p;

 p=string;

 p+=sprintf(p,"MTV file\n");
 p+=sprintf(p,"%d x %d pixels %d bpp",frame->fxpix,frame->fypix,frame->fbpp);

 return(infowrite(string,frame));
}



static os_error * loadmtv(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;
 buffer      bf;
 char        string[64];
 int         c;
 int         i;
 int         xpix;
 int         ypix;
 int         fn;
 int       * idata;
 imagestr  * loadimage;
 int         y;


 err=bf_open(name,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  /* line of x y \n           */
  /* followed by x*y rgb triplets */

  for(i=0;i<63;i++)
  {
   err=bf_getc(&bf,&c);
   if(err) break;
   string[i]=(char)c;
   if(c=='\n') break;
  }
  string[i]=0;

  if(!err)
  {
   if(sscanf(string,"%d %d",&xpix,&ypix)==2)
   {
    addframe(loadfile,&fn,0);
    loadfile->frames[fn].fxpix=xpix;
    loadfile->frames[fn].fypix=ypix;
    sprintf(loadfile->frames[fn].name,"MTV%d",fn);
    bf_tell(&bf,&loadfile->frames[fn].offset);
    loadfile->frames[fn].fbpp=24;
    loadfile->frames[fn].fxdpi=mtvxres;
    loadfile->frames[fn].fydpi=mtvyres;
    loadfile->frames[fn].xim=NULL;
                         
    getinfo(&loadfile->frames[fn]);

    /* now load image data */

    err=ximnew(loadfile->frames[fn].fxpix,loadfile->frames[fn].fypix,
                          loadfile->frames[fn].fbpp,&loadfile->frames[fn].xim);

    if(!err)
    {
     loadimage=((loadfile->frames[fn].xim)->sim[IM]);
     loadimage->xdpi=loadfile->frames[fn].fxdpi;
     loadimage->ydpi=loadfile->frames[fn].fydpi;
     loadimage->ipal.ncolours=0;

     cmsrgbprofile(&loadimage->profile);

     for(y=0;y<ypix;y++)
     {
      err=imfind1w(loadimage,y,&idata);
      if(err) break;
      err=bf_read(&bf,idata,xpix*3);
      if(err) break;
     }
    }
   }
  }
  err=bf_close(&bf,err);
 }

/* dprintf(0,"load mtv"); */

 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}



static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;

 err=NULL;

/* dprintf(0,"load mtv post"); */

 return(err);
 USE(userhandle);
}


static os_error * savemtv(char * name,int type)
{
 os_error * err;
 buffer      bf;
 int         xpix;
 int         ypix;
 int         fn;
 int       * idata;
 imagestr  * saveimage;
 int         x;
 int         y;
 int         shift;
 int         word;
 int         mask;
 int         sbyte;
 int         bpp;
 char        rtab[256];
 char        gtab[256];
 char        btab[256];



 err=bf_open(name,'w',DEFBUFFSIZE,&bf);
 if(!err)
 {
  fn=menuview->frame;
  saveimage=((menufile->frames[fn].xim)->sim[IM]);

  xpix=saveimage->xpix;
  ypix=saveimage->ypix;
  bpp=saveimage->bpp;

  word=0;   /* compiler */
  mask=0xFF;

  if(bpp<=8)
  {
   imsplitpalette(rtab,gtab,btab,saveimage);

   if(bpp==1) mask=0x1;
   else
   if(bpp==2) mask=0x3;
   else
   if(bpp==4) mask=0xF;
   else       mask=0xFF;
  }

  bf_printf(&bf,"%d %d\n",xpix,ypix);

  for(y=0;y<ypix;y++)
  {
   err=imfind1r(saveimage,y,&idata);
   if(err) break;

   if(bpp<=8)
   {
    shift=32;

    for(x=0;x<xpix;x++)
    {
     if(shift>=32) 
     {
      word=*idata++;
      shift=0;
     }
     sbyte=(word>>shift)&mask;
     shift+=bpp;
     bf_putc(&bf,rtab[sbyte]);
     bf_putc(&bf,gtab[sbyte]);
     bf_putc(&bf,btab[sbyte]);
    }
   }
   else
   if(bpp==24)
   {
    err=bf_write(&bf,idata,saveimage->xpix*3);
    if(err) break;
   }
   else
   if(bpp==16)
   {
    shift=32;
    mask=0x7FFF;

    for(x=0;x<xpix;x++)
    {
     if(shift==32)
     {
      word=*idata++;
      shift=0;
     }
     sbyte=(word>>shift)&mask;
     shift+=bpp;

     bf_putc(&bf,(sbyte<<3)&0xF8);
     bf_putc(&bf,(sbyte>>2)&0xF8);
     bf_putc(&bf,(sbyte>>7)&0xF8);
    }
   }
   else
   if(saveimage->bpp==32)
   {
    for(x=0;x<xpix;x++)
    {
     err=bf_write(&bf,idata,3);
     if(err) break;
     idata++;
    }
   }
   if(err) break;
  }
  err=bf_closec(&bf,err,name,type);
 }
 return(err);
}


/*****************************************************************************/

static int tdbl;
static int dbl;


static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}



static os_error * configloaded(int eventn,wimp_w userhandle,
                                                        void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {


  dbl=ftypegetrun(&ftype);

//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
  mtvxres=txres;
  mtvyres=tyres;
 }

 return(err);
}




static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}






static os_error * wrpc(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdpc(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}




static dbiconstr configicondefs[7]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,
    4, &txres,       DBWRITE,  0,   0,      6, -1,  6,-1, rdpc, wrpc,
    6, &tyres,       DBWRITE,  0,   0,     -1,  4, -1, 4, rdpc, wrpc,



   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TMTV,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);

 tdbl=dbl;
 txres=mtvxres;
 tyres=mtvyres;
 err=dodboxparent(&configbox,1,parent);

 return(err);
}

/*****************************************************************************/



static ftypestr ftype=
{
 MTV,             /* file type  */
 0,               /* flags      */
 loadmtv,         /* load       */
 loadfilepost,    /* loadpost   */
 "{MTV}",         /* name       */
 "{MTV}",         /* type name  */
 savemtv,         /* save       */
 config,          /* configure  */
 0,               /* icon       */
 bits,            /* bit flags  */
 NULL,            /* get frame  */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,            /* save info  */


 NULL,            /* saveim */
 "mtv\0""699\0",  /* extension */

 "MTV Raytracer (*.mtv)", /* description */
};



static contag contable[4]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "DefaultXRes",CONINT,&mtvxres,NULL,NULL,
 "DefaultYRes",CONINT,&mtvyres,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "MTV",
 NULL,
 NULL
};



os_error * mtvinit(void)
{
 os_error * err;

 err=registerfiletype(&ftype);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,configloaded,0);
 }

 return(err);
}


