/*->c.mkmap */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "etc.h"


#include "inv_cmap.h"



/* generate a default 256 colour palette  */
/* calculate colour matching table for it */


static int        paltab[257];




static os_error * genpal(void)
{
 int        palentries;

 int        i;
 int        c1;

 palentries=16;
 paltab[0]=0x0;
 paltab[1]=0x10101000;
 paltab[2]=0x20202000;
 paltab[3]=0x30303000;
 paltab[4]=0x4000;
 paltab[5]=0x10105000;
 paltab[6]=0x20206000;
 paltab[7]=0x30307000;
 paltab[8]=0x40000000;
 paltab[9]=0x50101000;
 paltab[10]=0x60202000;
 paltab[11]=0x70303000;
 paltab[12]=0x40004000;
 paltab[13]=0x50105000;
 paltab[14]=0x60206000;
 paltab[15]=0x70307000;
 palentries=16;


 for(i=255;i>=0;i--)
 {
  c1=paltab[(i & 0xF)];

  if(i & 0x10) c1|=0x8000;
  else         c1&=~0x8000;

  if(i & 0x20) c1|=0x400000;
  else         c1&=~0x400000;

  if(i & 0x40) c1|=0x800000;
  else         c1&=~0x800000;

  if(i & 0x80) c1|=0x80000000;
  else         c1&=~0x80000000;

  c1&=0xF0F0F000;
  c1|=(c1>>4)&0xF0F0F00;

  paltab[i]=c1;
 }
 palentries=256;


 return(NULL);
}


static unsigned int dist_buf[4096];
static char         rgbmap[4096];



int main(int argc,char * argv[])
{ 
 int i;
 int j;

 genpal();

 inv_cmap(256,paltab,4,dist_buf,(unsigned char*)rgbmap);


 printf("int paltab[256]=\n{\n");

 for(i=0;i<256;i++)
 {
  printf("0x%08x,\n",(unsigned int)paltab[i]);
 }
 printf("};\n\n");


 printf("char rgbmap[4096]=\n{\n");

 for(i=0;i<256;i++)
 {
  for(j=0;j<16;j++)
  {
   printf("0x%02x,",rgbmap[j+i*16]);
  }
  printf("\n");
 }

 printf("};\n");

 exit(0);
}

