/*->c.med */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "config.h"
#include "dbhi.h"


#include "str.h"
#include "constants.h"

#include "reslink.h"

#include "file.h"
#include "view.h"

#include "im.h"
#include "cmap.h"
#include "long.h"


#include "user.h"

#include "med.h"




typedef int (*medfn)(char * b1,char * b2,char * b3);


/*
Median Finding on a 3-by-3 Grid
by Alan Paeth
from "Graphics Gems", Academic Press, 1990
*/

#define s2(a,b) {register int t; if ((t=b-a)<0) {a+=t; b-=t;}}
#define mn3(a,b,c) s2(a,b); s2(a,c);
#define mx3(a,b,c) s2(b,c); s2(a,c);
#define mnmx3(a,b,c) mx3(a,b,c); s2(a,b);
#define mnmx4(a,b,c,d) s2(a,b); s2(c,d); s2(a,c); s2(b,d);
#define mnmx5(a,b,c,d,e) s2(a,b); s2(c,d); mn3(a,c,e); mx3(b,d,e);
#define mnmx6(a,b,c,d,e,f) s2(a,d); s2(b,e); s2(c,f);\
                            mn3(a,b,c); mx3(d,e,f);


/*
 * Find median on a 3x3 input box of integers.
 * b1, b2, b3 are pointers to the left-hand edge of three
 * parallel scan-lines to form a 3x3 spatial median.
 * Rewriting b2 and b3 as b1 yields code which forms median
 * on input presented as a linear array of nine elements.
 */


static int med3x3(char * b1,char * b2,char * b3)
    {
    register int r1, r2, r3, r4, r5, r6;
    r1 = *b1++; r2 = *b1++; r3 = *b1++;
    r4 = *b2++; r5 = *b2++; r6 = *b2++;
    mnmx6(r1, r2, r3, r4, r5, r6);
    r1 = *b3++;
    mnmx5(r1, r2, r3, r4, r5);
    r1 = *b3++;
    mnmx4(r1, r2, r3, r4);
    r1 = *b3++;
    mnmx3(r1, r2, r3);
    return(r2);
    }




static int maxf(char * b1,char * b2,char * b3)
{
 register int r2;
 register int r3;
 register int rs1;
 register int rs2;
 register int rs3;
 register int rs4;

 r2=*b1++;
 r3=*b2++;
 rs1=MAX(r2,r3);

 r2=*b1++;
 r3=*b2++;
 rs2=MAX(r2,r3);

 r2=*b1++;
 r3=*b2++;
 rs3=MAX(r2,r3);

 r2=*b3++;
 r3=*b3++;
 rs4=MAX(r2,r3);

 rs1=MAX(rs1,rs2);
 rs2=MAX(rs3,rs4);

 r2=*b3++;
 rs2=MAX(rs2,r2);
 rs1=MAX(rs2,rs1);

 return(rs1);
}                                                                              


static int minf(char * b1,char * b2,char * b3)
{
 register int r2;
 register int r3;
 register int rs1;
 register int rs2;
 register int rs3;
 register int rs4;

 r2=*b1++;
 r3=*b2++;
 rs1=MIN(r2,r3);

 r2=*b1++;
 r3=*b2++;
 rs2=MIN(r2,r3);

 r2=*b1++;
 r3=*b2++;
 rs3=MIN(r2,r3);

 r2=*b3++;
 r3=*b3++;
 rs4=MIN(r2,r3);

 rs1=MIN(rs1,rs2);
 rs2=MIN(rs3,rs4);

 r2=*b3++;
 rs2=MIN(rs2,r2);
 rs1=MIN(rs2,rs1);

 return(rs1);
}


static int avf(char * b1,char * b2,char * b3)
{
 register int s;

 s=*b1++;
 s+=*b1++;
 s+=*b1++;
 s+=*b3++;
 s+=*b3++;
 s+=*b3++;
 s+=*b2;
 b2+=2;
 s+=*b2;

 s>>=3;

 if(s<0) s=0;
 else
 if(s>255) s=255;

 return(s);
}



os_error * medim(imagestr * im,int ylo,int yhi,spanstr ** s,int mmode)
{
 os_error * err;
 int        y;
 int        ys;
 int        yd;
 int        x;
 int        xlo;
 int        xhi;
 int        xpix;
 int        ypix;
 int        bpp;
 char     * sp;
 int      * sdata;
 char     * dp;
 int      * ddata;
 int        c;
 unsigned int w;
 int        mask;
 int        shift;
 int        grey;

 char    *  temp;  /* an area of 3*(xpix+2)*3*sizeof(char) bytes */

 char    *  r0;
 char    *  r1;
 char    *  r2;

 char    *  g0;
 char    *  g1;
 char    *  g2;

 char    *  b0;
 char    *  b1;
 char    *  b2;

 char    *  r0p;
 char    *  r1p;
 char    *  r2p;

 char    *  g0p;
 char    *  g1p;
 char    *  g2p;

 char    *  b0p;
 char    *  b1p;
 char    *  b2p;

 char    *  xp;

 char    *  r;
 char    *  g;
 char    *  b;

 char   rtab[256];
 char   gtab[256];
 char   btab[256];

 int        rv;
 int        bv;
 int        gv;

 medfn      med;

 int        size;
 int        xlox;
 int        xhix;



 if(mmode==MMMAX) med=maxf;
 else
 if(mmode==MMMIN) med=minf;
 else
 if(mmode==MMAV) med=avf;
 else
 /* if(mmode==MMMED) */ med=med3x3;


 err=NULL;

 bpp=im->bpp;
 xpix=im->xpix;
 ypix=im->ypix;

 grey=imgrey(im);

 if(bpp<=8)
 {
  imsplitpalette(rtab,gtab,btab,im);

  if(grey)
  {
   err=makegmap(im->ipal.ncolours,im->ipal.word,gtab,&size);
   if(size<2) grey=0;
  }
  if(!grey) err=makecmap(im->ipal.ncolours,im->ipal.word,4,rgbmap);


  if(bpp==1) mask=0x1;
  else
  if(bpp==2) mask=0x3;
  else
  if(bpp==4) mask=0xF;
  else       mask=0xFF;
 }
 else mask=0x7FFF;


 if(err) return(err);

 err=flex_alloc((flex_ptr)&temp,sizeof(char)*(xpix+2)*3*3);
 if(err) return(err);


 for(y=ylo-1;y<=yhi;y++)
 {
  longproctick2(y,(yhi-ylo+2));

  if(y<ylo)   ys=ylo;
  else
  if(y>=yhi)  ys=yhi-1;
  else        ys=y;

  if(y>ylo)   yd=y-1;
  else        yd=ylo;


  xlo=(*s)[ys-ylo].xlo;        /* careful if y<ylo */
  xhi=(*s)[ys-ylo].xhi;


  err=imfind2rw(im,ys,&sdata,im,yd,&ddata);
  if(err) break;
  sp=(char*)sdata;
  dp=(char*)ddata;


  r0=temp+((y+2)%3)*(xpix+2);
  r1=temp+((y+3)%3)*(xpix+2);
  r2=temp+((y+4)%3)*(xpix+2);

  xp=temp+3*(xpix+2);

  g0=xp+((y+2)%3)*(xpix+2);
  g1=xp+((y+3)%3)*(xpix+2);
  g2=xp+((y+4)%3)*(xpix+2);

  xp=temp+6*(xpix+2);

  b0=xp+((y+2)%3)*(xpix+2);
  b1=xp+((y+3)%3)*(xpix+2);
  b2=xp+((y+4)%3)*(xpix+2);



  /* read in one row     */
  /* always read into r0 */

  if(xlo==0)
  {
   r=r0+1;
   g=g0+1;
   b=b0+1;
   xlox=xlo;
  }
  else
  {
   r=r0;
   g=g0;
   b=b0;
   xlox=xlo-1;
  }

  if(xhi>=xpix) xhix=xhi;
  else          xhix=xhi+1;

  switch(bpp)
  {
   case  1:
   case  2:
   case  4:
   case  8:
           sdata+=(xlox*bpp)/32;
           shift=(xlox*bpp)&0x1F;
           w=*sdata++;
                                          /* clear 32-shift bits */
           for(x=xlox;x<xhix;x++)
           {
            c=(w>>shift)&mask;

            *r++=rtab[c];
            *g++=gtab[c];
            *b++=btab[c];

            shift+=bpp;
            if(shift>=32)
            {
             w=*sdata++;
             shift=0;
            }
           }
           break;


   case 16:
           sdata+=(xlox*bpp)/32;
           shift=(xlox*bpp)&0x1F;
           w=*sdata++;
                                          /* clear 32-shift bits */
           for(x=xlox;x<xhix;x++)
           {
            c=(w>>shift)&mask;

            *r++=(char)((c<<3)&0xF8);
            *g++=(char)((c>>2)&0xF8);
            *b++=(char)((c>>7)&0xF8);

            shift+=bpp;
            if(shift>=32)
            {
             w=*sdata++;
             shift=0;
            }
           }
           break;

   case 24:
           sp+=3*xlox;
           for(x=xlox;x<xhix;x++)
           {
            *r++=*sp++;
            *g++=*sp++;
            *b++=*sp++;
           }
           break;

   case 32:
           sdata+=xlox;
           for(x=xlox;x<xhix;x++)
           {
            w=*sdata++;
            *r++=(char)(w&0xFF);
            *g++=(char)((w>>8)&0xFF);
            *b++=(char)((w>>16)&0xFF);
           }
           break;
  }


  if(xlo==0)
  {
   r0[0]=r0[1];
   g0[0]=g0[1];
   b0[0]=b0[1];
  }

  if(xhi>=xpix)
  {
   r0[xpix+1]=r0[xpix];
   g0[xpix+1]=g0[xpix];
   b0[xpix+1]=b0[xpix];
  }

  /* r0 is always next row of data */
  /* r1 is always current row of data */
  /* r2 is always prev row of data */


  if(y>ylo)  /* output the line at y-1 */
  {
   xlo=(*s)[y-1-ylo].xlo;
   xhi=(*s)[y-1-ylo].xhi;

   r0p=r0;
   r1p=r1;
   r2p=r2;
   g0p=g0;
   g1p=g1;
   g2p=g2;
   b0p=b0;
   b1p=b1;
   b2p=b2;


   if(bpp<=8)
   {
    ddata+=(xlo*bpp)/32;
    shift=(xlo*bpp)&0x1F;
    w=*ddata;

    if(shift==0) w=0;
    else         w=w<<(32-shift);

    if(shift==0) c=0;
    else         c=w>>(32-shift);   /* clearing bits */

    for(x=xlo;x<xhi;x++)
    {
     rv=med(r2p++,r1p++,r0p++);

     if(grey)
     {
      w=gtab[rv];
     }
     else
     {
      bv=med(b2p++,b1p++,b0p++);
      gv=med(g2p++,g1p++,g0p++);

      w=((rv&0xF0)<<4)|(gv&0xF0)|((bv&0xF0)>>4);
      w=rgbmap[w];
     }

     c|=w<<shift;
     shift+=bpp;
     if(shift>=32)
     {
      *ddata++=c;
      shift=c=0;
     }
    }

    if(shift)
    {
     w=*ddata;
     w=w>>shift;
     w=w<<shift;
     w|=c;
     *ddata=w;
    }
   }
   else
   if(bpp==16)
   {
    ddata+=(xlo*bpp)/32;
    shift=(xlo*bpp)&0x1F;
    w=*ddata;

    if(shift==0) w=0;
    else         w=w<<(32-shift);

    if(shift==0) c=0;
    else         c=w>>(32-shift); /* clearing bits */

    for(x=xlo;x<xhi;x++)
    {
     rv=med(r2p++,r1p++,r0p++);
     bv=med(b2p++,b1p++,b0p++);
     gv=med(g2p++,g1p++,g0p++);

     w=((rv&0xF8)>>3)|((gv&0xF8)<<2)|((bv&0xF8)<<7);

     c|=w<<shift;
     shift+=bpp;
     if(shift>=32)
     {
      *ddata++=c;
      shift=c=0;
     }
    }
    if(shift)
    {
     w=*ddata;
     w=w>>shift;
     w=w<<shift;
     w|=c;
     *ddata=w;
    }
   }
   else
   if(bpp==24)
   {
    dp+=3*xlo;
    for(x=xlo;x<xhi;x++)
    {
     *dp++=(char)med(r2p++,r1p++,r0p++);
     *dp++=(char)med(g2p++,g1p++,g0p++);
     *dp++=(char)med(b2p++,b1p++,b0p++);
    }
   }
   else
   if(bpp==32)
   {
    ddata+=xlo;
    for(x=xlo;x<xhi;x++)
    {
     w=med(r2p++,r1p++,r0p++);
     w|=med(g2p++,g1p++,g0p++)<<8;
     w|=med(b2p++,b1p++,b0p++)<<16;
     *ddata++=w;
    }
   }
  }
 }

 flex_free((flex_ptr)&temp);

 return(err);
}
