/*->c.mask */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <math.h>


#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "config.h"
#include "dbhi.h"


#include "str.h"
#include "constants.h"

#include "reslink.h"

#include "file.h"
#include "view.h"

#include "im.h"
#include "cmap.h"
#include "col.h"
#include "filter.h"
#include "pal.h"
#include "hsv.h"
#include "long.h"

#include "mask.h"





void maskcut(int * s,int sbpp,int * d,int dbpp,int n)
{
 int  smask;
 int  sshift;
 int  dmask;
 int  dshift;
 int  ss;
 int  dd;
 int  m;
 char map[256];
 int  i;
 int  delta;

 smask=(1<<sbpp)-1;
 dmask=(1<<dbpp)-1;

 delta=smask/2-1;
 if(delta<0) delta=0;

 for(i=0;i<=smask;i++)
 {
  map[i]=(char)((i*dmask+delta)/smask);
 }


 ss=*s++;
 dd=0;
 sshift=dshift=0;

 while(1)
 {
  m=(ss>>sshift) & smask;
  sshift+=sbpp;
  m=map[m];
  dd|=(m<<dshift);
  dshift+=dbpp;

  if(--n==0) break;

  if(sshift>=32)
  {
   ss=*s++;
   sshift=0;
  }

  if(dshift>=32)
  {
   *d++=dd;
   dshift=dd=0;
  }
 }


 if(dshift>0)
 {
  *d++=dd;
 }
}









void maskflip(int * s,int sbpp,int n)
{
 int  smask;
 int  sshift;
 int  ss;
 int  dd;
 int  m;

 smask=(1<<sbpp)-1;

 ss=*s;
 dd=0;
 sshift=0;

 while(n--)
 {
  m=(ss>>sshift) & smask;
  m=smask-m;
  dd|=(m<<sshift);
  sshift+=sbpp;

  if(sshift>=32)
  {
   *s++=dd;
   ss=*s;
   sshift=0;
   dd=0;
  }
 }


 if(sshift>0)
 {
  *s++=dd;
 }
}





os_error * maskcolour(imagestr * im,imagestr * mim,int * ncol,char * index)
{
 os_error * err;
 int   x;
 int   y;
 int   mbpp;
 int   bpp;
 int * idata;
 int * mdata=NULL;
 int   xpix;
 int   ypix;
 int   word;
 int   mword;
 int   shift;
 int   mshift;
 int   mask;
 int   mmask;
 char  used[256];
 int   sbyte;
 int   mbyte;


 err=NULL;

 memset(used,0,sizeof(used));

 xpix=im->xpix;
 ypix=im->ypix;
 bpp=im->bpp;
 mbpp=(mim==NULL)?0:mim->bpp;


 word=mword=0;
 shift=mshift=32;
 mmask=0;

 if(bpp==1) mask=0x1;
 else
 if(bpp==2) mask=0x3;
 else
 if(bpp==4) mask=0xF;
 else       mask=0xFF;

 if(mbpp)
 {
  if(mbpp==1) mmask=0x1;
  else
  if(mbpp==2) mmask=0x3;
  else
  if(mbpp==4) mmask=0xF;
  else        mmask=0xFF;
 }



 for(y=0;y<ypix;y++)
 {
  if(mbpp) err=imfind2rr(im,y,&idata,mim,y,&mdata);
  else     err=imfind1r(im,y,&idata);

  for(x=0;x<xpix;x++)
  {
   if(shift==32)
   {
    word=*idata++;
    shift=0;
   }
   sbyte=(word>>shift)&mask;
   shift+=bpp;

   if(mbpp)
   {
    if(mshift==32)
    {
     mword=*mdata++;
     mshift=0;
    }
    mbyte=(mword>>mshift)&mmask;
    mshift+=mbpp;

    if(mbyte!=0) used[sbyte]++;
   }
   else
   {
    used[sbyte]++;
   }
  }
 }

 *ncol=0;

 for(x=0;x<(1<<bpp);x++)
 {
  if(used[x]==0)
  {
   *ncol=(*ncol)+1;
   *index++=(char)x;
  }
 }

 return(err);
}


