/*->c.main */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "conf.h"
#include "etc.h"
#include "flex.h"
#include "sp.h"
#include "deb.h"
#include "appinfo.h"
#include "mlo.h"
#include "osddex.h"
#include "osshell.h"
#include "bits.h"
#include "dbhi.h"
#include "appreg.h"
#include "oshelp.h"
#include "filetype.h"


#include "resource.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"


#include "file.h"
#include "view.h"
#include "pr.h"
#include "im.h"
#include "configx.h"
#include "edit.h"
#include "page.h"
#include "fx.h"
#include "user.h"
#include "col.h"
#include "pal.h"
#include "hist.h"
#include "format.h"
#include "misc.h"
#include "compare.h"
#include "target.h"
#include "cms.h"
#include "resize.h"


#include "main.h"



int    version=124;
int    compatability=0;
char * datestring="(8th-January-2007)";



void zerofilesquit(os_error * err)
{
	if(userfiles()==0)
 {
  if(err) report(err);
  pollquit(0); 
 }
}


static void terminatelo(void)
{
 event(EVENT_ENDPROGRAM,NULL,0);
 scrapfinit();
 flex_finit();
 exit(0);
}




static os_error * terminatemessage(wimp_msgstr * msg,int * ack)
{
 scanterminate();
 USE(msg);
 USE(ack);
 return(NULL);
}



/* return 1 if not to quit */


static int termnok(void)
{
 int n=unsaved();
 int code;


#ifdef _DEBUG 
 flex_checkheap("dcs");
 wimp_check("dcs");
 poll_check("dcs");
 fs_scanstats();

#endif



 if(n)
 {
  if(n==1) confirmparent(0,CONDC,&code,"{FS10}");  /* files edited but not saved */
  else     confirmparent(0,CONDC,&code,"%d {FS09}",n);

  if(code!=1) return(1);
 }

 return(0);
}




void scanterminate(void)
{
// int code;
// confirmparent(0,CONDC,&code,"terminate");

 if(!termnok()) terminatelo();
}





/* set ack to 1 if you want to stop the quit sequence */

/*
static os_error * prequithandler(uservalue userhandle,int * ack,int prequit) 
{
 if(prequit==1)
 {
  if(unsaved()) *ack=1;
 }
 else
 {
  if(termnok()) *ack=1;
  else
  {
   closeallfiles();
  }
 }
 return(NULL);

 USE(userhandle);
}
*/



static os_error * addmessages(void)
{
 os_error * err;

          err=addmessage(terminatemessage,wimp_MCLOSEDOWN);
// if(!err) err=addprequit(prequithandler,0);

 return(err);
}






static os_error * appregevent(wimp_w handle,int event)
{
 os_error * err;

 err=NULL;

 switch(event)
 {

 case APPREGDOC:
                if(firstfile && firstfile->view)
                helptopic((firstfile->view)->handle,"<HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\DPScan.exe\\Path>\\DPScan.chm::/registration.htm>");
                break;

 }

 return(err);

 USE(handle);
}







static os_error * helpdecode(int * menu,wimp_w window)
{
 os_error * err;

 err=NULL;

 switch(menu[0])
 {


  case ID_HELP_ABOUTDPSCAN:
                                infowindow(window,version,datestring);
                                break;

	    case	ID_HELP_REGISTER:
                              err=appregwindow(window);
                              break;



  case    ID_HELP_HELPTOPICS:
                                helptopic(window,"<HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\DPScan.exe\\Path>\\DPScan.chm>");
                                break;


 }

 return(err);
}





/* open info window and pass back pointer */

os_error * maindynamic(int * menu,char * handle,wimp_w window)
{
 os_error * err;

 err=NULL;

// cprintf("main dynamic %d",menu[0]);

 menuview=viewfromwindow(window);
 menufile=menuview->file;

 switch(menu[0])
 {
  case 0:
         err=filedynamic(menu+1,handle);
         break;

  case 1:
         err=viewdynamic(menu+1,handle);
         break;

  case 2:
         err=editdynamic(menu+1,handle);
         break;

  case 3:
         err=filterdynamic(menu+1,handle);
         break;

  case 4:
         err=colourdynamic(menu+1,handle);
         break;

  case 5:
   //      err=miscdynamic(menu+1,handle);
         break;

 }

 return(err);
}




os_error * mainsetup(void)
{
 os_error * err;

 err=NULL;

          err=viewsetup();
 if(!err) err=filesetup();
 if(!err) err=editsetup();
 if(!err) err=coloursetup();
 if(!err) err=filtersetup();
 if(!err) err=miscsetup();

 return(err);
}




os_error * maindecode(int * menu,wimp_w window)
{
 os_error * err;

 err=NULL;

// cprintf("m[0]=%d [1]=%d",menu[0],menu[1]);

 menuview=viewfromwindow(window);
 menufile=menuview->file;


 switch(menu[0])
 {
  case 0:
         err=filedecode(menu+1,window);
         break;

  case 1:
         err=viewdecode(menu+1,window);
         break;

  case 2:
         err=editdecode(menu+1);
         break;

  case 3:
         err=filterdecode(menu+1,window);
         break;

  case 4:
         err=colourdecode(menu+1); 
         break;

  case 5:
         err=miscdecode(menu+1,window);
         break;

  case 6:
         err=helpdecode(menu+1,window);
									break;


 }


// mainsetup();


 return(err);
}





static int productcodes[]=
{
 APPREGOPCODE,
 APPREGOPSLCODE,
 APPREGDPSCANCODE,
 APPREGDPSCANSLCODE,
 APPREGLASTCODE
};




static void crashcleanup(void)
{
 flex_finit();
}







int main(int argc,char * argv[])
{ 
 os_error * err;


 setlocale(LC_ALL,".1252");

 osshellinit(0);


 err=inittask("DPScan","DPScan","!dpscan",NULL,NULL,NULL);

 if(!err) err=appreginit(appregevent,productcodes);

 if(err)
 {
  report(err);
  exit(0);
 }


// debugenable(crashcleanup);

 wimpt_setcrash(crashcleanup);



 if(!err) err=resinit(NULL);

// if(!err) err=addspritesx(NULL,"Sprites2.spr");


 if(!err) err=addmessages();


 if(!err) err=initdoc();


 if(!err) err=prinit();
 if(!err) err=iminit();
 if(!err) err=palinit();
 if(!err) err=histinit();
 if(!err) err=resizeinit();

 if(!err) err=cmsinit();

	cprintf("config init1 err=%x",err);

 if(!err) err=configinit();

	cprintf("config init2 err=%x",err);

 if(!err) err=scrapinit("DPScan",scrappath);

 if(!err) err=ddestart("dpscan");

 if(!err) err=userinit();

 if(!err) err=formatinit();

 if(!err) err=compareinit();

 if(!err) err=targetinit();




 if(err)
 {
  report(err);
  scanterminate();
 }


 event(EVENT_RUNPROGRAM,NULL,0);

 cprintf("point 1");

 if(argc==3)              /* check that called with '-Print' */
 {
 /* err=printdoc(argv[2]); */

		if(!cstrcmp(argv[1],"-JPEG"))
		{
			err=loadanyfile(argv[2]);
   if(!err)
   {
				fs_newextension(firstfile->sname,"jpg");
				err=saveimagefile(firstfile->sname,JPEG,firstfile->frames[0].xim->sim[0]);
			}
   report(err);
		}
 }
 else
 if(argc==2)
 {
  if(cstrcmp(argv[1],"-dde"))
  {
   err=loadanyfile(argv[1]);
   if(err)
   {
    report(err);
    err=newdocument();
   }
  }
 }
 else
 {
  err=newdocument();
 }

 if(!err) err=prinit2();		// if we do this before opening a window, window opens at back

 cprintf("point 2");

#if !defined(_DEBUG) && !defined(WIN64) && 0
 if(!err)
 {
  if(firstfile && firstfile->view)
  {
   err=appreg2("OvationPro",(firstfile->view)->handle,APPREGABS);
  }
 }
#endif

 if(err)
 {
  report(err);
  scanterminate();
 }


 runtask();

 return(0);
}

