/*->c.magnify */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "bbc.h"
#include "transform.h"

#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "colour.h"
#include "drag.h"
#include "key.h"
#include "deb.h"
#include "dbhi.h"


#include "str.h"
#include "reslink.h"
#include "file.h"

#include "viewo.h"
#include "viewr.h"
#include "view.h"

#include "undo.h"
#include "tw.h"

#include "infopal.h"
#include "tools.h"
#include "rulers.h"

#include "magnify.h"



/***************************************************************************/

static os_error * setzooms(viewstr * view,int mul,int div)
{
 os_error * err;

 err=NULL;

 if(mul>(div*100)) {mul=100;div=1;}
 else
 if(div>(mul*10)) {mul=1;div=10;}

 view->data.zoom.mul=mul;
 view->data.zoom.div=div;

 setviewscalefactor(view);

 setviewextent(view,(filestr*)view->file);
 viewopenshift(view,(filestr*)view->file,0,0);

 viewdeleteimage(view,(filestr*)view->file);
 viewcreateimage(view,(filestr*)view->file);
 refreshview(view);
 refreshrulers(view,(filestr*)view->file);

 mfill(view,(filestr*)view->file);

 return(err);
}


/***************************************************************************/


static os_error * setzoom(viewstr * view,int mul,int div)
{
 if(mul<0 || div<0) return(NULL);

 view->zcur=(view->zcur+1)&ZOOMMASK;
 view->zoomstack[view->zcur].mul=mul;
 view->zoomstack[view->zcur].div=div;
 view->zlast=(view->zcur+1)&ZOOMMASK;
 if(view->zlast==view->zfirst) view->zfirst=(view->zfirst+1)&ZOOMMASK;
 return(setzooms(view,mul,div));
}


static os_error * prevzoom(viewstr * view)
{
 os_error * err;

 err=NULL;

 if(view->zcur!=view->zfirst)
 {
  view->zcur=(view->zcur-1)&ZOOMMASK;
  err=setzooms(view,view->zoomstack[view->zcur].mul,
          view->zoomstack[view->zcur].div);
 }

 return(err);
}


static os_error * nextzoom(viewstr * view)
{
 os_error * err;
 int        next;

 err=NULL;

 next=(view->zcur+1)&ZOOMMASK;

 if(next!=view->zlast)
 {
  view->zcur=next;
  err=setzooms(view,view->zoomstack[view->zcur].mul,
          view->zoomstack[view->zcur].div);
 }

 return(err);
}


os_error * magnifyinit(viewstr * view,filestr * file)
{
 view->zfirst=0;
 view->zlast=1;
 view->zcur=0;
 view->zoomstack[0].div=view->zoomstack[0].mul=1;
 return(NULL);
 USE(file);
}


/***************************************************************************/

static os_error * zoom20(viewstr * view)
{
 return(setzoom(view,1,5));
}

static os_error * zoom50(viewstr * view)
{
 return(setzoom(view,1,2));
}

static os_error * zoomnorm(viewstr * view)
{
 return(setzoom(view,1,1));
}

static os_error * zoom150(viewstr * view)
{
 return(setzoom(view,3,2));
}

static os_error * zoom200(viewstr * view)
{
 return(setzoom(view,2,1));
}

static os_error * zoom300(viewstr * view)
{
 return(setzoom(view,3,1));
}



/* find size of screen, find size of image */

static os_error * zoomscreen(viewstr * view)
{
 os_error * err;
 filestr  * file;
 int        xdpi;
 int        ydpi;
 framestr * frame;
 imagestr * im;
 int        fn;
 int        iw;
 int        ih;

 err=NULL;

 file=(filestr*)view->file;

 if(file->framen && file->frames)
 {
  fn=view->frame;

  frame=&file->frames[fn];
  im=((frame->xim)->sim[IM]);

  xdpi=im->xdpi;
  ydpi=im->ydpi;
 }
 else return(err);

 iw=scale(im->xpix,180,xdpi);
 ih=scale(im->ypix,180,ydpi);

 if(iw*cvdu.screeny>ih*cvdu.screenx) err=setzoom(view,cvdu.screenx,iw);
 else                                err=setzoom(view,cvdu.screeny,ih);

 return(err);
}



static os_error * zoomwind(viewstr * view)
{
 os_error * err;
 filestr  * file;
 int        xdpi;
 int        ydpi;
 framestr * frame;
 imagestr * im;
 int        fn;
 int        iw;
 int        ih;
 int        wx;
 int        wy;
 windowstr  window;

 err=NULL;

 file=(filestr*)view->file;

 if(file->framen && file->frames)
 {
  fn=view->frame;

  frame=&file->frames[fn];
  im=((frame->xim)->sim[IM]);

  xdpi=im->xdpi;
  ydpi=im->ydpi;
 }
 else return(err);

 iw=scale(im->xpix,180,xdpi);
 ih=scale(im->ypix,180,ydpi);

 getw(view->handle,&window);

 wx=window.x1-window.x0;
 wy=window.y1-window.y0;

 if(iw*wy>ih*wx) err=setzoom(view,wx,iw);
 else            err=setzoom(view,wy,ih);

 return(err);
}



static os_error * zoomrational(viewstr * view)
{
 os_error * err;
 filestr  * file;
 int        xdpi;
 int        ydpi;
 framestr * frame;
 imagestr * im;
 int        fn;
 int        iw;
 int        ih;
 int        sxdpi;
 int        sydpi;

 err=NULL;

 file=(filestr*)view->file;

 if(file->framen && file->frames)
 {
  fn=view->frame;

  frame=&file->frames[fn];
  im=((frame->xim)->sim[IM]);

  xdpi=im->xdpi;
  ydpi=im->ydpi;
 }
 else return(err);

 iw=scale(im->xpix,180,xdpi);
 ih=scale(im->ypix,180,ydpi);

 sxdpi=180/cvdu.deltax;   /* screen res */
 sydpi=180/cvdu.deltay;

 sxdpi=cvdu.xdpi;
 sydpi=cvdu.ydpi;

 if(xdpi*sydpi>ydpi*sxdpi) err=setzoom(view,xdpi,sxdpi);
 else                      err=setzoom(view,ydpi,sydpi);

 return(err);
}


/*****************************************************************************/
/* code to do magnify drag box */

static viewstr * sview;
static filestr * sfile;

static int       sdrag;
static boxstr    sbox;

static int       sdrgx;
static int       sdrgy;
static int       scx;
static int       scy;
static int       omx;
static int       omy;




static void supdatebox(void)
{
 wimp_box      box;

 box.x0=osunits(sbox.x,sview)-cvdu.extrax;
 box.x1=osunits(sbox.x+sbox.w,sview)+cvdu.extrax;
 box.y1=-osunits(sbox.y,sview)+cvdu.extray;
 box.y0=-osunits(sbox.y+sbox.h,sview)-cvdu.extray;

 viewupdatelayer(sfile,&box,VRSELECT);
}


static os_error * sdragzero(wimp_w handle,uservalue userhandle,wimp_mousestr * mstr)
{
 windowstr     window;
 int           scroll;

 
// wimp_get_point_info(&mstr);
 getw(sview->handle,&window);

 scroll=autoscroll(sview,mstr,0,0);

 if(mstr->x!=omx || mstr->y!=omy || scroll)
 {
  supdatebox();

  scx=ourunits(mstr->x-window.bx,sview);
  scy=-ourunits(mstr->y-window.by,sview);

  sbox.x=MIN(scx,sdrgx);
  sbox.y=MIN(scy,sdrgy);
  sbox.w=ABS(scx-sdrgx);
  sbox.h=ABS(scy-sdrgy);

  supdatebox();

  omx=mstr->x;
  omy=mstr->y;
 }

 return(NULL);

 USE(handle);
 USE(userhandle);
}


/* end drag */

static os_error * sdragfn(wimp_w handle,uservalue userhandle,wimp_box * wbox)
{
 windowstr  window;
 wimp_box   box;
 int        w;
 int        h;
 int        ww;
 int        wh;
 int        m1;
 int        m2;

// remzeroevent(sdragzero,0);
 supdatebox();
 sdrag=0;

 getw(sview->handle,&window);

 box.x0=osunits(sbox.x,sview)-cvdu.extrax;
 box.x1=osunits(sbox.x+sbox.w,sview)+cvdu.extrax;
 box.y1=osunits(sbox.y,sview)+cvdu.extray;
 box.y0=osunits(sbox.y+sbox.h,sview)-cvdu.extray;

 w=box.x1-box.x0;
 h=box.y0-box.y1;

 ww=window.x1-window.x0;
 wh=window.y1-window.y0;

 m1=scale(0x10000,ww,w);
 m2=scale(0x10000,wh,h);

 if(m1<m2) setzoom(sview,ww,w);
 else      setzoom(sview,wh,h);

 box.x0=osunits(sbox.x,sview)-cvdu.extrax;
 box.y1=osunits(sbox.y,sview)+cvdu.extray;

 viewopenshift(sview,sfile,box.x0-window.scx,-(box.y1+window.scy));

 return(NULL);

 USE(handle);
 USE(userhandle);
 USE(wbox);
}



static os_error * sstartdrag(viewstr * view,wimp_w handle,wimp_mousestr * m)
{
 windowstr window;

 sview=view;
 sfile=(filestr*)sview->file;

 getw(handle,&window);

 scx=sdrgx=ourunits(m->x-window.bx,view);
 scy=sdrgy=-ourunits(m->y-window.by,view);

 startdrag2(handle,0,sdragfn,sdragzero);
 userdrag(handle,window.x0,window.y0,window.x1,window.y1);
// addzeroevent(sdragzero,0);
 sdrag=1;
 omx=omy=-1;

 sbox.x=MIN(scx,sdrgx);
 sbox.y=MIN(scy,sdrgy);
 sbox.w=ABS(scx-sdrgx);
 sbox.h=ABS(scy-sdrgy);

 supdatebox();

 return(NULL);
}


/*****************************************************************************/

os_error * mfill(viewstr * view,filestr * file)
{
 os_error * err;
 int        fn;
 wimp_w     handle;

 err=NULL;

 if(view->info)
 {
  handle=view->info;

  err=writeiconf(handle,2,"%d%%",(view->data.zoom.mul*100)/
                                 (view->data.zoom.div));

  if(file->framen)
  {
   fn=view->frame;
   writeiconfc(handle,21,"%d",fn+1);
   writeiconfc(handle,22,"/%d",file->framen);
  }
  else
  {
   writeicon(handle,21,"0");
   writeicon(handle,22,"/0");
  }

  selectst(handle,25,view->data.dither);
 }

 return(err);
}



os_error * mredraw(viewredrawstr * v)
{
 os_error * err;

 err=NULL;

 if(sdrag && sfile==v->file)
 {
  seteorcol(WIMPWHITE,WIMPRED);
  rbox(v,&sbox);
 }
 return(err);
}


void mselect(int select,viewstr * view)
{
 USE(view);
 USE(select);
}


os_error * mviewkey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 USE(handle);
 USE(userhandle);
 USE(icon);
 USE(key);

 return(NULL);
}


os_error * mviewicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;
 viewstr  * view;

 view=(viewstr*)userhandle;

 if(m->bbits==VBCLICKS)  err=nextzoom(view);
 else
 if(m->bbits==VBCLICKA)  err=prevzoom(view);
 else
 if(m->bbits==VBDRAGS)   err=sstartdrag(view,handle,m);
 else                    err=NULL;

 return(err);

 USE(handle);
 USE(userhandle);
 USE(m);

 return(NULL);
}


/*****************************************************************************/

static os_error * grabvalues(wimp_w handle,uservalue userhandle)
{
 os_error * err;
 framestr * frame;
 int        fn;
 int        m;
 int        f;
 int        x;
 viewstr  * sview;
 filestr  * sfile;

 err=NULL;

 sview=(viewstr*)userhandle;
 sfile=(filestr*)sview->file;

 fn=sview->frame;

 frame=&sfile->frames[fn];

 if(sfile->framen)
 {
  err=geticonint(handle,21,&f);

  if(!err && (f!=(fn+1))) /* goto page */
  {
   err=gotoframe(sview,sfile,f-1); /* implicit fill */
  }

  err=geticonint(handle,2,&m);
  if(!err)
  {
   x=(sview->data.zoom.mul*100)/sview->data.zoom.div;
   if(m!=x)
   {
    err=setzoom(sview,m,100);
   }
  }
 }
 return(err);
}




#define MAXWI 2



              /* N L R D U */

static char entryiclst[MAXWI][5]=
{
          2,          0,           0,          21,            0,
         21,          0,           0,           0,            2,
};



os_error * mkey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 os_error * err;
 int        cicon;
 int        j;
 int        ch;

 err=NULL;
 ch=*key;

 switch(ch)
 {
       case 27:
               break;

   case RETURN:
               err=grabvalues(handle,userhandle);
               break;

    case 0x18E:
    case 0x18F:
    case 0x19C:
    case 0x19D:
               ch&=0x18F;
               for(j=0;j<MAXWI;j++) if(entryiclst[j][0]==icon) break;
               cicon=entryiclst[j][(ch-0x18B)];
               if(cicon)
               {
                iecarrot(handle,cicon);
               }
               break;

       default:
               return(NULL);
 }
 *key=-1;

 return(err);

 USE(userhandle);
}


/*****************************************************************************/

os_error * micon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case  8:
          err=zoom20(infoview);
          break;
  case  9:
          err=zoom50(infoview);
          break;
  case 10:
          err=zoomnorm(infoview);
          break;
  case 11:
          err=zoom150(infoview);
          break;
  case 12:
          err=zoom200(infoview);
          break;
  case 13:
          err=zoom300(infoview);
          break;
  case  4:
          if(m->bbits==VBCLICKS) err=prevzoom(infoview);
          else                   err=nextzoom(infoview);
          break;
  case  5:
          err=zoomscreen(infoview);
          break;
  case  6:
          err=zoomwind(infoview);
          break;
  case  7:
          err=zoomrational(infoview);
          break;


  case 25:
          selectst(handle,25,infoview->data.dither^=1);
          err=viewdeleteimage(infoview,infofile);
          viewcreateimage(infoview,infofile);
          mfill(infoview,infofile);
          refreshview(infoview);
          break;


  case 23:  /* up   */
  case 24:  /* down */
          if(m->bbits==VBCLICKS)
          {
           if(m->i==23) err=nextframe();
           else         err=prevframe();
          }
          else
          if(m->bbits==VBCLICKA)
          {
           if(m->i==24) err=nextframe();
           else         err=prevframe();
          }
          break;


  case 16: /* undo */
          err=imageundo();
          break;

  case 17: /* redo */
          err=imageredo();
          break;

  case 18: /* acquire */
          err=twainacquire();
          break;

 }

 return(err);

 USE(handle);
 USE(userhandle);
}

