/*->c.long */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <time.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "bbc.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "redraw.h"
#include "colour.h"
#include "units.h"
#include "save.h"
#include "bits.h"
#include "hourglass.h"

#include "mlo.h"

#include "str.h"
#include "constants.h"


#include "long.h"



int longproc;
int longbeep;

static int oldmemc;
static int totalticks;
static int tickn;
static int dontpoll;

static int lastbeep;



contokstr longtoks[]=
{
 "Hourglass",LHG,
 "Fast",LDMA,
 "Multitask",LMTSK,
 NULL,0,
};







static void dolongbeep(void)
{
 if(longbeep) bbc_vdu(7);
}


/* never used, just to enable zero polls */

static void tacqzero(uservalue userhandle)
{
 USE(userhandle);
}



void longprocstart(char * why,int nopoll,int ticks,viewstr * view)
{

 dontpoll=nopoll;

 if(longproc==LDMA)
 {

 }
 else
 if(longproc==LHG || dontpoll)
 {
  totalticks=ticks;
  tickn=0;
  hourglasson();
 }
 else
 if(longproc==LMTSK)
 {
  dolongbeep();
  lastbeep=clock();
  addzeroevent(tacqzero,0);
 }

 USE(view);
 USE(why);
}



void longprocend(void)
{

 if(longproc==LDMA)
 {

 }
 else
 if(longproc==LHG || dontpoll)
 {
  hourglassoff();
 }
 else
 if(longproc==LMTSK)
 {
  if((clock()-lastbeep)>350) dolongbeep();
  remzeroevent(tacqzero,0);
 }
}


os_error * longproctick(void)
{
 if(longproc==LHG || dontpoll)
 {
  tickn++;
  hourglasspc((tickn*100)/totalticks);
 }
 else
 if(longproc==LMTSK)
 {
  poll();
 }

 return(NULL);
}



os_error * longproctick2(int i,int total)
{
 if(longproc==LHG || dontpoll)
 {
  hourglasspc((i*100)/total);
 }
 else
 if(longproc==LMTSK)
 {
  poll();
 }

 return(NULL);
}


