/*->c.jpegd */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <setjmp.h>




#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "fsx.h"
#include "task.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "config.h"
#include "deb.h"
#include "dbhi.h"



#include "constants.h"
#include "str.h"

#include "file.h"
#include "view.h"
#include "cms.h"


#include "im.h"
#include "info.h"
#include "long.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "jpeglib.h"

#include "iccjpeg.h"


#ifdef __cplusplus
}
#endif /* __cplusplus */


#include "jpegd.h"








struct my_error_mgr 
{
 struct jpeg_error_mgr pub;    /* "public" fields */

 jmp_buf setjmp_buffer;        /* for return to caller */
};


typedef struct my_error_mgr * my_error_ptr;


static void my_error_exit(j_common_ptr cinfo)
{
 os_error     * err;
 my_error_ptr   myerr;
 char           string[256];

 myerr=(my_error_ptr)cinfo->err;

 (*cinfo->err->format_message) (cinfo,string);

 err=generror(0,string);

 longjmp(myerr->setjmp_buffer,(int)err);
}


static void internalerror(j_common_ptr cinfo,os_error * err)
{
 my_error_ptr   myerr;

 myerr=(my_error_ptr)cinfo->err;

 longjmp(myerr->setjmp_buffer,(int)err);
}





static char * jspace[]=
{
 "Unknown",
 "Greyscale",
 "RGB",
 "YCbCr (YUV)",
 "CMYK",
 "YCbCrK"
};




static os_error * getinfo(framestr * frame,j_decompress_ptr cinfo,improfilestr * profile)
{
 char   string[256];
 char   string2[256];
 char * p;

 p=string;

 p+=sprintf(p,"JPEG file\n");
 p+=sprintf(p,"%d x %d pixels %d bpp\n",frame->fxpix,frame->fypix,frame->fbpp);
 p+=sprintf(p,"Precision %d bits. %d component%c\n",cinfo->data_precision,
                   cinfo->num_components,cinfo->num_components>1?'s':' ');
 p+=sprintf(p,"Colour space: %s\n",jspace[cinfo->jpeg_color_space]);

 if(profile)
 {
  cmsprofilename(profile,string2,sizeof(string2));
  p+=sprintf(p,"Colour profile: %s\n",string2);
 }


 return(infowrite(string,frame));
}





static void output_init(j_decompress_ptr cinfo,imagestr ** imagep,
                        unsigned char ** iccdata,unsigned int icclen)
{
  /* This routine can initialize for output based on the data passed in cinfo.
   * Useful fields include:
   *    image_width, image_height       Pretty obvious, I hope.
   *    data_precision                  bits per pixel value; typically 8.
   *    out_color_space                 output colorspace previously requested
   *    color_out_comps                 number of color components in same
   *    final_out_comps                 number of components actually output
   * final_out_comps is 1 if quantize_colors is true, else it is equal to
   * color_out_comps.
   *
   * If you have requested color quantization, the colormap is NOT yet set.
   * You may wish to defer output initialization until put_color_map is called.
   */

 os_error * err;
 int        fn;
 imagestr * loadimage;

 err=addframe(loadfile,&fn,0);
 if(!err)
 {
  loadfile->frames[fn].fxpix=(int)cinfo->image_width;
  loadfile->frames[fn].fypix=(int)cinfo->image_height;
  sprintf(loadfile->frames[fn].name,"JPEG%d",fn);
   /* bf_tell(bf,&loadfile->frames[fn].offset); */
  loadfile->frames[fn].offset=0;

  if(cinfo->output_components==4) loadfile->frames[fn].fbpp=32;
  else
  if(cinfo->output_components==3) loadfile->frames[fn].fbpp=24;
  else                            loadfile->frames[fn].fbpp=8;

  if(cinfo->X_density==cinfo->Y_density && cinfo->X_density==0)
  {
   cinfo->X_density=90;
   cinfo->Y_density=90;
   cinfo->density_unit=1;
  }


  if(cinfo->density_unit==0)
  {
   loadfile->frames[fn].fxdpi=90;
   loadfile->frames[fn].fydpi=(90*cinfo->X_density)/cinfo->Y_density;
  }
  else
  if(cinfo->density_unit==1)  /* dpi */
  {
   loadfile->frames[fn].fxdpi=cinfo->X_density;
   loadfile->frames[fn].fydpi=cinfo->Y_density;
  }
  else
  if(cinfo->density_unit==2) /* dpcm */
  {
   loadfile->frames[fn].fxdpi=(254*cinfo->X_density)/100;
   loadfile->frames[fn].fydpi=(254*cinfo->Y_density)/100;
  }

  if(loadfile->frames[fn].fxdpi<10) loadfile->frames[fn].fxdpi=90;
  if(loadfile->frames[fn].fydpi<10) loadfile->frames[fn].fydpi=90;


  loadfile->frames[fn].xim=NULL;



  err=ximnew(loadfile->frames[fn].fxpix,loadfile->frames[fn].fypix,
                   loadfile->frames[fn].fbpp,&loadfile->frames[fn].xim);

  if(!err)
  {
   *imagep=loadimage=((loadfile->frames[fn].xim)->sim[IM]);

   loadimage->xdpi=loadfile->frames[fn].fxdpi;
   loadimage->ydpi=loadfile->frames[fn].fydpi;

   if(*iccdata)
   {
    cmsaddprofile(&loadimage->profile,iccdata,icclen,0);
    getinfo(&loadfile->frames[fn],cinfo,&loadimage->profile);
   }
   else
   {
    if(cinfo->output_components==4) cmscmykprofile(&loadimage->profile);
    else                            cmsrgbprofile(&loadimage->profile); 

    getinfo(&loadfile->frames[fn],cinfo,NULL);
   }


   if(cinfo->output_components==1) imsetgreypal(loadimage,8);
   else
   {
    loadimage->ipal.ncolours=0;
    loadimage->ipal.palclass=(cinfo->output_components==4)?CL_CMYK:CL_RGB;
   }
  }
 }
}



/*
 * Reading a JPEG file that may contain an ICC profile requires two steps:
 *
 * 1. After jpeg_create_decompress() but before jpeg_read_header(),
 *    call setup_read_icc_profile().  This routine tells the IJG library
 *    to save in memory any APP2 markers it may find in the file.
 *
 * 2. After jpeg_read_header(), call read_icc_profile() to find out
 *    whether there was a profile and obtain it if so.
 */


/*
 * Prepare for reading an ICC profile
 */

//extern void setup_read_icc_profile JPP((j_decompress_ptr cinfo));


/*
 * See if there was an ICC profile in the JPEG file being read;
 * if so, reassemble and return the profile data.
 *
 * TRUE is returned if an ICC profile was found, FALSE if not.
 * If TRUE is returned, *icc_data_ptr is set to point to the
 * returned data, and *icc_data_len is set to its length.
 *
 * IMPORTANT: the data at **icc_data_ptr has been allocated with malloc()
 * and must be freed by the caller with free() when the caller no longer
 * needs it.  (Alternatively, we could write this routine to use the
 * IJG library's memory allocator, so that the data would be freed implicitly
 * at jpeg_finish_decompress() time.  But it seems likely that many apps
 * will prefer to have the data stick around after decompression finishes.)
 */

//extern boolean read_icc_profile JPP((j_decompress_ptr cinfo,
//				     JOCTET **icc_data_ptr,
//				     unsigned int *icc_data_len));




#define ABUFFSIZE 0x10000


os_error * read_JPEG_file(char * filename)
{
 os_error                       * err;
 char                           * buffer1;
 int                            * idata;
 struct jpeg_decompress_struct    cinfo;
 struct my_error_mgr              jerr;
 FILE                           * infile;
// JSAMPARRAY                       buffer;
 imagestr                       * image;
 int                              line;
 unsigned char                  * iccdata;
 unsigned int                     icclen;


 buffer1=NULL;

 err=NULL;


 if((infile=fopen(filename,"rb")) == NULL)
 {
  err=generror(0,"Can't open %s\n",filename);
  return(err);
 }


 cinfo.err=jpeg_std_error(&jerr.pub);
 jerr.pub.error_exit=my_error_exit;


 if((err=(os_error*)setjmp(jerr.setjmp_buffer))!=NULL)
 {
  jpeg_destroy_decompress(&cinfo);
  fclose(infile);
  sfree((flex_ptr)&buffer1);
  return(err);
 }

 if(salloc((flex_ptr)&buffer1,ABUFFSIZE)==NULL)
 {
  if(buffer1)  setvbuf(infile,buffer1,_IOFBF,ABUFFSIZE);
 }


 jpeg_create_decompress(&cinfo);

	cprintf("sizeof cinfo %d",sizeof(cinfo));

 setup_read_icc_profile(&cinfo);

 jpeg_stdio_src(&cinfo, infile);

 jpeg_read_header(&cinfo,TRUE);





 if(!read_icc_profile(&cinfo,&iccdata,&icclen))
 {
  iccdata=NULL;

 }

  /* Step 4: set parameters for decompression */

 jpeg_start_decompress(&cinfo);

 output_init(&cinfo,&image,&iccdata,icclen);

/*
 buffer=(*cinfo.mem->alloc_sarray)
                ((j_common_ptr)&cinfo,JPOOL_IMAGE,
                              cinfo.output_width*cinfo.output_components,1);
*/


 while(cinfo.output_scanline<cinfo.output_height)
 {
  line=cinfo.output_scanline;

  err=imfind1w(image,line,&idata);

//  jpeg_read_scanlines(&cinfo,buffer,1);

  jpeg_read_scanlines(&cinfo,(unsigned char **)&idata,1);


  if(cinfo.jpeg_color_space==JCS_RGB)
  {

  }
  else
		if(cinfo.jpeg_color_space==JCS_YCbCr)
  {
   char * r;
   char * b;
   char * blt;

   r=b=(char*)idata;
   r+=2;
   blt=b+cinfo.image_width*3;
   while(b<blt)
   {
    SWOP((*r),(*b));
    r+=3;
    b+=3;
   }
  }
  else
  if(cinfo.jpeg_color_space==JCS_CMYK)
  {
   int * p;
   int * lt;

   p=idata;
   lt=p+cinfo.image_width;
   while(p<lt)
   {
    *p=(*p)^0xFFFFFFFF;
    p++;
   }
  }


  err=longproctick2(line,image->ypix);

  if(err) internalerror((j_common_ptr)&cinfo,err);

//  memcpy(idata,buffer[0],cinfo.output_width*cinfo.output_components);
 }


 jpeg_finish_decompress(&cinfo);


 jpeg_destroy_decompress(&cinfo);


 if(iccdata)
 {

  free(iccdata);
 }


 fclose(infile);

 sfree((flex_ptr)&buffer1);

 return(err);
}

