/*->c.jpegc */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <setjmp.h>



#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "fsx.h"
#include "task.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "dbhi.h"


#include "constants.h"
#include "str.h"

#include "file.h"
#include "view.h"

#include "im.h"

#include "cms.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "jpeglib.h"

#include "iccjpeg.h"

#ifdef __cplusplus
}
#endif /* __cplusplus */


#include "jpegc.h"


#ifdef NEVER



/*
 * <setjmp.h> is used for the optional error recovery mechanism shown in
 * the second part of the example.
 */




/* These static variables are needed by the error routines. */
static jmp_buf setjmp_buffer;   /* for return to caller */
static external_methods_ptr emethods; /* needed for access to message_parm */


/* This routine is used for any and all trace, debug, or error printouts
 * from the JPEG code.  The parameter is a printf format string; up to 8
 * integer data values for the format string have been stored in the
 * message_parm[] field of the external_methods struct.
 */

METHODDEF void
trace_message (const char *msgtext)
{
  fprintf(stderr, msgtext,
          emethods->message_parm[0], emethods->message_parm[1],
          emethods->message_parm[2], emethods->message_parm[3],
          emethods->message_parm[4], emethods->message_parm[5],
          emethods->message_parm[6], emethods->message_parm[7]);
  fprintf(stderr, "\n");        /* there is no \n in the format string! */
}


/*
 * The error_exit() routine should not return to its caller.  The default
 * routine calls exit(), but here we assume that we want to return to
 * read_JPEG_file, which has set up a setjmp context for the purpose.
 * You should make sure that the free_all method is called, either within
 * error_exit or after the return to the outer-level routine.
 */


static void internalerror(os_error * err)
{
 (*emethods->free_all)();      /* clean up memory allocation & temp files */
 longjmp(setjmp_buffer,(int)err);   /* return control to outer routine */
}


METHODDEF void error_exit(const char *msgtext)
{
 os_error * err;
 char       string[256];

 sprintf(string, msgtext,
         emethods->message_parm[0], emethods->message_parm[1],
         emethods->message_parm[2], emethods->message_parm[3],
         emethods->message_parm[4], emethods->message_parm[5],
         emethods->message_parm[6], emethods->message_parm[7]);

 err=generror(0,string);

 internalerror(err);
}



/******************** JPEG COMPRESSION SAMPLE INTERFACE *******************/

/* This half of the example shows how to feed data into the JPEG compressor.
 * We present a minimal version that does not worry about refinements such
 * as error recovery (the JPEG code will just exit() if it gets an error).
 */


/*
 * To supply the image data for compression, you must define three routines
 * input_init, get_input_row, and input_term.  These routines will be called
 * from the JPEG compressor via function pointer values that you store in the
 * cinfo data structure; hence they need not be globally visible and the exact
 * names don't matter.  (In fact, the "METHODDEF" macro expands to "static" if
 * you use the unmodified JPEG include files.)
 *
 * The input file reading modules (jrdppm.c, jrdgif.c, jrdtarga.c, etc) may be
 * useful examples of what these routines should actually do, although each of
 * them is encrusted with a lot of specialized code for its own file format.
 */

static imagestr * saveimage;
static int        crow;


METHODDEF void
input_init (compress_info_ptr cinfo)
/* Initialize for input; return image size and component data. */
{
  /* This routine must return five pieces of information about the incoming
   * image, and must do any setup needed for the get_input_row routine.
   * The image information is returned in fields of the cinfo struct.
   * (If you don't care about modularity, you could initialize these fields
   * in the main JPEG calling routine, and make this routine be a no-op.)
   * We show some example values here.
   */

  cinfo->image_width=saveimage->xpix;             /* width in pixels */
  cinfo->image_height=saveimage->ypix;            /* height in pixels */

  cinfo->density_unit=1;
  cinfo->X_density=saveimage->xdpi;
  cinfo->Y_density=saveimage->ydpi;

  /* JPEG views an image as being a rectangular array of pixels, with each
   * pixel having the same number of "component" values (color channels).
   * You must specify how many components there are and the colorspace
   * interpretation of the components.  Most applications will use RGB data or
   * grayscale data.  If you want to use something else, you'll need to study
   * and perhaps modify jcdeflts.c, jccolor.c, and jdcolor.c.
   */

  if(saveimage->bpp>8 || !imgrey(saveimage))
  {
   cinfo->input_components=3;          /* or 1 for grayscale */
   cinfo->in_color_space=CS_RGB;       /* or CS_GRAYSCALE for grayscale */
  }
  else
  {
   cinfo->input_components=1;
   cinfo->in_color_space=CS_GRAYSCALE;
  }

  cinfo->data_precision=8;            /* bits per pixel component value */

  /* In the current JPEG software, data_precision must be set equal to
   * BITS_IN_JSAMPLE, which is 8 unless you twiddle jconfig.h.  Future
   * versions might allow you to say either 8 or 12 if compiled with
   * 12-bit JSAMPLEs, or up to 16 in lossless mode.  In any case,
   * it is up to you to scale incoming pixel values to the range
   *   0 .. (1<<data_precision)-1.
   * If your image data format is fixed at a byte per component,
   * then saying "8" is probably the best long-term solution.
   */

 crow=0;
}


/*
 * This function is called repeatedly and must supply the next row of pixels
 * on each call.  The rows MUST be returned in top-to-bottom order if you want
 * your JPEG files to be compatible with everyone else's.  (If you cannot
 * readily read your data in that order, you'll need an intermediate array to
 * hold the image.  See jrdtarga.c or jrdrle.c for examples of handling
 * bottom-to-top source data using the JPEG code's portable mechanisms.)
 * The data is to be returned into a 2-D array of JSAMPLEs, indexed as
 *              JSAMPLE pixel_row[component][column]
 * where component runs from 0 to cinfo->input_components-1, and column runs
 * from 0 to cinfo->image_width-1 (column 0 is left edge of image).  Note that
 * this is actually an array of pointers to arrays rather than a true 2D array,
 * since C does not support variable-size multidimensional arrays.
 * JSAMPLE is typically typedef'd as "unsigned char".
 */

/* Read next row of pixels into pixel_row[][] */


/* This example shows how you might read RGB data (3 components)
 * from an input file in which the data is stored 3 bytes per pixel
 * in left-to-right, top-to-bottom order.
 */


METHODDEF void
get_input_row (compress_info_ptr cinfo,JSAMPARRAY pixel_row)
{
 os_error * err;
 JSAMPROW ptr0, ptr1, ptr2;
 int       * idata;
 int         xpix;
 int         bpp;
 int         shift;
 int         word;
 int         mask;
 int         sbyte;
 int         x;
 char      * p;

 ptr0=pixel_row[2];
 ptr1=pixel_row[1];
 ptr2=pixel_row[0];

 err=imfind1r(saveimage,crow++,&idata);
 if(err) internalerror(err);

 xpix=saveimage->xpix;
 bpp=saveimage->bpp;

 if(saveimage->bpp<=8)
 {
  word=0;   /* compiler */
  shift=32;

  if(bpp==1) mask=0x1;
  else
  if(bpp==2) mask=0x3;
  else
  if(bpp==4) mask=0xF;
  else       mask=0xFF;

  if(cinfo->input_components==1)
  {
   for(x=0;x<xpix;x++)
   {
    if(shift==32)
    {
     word=*idata++;
     shift=0;
    }
    sbyte=(word>>shift)&mask;
    shift+=bpp;

    sbyte=saveimage->ipal.word[sbyte];

    *ptr0++=(JSAMPLE)((sbyte>>8)  & 0xFF); /* red */
   }
  }
  else
  {
   for(x=0;x<xpix;x++)
   {
    if(shift==32)
    {
     word=*idata++;
     shift=0;
    }
    sbyte=(word>>shift)&mask;
    shift+=bpp;

    sbyte=saveimage->ipal.word[sbyte];

    *ptr0++=(JSAMPLE)((sbyte>>8)  & 0xFF); /* red */
    *ptr1++=(JSAMPLE)((sbyte>>16) & 0xFF); /* green */
    *ptr2++=(JSAMPLE)((sbyte>>24) & 0xFF); /* blue */
   }
  }
 }
 else
 if(saveimage->bpp==16)
 {
  for(x=0;x<xpix;x++)
  {
   word=*idata++;

   *ptr0++=(JSAMPLE)((word<<3)&0xF8); /* red */
   *ptr1++=(JSAMPLE)((word>>2)&0xF8); /* green */
   *ptr2++=(JSAMPLE)((word>>7)&0xF8); /* blue */

   x++;
   if(x>=xpix) break;

   *ptr0++=(JSAMPLE)((word>>13)&0xF8); /* red */
   *ptr1++=(JSAMPLE)((word>>18)&0xF8); /* green */
   *ptr2++=(JSAMPLE)((word>>23)&0xF8); /* blue */
  }
 }
 else
 if(saveimage->bpp==24)
 {
  p=(char*)idata;

  for(x=0;x<xpix;x++)
  {
   *ptr0++=(JSAMPLE)*p++; /* red */
   *ptr1++=(JSAMPLE)*p++; /* green */
   *ptr2++=(JSAMPLE)*p++; /* blue */
  }
 }
 else
 if(saveimage->bpp==32)
 {
  p=(char*)idata;

  for(x=0;x<xpix;x++)
  {
   *ptr0++=(JSAMPLE)*p++; /* red */
   *ptr1++=(JSAMPLE)*p++; /* green */
   *ptr2++=(JSAMPLE)*p++; /* blue */
   p++;
  }
 }
}


METHODDEF void
input_term (compress_info_ptr cinfo)
/* Finish up at the end of the input */
{
  /* This termination routine will very often have no work to do, */
  /* but you must provide it anyway. */
  /* Note that the JPEG code will only call it during successful exit; */
  /* if you want it called during error exit, you gotta do that yourself. */

 USE(cinfo);
}


/*
 * That's it for the routines that deal with reading the input image data.
 * Now we have overall control and parameter selection routines.
 */


/*
 * This routine must determine what output JPEG file format is to be written,
 * and make any other compression parameter changes that are desirable.
 * This routine gets control after the input file header has been read
 * (i.e., right after input_init has been called).  You could combine its
 * functions into input_init, or even into the main control routine, but
 * if you have several different input_init routines, it's a definite win
 * to keep this separate.  You MUST supply this routine even if it's a no-op.
 */

METHODDEF void
c_ui_method_selection (compress_info_ptr cinfo)
{
  /* If the input is gray scale, generate a monochrome JPEG file. */
  if (cinfo->in_color_space == CS_GRAYSCALE)
    j_monochrome_default(cinfo);
  /* For now, always select JFIF output format. */
  jselwjfif(cinfo);
}



#define ABUFFSIZE 0x10000




/*
 * OK, here is the main function that actually causes everything to happen.
 * We assume here that the target filename is supplied by the caller of this
 * routine, and that all JPEG compression parameters can be default values.
 */

os_error * write_JPEG_file(char * filename,imagestr * image,int quality)
{
 os_error * err;
 char     * buffer1;

  /* These three structs contain JPEG parameters and working data.
   * They must survive for the duration of parameter setup and one
   * call to jpeg_compress; typically, making them local data in the
   * calling routine is the best strategy.
   */
 struct Compress_info_struct cinfo;
 struct Compress_methods_struct c_methods;
 struct External_methods_struct e_methods;


 err=NULL;

 saveimage=image;

  /* Initialize the system-dependent method pointers. */
  cinfo.methods = &c_methods;   /* links to method structs */
  cinfo.emethods = &e_methods;


  emethods = &e_methods;        /* save struct addr for possible access */
  e_methods.error_exit = error_exit; /* supply error-exit routine */
  e_methods.trace_message = trace_message; /* supply trace-message routine */
  e_methods.trace_level = 0;    /* default = no tracing */
  e_methods.num_warnings = 0;   /* no warnings emitted yet */
  e_methods.first_warning_level = 0; /* display first corrupt-data warning */
  e_methods.more_warning_level = 3; /* but suppress additional ones */



  /* Here we use the standard memory manager provided with the JPEG code.
   * In some cases you might want to replace the memory manager, or at
   * least the system-dependent part of it, with your own code.
   */
  jselmemmgr(&e_methods);       /* select std memory allocation routines */



  /* If the compressor requires full-image buffers (for entropy-coding
   * optimization or a noninterleaved JPEG file), it will create temporary
   * files for anything that doesn't fit within the maximum-memory setting.
   * (Note that temp files are NOT needed if you use the default parameters.)
   * You can change the default maximum-memory setting by changing
   * e_methods.max_memory_to_use after jselmemmgr returns.
   * On some systems you may also need to set up a signal handler to
   * ensure that temporary files are deleted if the program is interrupted.
   * (This is most important if you are on MS-DOS and use the jmemdos.c
   * memory manager back end; it will try to grab extended memory for
   * temp files, and that space will NOT be freed automatically.)
   * See jcmain.c or jdmain.c for an example signal handler.
   */

  /* Here, set up pointers to your own routines for input data handling
   * and post-init parameter selection.
   */
  c_methods.input_init = input_init;
  c_methods.get_input_row = get_input_row;
  c_methods.input_term = input_term;
  c_methods.c_ui_method_selection = c_ui_method_selection;

  /* Set up default JPEG parameters in the cinfo data structure. */
  j_c_defaults(&cinfo, quality, FALSE);
  /* Note: 75 is the recommended default quality level; you may instead pass
   * a user-specified quality level.  Be aware that values below 25 will cause
   * non-baseline JPEG files to be created (and a warning message to that
   * effect to be emitted on stderr).  This won't bother our decoder, but some
   * commercial JPEG implementations may choke on non-baseline JPEG files.
   * If you want to force baseline compatibility, pass TRUE instead of FALSE.
   * (If non-baseline files are fine, but you could do without that warning
   * message, set e_methods.trace_level to -1.)
   */

  /* At this point you can modify the default parameters set by j_c_defaults
   * as needed.  For a minimal implementation, you shouldn't need to change
   * anything.  See jcmain.c for some examples of what you might change.
   */

  /* Select the input and output files.
   * Note that cinfo.input_file is only used if your input reading routines
   * use it; otherwise, you can just make it NULL.
   * VERY IMPORTANT: use "b" option to fopen() if you are on a machine that
   * requires it in order to write binary files.
   */

  cinfo.input_file=NULL;      /* if no actual input file involved */

  if((cinfo.output_file=fopen(filename,"wb"))==NULL)
  {
   err=generror(0,"Can't open %s\n",filename);
   return(err);
  }


  if(salloc((flex_ptr)&buffer1,ABUFFSIZE)==NULL)
  {
   if(buffer1)  setvbuf(cinfo.output_file,buffer1,_IOFBF,ABUFFSIZE);
  }



  if((err=(os_error*)setjmp(setjmp_buffer))!=NULL)
  {
    /* If we get here, the JPEG code has signaled an error.
     * Memory allocation has already been cleaned up (see free_all call in
     * error_exit), but we need to close the input file before returning.
     * You might also need to close an output file, etc.
     */
   fclose(cinfo.output_file);
   if(buffer1) sfree((flex_ptr)&buffer1);
   return(err);
  }

  /* Here we go! */
  jpeg_compress(&cinfo);

  /* That's it, son.  Nothin' else to do, except close files. */
  /* Here we assume only the output file need be closed. */
  fclose(cinfo.output_file);
  if(buffer1) sfree((flex_ptr)&buffer1);

  /* Note: if you want to compress more than one image, we recommend you
   * repeat this whole routine.  You MUST repeat the j_c_defaults()/alter
   * parameters/jpeg_compress() sequence, as some data structures allocated
   * in j_c_defaults are freed upon exit from jpeg_compress.
   */

 return(err);
}



#endif




struct my_error_mgr 
{
 struct jpeg_error_mgr pub;    /* "public" fields */

 jmp_buf setjmp_buffer;        /* for return to caller */
};


typedef struct my_error_mgr * my_error_ptr;


static void my_error_exit(j_common_ptr cinfo)
{
 os_error     * err;
 my_error_ptr   myerr;
 char           string[256];

 myerr=(my_error_ptr)cinfo->err;

 (*cinfo->err->format_message) (cinfo,string);

 err=generror(0,string);

 longjmp(myerr->setjmp_buffer,(int)err);
}


static void internalerror(j_common_ptr cinfo,os_error * err)
{
 my_error_ptr   myerr;

 myerr=(my_error_ptr)cinfo->err;

 longjmp(myerr->setjmp_buffer,(int)err);
}






static os_error * get_input_row(j_compress_ptr cinfo,JSAMPARRAY pixel_row,
                                                        imagestr * saveimage)
{
 os_error * err;
 JSAMPROW    ptr;
 int       * idata;
 int         xpix;
 int         bpp;
 int         shift;
 int         word;
 int         mask;
 int         sbyte;
 int         x;
 char      * p;


 ptr=pixel_row[0];

 err=imfind1r(saveimage,cinfo->next_scanline,&idata);
 if(err) return(err);

 xpix=saveimage->xpix;
 bpp=saveimage->bpp;


 if(saveimage->bpp<=8)
 {
  word=0;   /* compiler */
  shift=32;

  if(bpp==1) mask=0x1;
  else
  if(bpp==2) mask=0x3;
  else
  if(bpp==4) mask=0xF;
  else       mask=0xFF;

  if(cinfo->input_components==1)
  {
   for(x=0;x<xpix;x++)
   {
    if(shift==32)
    {
     word=*idata++;
     shift=0;
    }
    sbyte=(word>>shift)&mask;
    shift+=bpp;

    sbyte=saveimage->ipal.word[sbyte];

    *ptr++=(JSAMPLE)((sbyte>>8)  & 0xFF); /* red */
   }
  }
  else
  {
   for(x=0;x<xpix;x++)
   {
    if(shift==32)
    {
     word=*idata++;
     shift=0;
    }
    sbyte=(word>>shift)&mask;
    shift+=bpp;

    sbyte=saveimage->ipal.word[sbyte];

    *ptr++=(JSAMPLE)((sbyte>>24) & 0xFF); /* blue */
    *ptr++=(JSAMPLE)((sbyte>>16) & 0xFF); /* green */
    *ptr++=(JSAMPLE)((sbyte>>8)  & 0xFF); /* red */
   }
  }
 }
 else
 if(saveimage->bpp==16)
 {
  for(x=0;x<xpix;x++)
  {
   word=*idata++;

   *ptr++=(JSAMPLE)((word>>7)&0xF8); /* blue */
   *ptr++=(JSAMPLE)((word>>2)&0xF8); /* green */
   *ptr++=(JSAMPLE)((word<<3)&0xF8); /* red */

   x++;
   if(x>=xpix) break;


   *ptr++=(JSAMPLE)((word>>23)&0xF8); /* blue */
   *ptr++=(JSAMPLE)((word>>18)&0xF8); /* green */
   *ptr++=(JSAMPLE)((word>>13)&0xF8); /* red */
  }
 }
 else
 if(saveimage->bpp==24)
 {
  p=(char*)idata;

  for(x=0;x<xpix;x++)
  {
   *ptr++=(JSAMPLE)*(p+2); /* red */
   *ptr++=(JSAMPLE)*(p+1); /* green */
   *ptr++=(JSAMPLE)*p; /* blue */
   p+=3;
  }
 }
 else
 if(saveimage->bpp==32)
 {
  p=(char*)idata;

  if(saveimage->ipal.palclass==CL_CMYK)
  {
   for(x=0;x<xpix;x++)
   {
    *ptr++=(JSAMPLE)(255-*p++);
    *ptr++=(JSAMPLE)(255-*p++);
    *ptr++=(JSAMPLE)(255-*p++);
    *ptr++=(JSAMPLE)(255-*p++);
   }
  }
  else
  {
   for(x=0;x<xpix;x++)
   {
    *ptr++=(JSAMPLE)*(p+2); /* red */
    *ptr++=(JSAMPLE)*(p+1); /* green */
    *ptr++=(JSAMPLE)*p; /* blue */
    p+=4;
   }
  }
 }

 return(err);
}












#define ABUFFSIZE 0x10000




os_error * write_JPEG_file(char * filename,imagestr * image,int quality)
{
 os_error                    * err;
 struct jpeg_compress_struct   cinfo;
 struct my_error_mgr           jerr;
 FILE                        * outfile;
 JSAMPROW                      row_pointer[1];
 char                        * buffer1;
 unsigned char               * iccdata;
 unsigned int                  icclen;



 err=NULL;

 buffer1=NULL;


 memset(row_pointer,0,sizeof(row_pointer));


 if((outfile=fopen(filename,"wb"))==NULL) 
 {
  err=generror(0,"Can't open %s\n",filename);
  return(err);
 }


 if(salloc((flex_ptr)&buffer1,ABUFFSIZE)==NULL)
 {
  if(buffer1) setvbuf(outfile,buffer1,_IOFBF,ABUFFSIZE);
 }


 cinfo.err=jpeg_std_error(&jerr.pub);
 jerr.pub.error_exit=my_error_exit;


 if((err=(os_error*)setjmp(jerr.setjmp_buffer))!=NULL)
 {
  jpeg_destroy_compress(&cinfo);
  fclose(outfile);
  fs_delete(filename);
  sfree((flex_ptr)&buffer1);
  sfree((flex_ptr)&row_pointer[0]);
  return(err);
 }


 jpeg_create_compress(&cinfo);
 
 jpeg_stdio_dest(&cinfo, outfile);

 cinfo.image_width=image->xpix;
 cinfo.image_height=image->ypix;

 if(image->ipal.palclass==CL_CMYK)
 {
  cinfo.input_components=4;
  cinfo.in_color_space=JCS_CMYK;
  err=salloc((flex_ptr)&row_pointer[0],4*image->xpix);
 }
 else
 if(image->bpp>8 || !imgrey(image))
 {
  cinfo.input_components=3;          /* or 1 for grayscale */
  cinfo.in_color_space=JCS_RGB;      /* or CS_GRAYSCALE for grayscale */
  err=salloc((flex_ptr)&row_pointer[0],3*image->xpix);
 }
 else
 {
  cinfo.input_components=1;
  cinfo.in_color_space=JCS_GRAYSCALE;
  err=salloc((flex_ptr)&row_pointer[0],image->xpix);
 }

 if(err) internalerror((j_common_ptr)&cinfo,err);

 jpeg_set_defaults(&cinfo);

 cinfo.density_unit=1;
 cinfo.X_density=(unsigned short)image->xdpi;
 cinfo.Y_density=(unsigned short)image->ydpi;

 jpeg_set_quality(&cinfo, quality, TRUE /* limit to baseline-JPEG values */);

 jpeg_start_compress(&cinfo, TRUE);


/*
 * This routine writes the given ICC profile data into a JPEG file.
 * It *must* be called AFTER calling jpeg_start_compress() and BEFORE
 * the first call to jpeg_write_scanlines().
 * (This ordering ensures that the APP2 marker(s) will appear after the
 * SOI and JFIF or Adobe markers, but before all else.)
 */

 cmsembedprofile(image,&iccdata,&icclen);
 if(iccdata)
 {
  write_icc_profile(&cinfo,iccdata,icclen);
 }


 while(cinfo.next_scanline<cinfo.image_height)
 {
  err=get_input_row(&cinfo,row_pointer,image);
  if(err) internalerror((j_common_ptr)&cinfo,err);
  jpeg_write_scanlines(&cinfo,row_pointer,1);
 }

 jpeg_finish_compress(&cinfo);

 fclose(outfile);

 sfree((flex_ptr)&buffer1);
 sfree((flex_ptr)&row_pointer[0]);

 jpeg_destroy_compress(&cinfo);

 return(err);
}



