/*->c.jpeg */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "dbhi.h"
#include "key.h"
#include "etc.h"
#include "config.h"
#include "pane.h"


#include "constants.h"
#include "str.h"
#include "reslink.h"
#include "view.h"
#include "file.h"
#include "units.h"

#include "jpegd.h"
#include "jpegc.h"

#include "jpeg.h"



extern ftypestr ftype;
extern dboxstr  configbox;


static int tdbl;
static int dbl;
static int tquality;
static int quality=75;


static os_error * loadjpeg(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;

 err=read_JPEG_file(name);

 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}



static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;

 err=NULL;

 return(err);
 USE(userhandle);
}


static os_error * savejpeg(char * name,int type)
{
 os_error * err;
 int        fn;
 imagestr * saveimage;

 fn=menuview->frame;
 saveimage=((menufile->frames[fn].xim)->sim[IM]);

 err=write_JPEG_file(name,saveimage,quality);
 if(!err) err=fs_settype(name,type);

 return(err);
}



static os_error * savejpegim(char * name,int type,imagestr * saveimage)  
{
 os_error * err;

 err=write_JPEG_file(name,saveimage,quality);
 if(!err) err=fs_settype(name,type);

 return(err);
}




/*****************************************************************************/


static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}



static os_error * configloaded(int eventn,uservalue userhandle,
                                                        void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {

  dbl=ftypegetrun(&ftype);
  
//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  dbl=tdbl;
  quality=tquality;
 }

 return(err);
}



static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}





static os_error * wrpc(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdpc(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}



static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

   11, &tquality,    DBWRITE,  0,   0,      -1, -1, -1, -1,    rdpc, wrpc,
    
    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TJPEG,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,


};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);

 tdbl=dbl;
 tquality=quality;
 err=dodboxparent(&configbox,1,parent);


 return(err);
}

/****************************************************************************/




static ftypestr ftype=
{
 JPEG,            /* file type */
 0,               /* flags     */
 loadjpeg,        /* load      */
 loadfilepost,    /* loadpost  */
 "{JPEG}",        /* name      */
 "{JPEG}",        /* type name */
 savejpeg,        /* save      */
 config,          /* configure */
 0,               /* icon number */
 bits,            /* bit flags */
 NULL,            /* load frame */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,

 savejpegim,         /* saveim */
 "jpg\0""jpe\0""jpeg\0""c85\0", /* extension */

 "JPEG (*.jpg)",/* description */
};



static contag contable[3]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "Quality",CONINT,&quality,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "JPEG",
 NULL,
 NULL
};



os_error * jpeginit(void)
{
 os_error * err;

 err=registerfiletype(&ftype);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);
 }

 return(err);
}


