/*->c.infopal */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "bbc.h"
#include "transform.h"

#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "deb.h"
#include "osunits.h"
#include "pane.h"
#include "dbhi.h"


#include "str.h"
#include "reslink.h"
#include "file.h"

#include "viewo.h"
#include "view.h"


#include "tools.h"

#include "infopal.h"




static os_error * reminfopal(viewstr * view,filestr * file);


viewstr * infoview;
filestr * infofile;


static os_error * dragwindow(wimp_mousestr * m)
{
 os_error   * err;
 wimp_dragstr drg;
 windowstr    window;

 err=getw(m->w,&window);
 if(!err)
 {
  drg.window=m->w;
  drg.type=wimp_MOVE_WIND;

  err=wimp_drag_box(&drg);
 }
 return(err);
}



static os_error * infotitleicon(wimp_mousestr * m)
{
 if(m->bbits==VBDRAGA || m->bbits==VBDRAGS)
 {
  dragwindow(m);
 }

 return(NULL);
}



static os_error * infoicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 menuview=infoview;
 menufile=infofile;

 switch(m->i)
 {
  case -1:        /* title bar */
         err=infotitleicon(m);
         break;

//  case 100:        /* close icon */
//         err=reminfopal(infoview,infofile);
//         break;

  default:
          if(tooltable[tool].infopalicon)
                 err=tooltable[tool].infopalicon(handle,userhandle,m);
          break;
 }

 return(err);

 USE(handle);
 USE(userhandle);
}



static os_error * infokey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 os_error * err;

 err=NULL;

 if(tooltable[tool].infopalkey) 
                err=tooltable[tool].infopalkey(handle,userhandle,icon,key);


 if(*key!=-1 && !err) err=viewkey(handle,userhandle,icon,key);

 return(err);
}


/* called when pane opened by wimp */

static os_error * infopalwopen(wimp_w handle,uservalue userhandle,wimp_openstr * o)
{
 os_error   * err;
 windowstr    window;
 windowstr    vwindow;

 err=wimp_open_wind(o);

 if(!err) err=getw(infoview->info,&window);
 if(!err) err=getw(infoview->handle,&vwindow);

 if(!err)
 {
  infoview->infoxshift=window.x0-vwindow.x0;
  infoview->infoyshift=vwindow.y0-window.y0;

  err=viewopenbehind(infoview,infofile,window.bhandle);
 }

 return(err);

 USE(userhandle);
 USE(handle);
}


// this is here to stop ALT+F4 caret in info pal closing it

static os_error * infowclose(wimp_w handle,uservalue userhandle)
{

// cprintf("infowclose");

 return(NULL);

 USE(handle);
 USE(userhandle);
}





os_error * openinfopal(viewstr * view)
{
 os_error   * err;
// wimp_openstr r;
 windowstr    window;
	filestr    * file;
 wimp_wstate  wst;
	int          w;
 int          h;
	wimp_w       prevpane;

 err=NULL;

	file=view->file;

 if(!(view->data.infopal && view->info))
 {
  if(infoview) closeinfopal(infoview,infofile);

  if(view->data.infopal)
  {
   err=createwindowparent(tooltable[tool].infopaltemplate,&view->info,view->handle);
   if(!err)
   {
    if(tooltable[tool].infopalfill) err=tooltable[tool].infopalfill(view,file);

    if(!err) err=addopenevent(infopalwopen,view->info,0);
    if(!err) err=wimp_setwindowflags(view->info,WINDOWPANE,WINDOWPANE);
    if(!err) err=addclickevent(infoicon,view->info,(uservalue)view);
    if(!err) err=addcloseevent(infowclose,view->info,(uservalue)view);
    if(!err) err=addkeyevent(infokey,view->info,(uservalue)view);

    infoview=view;
    infofile=file;

    err=wimp_get_wind_state(view->info,&wst);
    if(!err)
    {
     w=wst.o.box.x1-wst.o.box.x0;
     h=wst.o.box.y1-wst.o.box.y0;

     wst.o.box.x0=view->window.x0+view->infoxshift;
     wst.o.box.y0=view->window.y0-view->infoyshift;
					wst.o.box.y1=ypix2os(yos2pix(wst.o.box.y0)+yos2pix(h));

     if(1 /*!infopaloffscreen*/)
     {
      if(!(view->window.wflags & wimp_MINIMISED))
      {
       coerceboxscreen(&wst.o.box,w,h);
      }
     }

     /* set pane size */

     wst.o.box.x1=xpix2os(xos2pix(wst.o.box.x0)+xos2pix(w));
     wst.o.box.y0=ypix2os(yos2pix(wst.o.box.y1)-yos2pix(h));

     prevpane=viewprevpane(view,file,view->info);
     if(prevpane) 
     {
      getw(prevpane,&window);
      wst.o.behind=window.bhandle;
     }
     else
     {
      wst.o.behind=(wimp_w)-1;
     }

     err=wcheckopen(&wst.o,1/*infopalattached*/);
			 }
		 }
	 }
	}

 return(err);
}



// called from main win open to open info pal after main window is opened

os_error * openinfopalpane(viewstr * view,wimp_openstr * o,windowstr * window)
{
 os_error   * err;
 wimp_openstr r;
 windowstr    iwindow;
 int          w;
 int          h;
// wimp_wstate  wst;

 err=NULL;

 if(1)
 {
  err=getw(view->info,&iwindow);

  if(window)
  {
   if(!(view->window.wflags & wimp_MINIMISED) && !(window->wflags & wimp_MINIMISED))
   {
    if(iwindow.x0>(window->x1+window->x0)/2) 
    {
     view->infoxshift+=o->box.x1-window->x1;
     view->infoxshift-=o->box.x0-window->x0;
    }

    if(iwindow.y1>(window->y1+window->y0)/2) 
    {
     view->infoyshift+=o->box.y0-window->y0;
     view->infoyshift-=o->box.y1-window->y1;
    }
   }
  } 

  w=(xcoordos2pix(iwindow.x1)-xcoordos2pix(iwindow.x0));
  h=(ycoordos2pix(iwindow.y0)-ycoordos2pix(iwindow.y1));

  r.w=view->info;
  r.x=0;
  r.y=0;
  r.behind=o->behind;

  r.box.x0=o->box.x0+view->infoxshift;
  r.box.y0=o->box.y0-view->infoyshift;

  r.box.x1=xpix2os(xos2pix(r.box.x0)+w);
  r.box.y1=ypix2os(yos2pix(r.box.y0)+h);

  w=xpix2os(w);
  h=ypix2os(h);


  if(1 /*!infopaloffscreen*/)
  {
   if(!(view->window.wflags & wimp_MINIMISED))
   {
    coerceboxscreen(&r.box,w,h);
   }
  }

  err=wcheckopen(&r,1);
 }

 return(err);
}







os_error * closeinfopal(viewstr * view,filestr * file)
{
 os_error * err;

 if(view->data.infopal && view->info)
 {
           err=remclickevent(infoicon,view->info,(uservalue)view);
  if(!err) err=remkeyevent(infokey,view->info,(uservalue)view);
  if(!err) err=remopenevent(infopalwopen,view->info,0);
  if(!err) err=remcloseevent(infowclose,view->info,(uservalue)view);
  if(!err) err=closedown(&view->info);
  infoview=NULL;
  infofile=NULL;
 }
 else err=NULL;

 return(err);

 USE(file);
}




os_error * infopalupdateview(viewstr * view)
{
 os_error * err;

 err=NULL;

 if(view==infoview && infoview && view->data.infopal && view->info)
 {
  if(tooltable[tool].infopalfill) 
              err=tooltable[tool].infopalfill(view,(filestr*)view->file);
 }

 return(err);
}



os_error * infopalupdatefileframe(filestr * file,int fn)
{
 viewstr * view;

 view=file->view;
 while(view)
 {
  if(view->frame==fn)
  {
   infopalupdateview(view);
  }
  view=view->next;
 }

 return(NULL);
}


static os_error * addinfopal(viewstr * view,filestr * file)
{
 os_error * err;

	err=NULL;

 if(!view->data.infopal)
 {
  view->data.infopal=1;
		openinfopal(view);
 }


 return(err);

 USE(file);
}



static os_error * reminfopal(viewstr * view,filestr * file)
{
 os_error * err;

 if(view->data.infopal)
 {
  err=closeinfopal(view,file);
  view->data.infopal=0;
  viewopenpanes(view);
 }
 else err=NULL;

 return(err);
}




void setinfopal(int open)
{
 viewstr * view;
 filestr * file;

 view=menuview;
 file=(filestr*)view->file;

 if(open && !view->data.infopal) addinfopal(view,file);
 else
 if(!open && view->data.infopal) reminfopal(view,file);
}

