/*->c.info */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "etc.h"
#include "alloc.h"
#include "deb.h"
#include "osunits.h"
#include "dbhi.h"


#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "mlo.h"
#include "key.h"


#include "file.h"
#include "view.h"
#include "pr.h"
#include "im.h"
#include "config.h"
#include "edit.h"

#include "info.h"


#define INFOBASE 100


static os_error * infokey(wimp_w handle,uservalue userhandle,int icon,int * key);


static os_error * infoclose(wimp_w handle,uservalue userhandle)
{
 infostr  * info;
 viewstr  * view;
 filestr  * file;

 view=(viewstr*)userhandle;
 file=view->file;

 info=&file->frames[view->frame].info;

 remcloseevent(infoclose,handle,userhandle);
 remparentcloseevent(infoclose,handle,userhandle);
 remkeyevent(infokey,handle,userhandle);

 closedown(&info->handle);

 return(NULL);
}


static os_error * infokey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 int ch;

 ch=*key;


 if(ch==RETURN || ch==ESCAPE)
 {
  *key=-1;
  infoclose(handle,userhandle);
 }

 return(NULL);

 USE(icon);
}



/* create an info window */

os_error * infocreate(viewstr * view,filestr * file,wimp_w * handle)
{
 os_error * err;
 int        frame;
 int        i;
 infostr  * info;
 char     * p;
 int        len;


 err=NULL;

 if(file->frames)
 {
  frame=view->frame;
  info=&file->frames[frame].info;

  if(info->handle) infoclose(info->handle,(uservalue)view);
  
  err=createwindowparent(TIMINFO,&info->handle,view->handle);
  
  if(!err)
  {
   *handle=info->handle;
   p=info->text;

   for(i=0;i<info->n;i++)
   {
    len=strlen(p)+1;
    err=writeicon(info->handle,i+INFOBASE,p);
    if(err) break;
    p+=len;
   }
  }
 }
 else
 {
  *handle=0;
 }
 return(err);
}


os_error * infoinit(framestr * frame)
{
 frame->info.text=NULL;
 frame->info.n=0;
 frame->info.handle=0;

 return(NULL);
}


os_error * infofinit(framestr * frame)
{
 os_error * err;

 closedown(&frame->info.handle);


 if(frame->info.text) err=sfree((flex_ptr)&frame->info.text);
 else                 err=NULL;

 return(err);
}


os_error * infowrite(char * text,framestr * frame)
{
 os_error * err;
 char     * p;
 char     * q;
 int        len;


 len=strlen(text)+1;

 err=salloc((flex_ptr)&frame->info.text,len);
 if(!err)
 {
  memcpy(frame->info.text,text,len);

  len=0;
  q=p=frame->info.text;
  while(*p)
  {
   if(*p=='\n') 
   {
    len++;
    *p=0;
    q=p+1;
   }
   p++;
  }

  if(*q==0) len--;

  frame->info.n=len+1;
 }
 return(err);
}





os_error * popfileinfo(void)
{
 os_error  * err;
 wimp_w      handle;
 wimp_wstate wst;
 iconstr     icon;
 infostr   * info;

 err=infocreate(menuview,menufile,&handle);
 if(!err)
 {
  err=wimp_get_wind_state(handle,&wst);
  if(!err)
  {
   info=&menufile->frames[menuview->frame].info;
   geti(handle,INFOBASE+info->n,&icon);
   wst.o.box.y0=wst.o.box.y1+ypix2os(yos2pix(icon.iy1)+1);
   centerwindow3(&wst.o,0);
   wst.o.behind=(wimp_w)-1;

   if(!err)  err=wimp_open_wind(&wst.o);
   if(!err)  err=setactive(handle);
   if(!err)
   {
    addcloseevent(infoclose,handle,(uservalue)menuview);
    addparentcloseevent(infoclose,handle,(uservalue)menuview);
    addkeyevent(infokey,handle,(uservalue)menuview);
   }
  }
 }

 return(err);
}



