/*->c.im */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "dbhi.h"
#include "bitrev.h"


#include "crc.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "configx.h"

#include "file.h"
#include "view.h"

#include "cx.h"

#include "chunk.h"
#include "vm.h"
#include "cms.h"


#include "im.h"

/* manage image buffers */

static imagestr * firstim;


/*****************************************************************************/
/* return pointers to row data */



#ifdef USEVM



static int cmpchunk(const void * c1, const void * c2)
{
 if(((imchunkstr*)c1)->el<=((imchunkstr*)c2)->sl) return(-1);
 else
 if(((imchunkstr*)c1)->sl>=((imchunkstr*)c2)->el) return(1);
 else                                             return(0);
}


os_error * imfind1r(imagestr * ip,int y,int ** data)
{
 os_error    * err;
 imchunkstr    target;
 imchunkstr  * chunk;
 int           offset;

/* dprintf(0,"im find in "); */

 /* find chunk from y */

 target.sl=y;
 target.el=y+1;
 chunk=(imchunkstr*)bsearch((imchunkstr*)&target,ip->imchunk,ip->imchunks,sizeof(imchunkstr),cmpchunk);

 err=ivmchunkensurer(&chunk->chunk,chunk->size);

 if(!err)
 {
  offset=(y-chunk->sl)*ip->wwidth+sizeof(sprite_header)/sizeof(int);
  *data=(chunk->chunk)->data+offset;
 }

/* dprintf(0,"im find out"); */

 return(err);
}




os_error * imfind1w(imagestr * ip,int y,int ** data)
{
 os_error    * err;
 imchunkstr    target;
 imchunkstr  * chunk;
 int           offset;

/* dprintf(0,"im find in "); */

 /* find chunk from y */

 target.sl=y;
 target.el=y+1;
 chunk=(imchunkstr*)bsearch((imchunkstr*)&target,ip->imchunk,ip->imchunks,sizeof(imchunkstr),cmpchunk);

 err=ivmchunkensurew(&chunk->chunk,chunk->size);

 if(!err)
 {
  offset=(y-chunk->sl)*ip->wwidth+sizeof(sprite_header)/sizeof(int);
  *data=(chunk->chunk)->data+offset;
 }

/* dprintf(0,"im find out"); */

 return(err);
}







os_error * imfind2rr(imagestr * ip1,int y1,int ** data1,
                     imagestr * ip2,int y2,int ** data2)
{
 os_error    * err;
 imchunkstr    target;
 imchunkstr  * chunk1;
 imchunkstr  * chunk2;
 int           offset;

 /* find chunk from y */

/* dprintf(0,"im fin2 in "); */

 target.sl=y1;
 target.el=y1+1;
 chunk1=(imchunkstr*)bsearch((imchunkstr*)&target,ip1->imchunk,ip1->imchunks,
                                     sizeof(imchunkstr),cmpchunk);

 target.sl=y2;
 target.el=y2+1;
 chunk2=(imchunkstr*)bsearch((imchunkstr*)&target,ip2->imchunk,ip2->imchunks,
                                     sizeof(imchunkstr),cmpchunk);

 err=ivmchunkensurer(&chunk1->chunk,chunk1->size);
 if(!err) err=ivmchunkensurer(&chunk2->chunk,chunk2->size);

 if(!err)
 {
  offset=(y1-chunk1->sl)*ip1->wwidth+sizeof(sprite_header)/sizeof(int);
  *data1=(chunk1->chunk)->data+offset;

  offset=(y2-chunk2->sl)*ip2->wwidth+sizeof(sprite_header)/sizeof(int); 
  *data2=(chunk2->chunk)->data+offset;
 }

/* dprintf(0,"im fin2 out"); */

 return(err);
}






os_error * imfind2rw(imagestr * ip1,int y1,int ** data1,
                     imagestr * ip2,int y2,int ** data2)
{
 os_error    * err;
 imchunkstr    target;
 imchunkstr  * chunk1;
 imchunkstr  * chunk2;
 int           offset;

 /* find chunk from y */

/* dprintf(0,"im fin2 in "); */

 target.sl=y1;
 target.el=y1+1;
 chunk1=(imchunkstr*)bsearch((imchunkstr*)&target,ip1->imchunk,ip1->imchunks,
                                     sizeof(imchunkstr),cmpchunk);

 target.sl=y2;
 target.el=y2+1;
 chunk2=(imchunkstr*)bsearch((imchunkstr*)&target,ip2->imchunk,ip2->imchunks,
                                     sizeof(imchunkstr),cmpchunk);

 err=ivmchunkensurer(&chunk1->chunk,chunk1->size);
 if(!err) err=ivmchunkensurew(&chunk2->chunk,chunk2->size);

 if(!err)
 {
  offset=(y1-chunk1->sl)*ip1->wwidth+sizeof(sprite_header)/sizeof(int);
  *data1=(chunk1->chunk)->data+offset;

  offset=(y2-chunk2->sl)*ip2->wwidth+sizeof(sprite_header)/sizeof(int); 
  *data2=(chunk2->chunk)->data+offset;
 }

/* dprintf(0,"im fin2 out"); */

 return(err);
}






os_error * imfind2ww(imagestr * ip1,int y1,int ** data1,
                     imagestr * ip2,int y2,int ** data2)
{
 os_error    * err;
 imchunkstr    target;
 imchunkstr  * chunk1;
 imchunkstr  * chunk2;
 int           offset;

 /* find chunk from y */

/* dprintf(0,"im fin2 in "); */

 target.sl=y1;
 target.el=y1+1;
 chunk1=(imchunkstr*)bsearch((imchunkstr*)&target,ip1->imchunk,ip1->imchunks,
                                     sizeof(imchunkstr),cmpchunk);

 target.sl=y2;
 target.el=y2+1;
 chunk2=(imchunkstr*)bsearch((imchunkstr*)&target,ip2->imchunk,ip2->imchunks,
                                     sizeof(imchunkstr),cmpchunk);

 err=ivmchunkensurew(&chunk1->chunk,chunk1->size);
 if(!err) err=ivmchunkensurew(&chunk2->chunk,chunk2->size);

 if(!err)
 {
  offset=(y1-chunk1->sl)*ip1->wwidth+sizeof(sprite_header)/sizeof(int);
  *data1=(chunk1->chunk)->data+offset;

  offset=(y2-chunk2->sl)*ip2->wwidth+sizeof(sprite_header)/sizeof(int); 
  *data2=(chunk2->chunk)->data+offset;
 }

/* dprintf(0,"im fin2 out"); */

 return(err);
}






/* throw away image */

os_error * imtrash(imagestr ** imp)
{
 os_error * err;
 int        i;
 imagestr * ip;

/*
 imagestr * next;
 imagestr * prev;
*/

 err=NULL;

 ip=*imp;
 if(ip)
 {
/* dprintf(0,"ip=%x chunks=%d",ip,ip->imchunks);  */

  cmsscrapprofile(&ip->profile);

  for(i=(ip->imchunks-1);i>=0;i--)
  {
/*  dprintf(0,"i=%d chunk=%d",i,ip->imchunk[i].chunk); */

   ivmchunkdestroy(&ip->imchunk[i].chunk);
  }

/*
 next=ip->next;
 prev=ip->prev;

 if(next) next->prev=prev;
 if(prev) prev->next=next;
 if(firstim==ip) firstim=next;
*/

  err=sfree((flex_ptr)imp);
 }

 return(err);
}









/* create a new image */

/* bpp supports 1,2,4,8,24,32 */

os_error * imnew(int xpix,int ypix,int bpp,imagestr ** imp)
{
 os_error   * err;
 int          bitwidth;
 int          size;
 int          chunks;
 imagestr   * ip;
 int          i;
 int          lines;
 int          temp;
 imchunkstr * chunkp;


 bitwidth=(xpix*bpp+31)&(~31);
 bitwidth/=8;
 size=bitwidth*ypix; /* bytes */

 /* work out lines per chunk */
 lines=imchunksize/bitwidth;

/* lines=lines/20; */
 if(!lines) lines++;
/* lines=lines*20; */

/* lines++; */

 temp=lines*bitwidth;
 chunks=(size+temp-1)/temp;

/* dprintf(0,"lines=%d chunks=%d",lines,chunks); */


 err=salloc((flex_ptr)imp,sizeof(imagestr)+sizeof(imchunkstr)*(chunks-1));
 if(!err)
 {
  ip=*imp;
  ip->imchunks=chunks;
  ip->wwidth=bitwidth/4; /* words */

  ip->xpix=xpix;
  ip->ypix=ypix;
  ip->bpp=bpp;
  tr_setidentity(&ip->tr);
  cmsinitprofile(&ip->profile);

/*
  ip->prev=NULL;
  if(firstim) firstim->prev=ip;
  ip->next=firstim;
  firstim=ip;

  ip->undo=ip->redo=NULL;
*/

  chunkp=ip->imchunk;

  for(i=0;i<chunks;i++,chunkp++)
  {
   chunkp->chunk=NULL;
   chunkp->width=bitwidth;
   chunkp->sl=i*lines;
   chunkp->el=MIN(ypix,chunkp->sl+lines);
   chunkp->size=(chunkp->el-chunkp->sl)*bitwidth+sizeof(sprite_header)+0x10;
  }
 }

 return(err);
}






static os_error * imcopychunk(imchunkstr * schunk,imchunkstr * dchunk)
{
 os_error * err;

 err=NULL;

 if(schunk->chunk)
 {
  dchunk->chunk=schunk->chunk;
  (schunk->chunk)->uses++;

/*           err=ivmchunkensure(&schunk->chunk,schunk->size);
  if(!err) err=ivmchunkensure(&dchunk->chunk,dchunk->size);
  if(!err) memcpy(dchunk->chunk->data,schunk->chunk->data,schunk->size); */
 }

 return(err);
}



os_error * imcopy(imagestr * sim,imagestr ** dimp)
{
 os_error * err;
 imagestr * dim;
 int        i;


 err=NULL;

 if(sim)
 {
  err=imnew(sim->xpix,sim->ypix,sim->bpp,dimp);
  if(!err)
  {
   dim=*dimp;

   dim->xdpi=sim->xdpi;
   dim->ydpi=sim->ydpi;
   dim->ipal=sim->ipal;
   dim->tr=sim->tr;
   cmscopyprofile(dim,sim);

   for(i=0;i<sim->imchunks;i++)
   {
    err=imcopychunk(&sim->imchunk[i],&dim->imchunk[i]);
   }
  }
 }

 return(err);
}


#else



os_error * imnew(int xpix,int ypix,int bpp,imagestr ** imp)
{
 os_error   * err;
 int          bitwidth;
 int          size;
 int          chunks;
 imagestr   * ip;
 int          i;
 int          lines;
 int          temp;
 imchunkstr * chunkp;


 bitwidth=(xpix*bpp+31)&(~31);
 bitwidth/=8;
 size=bitwidth*ypix; /* bytes */


 err=salloc((flex_ptr)imp,sizeof(imagestr)+size);
 if(!err)
 {
  ip=*imp;

  ip->wwidth=bitwidth/sizeof(int); /* words */

  ip->xpix=xpix;
  ip->ypix=ypix;
  ip->bpp=bpp;
  tr_setidentity(&ip->tr);
  cmsinitprofile(&ip->profile);
 }

 return(err);
}




os_error * imtrash(imagestr ** imp)
{
 os_error * err;
 int        i;
 imagestr * ip;


 err=NULL;

 ip=*imp;
 if(ip)
 {
  cmsscrapprofile(&ip->profile);

  err=sfree((flex_ptr)imp);
 }

 return(err);
}





os_error * imcopy(imagestr * sim,imagestr ** dimp)
{
 os_error * err;
 imagestr * dim;
 int        i;


 err=NULL;

 if(sim)
 {
  err=imnew(sim->xpix,sim->ypix,sim->bpp,dimp);
  if(!err)
  {
   dim=*dimp;

   dim->xdpi=sim->xdpi;
   dim->ydpi=sim->ydpi;
   dim->ipal=sim->ipal;
   dim->tr=sim->tr;
   cmscopyprofile(dim,sim);

			memcpy(sim->data,dim->data,sim->ypix*sim->wwidth*sizeof(int));

  }
 }

 return(err);
}



#endif



os_error * ximtrash(ximagestr ** ximp)
{
 os_error * err;

          err=imtrash(&((*ximp)->sim[IM]));
 if(!err) err=imtrash(&((*ximp)->sim[AL]));
 if(!err) err=sfree((flex_ptr)ximp);

 return(err);
}







os_error * ximnew(int xpix,int ypix,int bpp,ximagestr ** imp)
{
 os_error   * err;

 err=salloc((flex_ptr)imp,sizeof(ximagestr));
 if(!err)
 {
  err=imnew(xpix,ypix,bpp,&((*imp)->sim[IM]));
 }

 return(err);
}




os_error * ximnew2(int xpix,int ypix,int bpp,int mpp,ximagestr ** imp)
{
 os_error * err;

 err=salloc((flex_ptr)imp,sizeof(ximagestr));
 if(!err)
 {
                    err=imnew(xpix,ypix,bpp,&((*imp)->sim[IM]));
  if(!err && mpp>0) err=imnew(xpix,ypix,mpp,&((*imp)->sim[AL]));
 }

 return(err);
}






os_error * ximcopy(ximagestr * sxim,ximagestr ** dximp)
{
 os_error * err;

 err=salloc((flex_ptr)dximp,sizeof(ximagestr));
 if(!err)
 {
           err=imcopy(sxim->sim[IM],&((*dximp)->sim[IM]));
  if(!err) err=imcopy(sxim->sim[AL],&((*dximp)->sim[AL]));
 }

 return(err);
}




os_error * ximcopyal(ximagestr * sxim,ximagestr * dxim)
{
 os_error * err;

 err=NULL;

 if(sxim->sim[AL])
 {
  err=imcopy(sxim->sim[AL],&(dxim->sim[AL]));
 }

 return(err);
}





int imbpp(int colours)
{
 int bpp;

 bpp=0;

 while(colours/=2) bpp++;

 while(1)
 {
  if(bpp==1 || bpp==2 || bpp==4 || bpp==8 || bpp==24) break;
  else
  if(bpp>=32)
  {
   bpp=32;
   break;
  }
  else  bpp++;
 }
 return(bpp);
}




int greypal(int * pal,int ncolours)
{
 int i;
 int r;
 int g;
 int b;

 for(i=0;i<ncolours;i++)
 {
  r=(pal[i]>>8) & 0xFF;
  g=(pal[i]>>16) & 0xFF;
  b=(pal[i]>>24) & 0xFF;
  if(r!=g || g!=b) return(0);
 }
 return(1);
}


int imgrey(imagestr * image)
{
 if(image->bpp>8) return(0);
 return(greypal(image->ipal.word,image->ipal.ncolours));
}


static int cmppal(const void * p1,const void * p2)
{
 int w1;
 int w2;

 w1=*((int*)p1);
 w1&=0xFFFFFF00;
 w2=*((int*)p2);
 w2&=0xFFFFFF00;

 return(w1-w2);
}


int imlingrey(imagestr * image)
{
 ipalstr pal;
 int     i;
 int     exact;

 pal=image->ipal;

 qsort(&pal.word,pal.ncolours,sizeof(int),cmppal);

 for(i=0;i<pal.ncolours;i++)
 {
  exact=(i*256)/pal.ncolours;

  if(ABS((((pal.word[i]>>8)&0xFF)-exact))>1) return(0);
 }

 return(1);
}



/* return -1 if 1bpp && min is white */
/* return  1 if 1bpp && min is black */


int imbw(imagestr * image)
{
 if(image->bpp==1)
 {
  if( ((image->ipal.word[0] & 0xFFFFFF00)==0xFFFFFF00) &&
      ((image->ipal.word[1] & 0xFFFFFF00)==0x0) )  return(-1);
  else
  if( ((image->ipal.word[1] & 0xFFFFFF00)==0xFFFFFF00) &&
      ((image->ipal.word[0] & 0xFFFFFF00)==0x0) )  return(1);
 }
 return(0);
}


/* generate a greyscale palette */

void imsetgreypal(imagestr * image,int bpp)
{
 int i;
 int palw;

 image->ipal.ncolours=1<<bpp;

 switch(image->bpp)
 {
  case 8:
         for(i=0;i<256;i++)
         {
          palw=(i<<24)|(i<<16)|(i<<8);
          image->ipal.word[i]=palw;
         }
         break;

  case 1:
         image->ipal.word[0]=0;
         image->ipal.word[1]=0xFFFFFF00;
         break;

  case 2:
         image->ipal.word[0]=0;
         image->ipal.word[1]=0x55555500;
         image->ipal.word[2]=0xAAAAAA00;
         image->ipal.word[3]=0xFFFFFF00;
         break;

  case 4:
         for(i=0;i<16;i++)
         {
          palw=(i<<28)|(i<<24)|(i<<20)|(i<<16)|(i<<12)|(i<<8);
          image->ipal.word[i]=palw;
         }
         break;
 }
}



static int ospal[4][16]=
{
 0xffffff00,0x00000000,0x0,0x0,
 0x0,0x0,0x0,0x0,
 0x0,0x0,0x0,0x0,
 0x0,0x0,0x0,0x0,

 0xffffff00,0xdddddd00,0x99999900,0x00000000,
 0x0,0x0,0x0,0x0,
 0x0,0x0,0x0,0x0,
 0x0,0x0,0x0,0x0,

 0xffffff00,0xdddddd00,0xbbbbbb00,0x99999900,
 0x77777700,0x55555500,0x33333300,0x00000000,
 0x99440000,0x00eeee00,0x00cc0000,0x0000dd00,
 0xbbeeee00,0x00885500,0x00bbff00,0xffbb0000,


 0x0,0x10101000,0x20202000,0x30303000,
 0x4000,0x10105000,0x20206000,0x30307000,
 0x40000000,0x50101000,0x60202000,0x70303000,
 0x40004000,0x50105000,0x60206000,0x70307000,
};


os_error * imospal(imagestr * image)
{
 int        i;
 int        j;
 int        c1;
 int        bpp;

 bpp=image->bpp;

 if(bpp==8)
 {
  for(i=255;i>=0;i--)
  {
   c1=ospal[3][(i & 0xF)];

   if(i & 0x10) c1|=0x8000;
   else         c1&=~0x8000;

   if(i & 0x20) c1|=0x400000;
   else         c1&=~0x400000;

   if(i & 0x40) c1|=0x800000;
   else         c1&=~0x800000;

   if(i & 0x80) c1|=0x80000000;
   else         c1&=~0x80000000;

   c1&=0xF0F0F000;
   c1|=(c1>>4)&0xF0F0F00;

   image->ipal.word[i]=c1;
  }

  image->ipal.ncolours=256;
 }
 else
 {
  if(bpp==1) 
  {
   j=0;
   image->ipal.ncolours=2;
  }
  else
  if(bpp==2) 
  {
   j=1;
   image->ipal.ncolours=4;
  }
  else
  /* if(bpp==4) */ 
  {
   j=2;
   image->ipal.ncolours=16;
  }

  for(i=0;i<image->ipal.ncolours;i++)
  {
   image->ipal.word[i]=ospal[j][i];
  }
 }
 return(NULL);
}



os_error * imrgbpal(imagestr * image)
{
 int    bpp;
 double N;
 int    i;
 int    levels;
 int    levelsq, levelsc;

 bpp=image->bpp;

 if(bpp==8) levels=5;
 else
 /* if(dbpp==4)*/ levels=2;
    
 levelsq=levels*levels;    /* squared */
 levelsc=levels*levelsq;   /* and cubed */

 N=255.0/((double)(levels-1));    /* Get size of each step */

 for(i=0;i<levelsc;i++) 
 {
  image->ipal.word[i]=(((int)(0.5+((double)(i%levels))*N))<<8) |
                      (((int)(0.5+((double)((i/levels)%levels))*N))<<16) |
                      (((int)(0.5+((double)((i/levelsq)%levels))*N))<<24);
 }

 image->ipal.ncolours=levelsc;

 return(NULL);
}



os_error * imzero(imagestr * im)
{
 os_error * err;
 int        y;
 int        ypix;
 int      * idata;
 int        wwidth;

 err=NULL;
 ypix=im->ypix;
 wwidth=im->wwidth*sizeof(int);

 for(y=0;y<ypix;y++)
 {
  err=imfind1w(im,y,&idata);
  if(err) break;
  memset(idata,0,wwidth);
 }

 return(err);
}


os_error * imrevline(imagestr * im,int y)
{
 os_error * err;
 int      * idata;
 char     * p;
 int        x;
 int        i;

 if(im->bpp>4) return(NULL);

 err=imfind1w(im,y,&idata);
 if(!err)
 {
  p=(char*)idata;
  x=im->wwidth*4;

  switch(im->bpp)
  {
   case 1:
          for(i=0;i<x;i++,p++) *p=bitrev[*p];
          break;
   case 2:
          for(i=0;i<x;i++,p++) *p=dbitrev[*p];
          break;
   case 4:
          for(i=0;i<x;i++,p++) *p=nybrev[*p];
          break;
  }
 }

 return(err);
}



void  shiftline(int * wdata,int xpix,int bpp,int rshift)
{
 unsigned int w;
 unsigned int r;
 int          x;
 int        * rdata;
 int          wshift;

 rdata=wdata;
 r=*rdata++;
 w=0;
 wshift=0;

 for(x=0;x<xpix;x++)
 {
  w|=(r>>rshift)<<wshift;
  rshift+=bpp;
  if(rshift>=32)
  {
   rshift=0;
   r=*rdata++;
  }
  wshift+=bpp;
  if(wshift>=32)
  {
   *wdata++=w;
   wshift=0;
   w=0;
  }
 }
 if(wshift) *wdata=w;
}



void imsplitpalette(char * r,char * g,char * b,imagestr * im)
{
 int i;

 if(im->bpp<=8)
 {
  for(i=0;i<im->ipal.ncolours;i++)
  {
   if(r) *r++=(char)((im->ipal.word[i]>>8)&0xFF);
   if(g) *g++=(char)((im->ipal.word[i]>>16)&0xFF);
   if(b) *b++=(char)((im->ipal.word[i]>>24)&0xFF);
  }
 }
}




os_error * immemory(int memsize)
{
#ifdef USEVM
 return(ivmsetmemory(memsize));
#else
	return(NULL);
#endif
}


void imgetmemory(int * ramused,int * discused,int * discsize)
{
#ifdef USEVM
 ivmgetmemory(ramused);
 vmgetsize(discused,discsize);
#else


#endif
}


os_error * iminit(void)
{
 firstim=NULL;

#ifdef USEVM
 ivminit();
#endif


 return(NULL);
}



