/*->c.ico */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"
#include "bitrev.h"


#include "constants.h"
#include "str.h"
#include "reslink.h"
#include "units.h"

#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "mask.h"
#include "cms.h"

#include "ico.h"


extern ftypestr ftype;
extern ftypestr ftype2;
extern dboxstr  configbox;
extern dboxstr  configbox2;

static int tdbl;
static int dbl;


static int icoxres=90;
static int icoyres=90;
static int txres;
static int tyres;


static int tdbl2;
static int dbl2;


static int icoxres2=90;
static int icoyres2=90;
static int txres2;
static int tyres2;




/*****************************************************************************/


#define C_OS2 12
#define C_WIN 40


typedef struct bmphdrstr
{
 int        cbsize;
 short int  xhotspot;
 short int  yhotspot;
 int        offbits;    
 int        cbfix;      /* size of what follows */
} bmphdrstr;


typedef union bmpinfostr
{
 struct
 {
  short int cx;
  short int cy;
  short int cplanes;
  short int bitcount;

 } os2;

 struct
 {
  int       cx;
  int       cy;
  short int cplanes;
  short int bitcount;

  int       compression;
  int       imagesize; /*uncompressed size, can be 0 if compression not used*/
  int       xdpm;
  int       ydpm;
  int       ncolourused;      /* number of palette entries actually used */
                              /* can be 0 for all */
  int       ncolourimportant; /* number of important colours */
                              /* can be 0 for all */
 } windows;

} bmpinfostr;


//#define BI_RGB  0
//#define BI_RLE8 1
//#define BI_RLE4 2



typedef struct bmpstr
{
 bmphdrstr  hdr;
 bmpinfostr info;

} bmpstr;


#define STBASE 0
#define STABS  1
#define STRUN  2




#ifdef NEVER

typedef struct
{
   BITMAPINFOHEADER   icHeader;      // DIB header
   RGBQUAD         icColors[1];   // Color table
   BYTE            icXOR[1];      // DIB bits for XOR mask
   BYTE            icAND[1];      // DIB bits for AND mask
} ICONIMAGE;

#endif




typedef struct
{
    char        bWidth;          // Width, in pixels, of the image
    char        bHeight;         // Height, in pixels, of the image
    char        bColorCount;     // Number of colors in image (0 if >=8bpp)
    char        bReserved;       // Reserved ( must be 0)
    short int   wPlanes;         // Color Planes
    short int   wBitCount;       // Bits per pixel
    int         dwBytesInRes;    // How many bytes in this resource?
    int         dwImageOffset;   // Where in the file is this image?

} ICONDIRENTRY;




typedef struct
{
    short int      idReserved;   // Reserved (must be 0)
    short int      idType;       // Resource Type (1 for icons)
    short int      idCount;      // How many images?

} ICONDIR;

#define ICONDIRSIZE (3*sizeof(short int))















static os_error * getinfo(framestr * frame,bmpinfostr * bmpf)
{
 char   string[256];
 char * p;
 int    colours;

 p=string;

 p+=sprintf(p,"Windows Icon file\n");
 p+=sprintf(p,"%d x %d pixels, %d bpp\n",frame->fxpix,
                                          frame->fypix,frame->fbpp);
 colours=bmpf->windows.ncolourused;

 if(frame->fbpp<=8)
 {
  if(!colours) colours=(1<<frame->fbpp);
  p+=sprintf(p,"Mask Yes. Palette entries %d.\n",colours);
 }

 return(infowrite(string,frame));
}




static os_error * loadbmp(buffer * bf,int bpp,int xpix,int ypix,
                                                    imagestr * loadimage)
{
 os_error  * err;
 int         x;
 int         y;
 int       * idata;
 int         wwidth;
 char      * p;
 int         b;
	int       * pw;

 err=NULL;

 wwidth=((bpp*xpix+31) & ~0x1F)>>3;
 for(y=(ypix-1);y>=0;y--)
 {
  err=imfind1w(loadimage,y,&idata);
  if(err) break;
  err=bf_read(bf,idata,wwidth);
  if(err) break;

  if(bpp==24)
  {
   p=(char*)idata;
   for(x=0;x<xpix;x++)
   {
    b=*p;
    *p=*(p+2);
    *(p+2)=(char)b;
    p+=3;
   }
  }
		else
		if(bpp==32)
		{
			pw=idata;
   for(x=0;x<xpix;x++)
   {
    b=*pw;
				b=((b&0xFF)<<16)|(b&0xFF00)|((b&0xFF0000)>>16);
    *pw=b;
				pw++;
   }
		}
  else imrevline(loadimage,y);
 }

 return(err);
}






static os_error * icoloadframe(filestr * file,buffer * bf,
                                                ICONDIRENTRY * ide,int fn)
{
 os_error * err;
 imagestr * loadimage;
 int        r;
 int        g;
 int        b;
 bmpinfostr bmpf;
 int        bpp;
 int        xpix;
 int        ypix;
 int        colours;
 int        i;
 int        pal[256];
 int        cbfix=0;
 int     * idata;


          err=bf_seek(bf,ide->dwImageOffset);
 if(!err) err=bf_read(bf,&cbfix,sizeof(int));
 if(!err) err=bf_read(bf,&bmpf,cbfix-sizeof(int));

 if(!err)
 {
  bpp =bmpf.windows.bitcount;
  xpix=bmpf.windows.cx;
  ypix=bmpf.windows.cy/2;

  if(bpp>8) colours=0;
  else
  {
   colours=bmpf.windows.ncolourused;
   if(colours==0) colours=(1<<bpp);
  }

  for(i=0;i<colours;i++)
  {
   bf_getc(bf,&b);
   bf_getc(bf,&g);
   bf_getc(bf,&r);
   pal[i]=(b<<24)|(g<<16)|(r<<8);
   bf_getc(bf,&b);
  }


  err=ximnew2(file->frames[fn].fxpix,file->frames[fn].fypix,
              bmpf.windows.bitcount,1,&file->frames[fn].xim);

  if(!err)
  {
   loadimage=((file->frames[fn].xim)->sim[IM]);
   loadimage->xdpi=file->frames[fn].fxdpi;
   loadimage->ydpi=file->frames[fn].fydpi;

   cmsrgbprofile(&loadimage->profile);

   file->frames[fn].fbpp=bmpf.windows.bitcount;

   getinfo(&loadfile->frames[fn],&bmpf);


   loadimage->ipal.ncolours=colours;
   for(i=0;i<colours;i++)
   {
    loadimage->ipal.word[i]=pal[i];
   }


   loadbmp(bf,bmpf.windows.bitcount,bmpf.windows.cx,
                                    bmpf.windows.cy/2,loadimage);
   

   loadimage=((loadfile->frames[fn].xim)->sim[AL]);
   imsetgreypal(loadimage,1);
   loadbmp(bf,1,bmpf.windows.cx,bmpf.windows.cy/2,loadimage);

   for(i=0;i<ypix;i++)
   {
    err=imfind1w(loadimage,i,&idata);
    if(err) break;
    maskflip(idata,1,xpix);
   }
  }
 }

 return(err);
}




static os_error *loadico(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error    * err;
 buffer        bf;
 ICONDIR       icodir;
 ICONDIRENTRY  icoentry;
 ICONDIRENTRY  icoentry1;
 int           i;
 int           fn;

 err=bf_open(name,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  err=bf_read(&bf,&icodir,ICONDIRSIZE);
  if(!err)
  {
   for(i=0;i<icodir.idCount;i++)
   {
    err=bf_read(&bf,&icoentry,sizeof(ICONDIRENTRY));
    if(err) break;

    err=addframe(loadfile,&fn,0);
    if(err) break;

    loadfile->frames[fn].offset=icoentry.dwImageOffset;
    loadfile->frames[fn].fbpp=icoentry.wBitCount;
    loadfile->frames[fn].fxpix=icoentry.bWidth;
    loadfile->frames[fn].fypix=icoentry.bHeight;
    loadfile->frames[fn].fxdpi=icoxres;
    loadfile->frames[fn].fydpi=icoyres;
    loadfile->frames[fn].xim=NULL;

    if(i==0) icoentry1=icoentry;

    sprintf(loadfile->frames[fn].name,"ICO%dx%d",
                                       icoentry.bWidth,icoentry.bHeight);
   }

   if(!err)
   {
    err=icoloadframe(loadfile,&bf,&icoentry1,0);
   }
  }
  err=bf_close(&bf,err);
 }


 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}





static os_error * getframe(filestr * file,int fn)
{
 os_error    * err;
 buffer        bf;
 ICONDIRENTRY  icoentry;

 err=bf_open(file->oname,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
           err=bf_seek(&bf,ICONDIRSIZE+sizeof(ICONDIRENTRY)*fn);
  if(!err) err=bf_read(&bf,&icoentry,sizeof(ICONDIRENTRY));
  if(!err) err=icoloadframe(file,&bf,&icoentry,fn);

  err=bf_close(&bf,err);
 }
 return(err);
}





static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;
 err=NULL;
 return(err);
 USE(userhandle);
}


/*****************************************************************************/

static char explode[16]=
{
 0x00,  /* 0x0 */
 0x10,  /* 0x1 */
 0x20,
 0x30,
 0x01,
 0x11,
 0x12,
 0x13,
 0x02,
 0x12,
 0x22,
 0x32,
 0x03,
 0x13,
 0x23,
 0x33
};







static os_error * savebmpmask(buffer * bf,imagestr * saveimage,
                                                     int xpix,int ypix)
{
 os_error  * err;
 int         wwidth;
 int       * temp;
 int         y;
 int       * idata;
 int         mbpp;
 char      * p;
 int         i;

 err=NULL;

 mbpp=saveimage->bpp;
 wwidth=((xpix+31)&~0x1F)>>3;

 err=flex_alloc((flex_ptr)&temp,wwidth);
 if(!err)
 {
  for(y=(ypix-1);y>=0;y--)
  {
   err=imfind1r(saveimage,y,&idata);
   if(err) break;

   maskcut(idata,mbpp,temp,1,xpix);
   maskflip(temp,mbpp,xpix);

   p=(char*)temp;

   for(i=0;i<wwidth;i++,p++) *p=bitrev[*p];

   err=bf_write(bf,temp,wwidth);
  }

  if(temp) flex_free((flex_ptr)&temp);
 }

 return(err);
}








static os_error * savebmp(buffer * bf,imagestr * saveimage,
                          int bpp,int obpp,int xpix,int ypix)
{
 os_error  * err;
 int         wwidth;
 char      * p;
 char      * q;
 char      * temp;
 int         i;
 int         y;
 int       * idata;
 int         ch;
 int         x;


 err=NULL;

 wwidth=((xpix*obpp+31)&~0x1F)>>3;

 if(obpp==1 || obpp==4 || bpp==16 || bpp==32 || bpp==24)
                                    err=flex_alloc((flex_ptr)&temp,wwidth);
 else                              temp=NULL;

 if(!err)
 {
  for(y=(ypix-1);y>=0;y--)
  {
   err=imfind1r(saveimage,y,&idata);
   if(err) break;

   if(bpp==32)
   {
    q=temp;

    for(x=0;x<xpix;x++)
    {
     ch=*idata++;
     *q++=(char)(ch>>16);
     *q++=(char)(ch>>8);
     *q++=(char)ch;
    }

    err=bf_write(bf,temp,wwidth);
   }
   else
   if(bpp==16)
   {
    q=temp;
    for(x=0;x<xpix;x++)
    {
     ch=*idata++;

     *q++=(char)((ch>>7)&0xF8);
     *q++=(char)((ch>>2)&0xF8);
     *q++=(char)((ch<<3)&0xF8);

     x++;
     if(x>=xpix) break;

     *q++=(char)((ch>>23)&0xF8);
     *q++=(char)((ch>>18)&0xF8);
     *q++=(char)((ch>>13)&0xF8);
    }
    err=bf_write(bf,temp,wwidth);
   }
   else
   if(bpp==24)
   {
    q=temp;
    p=(char*)idata;

    for(x=0;x<xpix;x++)
    {
     *q++=*(p+2);
     *q++=*(p+1);
     *q++=*p;
     p+=3;
    }

    err=bf_write(bf,temp,wwidth);
   }
   else
   if(bpp==8) err=bf_write(bf,idata,wwidth);
   else
   if(bpp==1)
   {
    q=temp;
    p=(char*)idata;
    for(i=0;i<wwidth;i++) *q++=bitrev[*p++];
    err=bf_write(bf,temp,wwidth);
   }
   else
   if(bpp==4)
   {
    q=temp;
    p=(char*)idata;
    for(i=0;i<wwidth;i++) *q++=nybrev[*p++];
    err=bf_write(bf,temp,wwidth);
   }
   else
   if(obpp==4)
   {
    q=temp;
    p=(char*)idata;
    for(i=0;i<wwidth;i++)
    {
     ch=*p++;
     *q++=explode[ch & 0xF];
     *q++=explode[ch>>4];
    }
    err=bf_write(bf,temp,wwidth);
   }
  }

  if(temp) flex_free((flex_ptr)&temp);
 }

 return(err);
}







static os_error * savenullbmp(buffer * bf,int bpp,int xpix,int ypix)
{
 os_error  * err;
 int         wwidth;
 char      * temp;
 int         y;

 err=NULL;

 wwidth=((xpix*bpp+31)&~0x1F)>>3;

 err=flex_alloc((flex_ptr)&temp,wwidth);
 if(!err)
 {
  memset(temp,0,wwidth);

  for(y=(ypix-1);y>=0;y--)
  {
   err=bf_write(bf,temp,wwidth);
  }

  flex_free((flex_ptr)&temp);
 }

 return(err);
}











static os_error * savemaskbmp(buffer * bf,imagestr * saveimage,
                              imagestr * maskim,
                              int bpp,int obpp,int xpix,int ypix)
{
 os_error  * err;
 int         wwidth;
 char      * p;
 char      * q;
 char      * temp;
 int         i;
 int         y;
 int       * idata;
 int         ch;
 int         x;
 int       * mm;
 int         m;
 int         mshift;
 int         mwidth;
 int       * mdata;
 int         zindex;
 int         zm;


 err=NULL;


 zindex=0;

 if(bpp<=8)
 {
  for(i=0;i<(1<<bpp);i++)
  {
   if((saveimage->ipal.word[i] & 0xFFFFFF00)==0)
   {
    zindex=i;
    break;
   }
  }
 }


 wwidth=((xpix*obpp+31)&~0x1F)>>3;

 err=flex_alloc((flex_ptr)&temp,wwidth);
 if(!err)
 {
  mwidth=((xpix+31)&~0x1F)>>3;        /* add a word to let pointers over run */
  err=flex_alloc((flex_ptr)&mdata,mwidth+sizeof(int));

  if(!err)
  {
   for(y=(ypix-1);y>=0;y--)
   {
    err=imfind1r(maskim,y,&idata);
    if(err) break;

    maskcut(idata,maskim->bpp,mdata,1,xpix);
    mshift=0;
    mm=mdata;
    m=*mm++;

    err=imfind1r(saveimage,y,&idata);
    if(err) break;


    if(bpp==32)
    {
     q=temp;

     for(x=0;x<xpix;x++)
     {
      ch=*idata++;

      if((m & 0x1)==0) ch=0;

      *q++=(char)(ch>>16);
      *q++=(char)(ch>>8);
      *q++=(char)(ch);

      m=m>>1;
      mshift++;
      if(mshift>=32)
      {
       m=*mm++;
       mshift=0;
      }
     }

     err=bf_write(bf,temp,wwidth);
    }
    else
    if(bpp==16)
    {
     q=temp;
     for(x=0;x<xpix;x++)
     {
      ch=*idata++;

      if((m & 0x1)==0) ch&=0xFFFF0000;
      if((m & 0x2)==0) ch&=0xFFFF;

      *q++=(char)((ch>>7)&0xF8);
      *q++=(char)((ch>>2)&0xF8);
      *q++=(char)((ch<<3)&0xF8);

      x++;
      if(x>=xpix) break;

      *q++=(char)((ch>>23)&0xF8);
      *q++=(char)((ch>>18)&0xF8);
      *q++=(char)((ch>>13)&0xF8);

      m=m>>2;
      mshift+=2;
      if(mshift>=32)
      {
       m=*mm++;
       mshift=0;
      }
     }
     err=bf_write(bf,temp,wwidth);
    }
    else
    if(bpp==24)
    {
     q=temp;
     p=(char*)idata;

     for(x=0;x<xpix;x++)
     {
      if((m & 0x1)==0)
      {
       *q++=0;
       *q++=0;
       *q++=0;
      }
      else
      {
       *q++=*(p+2);
       *q++=*(p+1);
       *q++=*p;
      }

      p+=3;

      m=m>>1;
      mshift++;
      if(mshift>=32)
      {
       m=*mm++;
       mshift=0;
      }
     }

     err=bf_write(bf,temp,wwidth);
    }
    else
    if(bpp==8)
    {
     q=temp;
     p=(char*)idata;
     for(i=0;i<wwidth;i++)
     {
      ch=*p++;

      if((m & 0x1)==0) ch=zindex;

      *q++=(char)ch;

      m=m>>1;
      mshift+=1;
      if(mshift>=32)
      {
       m=*mm++;
       mshift=0;
      }
     }
     err=bf_write(bf,temp,wwidth);
    }
    else
    if(bpp==1)
    {
     q=temp;
     p=(char*)idata;

     zm=zindex|(zindex<<1)|(zindex<<2)|(zindex<<3);
     zm=zm | (zm<<4);

     for(i=0;i<wwidth;i++)
     {
      ch=*p++;
      ch&=m;
      ch|=(zm & (~m));

      *q++=bitrev[ch];

      m=m>>8;
      mshift+=8;
      if(mshift>=32)
      {
       m=*mm++;
       mshift=0;
      }
     }
     err=bf_write(bf,temp,wwidth);
    }
    else
    if(bpp==4)
    {
     q=temp;
     p=(char*)idata;
     for(i=0;i<wwidth;i++)
     {
      ch=*p++;

      if((m & 0x1)==0)
      {
       ch&=0xF0;
       ch|=zindex;
      }
      if((m & 0x2)==0)
      {
       ch&=0xF;
       ch|=(zindex<<4);
      }

      *q++=nybrev[ch];

      m=m>>2;
      mshift+=2;
      if(mshift>=32)
      {
       m=*mm++;
       mshift=0;
      }
     }
     err=bf_write(bf,temp,wwidth);
    }
    else
    if(obpp==4)  /* bpp == 2 */
    {
     q=temp;
     p=(char*)idata;
     for(i=0;i<wwidth;i++)
     {
      ch=*p++;

      if((m & 0x1)==0) {ch&=0xFC;ch|=zindex;}
      if((m & 0x2)==0) {ch&=0xF3;ch|=(zindex<<2);}
      if((m & 0x4)==0) {ch&=0xCF;ch|=(zindex<<4);}
      if((m & 0x8)==0) {ch&=0x3F;ch|=(zindex<<6);}

      *q++=explode[ch & 0xF];
      *q++=explode[ch>>4];

      m=m>>4;
      mshift+=4;
      if(mshift>=32)
      {
       m=*mm++;
       mshift=0;
      }
     }
     err=bf_write(bf,temp,wwidth);
    }
   }

   flex_free((flex_ptr)&mdata);
  }
  flex_free((flex_ptr)&temp);
 }

 return(err);
}







static os_error * saveico(char * name,int type)
{
 os_error * err;
 buffer      bf;
 bmpinfostr  bmpf;
 int         fn;
 imagestr  * saveimage;
 imagestr  * maskim;
 int         xpix;
 int         ypix;
 int         bpp;
 int         obpp;
 int         palsize;
 int         bitsize;
 int         wwidth;
 int         bitsize2;
 int         wwidth2;
 int         i;
 int         palword;
 int         colours;
 int           xdpi;
 int           ydpi;
 ICONDIR       icodir;
 ICONDIRENTRY  icoentry;
 int           rsize;
 int           cbfix;


 err=NULL;


 fn=menuview->frame;
 saveimage=((menufile->frames[fn].xim)->sim[IM]);
 maskim=((menufile->frames[fn].xim)->sim[AL]);


 xpix=saveimage->xpix;
 ypix=saveimage->ypix;
 xdpi=saveimage->xdpi;
 ydpi=saveimage->ydpi;
 bpp=saveimage->bpp;


 if(xpix>255 || ypix>255) err=geterror(EICO0);
 if(!err)     err=bf_open(name,'w',DEFBUFFSIZE,&bf);
 if(!err)
 {
  if(bpp==16 || bpp==32) obpp=24;
  else                   obpp=(bpp==2)?4:bpp;

  if(obpp>8) colours=0;
  else       colours=(1<<obpp);

  palsize=(4*colours);
  wwidth=((xpix*obpp+31)&~0x1F)>>3;
  bitsize=wwidth*ypix;
  wwidth2=((xpix*1+31)&~0x1F)>>3;
  bitsize2=wwidth2*ypix;
  cbfix=sizeof(bmpinfostr)+sizeof(int);
  rsize=cbfix+palsize+bitsize+bitsize2;

  icodir.idReserved=0;
  icodir.idType=(short)((type==ICO)?1:2);
  icodir.idCount=1;

  icoentry.bWidth=(char)xpix;             // Width, in pixels, of the image
  icoentry.bHeight=(char)ypix;            // Height, in pixels, of the image
  icoentry.bColorCount=(char)colours;    // Number of colors in image (0 if >=8bpp)
  icoentry.bReserved=0;             // Reserved ( must be 0)
  icoentry.wPlanes=1;               // Color Planes
  icoentry.wBitCount=(short)obpp;          // Bits per pixel
  icoentry.dwBytesInRes=rsize;      // How many bytes in this resource?
  icoentry.dwImageOffset=ICONDIRSIZE+sizeof(ICONDIRENTRY);

  bmpf.windows.cx=xpix;
  bmpf.windows.cy=ypix*2;
  bmpf.windows.cplanes=1;
  bmpf.windows.bitcount=(short)obpp;
  bmpf.windows.compression=BI_RGB;
  bmpf.windows.imagesize=0;
  bmpf.windows.xdpm=0;
  bmpf.windows.ydpm=0;
  bmpf.windows.ncolourused=0;
  bmpf.windows.ncolourimportant=0;

  bf_write(&bf,&icodir,ICONDIRSIZE);
  bf_write(&bf,&icoentry,sizeof(ICONDIRENTRY));
  bf_write(&bf,&cbfix,sizeof(int));
  bf_write(&bf,&bmpf,sizeof(bmpinfostr));

  for(i=0;i<colours;i++)
  {
   palword=saveimage->ipal.word[i];

   bf_putc(&bf,(palword>>24)&0xFF);
   bf_putc(&bf,(palword>>16)&0xFF);
   bf_putc(&bf,(palword>>8)&0xFF);
   bf_putc(&bf,0);
  }


  if(maskim) savemaskbmp(&bf,saveimage,maskim,bpp,obpp,xpix,ypix);
  else       savebmp(&bf,saveimage,bpp,obpp,xpix,ypix);

  if(maskim) savebmpmask(&bf,maskim,xpix,ypix);
  else       savenullbmp(&bf,1,xpix,ypix);


  err=bf_closec(&bf,err,name,type);
 }
 return(err);
}






/*****************************************************************************/


static os_error * wrpc(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdpc(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}



/*****************************************************************************/

#ifdef NEVER
static int bits2(int xcase)
{
 if(xcase==FAUTORUN) return(dbl2);

 return(0);
}

#endif


static os_error * configclose2(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl2!=tdbl2)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl2=tdbl2;
  }
  icoxres2=txres2;
  icoyres2=tyres2;
 }

 return(err);
}



static os_error * configicon2(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype2,handle,&configbox2,&tdbl2);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl2(int value,char * string)
{
 ftypewr(value,string,&ftype2);
 return(NULL);
}





static dbiconstr configicondefs2[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl2,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl2,
    5, &txres2,       DBWRITE,  0,   0,      7, -1,  7,-1, rdpc, wrpc,
    6, &tyres2,       DBWRITE,  0,   0,     -1,  5, -1, 5, rdpc, wrpc,


   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox2=
{
 0,
 TCUR,
 DBFIX,
 0,
 configclose2,
 configicon2,
 NULL,
 NULL,
 configicondefs2,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config2(wimp_w parent)
{
 os_error * err;

 if(configbox2.handle) err=dbclose(&configbox2,DBCANCEL);

 tdbl2=dbl2;
 txres2=icoxres2;
 tyres2=icoyres2;
 err=dodboxparent(&configbox2,1,parent);


 return(err);
}

/*****************************************************************************/




static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}




static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
  icoxres=txres;
  icoyres=tyres;
 }

 return(err);
}



static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}





static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,
    5, &txres,       DBWRITE,  0,   0,      7, -1,  7,-1, rdpc, wrpc,
    6, &tyres,       DBWRITE,  0,   0,     -1,  5, -1, 5, rdpc, wrpc,


   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TICO,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);

 tdbl=dbl;
 txres=icoxres;
 tyres=icoyres;
 err=dodboxparent(&configbox,1,parent);


 return(err);
}

/*****************************************************************************/


static ftypestr ftype=
{
 ICO,             /* file type  */
 0,               /* flags      */
 loadico,         /* load       */
 loadfilepost,    /* loadpost   */
 "{ICO}",         /* name       */
 "{ICO}",         /* type name  */
 saveico,         /* save       */
 config,          /* configure  */
 0,               /* icon       */
 bits,            /* bit flags  */
 getframe,        /* get frame  */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,            /* file info  */


 NULL,            /* saveim */
 "ico\0""132\0",  /* extension */

 "Windows Icon (*.ico)",/* description */
};





static contag contable[5]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "DefaultXRes",CONINT,&icoxres,NULL,NULL,
 "DefaultYRes",CONINT,&icoyres,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "ICO",
 NULL,
 NULL
};





static ftypestr ftype2=
{
 CURSOR,          /* file type  */
 0,               /* flags      */
 loadico,         /* load       */
 loadfilepost,    /* loadpost   */
 "{CUR}",         /* name       */
 "{CUR}",         /* type name  */
 saveico,         /* save       */
 config2,         /* configure  */
 0,               /* icon       */
 bits,            /* bit flags  */
 getframe,        /* get frame  */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,            /* file info  */


 NULL,            /* saveim */
 "cur\0""133\0",  /* extension */

 "Windows Cursor (*.cur)",/* description */
};








static contag contable2[5]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "DefaultXRes",CONINT,&icoxres2,NULL,NULL,
 "DefaultYRes",CONINT,&icoyres2,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink2=
{
 "CUR",
 NULL,
 NULL
};




static os_error * configloaded(int eventn,uservalue userhandle,
                                                        void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {

  dbl=ftypegetrun(&ftype);
  dbl2=ftypegetrun(&ftype2);

//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}






os_error * icoinit(void)
{
 os_error * err;

          err=registerfiletype(&ftype);
 if(!err) err=registerfiletype(&ftype2);
 if(!err)
 {
           err=addcontable(contable,&configlink);
  if(!err) err=addcontable(contable2,&configlink2);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);
 }

 return(err);
}


