/*->c.hsv */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <math.h>


#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "config.h"

#include "str.h"
#include "constants.h"

#include "col.h"

#include "hsv.h"


#define MAXCV  255

#define HUE360 192
#define HUE180 (HUE360/2)
#define HUE90  (HUE180/2)
#define HUE120 (HUE360/3)
#define HUE60  (HUE120/2)
#define HUE240 (HUE120*2)
#define HUE300 (HUE60*5)



#define XSHIFT 16

static int xtab[512];




static int dc;
static int dv;
static int ds;
static int dh;


//static int  hmap[HUE360];
//static char smap[MAXCV];
//static char vmap[MAXCV];



#define hmap rvmap
#define smap gvmap
#define vmap bvmap





int hsvmap(int r,int g,int b)
{
 int h;
 int s;
 int v;
 int min;
 int max;

 if(r>g)
 {
  if(b>r) 
  {
   v=b;
   min=g;
  }
  else  /* r>g b<r */
  {
   v=r;
   if(b>g) min=g;
   else    min=b;
  }
 }
 else   /* r<=g */
 {
  if(b>g) 
  {
   v=b;
   min=r;
  }
  else
  {
   v=g;
   if(r<b) min=r;
   else    min=b;
  }
 }


 max=v;

 if(min==v)
 {
  s=0;
  h=0;
 }
 else
 {
//  s=((v-min)*MAXCV)/v;  // hsv->type.hsv.s=scale(MAXCV,max-min,max);
  s=((v-min)*MAXCV*xtab[v])>>XSHIFT;

  if(min==b)
  {
//   h=(HUE120*(g-min))/(r+g-2*min); 
//   h=(HUE120*(g-min)*xtab[r+g-2*min])>>XSHIFT;

   if(max==r)
   {
//    h=scale(HUE60,g-min,r-min);
    h=(HUE60*(g-min)*xtab[r-min])>>XSHIFT;
   }
   else
   {
//    h=HUE120-scale(HUE60,r-min,g-min);
    h=HUE120-((HUE60*(r-min)*xtab[g-min])>>XSHIFT);
   }
  }
  else
  if(min==r)
  {
//   h=HUE120+(HUE120*(b-min))/(b+g-2*min);
//   h=HUE120+((HUE120*(b-min)*xtab[b+g-2*min])>>XSHIFT);

   if(max==g)
   {
//    h=HUE120+scale(HUE60,b-min,g-min);
    h=HUE120+((HUE60*(b-min)*xtab[g-min])>>XSHIFT);
   }
   else
   {
//    h=HUE240-scale(HUE60,g-min,b-min);
    h=HUE240-((HUE60*(g-min)*xtab[b-min])>>XSHIFT);
   }
  }
  else
  {
//   h=HUE240+(HUE120*(r-min))/(r+b-2*min);
//   h=HUE240+((HUE120*(r-min)*xtab[r+b-2*min])>>XSHIFT);
   if(max==b)
   {
//    h=HUE240+scale(HUE60,r-min,b-min);
    h=HUE240+((HUE60*(r-min)*xtab[b-min])>>XSHIFT);
   }
   else
   {
//    h=HUE360-scale(HUE60,b-min,r-min);
    h=HUE360-((HUE60*(b-min)*xtab[r-min])>>XSHIFT);
   }
  }
 }


 v=vmap[v];
 s=smap[s];
 h=hmap[h];

#define DIVHUE60(a) (((a))/(HUE360/6))


 min=(v*(MAXCV-s)*xtab[MAXCV])>>XSHIFT;


// min=(v*(MAXCV-s))/MAXCV;

// min=(v*(MAXCV-s))/MAXCV; //  min=scale(hsv->type.hsv.v,MAXCV-hsv->type.hsv.s,MAXCV);

 if(h<=HUE120)
 {
  b=min;
  if(h<=HUE60)
  {
   r=v;
//   g=min+(h*(v-min))/(HUE120-h);
      // rgb->type.rgb.g=min+scale(h,hsv->type.hsv.v-min,HUE60);
   g=min+DIVHUE60(((h*(v-min))));
  }
  else
  {
   g=v;
//   r=min+((HUE120-h)*(v-min))/h;
//      rgb->type.rgb.r=min+scale(HUE120-h,hsv->type.hsv.v-min,HUE60);
   r=min+DIVHUE60((((HUE120-h)*(v-min))));
  }
 }
 else
 if(h<=HUE240)
 {
  r=min;
  if(h<=HUE180)
  {
   g=v;
//   b=min+((h-HUE120)*(v-min))/(HUE240-h);
   //   rgb->type.rgb.b=min+scale(h-HUE120,hsv->type.hsv.v-min,HUE60);
   b=min+DIVHUE60((((h-HUE120)*(v-min))));
  }
  else
  {
   b=v;
//   g=min+((HUE240-h)*(v-min))/(h-HUE120);
   // rgb->type.rgb.g=min+scale(HUE240-h,hsv->type.hsv.v-min,HUE60);
   g=min+DIVHUE60((((HUE240-h)*(v-min))));
  }
 }
 else
 {
  g=min;
  if(h<=HUE300)
  {
   b=v;
//   r=min+((h-HUE240)*(v-min))/(HUE360-h); 
   //   rgb->type.rgb.r=min+scale(h-HUE240,hsv->type.hsv.v-min,HUE60);
   r=min+DIVHUE60((((h-HUE240)*(v-min))));
  }
  else
  {
   r=v;
//   b=min+((HUE360-h)*(v-min))/(h-HUE240);
   //   rgb->type.rgb.b=min+scale(HUE360-h,hsv->type.hsv.v-min,HUE60);
   b=min+DIVHUE60((((HUE360-h)*(v-min))));
  }
 }

 return(r|(g<<8)|(b<<16));
}








os_error * hsvmapstart(int c,int v,int s,int h)
{
 os_error * err;
 int        i;

 err=NULL;

 dc=(c*MAXCV)/100;
 dv=(v*MAXCV)/100;
 ds=(s*MAXCV)/100;
 dh=(h*MAXCV)/100;


 for(i=0;i<=MAXCV;i++)
 {
  v=i+dv;
  v+=(v*dc)/MAXCV;
  if(v>MAXCV) v=MAXCV;
  if(v<0) v=0;
  vmap[i]=(char)v;
 }

 for(i=0;i<=HUE360;i++)
 {
  h=i+dh;
  if(h>HUE360) h-=HUE360;
  if(h<0) h+=HUE360;
  hmap[i]=h; //(char)h;
 }

 for(i=0;i<=MAXCV;i++)
 {
//  s=i+(s*ds)/MAXCV;
  s=i+ds;
  if(s>MAXCV) s=MAXCV;
  if(s<0) s=0;
  smap[i]=(char)s;
 }

 for(i=1;i<512;i++) xtab[i]=(1<<XSHIFT)/i;

 return(err);
}


os_error * hsvmapend(void)
{
 os_error * err;

 err=NULL;

 return(err);
}


