/*->c.hist */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"
#include "bbc.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "filetype.h"
#include "fsx.h"
#include "bf.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "mlo.h"
#include "units.h"
#include "bits.h"
#include "conf.h"
#include "colour.h"
#include "redraw.h"
#include "xmath.h"
#include "config.h"
#include "pane.h"
#include "save.h"
#include "deb.h"


#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewr.h"
#include "im.h"
#include "long.h"

#include "bm.h"
#include "fx.h"
#include "user.h"
#include "col.h"

#include "hist.h"




/* static dboxstr hbox; */

static int       hmode=7;
static filestr * hfile;
static viewstr * hview;

#define MAXLEVELS 256
#define MINLEVELS 2

static int clevels=16;


#define MAXBIN   (clevels)
#define XBIN     (clevels)


static int rbin[MAXLEVELS];
static int gbin[MAXLEVELS];
static int bbin[MAXLEVELS];

static int rmax;
static int gmax;
static int bmax;


static int cut1=25;
static int cut2=230;


os_error * calchist2(viewstr * view,int maxbin,int xbin,int flags,
                                    int * rbin,int * gbin,int * bbin)
{
 os_error * err;
 filestr  * file;
 imagestr * im;
 int        bpp;
 int        xpix;
 int        ypix;
 int      * data;
 char     * p;
 int        mask;
 int        shift;
 int        c;
 int        w;
 int        i;
 spanstr  * sp;
 int        ylo;
 int        yhi;
 int        xlo;
 int        xhi;
 int        y;
 int        x;
 char       rtab[256];
 char       gtab[256];
 char       btab[256];
 int        sumr;
 int        sumg;
 int        sumb;


 file=(filestr*)view->file;


 for(i=0;i<maxbin;i++)
 {
  rbin[i]=gbin[i]=bbin[i]=0;
 }


 err=setupfilterarea(view,&sp,&ylo,&yhi);
 if(!err)
 {
  if(file->frames && file->framen)
  {
   im=((file->frames[view->frame].xim)->sim[IM]);

   bpp=im->bpp;
   xpix=im->xpix;
   ypix=im->ypix;

   longprocstart(NULL,0,ypix,view);

   if(bpp<=8)
   {
    /* construct tables which tell us which bin to inc for each colour */

    for(i=0;i<im->ipal.ncolours;i++)
    {
     w=im->ipal.word[i];
     rtab[i]=(char)((((w>> 8)&0xFF)*xbin)/256);
     gtab[i]=(char)((((w>>16)&0xFF)*xbin)/256);
     btab[i]=(char)((((w>>24)&0xFF)*xbin)/256);
    }
   }


   if(bpp==1) mask=0x1;
   else
   if(bpp==2) mask=0x3;
   else
   if(bpp==4) mask=0xF;
   else       mask=0xFF;


   for(y=ylo;y<yhi;y++)
   {
    longproctick();

    err=imfind1r(im,y,&data);
    p=(char*)data;

    xlo=sp[y-ylo].xlo;
    xhi=sp[y-ylo].xhi;

    switch(bpp)
    {
     case  1:
     case  2:
     case  4:
     case  8:
             data+=(xlo*bpp)/32;
             shift=(xlo*bpp)&(0x1F);
             c=*data++;

             for(x=xlo;x<xhi;x++)
             {
              w=(c>>shift)&mask;
              rbin[rtab[w]]++;
              gbin[gtab[w]]++;
              bbin[btab[w]]++;

              shift+=bpp;
              if(shift>=32)
              {
               c=*data++;
               shift=0;
              }
             }
             break;

     case 16:
             data+=(xlo*bpp)/32;
             shift=(xlo*bpp)&(0x1F);
             c=*data++;

             for(x=xlo;x<xhi;x++)
             {
              if(shift) rbin[(((c>>(shift-3))&0xF8)*xbin)/0xF8]++;
              else      rbin[(((c<<3)&0xF8)*xbin)/0xF8]++;

              gbin[(((c>>(shift+2))&0xF8)*xbin)/0xF8]++;
              bbin[(((c>>(shift+7))&0xF8)*xbin)/0xF8]++;

              shift+=bpp;
              if(shift>=32)
              {
               c=*data++;
               shift=0;
              }
             }

             break;

     case 24:
             p+=3*xlo;
             for(x=xlo;x<xhi;x++)
             {
              rbin[((*p++)*xbin)/256]++;
              gbin[((*p++)*xbin)/256]++;
              bbin[((*p++)*xbin)/256]++;
             }
             break;

     case 32:
             data+=xlo;
             for(x=xlo;x<xhi;x++)
             {
              w=*data++;
              rbin[((w&0xFF)*xbin)/256]++;
              gbin[(((w>>8)&0xFF)*xbin)/256]++;
              bbin[(((w>>16)&0xFF)*xbin)/256]++;
             }
             break;
    }
   }

   longprocend();
  }

  freefilterarea(&sp);
 }

 if(flags & HISTCUM)
 {

  sumr=sumg=sumb=0;

  for(i=0;i<maxbin;i++)
  {
   sumr+=rbin[i];
   rbin[i]=sumr;

   sumg+=gbin[i];
   gbin[i]=sumg;

   sumb+=bbin[i];
   bbin[i]=sumb;
  }
 }

 return(err);
}





static os_error * calchist(viewstr * view,filestr * file)
{
 os_error * err;
 int        i;

 err=calchist2(view,MAXBIN,XBIN,0,rbin,gbin,bbin);

 rmax=gmax=bmax=0;

 for(i=0;i<MAXBIN;i++)
 {
  rmax=MAX(rmax,rbin[i]);
  gmax=MAX(gmax,gbin[i]);
  bmax=MAX(bmax,bbin[i]);
 }

 return(err);
 USE(file);
}











/****************************************************************************/


static os_error * redrawslider3x(wimp_redrawstr * redrawstr,
                                int i1,int i2,wimp_w handle,int value,int max)
{
 os_error * err;
 int        ox;
 int        oy;
 iconstr    icon1;
 iconstr    icon2;
 int        h;
 int        w;
 int        dx;
 int        dy;
 int        x;
 int        y;


 ox=redrawstr->box.x0-redrawstr->scx;
 oy=redrawstr->box.y1-redrawstr->scy;

 err=geti(handle,i1,&icon1);

 if(iconinredraw(redrawstr,&icon1))
 {
  err=geti(handle,i2,&icon2);

  x=ox+icon2.ix0+(value*(icon2.ix1-icon2.ix0-cvdu.deltax))/max;
  y=oy+icon1.iy1-cvdu.deltay;

  h=icon1.iy1-icon1.iy0;
  w=(h*2)/3;

  dy=h/3;
  dx=w/2;

  err=wimp_setcolour(WIMPBLACK);

  bbc_move(x,y);
  bbc_move(x-dx,y-dy);
  bbc_plot(bbc_TriangleFill+bbc_DrawAbsFore,x+dx,y-dy);

  bbc_rectanglefill(x-cvdu.deltax,y-dy,2*cvdu.deltax,-2*dy+cvdu.deltay);
 }
 return(err);
}




#define XMARGIN 16
#define YMARGIN 16


static os_error * hredrawsub(wimp_w handle,wimp_redrawstr * redrawstr,int more)
{
 os_error * err;
 int        ox;
 int        oy;
 iconstr    icon;
 int        w;
 int        i;
 int        x;
 int        xs;
 int        y;
 int        cw;
 int        ch;
 int        maxh;
 int        maxw;
 int        max;
 int        col;
 int        nx;

 err=NULL;

 while(more)
 {
  redrawslider3x(redrawstr,7,6,handle,cut1,255);
  redrawslider3x(redrawstr,7,6,handle,cut2,255);

  ox=redrawstr->box.x0-redrawstr->scx;
  oy=redrawstr->box.y1-redrawstr->scy;

  err=geti(handle,3,&icon);

  w=icon.ix1-icon.ix0;

  cw=w-(MAXBIN+1)*cvdu.deltax-2*XMARGIN;
  xs=(cw%MAXBIN)/2;
  cw=cw/MAXBIN;

  maxh=icon.iy1-icon.iy0-2*YMARGIN;
  maxw=w-2*XMARGIN;

  if(iconinredraw(redrawstr,&icon))
  {
   x=ox+icon.ix0+XMARGIN; /* +xs; */
   y=oy+icon.iy0+YMARGIN;

   max=0;
   if(hmode & 0x1) max+=rmax;
   if(hmode & 0x2) max+=gmax;
   if(hmode & 0x4) max+=bmax;

   for(i=0;i<MAXBIN;i++)
   {
    ch=0;
    col=0;
    nx=ox+icon.ix0+XMARGIN+((i+1)*maxw)/MAXBIN;

    if(hmode & 0x1) {ch+=rbin[i];col|=((i*255)/(MAXBIN-1))<<8;}
    if(hmode & 0x2) {ch+=gbin[i];col|=((i*255)/(MAXBIN-1))<<16;}
    if(hmode & 0x4) {ch+=bbin[i];col|=((i*255)/(MAXBIN-1))<<24;}

    ch=scale(ch,maxh,max);

    setgcol(col);
    bbc_rectanglefill(x,y,nx-x,ch);   /* was cw */

    wimp_setcolour(WIMPBLACK);
    bbc_rectangle(x,y,cw,ch);
   /* x+=cw+cvdu.deltax; */
    x=nx;
   }
  }

  err=wimp_get_rectangle(redrawstr,&more);
 }

 return(err);
}


static os_error * hredraw(wimp_w handle,uservalue userhandle)
{
 os_error     * err;
 wimp_redrawstr redrawstr;
 int            more;
 redrawstr.w=handle;
 err=wimp_redraw_wind(&redrawstr,&more);
 if(!err) err=hredrawsub(handle,&redrawstr,more);
 return(err);
 USE(userhandle);
}


static os_error * hexpand(void)
{
 int i;
 int lo;
 int hi;
 int x;

 lo=MIN(cut1,cut2);
 hi=MAX(cut1,cut2);

 for(i=0;i<256;i++)
 {
  if(i<=lo) x=0;
  else
  if(i>=hi) x=255;
  else      x=((i-lo)*255)/(hi-lo);

  if(hmode & 0x1) rvmap[i]=(char)x;
  else            rvmap[i]=(char)i;

  if(hmode & 0x2) gvmap[i]=(char)x;
  else            gvmap[i]=(char)i;

  if(hmode & 0x4) bvmap[i]=(char)x;
  else            bvmap[i]=(char)i;
 }

 return(mapfx(hview,hfile,MIGAMMA));
}



static int binsplit(int * bin,int average,int * split,int * out)
{
 int current;
 int splits;
 int last;
 int lastv;
 int next;
 int nextv;
 int i;
 int oldbin;
 int currbin;

 splits=0;

 current=0;
 oldbin=-1;

 for(i=0;i<256;i++)
 {
  currbin=(i*XBIN)/256;

  if(oldbin!=currbin)
  {
   oldbin=currbin;

   current+=bin[currbin];

   if(current>average)
   {
    while(current>average)
    {
     current-=average;
    }
    split[splits++]=i;
   }
  }
 }



 last=0;
 lastv=0;
 for(i=0;i<splits;i++)
 {
  if(i<(splits-1)) {next=split[i+1];nextv=out[i+1];}
  else             {next=256;nextv=255;}

  next=(next+last)/2;
  nextv=(nextv+lastv)/2;
  last=split[i];
  lastv=out[i];
  split[i]=next;
  out[i]=nextv;
 /* dprintf(i,"out=%d split=%d",out[i],split[i]); */
 } 

 return(splits);
}




static os_error * hequalise(void)
{
 int i;
 int average;
 int rsplit[MAXLEVELS+1];
 int rout[MAXLEVELS+1];
 int gsplit[MAXLEVELS+1];
 int gout[MAXLEVELS+1];
 int bsplit[MAXLEVELS+1];
 int bout[MAXLEVELS+1];
 int rmax;
 int gmax;
 int bmax;
 int ri;
 int gi;
 int bi;


 average=0;
 for(i=0;i<MAXBIN;i++) average+=rbin[i];
 average/=MAXBIN;

 rmax=binsplit(rbin,average,rsplit,rout);
 gmax=binsplit(gbin,average,gsplit,gout);
 bmax=binsplit(bbin,average,bsplit,bout);

 ri=gi=bi=0;

 for(i=0;i<256;i++)
 {
  if(i>rsplit[ri] && ri<(rmax-1)) ri++;
  if(i>gsplit[gi] && gi<(gmax-1)) gi++;
  if(i>bsplit[bi] && bi<(bmax-1)) bi++;

 /* dprintf(0,"i=%d rsplit=%d ri=%d ro=%d",i,rsplit[ri],ri,rout[ri]); */

  if(hmode & 0x1) rvmap[i]=(char)rout[ri];
  else            rvmap[i]=(char)i;

  if(hmode & 0x2) gvmap[i]=(char)gout[gi];
  else            gvmap[i]=(char)i;

  if(hmode & 0x4) bvmap[i]=(char)bout[bi];
  else            bvmap[i]=(char)i;
 }

 return(mapfx(hview,hfile,MIGAMMA));
}





/* save dictionary as text */
                  
static os_error * savehisttext(char * name,int type)
{
 os_error * err;
 buffer     bf;
 int        i;

 err=bf_open(name,'w',DEFBUFFSIZE,&bf);
 if(!err)
 {
  for(i=0;i<MAXBIN;i++) bf_printf(&bf,"%d%c",rbin[i],(i==(MAXBIN-1))?'\r\n':',');
  for(i=0;i<MAXBIN;i++) bf_printf(&bf,"%d%c",gbin[i],(i==(MAXBIN-1))?'\r\n':',');
  for(i=0;i<MAXBIN;i++) bf_printf(&bf,"%d%c",bbin[i],(i==(MAXBIN-1))?'\r\n':',');

  bf_closec(&bf,err,name,type);
 }

 return(err);
}




static os_error * openhistsave(wimp_w handle)
{
 os_error * err;
 TCHAR      path[MAX_PATH];

 xzstrncpyu(path,TEXT("TextFile"),NITEM(path));

 err=opensaveparent(path,NITEM(path),TEXTFILE,savehisttext,handle);
 

 return(err);
}





static os_error * wrlevel(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}


static os_error * rdlevel(int * value,char * string)
{
 os_error * err;
 int        temp;

 err=stringtonumber(string,&temp);
 if(!err)
 {
  *value=CUT(temp,MINLEVELS,MAXLEVELS);
 }

 return(err);
}






static os_error * hicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;
 char     * string;

 err=NULL;


 if(m->bbits==VBCLICKA)
 {
  err=openhistsave(handle);
 }
 else
 {
  switch(m->i)
  {
   case 1:       /* expand */
          err=hexpand();
          break;

   case 5:       /* equalise */
          err=hequalise();
          break;

   case 8:       /* recalc */
          iconaddr(handle,12,&string);
          rdlevel(&clevels,string);

          err=calchist(hview,hfile);
          wimp_set_icon_state(handle,3,(wimp_iconflags)0,(wimp_iconflags)0);
          break;


   case 4:
          err=openhistsave(handle);
          break;
  }
 }

 return(err);
 USE(userhandle);
}



static os_error * hclose(int code)
{
 os_error * err;

 err=NULL;


 return(err);

 USE(code);
}



static dbiconstr hicondefs[]=
{
 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

   20, &hmode,       DBTOGGLE, 0,    0,     1, F1, 1, 0,          NULL,NULL,
   21, &hmode,       DBTOGGLE, 0,    0,     2, F2, 1, 0,          NULL,NULL,
   22, &hmode,       DBTOGGLE, 0,    0,     4, F3, 1, 0,          NULL,NULL,

    3, &hmode,       DBUPDATE, 0,   0,     -1, -1, -1, -1,        NULL,NULL,

 /* N   &V           Type     Grp   Flags          R   L   D   U    In  Out */

    7,  NULL,        DBTRACKHDR,0,   0,      6,-1,255, 0,         NULL, 0,

   77,  &cut1,       DBTRACK,   0,    0,     6,-1,255, 0,  (dbreadfn)7, 0,
   78,  &cut2,       DBTRACK,   0,    0,     6,-1,255, 0,  (dbreadfn)7, 0,

   12,  &clevels,    DBWRITE,  1,DBASSOCINC, -1, -1, -1, -1,   rdlevel,wrlevel,
   13,  &clevels,    DBDEC,    1,   0,      1,-1,MAXLEVELS,
                                                 MINLEVELS,NULL,NULL,
   14,  &clevels,    DBINC,    1,   0,      1,-1,MAXLEVELS,
                                                 MINLEVELS,NULL,NULL,

    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0,     NULL ,0,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr hbox=
{
 0,
 THIST,
 DBFIX,
 0,
 hclose,
 hicon,
 NULL,
 hredraw,
 hicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};




static os_error * closevent(int eventn,uservalue userhandle,void * data,int data1)
{
 viewstr * view;
 filestr * file;


 if(eventn==EVENT_FCLOSE)
 {
  file=(filestr*)data;

  if(file==hfile)
  {
   dbclose(&hbox,DBSMASH);
   hview=NULL;
   hfile=NULL;
  }
 }
 else
 if(eventn==EVENT_VCLOSE)
 {
  view=(viewstr*)data;

  if(view==hview)
  {
   dbclose(&hbox,DBSMASH);
   hview=NULL;
   hfile=NULL;
  }
 }

 return(NULL);

 USE(userhandle);
 USE(data1);
}




os_error * histogram(wimp_w parent)
{
 os_error * err;

 err=NULL;

 if(hbox.handle) dbclose(&hbox,DBCANCEL);
 hview=menuview;
 hfile=menufile;
 calchist(hview,hfile);
 err=dodboxparent(&hbox,1,parent);


 return(err);
}


os_error * histinit(void)
{
 os_error * err;

 err=addevent(EVENT_FCLOSE,(eventfn)closevent,0);
 if(!err) err=addevent(EVENT_VCLOSE,(eventfn)closevent,0);

 return(err);
}


