/*->c.gifmk */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <setjmp.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"


#include "constants.h"
#include "str.h"

#include "reslink.h"
#include "view.h"
#include "file.h"
#include "im.h"
#include "mask.h"

#include "gif.h"
#include "gifmk.h"





#define EXTENSION          0x21
#define TRAILER            0x3b

#define APPEXTENSION       0xFF
#define COMMENTEXTENSION   0xFE
#define GRAPHICSEXTENSION  0xF9
#define TEXTEXTENSION      0x1


#define INTERLACEMASK      0x40
#define COLORMAPMASK       0x80
#define TRANSPARENCYMASK   0x1



static int transparencyindex=156;




/***************************************************************************
 *
 *  GIFENCOD.C       - GIF Image compression routines
 *
 *  Lempel-Ziv compression based on 'compress'.  GIF modifications by
 *  David Rowley (mgardi@watdcsu.waterloo.edu)
 *
 ***************************************************************************/


#define BITS    12

#define HSIZE  5003            /* 80% occupancy */


/*
 * a code_int must be able to hold 2**BITS values of type int, and also -1
 */

typedef int           code_int;
typedef int           count_int;
typedef unsigned char char_type;


/*
 *
 * GIF Image compression - modified 'compress'
 *
 * Based on: compress.c - File compression ala IEEE Computer, June 1984.
 *
 * By Authors:  Spencer W. Thomas       (decvax!harpo!utah-cs!utah-gr!thomas)
 *              Jim McKie               (decvax!mcvax!jim)
 *              Steve Davies            (decvax!vax135!petsd!peora!srd)
 *              Ken Turkowski           (decvax!decwrl!turtlevax!ken)
 *              James A. Woods          (decvax!ihnp4!ames!jaw)
 *              Joe Orost               (decvax!vax135!petsd!joe)
 *
 */


static int n_bits;                        /* number of bits/code */
static int maxbits = BITS;                /* user settable max # bits/code */
static code_int maxcode;                  /* maximum code, given n_bits */
static code_int maxmaxcode = (code_int)1 << BITS; /* should NEVER generate this
code */

#ifdef COMPATIBLE               /* But wrong! */
# define MAXCODE(n_bits)        ((code_int) 1 << (n_bits) - 1)
#else
# define MAXCODE(n_bits)        (((code_int) 1 << (n_bits)) - 1)
#endif /* COMPATIBLE */

static count_int * htab;
static unsigned short * codetab;


#define HashTabOf(i)       htab[i]
#define CodeTabOf(i)    codetab[i]

static code_int hsize = HSIZE;                 /* for dynamic table sizing */


static code_int free_ent;                      /* first unused entry */

/*
 * block compression parameters -- after all codes are used up,
 * and compression rate changes, start over.
 */
static int clear_flg;


static int ClearCode;
static int EOFCode;


/******************************************************************************
 *
 * GIF Specific routines
 *
 ******************************************************************************/
static buffer   * gbf;
static imagestr * gimage;
static imagestr * gmimage;
static int        g_init_bits;

static jmp_buf xraisejmp;


/*
 * Number of characters so far in this 'packet'
 */
static int a_count;

/*
 * Set up the 'byte output' routine
 */

static void char_init(void)
{
 a_count=0;
}

/*
 * Define the storage for the packet accumulator
 */

static char accum[256];


/*
 * Flush the packet to disk, and reset the accumulator
 */

static void flush_char(void)
{
 os_error * err;

 if(a_count>0)
 {
  err=bf_putc(gbf,a_count);
  if(!err) err=bf_write(gbf,accum,a_count);
  if(err) longjmp(xraisejmp,(int)err);
  a_count=0;
 }
}


/*
 * Add a character to the end of the current packet, and if it is 254
 * characters, flush the packet to disk.
 */
static void char_out(int c)
{
 accum[a_count++]= (char)c;
 if(a_count>=254) flush_char();
}

/* The End */

static int Width, Height;
static int curx, cury;
static int Pass;
static int Interlace;

static int shift;
static int bpp;
static int word;
static int mask;

static int mshift;
static int mbpp;
static int mword;
static int mmask;
static int mcut;


static int * idata;
static int * mdata;


static os_error * gifscaninit(imagestr * image,imagestr * mimage)
{
 os_error * err;

 bpp=image->bpp;
 mbpp=mimage?mimage->bpp:0;

 if(mbpp) err=imfind2rr(image,cury,&idata,mimage,cury,&mdata);
 else     err=imfind1r(image,cury,&idata);

 if(!err)
 {
  word=mword=0;
  shift=mshift=32;

  if(bpp==1) mask=0x1;
  else
  if(bpp==2) mask=0x3;
  else
  if(bpp==4) mask=0xF;
  else       mask=0xFF;

  if(mbpp)
  {
   if(mbpp==1) mmask=0x1;
   else
   if(mbpp==2) mmask=0x3;
   else
   if(mbpp==4) mmask=0xF;
   else        mmask=0xFF;

   mcut=(1<<mbpp)/2;
  }
 }

 return(err);
}


static int GIFNextPixel(void)
{
 os_error * err;
 int        sbyte;
 int        mbyte;


 if(curx>=Width)
 {
  curx=0;

  if(!Interlace)
  {
   cury++;
   if(cury>=Height) return(EOF);
  }
  else 
  {
   switch(Pass)
   {
     case 0:
            cury+=8;
            if(cury>=Height) 
            {
             Pass++;
             cury=4;
            }
            break;

     case 1:
            cury+=8;
            if(cury>=Height)
            {
             Pass++;
             cury=2;
            }
            break;

     case 2:
            cury+=4;
            if(cury>=Height)
            {
             Pass++;
             cury = 1;
            }
            break;

     case 3:
            cury+=2;
            if(cury>=Height) return(EOF);
            break;
   }
  }

  err=gifscaninit(gimage,gmimage);
  if(err) longjmp(xraisejmp,(int)err);
 }

 if(shift==32)
 {
  word=*idata++;
  shift=0;
 }
 sbyte=(word>>shift)&mask;
 shift+=bpp;


 if(mbpp)
 {
  if(mshift==32)
  {
   mword=*mdata++;
   mshift=0;
  }
  mbyte=(mword>>mshift)&mmask;
  mshift+=mbpp;

  if(mbyte<mcut) sbyte=transparencyindex;
 }

 curx++;

 return(sbyte);
}



/*****************************************************************
 * TAG( output )
 *
 * Output the given code.
 * Inputs:
 *      code:   A n_bits-bit integer.  If == -1, then EOF.  This assumes
 *              that n_bits =< (long)wordsize - 1.
 * Outputs:
 *      Outputs code to the file.
 * Assumptions:
 *      Chars are 8 bits long.
 * Algorithm:
 *      Maintain a BITS character long buffer (so that 8 codes will
 * fit in it exactly).  Use the VAX insv instruction to insert each
 * code in turn.  When the buffer fills up empty it and start over.
 */

static unsigned int cur_accum;
static int  cur_bits;

static
unsigned int masks[] = { 0x0000, 0x0001, 0x0003, 0x0007, 0x000F,
                                  0x001F, 0x003F, 0x007F, 0x00FF,
                                  0x01FF, 0x03FF, 0x07FF, 0x0FFF,
                                  0x1FFF, 0x3FFF, 0x7FFF, 0xFFFF };

static void output(code_int code)
{
 cur_accum&=masks[cur_bits];

 if(cur_bits>0) cur_accum|=(code<<cur_bits);
 else           cur_accum=code;

 cur_bits+=n_bits;

 while(cur_bits>=8)
 {
  char_out((unsigned int)(cur_accum & 0xff));
  cur_accum>>=8;
  cur_bits-=8;
 }

    /*
     * If the next entry is going to be too big for the code size,
     * then increase it, if possible.
     */
 if(free_ent>maxcode || clear_flg)
 {
  if(clear_flg)
  {
   maxcode=MAXCODE(n_bits=g_init_bits);
   clear_flg=0;
  }
  else
  {
   n_bits++;
   if(n_bits==maxbits) maxcode=maxmaxcode;
   else                maxcode=MAXCODE(n_bits);
  }
 }
}


static void cl_hash(count_int hsize)          /* reset code table */
{
 count_int * htab_p;
 htab_p=htab;
 while(hsize--) *htab_p++=-1;
}


/*
 * Clear out the hash table
 */

static void cl_block(void)             /* table clear for block compress */
{
 cl_hash((count_int)hsize);
 free_ent=ClearCode+2;
 clear_flg=1;

 output((code_int)ClearCode);
}



/*
 * compress stdin to stdout
 *
 * Algorithm:  use open addressing double hashing (no chaining) on the
 * prefix code / next character combination.  We do a variant of Knuth's
 * algorithm D (vol. 3, sec. 6.4) along with G. Knott's relatively-prime
 * secondary probe.  Here, the modular division first probe is gives way
 * to a faster exclusive-or manipulation.  Also do block compression with
 * an adaptive reset, whereby the code table is cleared when the compression
 * ratio decreases, but after the table fills.  The variable-length output
 * codes are re-sized at this point, and a special CLEAR code is generated
 * for the decompressor.  Late addition:  construct the table according to
 * file size for noticeable speed improvement on small files.  Please direct
 * questions about this implementation to ames!jaw.
 */




static os_error * compress(buffer * bf,imagestr * image,imagestr * mimage,
                                                        int init_bits)
{
 os_error * err;
 register int fcode;
 register code_int i = 0;
 register int c;
 register code_int ent;
 register code_int disp;
 register code_int hsize_reg;
 register int hshift;

 err=NULL;

 g_init_bits=init_bits;
 gbf=bf;
 gimage=image;
 gmimage=mimage;
 err=gifscaninit(image,mimage);
 if(err) return(err);

 cur_accum=0;
 cur_bits=0;

 clear_flg=0;
 maxcode=MAXCODE(n_bits=g_init_bits);

 ClearCode=(1<<(init_bits-1));
 EOFCode=ClearCode+1;
 free_ent=ClearCode+2;

 char_init();

 ent=GIFNextPixel();

 hshift = 0;
 for(fcode=hsize;fcode<65536;fcode*=2) hshift++;
 hshift=8-hshift;                /* set hash code range bound */

 hsize_reg=hsize;
 cl_hash((count_int)hsize_reg);            /* clear hash table */

 output((code_int)ClearCode);

 while((c=GIFNextPixel())!=EOF)
 {
  fcode=((c<<maxbits)+ent);
  i=(((code_int)c<<hshift)^ent);    /* xor hashing */

  if(HashTabOf(i)==fcode)
  {
   ent=CodeTabOf(i);
   continue;
  }
  else 
  if(HashTabOf(i)<0) goto nomatch;      /* empty slot */
  disp=hsize_reg-i;                     /* secondary hash (after G. Knott) */
  if(i==0) disp=1;

probe:
  if((i-=disp)<0) i+=hsize_reg;

  if(HashTabOf(i)==fcode)
  {
   ent=CodeTabOf(i);
   continue;
  }

  if((long)HashTabOf(i)>0) goto probe;
nomatch:
 output((code_int)ent);
  ent=c;

  if(free_ent<maxmaxcode )
  {
   CodeTabOf(i)=(unsigned short)free_ent++; /* code -> hashtable */
   HashTabOf(i)=fcode;
  }
  else cl_block();
 }

 /*
  * Put out the final code.
  */

 output((code_int)ent);
 output((code_int)EOFCode);

 /*
  * At EOF, write the rest of the buffer.
  */

 while(cur_bits>0)
 {
  char_out((unsigned int)(cur_accum & 0xff));
  cur_accum>>=8;
  cur_bits-=8;
 }
 flush_char();

 return(err);
}




static os_error * mkgif2(imagestr * image,imagestr * mimage,buffer * bf,
                                                            int interlace)
{
 os_error * err;
 int        B;
 int        RWidth;
 int        RHeight;
 int        LeftOfs;
 int        TopOfs;
 int        Resolution;
 int        ColorMapSize;
 int        InitCodeSize;
 int        i;
 int        BitsPerPixel;
 int        Background;
 int        ncol;
 char       tcols[256];


 err=NULL;


 if(mimage)
 {
  maskcolour(image,mimage,&ncol,tcols);
  if(ncol) transparencyindex=tcols[0];
  else     mimage=NULL;
 }


 Interlace=interlace;
 Background=0;

 BitsPerPixel=image->bpp;
 RWidth=Width=image->xpix;
 RHeight=Height=image->ypix;
 LeftOfs=TopOfs=0;

 if(Height<=4) Interlace=0;


 ColorMapSize=1<<BitsPerPixel;
 Resolution=BitsPerPixel;

 /*
  * Indicate which pass we are on (if interlace)
  */

 Pass=0;

 /*
  * The initial code size
  */

 if(BitsPerPixel<=1) InitCodeSize=2;
 else                InitCodeSize=BitsPerPixel;

 /*
  * Set up the current x and y position
  */

 curx=cury=0;

 /*
  * Write the Magic header
  */

 err=bf_write(bf,mimage?"GIF87a":"GIF89a",6);
 if(err) return(err);

 /*
  * Write out the screen width and height
  */

 err=bf_puts(bf,RWidth);
 if(err) return(err);
 err=bf_puts(bf,RHeight);
 if(err) return(err);

 /*
  * Indicate that there is a global colour map
  */
 
 B=0x80;       /* Yes, there is a color map */

 /*
  * OR in the resolution
  */

 B|=(Resolution-1)<<5;

  /*
   * OR in the Bits per Pixel
   */
 
 B|=(BitsPerPixel-1);

  /*
   * Write it out
   */
 
 err=bf_putc(bf,B);
 if(err) return(err);

  /*
   * Write out the Background colour
   */

 err=bf_putc(bf,Background);
 if(err) return(err);

  /*
   * Byte of 0's (future expansion)
   */
 
 err=bf_putc(bf,0);
 if(err) return(err);

  /*
   * Write out the Global Colour Map
   */

 for(i=0;i<ColorMapSize;i++)
 {
  err=bf_putc(bf,image->ipal.word[i]>>8);
  if(err) break;
  err=bf_putc(bf,image->ipal.word[i]>>16);
  if(err) break;
  err=bf_putc(bf,image->ipal.word[i]>>24);
  if(err) break;
 }


 if(mimage)
 {
  err=bf_putc(bf,EXTENSION);
  err=bf_putc(bf,GRAPHICSEXTENSION);

  bf_putc(bf,4);
  bf_putc(bf,TRANSPARENCYMASK);
  bf_putc(bf,0);
  bf_putc(bf,0);
  bf_putc(bf,transparencyindex);
 
  bf_putc(bf,0);
 }


  /*
   * Write an Image separator
   */


 err=bf_putc(bf,',');
 if(err) return(err);

  /*
   * Write the Image header
   */

 err=bf_puts(bf,LeftOfs);
 if(err) return(err);
 err=bf_puts(bf,TopOfs);
 if(err) return(err);
 err=bf_puts(bf,Width);
 if(err) return(err);
 err=bf_puts(bf,Height);
 if(err) return(err);

  /*
   * Write out whether or not the image is interlaced
   */
 if(Interlace) err=bf_putc(bf,0x40);
 else          err=bf_putc(bf,0x00);
 if(err) return(err);




  /*
   * Write out the initial code size
   */
 err=bf_putc(bf,InitCodeSize);
 if(err) return(err);


  /*
   * Go and actually compress the data
   */

 if((err=(os_error *)setjmp(xraisejmp))==NULL)
 {
  err=compress(bf,image,mimage,InitCodeSize+1);

  /*
   * Write out a Zero-length packet (to end the series)
   */
 
  err=bf_putc(bf,0);
  if(err) return(err);

   /*
    * Write the GIF file terminator
    */

  err=bf_putc(bf,';');
 }

 return(err);
}




os_error * mkgif(imagestr * image,imagestr * mimage,buffer * bf,int interlace)
{
 os_error * err;

 err=flex_alloc((flex_ptr)&htab,sizeof(count_int)*HSIZE);
 if(!err)
 {
  err=flex_alloc((flex_ptr)&codetab,sizeof(unsigned short)*HSIZE);
  if(!err)
  {
   err=mkgif2(image,mimage,bf,interlace);
   flex_free((flex_ptr)&codetab);
  }
  flex_free((flex_ptr)&htab);
 }
 return(err);
}


