/*->c.gif */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <setjmp.h>


#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"
#include "deb.h"

#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"


#include "constants.h"
#include "str.h"

#include "reslink.h"
#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "long.h"
#include "units.h"
#include "cms.h"


#include "gifmk.h"
#include "gif.h"


extern ftypestr ftype;
extern dboxstr  configbox;

static jmp_buf xraisejmp;


#define IMAGESEP           0x2c
#define EXTENSION          0x21
#define TRAILER            0x3b

#define APPEXTENSION       0xFF
#define COMMENTEXTENSION   0xFE
#define GRAPHICSEXTENSION  0xF9
#define TEXTEXTENSION      0x1


#define INTERLACEMASK      0x40
#define COLORMAPMASK       0x80
#define TRANSPARENCYMASK   0x1


static imagestr * loadimage;
static imagestr * mimage;


typedef struct gifstr
{
 int leftoffset;
 int topoffset; 
 int width;
 int height;
 int bits;
 int colormapsize;
 int pal[256];
 int transparency;
 int transparencyindex;

} gifstr;

static gifstr gif;

static int gifxres=90;
static int gifyres=45;



static int xc;         /* Output X and Y coords of current pixel */
static int yc; 
static int pass;       /* Used by output routine if interlaced pic */
static int yline;


static int codesize;   /* Code size, read from GIF LZW header */
static int readmask;

static int interlace;
static int mkinterlace;

    /* The hash table used by the decompressor */

static int * prefix;
static int * suffix;

    /* An output array used by the decompressor */
static int outcode[4097 /* 1025 */];

    /* The color map, read from the GIF header */

static int pal[256];
static int colormapsize;

static int    version;


static char * id[2]={
                     "GIF87a",
                     "GIF89a"
                    };


static int count;


static buffer * gbf;
static char     nbuff[256];
static char   * nbp;




static os_error * getinfo(framestr * frame)
{
 char   string[256];
 char * p;

 p=string;

 p+=sprintf(p,"GIF file\n");
 p+=sprintf(p,"%d x %d pixels, %d bpp\n",frame->fxpix,
                                         frame->fypix,frame->fbpp);
 p+=sprintf(p,"Palette entries %d\n",gif.colormapsize);
 p+=sprintf(p,"Interlace %s\n",interlace?"Yes":"No");
 p+=sprintf(p,"Transparency %s (%d)",gif.transparency?"Yes":"No",
                                     gif.transparencyindex);

 return(infowrite(string,frame));
}





static os_error * skipdata(buffer * bf)
{
 os_error * err=NULL;
 int        len;

 while(1)
 {
  err=bf_getc(bf,&len);
  if(err) break;
  if(!len) break;
  err=bf_seekrel(bf,len);
  if(err) break;
 }
 return(err);
}


static os_error * skipframe(buffer * bf)
{
 os_error * err;
 int        bits;

          err=bf_getc(bf,&bits);
 if(!err) err=skipdata(bf);

 return(err);
}




static int nbfill(void)
{
 os_error * err;

 err=bf_getc(gbf,&count);
 if(err) 
 {
  longjmp(xraisejmp,(int)err);
 }

 if(count<0)
 {
  longjmp(xraisejmp,(int)geterror(ECR));
 }

 err=bf_read(gbf,nbuff,count);
 if(err)
 {
  longjmp(xraisejmp,(int)err);
 }

 nbp=nbuff;

 count--;
 return(*nbp++);
}


#define nextbyteblocked (count--?(*nbp++):nbfill())



static int  shift;
static int  byte;

static int readcode(void)
{
 register int diff;
 register int code;

 code=byte>>shift;

 diff=shift+codesize;
 if(diff>=8)
 {
  byte=nextbyteblocked;
  diff-=8;
  code|=byte<<(8-shift);
  if(diff>=8)
  {
   byte=nextbyteblocked;
   diff-=8;
   code|=byte<<(16-shift);
  }
 }

 shift=diff;

 return(code & readmask);
}


static int * idata;
static int * mdata;
static int   iword;
static int   mword;
static int   ishift;
static int   mshift;
static int   ibpp;
static int   mbpp;


static void addpixel(int index)
{
 os_error * err;

 /* write pixel at xc,yc */

 iword|=(index<<ishift);
 ishift+=ibpp;
 if(ishift==32)
 {
  *idata++=iword;
  iword=ishift=0;
 }


 if(mbpp)
 {
  mword|=(index!=gif.transparencyindex)<<mshift;
  mshift+=mbpp;
  if(mshift==32)
  {
   *mdata++=mword;
   mword=mshift=0;
  }
 }


 /* Update the X-coordinate, and if it overflows, update the Y-coordinate */

 if(++xc>=gif.width)
 {
  if(ishift)
  {
   *idata++=iword;
   iword=ishift=0;
  }

  if(mbpp)
  {
   *mdata++=mword;
   mword=mshift=0;
  }

 /* If a non-interlaced picture, just increment YC to the next scan line.
  * If it's interlaced, deal with the interlace as described in the GIF
  * spec.  Put the decoded scan line out to the screen if we haven't gone
  * past the bottom of it
  */
   xc=0;

   if(!interlace) yc++;
   else
   {
    switch(pass)
    {
     case 0:
            yc+=8;
            if(yc>=gif.height)
            {
             pass++;
             yc=4;
            }
            break;

     case 1:
            yc+=8;
            if(yc>=gif.height)
            {
             pass++;
             yc=2;
            }
            break;

     case 2:
            yc+=4;
            if(yc>=gif.height)
            {
             pass++;
             yc=1;
            }
            break;

     case 3:
            yc+=2;
            break;
          
    default:
            break;
   }
  }


  if(yc>=gif.height) longjmp(xraisejmp,1);

  if(mbpp) err=imfind2ww(loadimage,yc,&idata,mimage,yc,&mdata);
  else     err=imfind1w(loadimage,yc,&idata);    /* nb do this elsewhere */

  if(err) longjmp(xraisejmp,(int)err);

  longproctick2(yline++,gif.height);
 }
}



static os_error * loadframe2(buffer * bf)
{
 os_error * err;
 int        initcodesize;
 int        code;
 int        oldcode;
 int        curcode;
 int        clearcode;
 int        eofcode;
 int        maxcode;
 int        firstfree;
 int        freecode;
 int        finchar;
 int        outcount;
 int        incode;
 int        i;
 int        bitmask;


 interlace=gif.bits & INTERLACEMASK;

 err=bf_getc(bf,&codesize);
 if(!err)
 {
//    bitmask=gif.colormapsize-1;
				bitmask=(1<<codesize)-1;
    clearcode=(1<<codesize);
    eofcode=clearcode+1;
    freecode=firstfree=clearcode+2;
    outcount=0;

    xc=yc=yline=0;
    shift=8;
    pass=0;
    count=0;
    byte=0;

  /* The GIF spec has it that the code size is the code size used to
   * compute the above values is the code size given in the file, but the
   * code size used in compression/decompression is the code size given in
   * the file plus one. (thus the ++).
   */

    codesize++;
    initcodesize=codesize;
    maxcode=(1<<codesize);
    readmask=maxcode-1;

 /* Decompress the file, continuing until you see the GIF EOF code.
  * One obvious enhancement is to add checking for corrupt files here.
  */

    code=readcode();
    finchar=oldcode=code; /* compiler */

    while(code!=eofcode)
    {

    /* Clear code sets everything back to its initial value, then reads the
     * immediately subsequent code as uncompressed data.
     */

     if(code==clearcode)
     {

      codesize=initcodesize;
      maxcode=(1<<codesize);
      readmask=maxcode-1;
      freecode=firstfree;
      code=readcode();
      curcode=oldcode=code;
      finchar=curcode & bitmask;
      addpixel(finchar);
     }
     else
     {
     /* If not a clear code, then must be data: 
        save same as CurCode and InCode */

      curcode=incode=code;

     /* If greater or equal to FreeCode, not in the hash table yet;
      * repeat the last character decoded
      */

      if(curcode>=freecode)
      {
       curcode=oldcode;
       outcode[outcount++]=finchar;
      }

     /* Unless this code is raw data, pursue the chain pointed to by CurCode
      * through the hash table to its end; each code in the chain puts its
      * associated output code on the output queue.
      */

      while(curcode>bitmask)
      {
       outcode[outcount++]=suffix[curcode];
       curcode=prefix[curcode];
      }


     /* The last code in the chain is treated as raw data. */

      finchar=curcode & bitmask;
      outcode[outcount++]=finchar;

     /* Now we put the data out to the Output routine.
      * It's been stacked LIFO, so deal with it that way...
      */

      for(i=outcount-1;i>=0;i--) addpixel(outcode[i]);
      outcount=0;

     /* Build the hash table on-the-fly. No table is stored in the file. */


      prefix[freecode]=oldcode;
      suffix[freecode]=finchar;
      oldcode=incode;

     /* Point to the next slot in the table.  If we exceed the current
      * MaxCode value, increment the code size unless it's already 12.  If it
      * is, do nothing: the next code decompressed better be CLEAR
      */

      freecode++;
      if(freecode>=maxcode)
      {
       if(codesize<12)
       {
        codesize++;
        maxcode*=2;
        readmask=(1<<codesize)-1;
       }
      }
     }

     code=readcode();
    }


  /*  if(!err) bf_seekrel(bf,count); */
      if(!err) skipdata(bf);  /* clean up */

 }
 return(err);
}




static os_error * gifloadframe(filestr * file,buffer * bf,int fn)
{
 os_error * err;

 gbf=bf;

 err=flex_alloc((flex_ptr)&suffix,sizeof(int)*(4096));
 if(!err)
 {
  err=flex_alloc((flex_ptr)&prefix,sizeof(int)*(4096));
  if(!err)
  {
   if((err=(os_error *)setjmp(xraisejmp))==NULL)
   {
    err=loadframe2(bf);
   }
   if(err==((os_error *)1))
   {
    skipdata(bf); /* clean up */
    err=NULL;
   }

   flex_free((flex_ptr)&prefix);
  }
  flex_free((flex_ptr)&suffix);
 }

 if(!err) err=getinfo(&file->frames[fn]);

 return(err);
}



static os_error * setupload(filestr * file,int fn)
{
 os_error * err;
 int        i;

 gif=(((gifstr*)file->data)[fn]);
 mbpp=gif.transparency?1:0;

 err=ximnew2(file->frames[fn].fxpix,file->frames[fn].fypix,
             file->frames[fn].fbpp,mbpp,&file->frames[fn].xim);

 if(!err)
 {
  loadimage=((file->frames[fn].xim)->sim[IM]);
  mimage=((file->frames[fn].xim)->sim[AL]);
  ibpp=file->frames[fn].fbpp;

  cmsrgbprofile(&loadimage->profile);

  if(mbpp) err=imfind2ww(loadimage,0,&idata,mimage,0,&mdata);
  else     err=imfind1w(loadimage,0,&idata);    /* nb do this elsewhere */
  if(!err)
  {
   ishift=0;
   iword=0;
   loadimage->xdpi=file->frames[fn].fxdpi;
   loadimage->ydpi=file->frames[fn].fydpi;
   loadimage->ipal.ncolours=gif.colormapsize;
   for(i=0;i<gif.colormapsize;i++)
   {
    loadimage->ipal.word[i]=gif.pal[i];
   }
  }
 }
 return(err);
}





static os_error * readframeheader(buffer * bf,int * eof,int sync)
{
 os_error * err=NULL;
 int        byte=0;
 int        extension;
 int        len;
 int        fn;
 int        i;
 int        lbpp;
 int        ch;
 int        c;
 char       data[8];

 *eof=0;
 extension=0;

 memset(&gif,0,sizeof(gifstr));

 while(1)
 {
  bf_tell(bf,&i);

		if(sync)
		{
			while(1)
			{
    err=bf_getc(bf,&byte);
				if(err) break;
				if(byte==-1) break;
				if(byte==IMAGESEP)
    {
					bf_tell(bf,&i);
					i--;
     break;
				}
			}
		}
		else
		{
   err=bf_getc(bf,&byte);
		}

  if(err) break;
  else
  if(byte==TRAILER || byte==-1)
  {
   *eof=1;
   break;
  }
  else
  if(byte==IMAGESEP)
  {
   /* Now read in values from the image descriptor */

   bf_gets(bf,&gif.leftoffset);
   bf_gets(bf,&gif.topoffset); 
   bf_gets(bf,&gif.width);
   bf_gets(bf,&gif.height);
   bf_getc(bf,&gif.bits);


   /*
     <Packed Fields>  =      Local Color Table Flag        1 Bit
                             Interlace Flag                1 Bit
                             Sort Flag                     1 Bit
                              Reserved                     2 Bits
                            Size of Local Color Table      3 Bits
    */


   if(gif.bits & COLORMAPMASK)
   {
    lbpp=(gif.bits & 7)+1;
    gif.colormapsize=1<<lbpp;

    for(i=0;i<gif.colormapsize;i++)
    {
     err=bf_getc(bf,&ch);
     c =(ch)<<8; /* Red */
     err=bf_getc(bf,&ch);
     c|=(ch)<<16;
     err=bf_getc(bf,&ch);
     c|=(ch)<<24;
     gif.pal[i]=c;
    }
   }
   else
   {
    gif.colormapsize=colormapsize;
    for(i=0;i<colormapsize;i++) gif.pal[i]=pal[i];
   }

   break;
  }
  else
  if(byte==EXTENSION)
  {
   extension=1;
  }
  else
  if(byte==APPEXTENSION && extension)
  {               
   bf_getc(bf,&len);   /* should be 11 bytes */
   bf_seekrel(bf,len); /* skip               */
   skipdata(bf);       /* skip through data stream */
   extension=0;
  }
  else
  if(byte==COMMENTEXTENSION && extension)
  {
   skipdata(bf);      /* skip through data stream */
   extension=0;
  }
  else
  if(byte==GRAPHICSEXTENSION && extension)
  {
   bf_getc(bf,&len);       /* should be 4 bytes */
 //  bf_seekrel(bf,len); /* skip               */
   bf_read(bf,data,len);

   gif.transparency=((data[0] & TRANSPARENCYMASK)!=0);
   gif.transparencyindex=data[3];

   skipdata(bf); /* skip through data stream, should start with a single zero*/
   extension=0;
  }
  else
  if(byte==TEXTEXTENSION && extension)
  {
   bf_getc(bf,&len); /* should be 12 bytes */
   bf_seekrel(bf,len); /* skip               */
   skipdata(bf); /* skip through data stream */
   extension=0;
  }
 }


 if(!err && !(*eof))
 {
  err=addframe(loadfile,&fn,sizeof(gifstr));
  if(!err)
  {
   ((gifstr*)loadfile->data)[fn]=gif;

   loadfile->frames[fn].fxpix=gif.width;
   loadfile->frames[fn].fypix=gif.height;
   sprintf(loadfile->frames[fn].name,"GIF%d",fn);
   bf_tell(bf,&loadfile->frames[fn].offset);
   loadfile->frames[fn].fbpp=imbpp(gif.colormapsize);

   loadfile->frames[fn].fxdpi=gifxres;
   loadfile->frames[fn].fydpi=gifyres;
   loadfile->frames[fn].xim=NULL;
  }
 }
 return(err);
}



static os_error * readfileheader(buffer * bf)
{
 os_error * err;
 char       temp[8];
 int        bits;
 int        rwidth;
 int        rheight;
 int        bpp;
 int        ch;
 int        c;
 int        i;

 err=bf_read(bf,temp,6);

 for(version=0;version<2;version++)
  if(!memcmp(temp,id[version],6)) break;

 if(version>=2) err=geterror(ENOTTYPE);
 else
 {
  err=bf_gets(bf,&rwidth);
  err=bf_gets(bf,&rheight);

  /*
    Global Color Table Flag       1 Bit
    Color Resolution              3 Bits
    Sort Flag                     1 Bit
    (1 -   Ordered by decreasing importance, most important color first.)

    Size of Global Color Table    3 Bits     <= lo bits 
   */
                       
  err=bf_getc(bf,&bits);

  bpp=(bits & 7)+1;
  colormapsize=1<<bpp;

  cprintf("global %x",bits);

  err=bf_getc(bf,&ch);                     /* background color... */


  err=bf_getc(bf,&ch);                     /* aspect ratio        */

  /*
    Aspect Ratio = (Pixel Aspect Ratio + 15) / 64

    The Pixel Aspect Ratio is defined to be the quotient of the pixel's
    width over its height.  The value range in this field allows
    specification of the widest pixel of 4:1 to the tallest pixel of
    1:4 in increments of 1/64th.

    Values :        0 -   No aspect ratio information is given.
               1..255 -   Value used in the computation.
   */

  /* Read in global colormap. */

  cprintf("colourmapsize %d",colormapsize);

  if(bits & COLORMAPMASK)
  {
   for(i=0;i<colormapsize;i++)
   {
    err=bf_getc(bf,&ch);
    c =(ch)<<8; /* Red */
    err=bf_getc(bf,&ch);
    c|=(ch)<<16;
    err=bf_getc(bf,&ch);
    c|=(ch)<<24;
    pal[i]=c;
   }
  }
  else
  {
   /* no colourmap */
   /* arggh!       */

   cprintf("no colourmap");
  }
 }
 return(err);
}





static os_error * loadgif(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;
 buffer      bf;
 int         eof;

 err=bf_open(name,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  err=readfileheader(&bf);
  if(!err) err=readframeheader(&bf,&eof,0);
  if(!err) err=setupload(loadfile,0);
  if(!err) err=gifloadframe(loadfile,&bf,0);

  while(!err)
  {
   err=readframeheader(&bf,&eof,0);
   if(eof || err) break;
   err=skipframe(&bf);
   if(err) break;
  }
                                                                            
  err=bf_close(&bf,err);
 }

 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}


static os_error * getframe(filestr * file,int fn)
{
 os_error  * err;
 buffer      bf;

 /*dprintf(0,"get frame"); */

 err=bf_open(file->oname,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  gif=((gifstr*)file->data)[fn];

           err=bf_seek(&bf,file->frames[fn].offset);
  if(!err) err=setupload(file,fn);
  if(!err) err=gifloadframe(file,&bf,fn);

 /* dprintf(0,"get frame 2");*/
  err=bf_close(&bf,err);
 }
 return(err);
}


static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;

 err=NULL;

 return(err);
 USE(userhandle);
}


static os_error * savegif(char * name,int type)
{
 os_error * err;
 int        fn;
 imagestr * saveimage;
 imagestr * mimage;
 buffer     bf;

 fn=menuview->frame;
 saveimage=((menufile->frames[fn].xim)->sim[IM]);
 mimage=((menufile->frames[fn].xim)->sim[AL]);

 if(saveimage->bpp>8) err=geterror(EBADBITS);
 else
 {
  err=bf_open(name,'w',DEFBUFFSIZE,&bf);
  if(!err)
  {
   err=mkgif(saveimage,mimage,&bf,mkinterlace);
   err=bf_closec(&bf,err,name,type);
  }
 }
 return(err);
}


/*****************************************************************************/


static int tdbl;
static int tinterlace;
static int dbl;
static int txres;
static int tyres;


static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}



static os_error * configloaded(int eventn,uservalue userhandle,
                                                        void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {

  dbl=ftypegetrun(&ftype);

//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
  dbl=tdbl;
  mkinterlace=tinterlace;
  gifxres=txres;
  gifyres=tyres;
 }

 return(err);
}



static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}






static os_error * wrpc(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdpc(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}


static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,
    0, &tinterlace,  DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
    5, &txres,       DBWRITE,  0,   0,      7, -1,  7,-1, rdpc, wrpc,
    7, &tyres,       DBWRITE,  0,   0,     -1,  5, -1, 5, rdpc, wrpc,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TGIF,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);

 tdbl=dbl;
 tinterlace=mkinterlace;
 txres=gifxres;
 tyres=gifyres;
 err=dodboxparent(&configbox,1,parent);


 return(err);
}



/****************************************************************************/


static ftypestr ftype=
{
 GIF,             /* file type */
 0,               /* flags     */
 loadgif,         /* load      */
 loadfilepost,    /* loadpost  */
 "{GIF}",         /* name      */
 "{GIF}",         /* type name */
 savegif,         /* save      */
 config,          /* configure */
 0,               /* icon      */
 bits,            /* bit flags */
 getframe,        /* get one frame */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,


 NULL,            /* saveim */
 "gif\0""695\0",  /* extension */

 "CompuServe GIF (*.gif)",/* description */
};



static contag contable[5]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "Interlace",CONINT,&mkinterlace,NULL,NULL,
 "DefaultXRes",CONINT,&gifxres,NULL,NULL,
 "DefaultYRes",CONINT,&gifyres,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "GIF",
 NULL,
 NULL
};



os_error * gifinit(void)
{
 os_error * err;

 err=registerfiletype(&ftype);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);
 }

 return(err);
}


