/*->c.fxr */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "config.h"
#include "dbhi.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"

#include "file.h"
#include "view.h"

#include "im.h"
#include "cmap.h"
#include "col.h"
#include "long.h"
#include "format.h"
#include "getmatch.h"

#include "fxr.h"






/*****************************************************************************/
/* used to dither whole images from one format to another */


os_error * fxrfsi(formatstr * fsp,imagestr * sim,imagestr * dim)
{
 os_error * err;
 int        x;
 int        y;
 int        xpix;
 int        ypix;
 int        dbpp;
 int        sbpp;
 int        r;
 int        g;
 int        b;
 char       rtab[256];
 char       gtab[256];
 char       btab[256];


 int      * paltab;
 int        grey;

 int        smask;
 int        sshift;
 int        dshift;

 int        s;
 int        d;
 int      * sdata;
 int      * ddata;
 char     * sp;
 char     * dp;
 int        sbyte;

 int      * errline;
 int        rv;
 int        gv;
 int        bv;
 int        index;
 int      * e;
 int        pword;
 int        re;
 int        ge;
 int        be;
 int        size;

 int      * pstart=NULL;
 int      * pend=NULL;


 err=NULL;

 xpix=sim->xpix;
 ypix=sim->ypix;
 dbpp=dim->bpp;
 sbpp=sim->bpp;

 if(dbpp>16) return(fxrthreshold(sim,dim));

 if(dbpp>8) grey=0;
 else       grey=imgrey(sim);


 if(sbpp<=8)
 {
  imsplitpalette(rtab,gtab,btab,sim);
 }

 paltab=dim->ipal.word;


 if(dbpp<=8) 
 {
  pstart=dim->ipal.word;
  pend=pstart+dim->ipal.ncolours-1;

  if(grey)
  {
   err=makegmap(dim->ipal.ncolours,dim->ipal.word,gtab,&size);
   if(size<2) grey=0;
  }
  if(!grey) err=makecmap(dim->ipal.ncolours,dim->ipal.word,4,rgbmap);
 }
 if(err) return(err);

 if(sbpp==1)  {smask=0x1;}
 else
 if(sbpp==2)  {smask=0x3;}
 else
 if(sbpp==4)  {smask=0xF;}
 else
 if(sbpp==8)  {smask=0xFF;}
 else         {smask=0x7FFF;}


 r=g=b=0; /* compiler */

 err=flex_alloc((flex_ptr)&errline,(xpix+2)*3*sizeof(int));
 if(err) return(err);
 memset(errline,0,(xpix+2)*3*sizeof(int));


 for(y=0;y<ypix;y++)
 {
  err=longproctick2(y,ypix);
  if(err) break;


  err=imfind2rw(sim,y,&sdata,dim,y,&ddata);
  if(err) break;
  sp=(char*)sdata;
  dp=(char*)ddata;


  if((y & 0x1)||(!fsp->fszigzag))
  {
   sshift=dshift=0;

   s=*sdata++;
   d=0;

   rv=gv=bv=0;
   e=errline+3;

   for(x=0;x<xpix;x++)
   {
    switch(sbpp)
    {
     case 1:
     case 2:
     case 4:
     case 8:
            sbyte=(s>>sshift)&smask;
            sshift+=sbpp;
            if(sshift>=32)
            {
             s=*sdata++;
             sshift=0;
            }
            r=rtab[sbyte];
            g=gtab[sbyte];
            b=btab[sbyte];
            break;

     case 16:
             sbyte=(s>>sshift)&smask;
             sshift+=sbpp;
             if(sshift>=32)
             {
              s=*sdata++;
              sshift=0;
             }
             r=(sbyte&0x1F)<<3;
             g=(sbyte&0x3E0)>>2;
             b=(sbyte&0x7C00)>>7;
             break;

     case 24:
             r=*sp++;
             g=*sp++;
             b=*sp++;
             break;

     case 32:
             r=s&0xFF;
             g=(s>>8)&0xFF;
             b=(s>>16)&0xFF;
             s=*sdata++;       /* should be here */
             break;
    }

    rv+=r*16;
    gv+=g*16;
    bv+=b*16;

    if(rv>0xFFF) rv=0xFFF;
    if(gv>0xFFF) gv=0xFFF;
    if(bv>0xFFF) bv=0xFFF;
    if(rv<0)     rv=0;
    if(gv<0)     gv=0;
    if(bv<0)     bv=0;


                      /* get errors in rv,gv,bv */

    if(dbpp<=8)
    {
     if(grey) 
     {
      index=gtab[rv>>4];
     }
     else
     {
      if(fsp->fsexact)
      {
       index=getmatch(pstart,pend,((rv & 0xFF0)<< 4)|
                                  ((gv & 0xFF0)<<12)|
                                  ((bv & 0xFF0)<<20));
      }
      else
      {
       index=(((rv) & 0xF00))+(((gv>>4) & 0xF0))+(((bv>>8) & 0xF)); 
       index=rgbmap[index];
      }
     }

     d|=(index<<dshift);
     dshift+=dbpp;
     if(dshift>=32)
     {
      *ddata++=d;
      dshift=0;
      d=0;
     }

     pword=paltab[index];

     rv-=((pword>> 4) & 0xFF0) | ((pword>>12) & 0xF);
     gv-=((pword>>12) & 0xFF0) | ((pword>>20) & 0xF);
     bv-=((pword>>20) & 0xFF0) | ((pword>>28) & 0xF);
    }
    else   /* support the x->16 bit case */
           /* !!!! there is another copy of this lot below */
    {
     index=(((rv>>(3+4)) & 0x1F))|
           (((gv>>(4-2)) & 0x3E0))|
           (((bv<<(7-4)) & 0x7C00));

     d|=(index<<dshift);
     dshift+=dbpp;
     if(dshift>=32)
     {
      *ddata++=d;
      dshift=0;
      d=0;
     }

     rv=(rv&0x7F);
     gv=(gv&0x7F);
     bv=(bv&0x7F);
    }

    if(!fsp->fssimple)
    {
     rv/=16;
     gv/=16;
     bv/=16;
     *(e-3)+=(3*rv);
     *(e-2)+=(3*gv);
     *(e-1)+=(3*bv);

     (*e++)+=(5*rv);
     (*e++)+=(5*gv);
     (*e++)+=(5*bv);

     re=*(e+0);
     ge=*(e+1);
     be=*(e+2);

     *(e+0)=rv;
     *(e+1)=gv;
     *(e+2)=bv;

     rv=re+(rv*7);
     gv=ge+(gv*7);
     bv=be+(bv*7);
    }
   }
   if(dshift) *ddata=d;
  }                      /* end of odd line stuff */
  else
  {
   rv=gv=bv=0;
   e=errline+3*(xpix);

   sp=((char*)sdata)+((xpix*sbpp)/8);
   sdata=sdata+((xpix*sbpp)/32);
   sshift=(xpix*sbpp)&0x1F;
   ddata=ddata+((xpix*dbpp)/32);
   dshift=(xpix*dbpp)&0x1F;

   if(dshift==0) {ddata--;dshift=32;}

   s=*sdata;
   d=0;

   for(x=xpix-1;x>=0;x--)
   {
    switch(sbpp)
    {
     case 1:
     case 2:
     case 4:
     case 8:
            sshift-=sbpp;
            if(sshift<0)
            {
             sshift=32-sbpp;
             s=*(--sdata);
            }
            sbyte=(s>>sshift)&smask;

            r=rtab[sbyte];
            g=gtab[sbyte];
            b=btab[sbyte];
            break;

    case 16:
            sshift-=sbpp;
            if(sshift<0)
            {
             sshift=32-sbpp;
             s=*(--sdata);
            }
            sbyte=(s>>sshift)&smask;

            r=(sbyte&0x1F)<<3;
            g=(sbyte&0x3E0)>>2;
            b=(sbyte&0x7C00)>>7;
            break;

    case 24:
            b=*--sp;
            g=*--sp;
            r=*--sp;
            break;

    case 32:
            s=*(--sdata);
            r=s&0xFF;
            g=(s>>8)&0xFF;
            b=(s>>16)&0xFF;
            break;
    }

    rv+=r*16;
    gv+=g*16;
    bv+=b*16;


    if(rv>0xFFF) rv=0xFFF;
    if(gv>0xFFF) gv=0xFFF;
    if(bv>0xFFF) bv=0xFFF;
    if(rv<0)     rv=0;
    if(gv<0)     gv=0;
    if(bv<0)     bv=0;

                      /* get errors in rv,gv,bv */

    if(dbpp<=8)
    {
     if(grey) 
     {
      index=gtab[rv>>4];
     }
     else
     {
      if(fsp->fsexact)
      {
       index=getmatch(pstart,pend,((rv & 0xFF0)<< 4)|
                                  ((gv & 0xFF0)<<12)|
                                  ((bv & 0xFF0)<<20));
      }
      else
      {
       index=(((rv) & 0xF00))+(((gv>>4) & 0xF0))+(((bv>>8) & 0xF)); 
       index=rgbmap[index];
      }
     }

     dshift-=dbpp;
     if(dshift<0)
     {
      *ddata--=d;
      dshift=32-dbpp;
      d=0;
     }
     d|=(index<<dshift);

     pword=paltab[index];

     rv-=((pword>> 4) & 0xFF0) | ((pword>>12) & 0xF);

     gv-=((pword>>12) & 0xFF0) | ((pword>>20) & 0xF);

     bv-=((pword>>20) & 0xFF0) | ((pword>>28) & 0xF);
    }
    else   /* support the x->16 bit case */
    {
     index=(((rv>>(3+4)) & 0x1F))|
           (((gv>>(4-2)) & 0x3E0))|
           (((bv<<(7-4)) & 0x7C00));

     dshift-=dbpp;
     if(dshift<0)
     {
      *ddata--=d;
      dshift=32-dbpp;
      d=0;
     }
     d|=(index<<dshift);

     rv=(rv&0x7F);
     gv=(gv&0x7F);
     bv=(bv&0x7F);
    }

    if(!fsp->fssimple)
    {
     rv/=16;
     gv/=16;
     bv/=16;
     *(e+3)+=(3*rv);
     *(e+4)+=(3*gv);
     *(e+5)+=(3*bv);

     *(e+0)+=(5*rv);
     *(e+1)+=(5*gv);
     *(e+2)+=(5*bv);

     e-=3;

     re=*(e+0);
     ge=*(e+1);
     be=*(e+2);

     *(e+0)=rv;
     *(e+1)=gv;
     *(e+2)=bv;

     rv=re+(rv*7);
     gv=ge+(gv*7);
     bv=be+(bv*7);
    }
   }
   *ddata=d;
  }
 }

 flex_free((flex_ptr)&errline);

 return(err);
}



os_error * fxrthreshold(imagestr * sim,imagestr * dim)
{
 os_error * err;
 int        x;
 int        y;
 int        xpix;
 int        ypix;
 int        dbpp;
 int        sbpp;
 int        r;
 int        g;
 int        b;
 char       rtab[256];
 char       gtab[256];
 char       btab[256];

 char       palmap[256];
 int        grey;

 int        smask;
 int        sshift;
 int        dshift;

 int        s;
 int        d;
 int      * sdata;
 int      * ddata;
 char     * sp;
 char     * dp;
// int        i;
 int        sbyte;
 int        size;

 err=NULL;


 xpix=sim->xpix;
 ypix=sim->ypix;
 dbpp=dim->bpp;
 sbpp=sim->bpp;

 if(dbpp>8) grey=0;
 else       grey=imgrey(sim);

 imsplitpalette(rtab,gtab,btab,sim);


 if(dbpp<=8) 
 {
  if(grey)
  {
   err=makegmap(dim->ipal.ncolours,dim->ipal.word,gtab,&size);
   if(size<2) grey=0;
  }

  if(!grey) err=makecmap(dim->ipal.ncolours,dim->ipal.word,4,rgbmap);
 }


 if(err) return(err);

 if(sbpp==1)  {smask=0x1;}
 else
 if(sbpp==2)  {smask=0x3;}
 else
 if(sbpp==4)  {smask=0xF;}
 else
 if(sbpp==8)  {smask=0xFF;}
 else         {smask=0x7FFF;}


 if(sbpp<=8 && dbpp<=8)  /* generate palette map */
 {
  palmapf(sim->ipal.ncolours,sim->ipal.word,dim->ipal.ncolours,dim->ipal.word,palmap);

#ifdef NEVER
  for(i=0;i<sim->ipal.ncolours;i++)
  {
   sbyte=sim->ipal.word[i];      /* rgb */

   if(grey) 
   {
    palmap[i]=gtab[(sbyte>>8)&0xFF];
   }
   else
   {

    sbyte=((sbyte>>4) & 0xF00)|
         ((sbyte>>16) & 0xF0)|
         ((sbyte>>28) & 0xF);

    palmap[i]=rgbmap[sbyte];
   }
  }
#endif

 }

 r=g=b=0; /* compiler */


 for(y=0;y<ypix;y++)
 {
  err=longproctick2(y,ypix);

  err=imfind2rw(sim,y,&sdata,dim,y,&ddata);
  if(err) break;
  sp=(char*)sdata;
  dp=(char*)ddata;


  if(sbpp<=8 && dbpp<=8)  /* then just a palette map */
  {
   sshift=dshift=0;

   s=*sdata++;
   d=0;

   for(x=0;x<xpix;x++)
   {
    sbyte=palmap[(s>>sshift)&smask];
    d|=(sbyte<<dshift);
    sshift+=sbpp;
    if(sshift>=32)
    {
     s=*sdata++;
     sshift=0;
    }
    dshift+=dbpp;
    if(dshift>=32)
    {
     *ddata++=d;
     dshift=0;
     d=0;
    }
   }
   if(dshift) *ddata=d;
  }
  else
  {
   sshift=dshift=0;

   s=*sdata++;
   d=0;

   for(x=0;x<xpix;x++)
   {
    switch(sbpp)
    {
     case 1:
     case 2:
     case 4:
     case 8:
            sbyte=(s>>sshift)&smask;
            sshift+=sbpp;
            if(sshift>=32)
            {
             s=*sdata++;
             sshift=0;
            }
            r=rtab[sbyte];
            g=gtab[sbyte];
            b=btab[sbyte];
            break;

    case 16:
            sbyte=(s>>sshift)&smask;
            sshift+=sbpp;
            if(sshift>=32)
            {
             s=*sdata++;
             sshift=0;
            }
            r=(sbyte<<3)&0xF8;
            g=(sbyte>>2)&0xF8;
            b=(sbyte>>7)&0xF8;
            break;

    case 24:
            r=*sp++;
            g=*sp++;
            b=*sp++;
            break;

    case 32:
            r=s&0xFF;
            g=(s>>8)&0xFF;
            b=(s>>16)&0xFF;
            s=*sdata++;        /* yes should be here */
            break;
    }


    switch(dbpp)
    {
     case 1:
     case 2:
     case 4:
     case 8:
            sbyte=((r<<4)&0xF00)|(g & 0xF0)|((b>>4)&0xF);
//          sbyte=((r<<7)&0x7C00)|((g<<2) & 0x3E0)|((b>>3)&0x1F);

            d|=(rgbmap[sbyte]<<dshift);
            dshift+=dbpp;
            if(dshift>=32)
            {
             *ddata++=d;
             dshift=0;
             d=0;
            }
            break;

    case 16:
            if(dshift)
            d|=((r&0xF8)<<(dshift-3))|
               ((g&0xF8)<<(dshift+2))|
               ((b&0xF8)<<(dshift+7));
            else
            d|=((r&0xF8)>>3)|
               ((g&0xF8)<<2)|
               ((b&0xF8)<<7);

            dshift+=dbpp;
            if(dshift>=32)
            {
             *ddata++=d;
             dshift=0;
             d=0;
            }
            break;

    case 24:
            *dp++=(char)r;
            *dp++=(char)g;
            *dp++=(char)b;
            break;

    case 32:
            *ddata++=r|(g<<8)|(b<<16);
            break;
    }
   }

   if(dshift) *ddata=d;
  }
 }

 return(err);
}

/****************************************************************************/

/*
static int magic4x4[4][4]=
{
  0, 14,  3, 13,
 11,  5,  8,  6,
 12,  2, 15,  1,
  7,  9,  4, 10
};
*/

static int dither8[16*16] = {
      1,235, 59,219, 15,231, 55,215,  2,232, 56,216, 12,228, 52,212,
    129, 65,187,123,143, 79,183,119,130, 66,184,120,140, 76,180,116,
     33,193, 17,251, 47,207, 31,247, 34,194, 18,248, 44,204, 28,244,
    161, 97,145, 81,175,111,159, 95,162, 98,146, 82,172,108,156, 92,
      9,225, 49,209,  5,239, 63,223, 10,226, 50,210,  6,236, 60,220,
    137, 73,177,113,133, 69,191,127,138, 74,178,114,134, 70,188,124,
     41,201, 25,241, 37,197, 21,255, 42,202, 26,242, 38,198, 22,252,
    169,105,153, 89,165,101,149, 85,170,106,154, 90,166,102,150, 86,
      3,233, 57,217, 13,229, 53,213,  0,234, 58,218, 14,230, 54,214,
    131, 67,185,121,141, 77,181,117,128, 64,186,122,142, 78,182,118,
     35,195, 19,249, 45,205, 29,245, 32,192, 16,250, 46,206, 30,246,
    163, 99,147, 83,173,109,157, 93,160, 96,144, 80,174,110,158, 94,
     11,227, 51,211,  7,237, 61,221,  8,224, 48,208,  4,238, 62,222,
    139, 75,179,115,135, 71,189,125,136, 72,176,112,132, 68,190,126,
     43,203, 27,243, 39,199, 23,253, 40,200, 24,240, 36,196, 20,254,
    171,107,155, 91,167,103,151, 87,168,104,152, 88,164,100,148, 84 };




/* basic dithering macro */

#define DMAP(v,x,y)     (modN[v]>magic[x+y] ? divN[v] + 1 : divN[v])

static void make_square(double N,int * divN,int * modN,
                                       int * magic,int * dither,int side)
{
 register int i, j;
 double magicfact;

 for(i=0;i<256;i++)
 {
  divN[i] = (int)(i / N);
  modN[i] = i - (int)(N * divN[i]);
 }
 modN[255]=0;              /* always */

    /*
     * Expand 4x4 dither pattern to 16x16.  4x4 leaves obvious patterning,
     * and doesn't give us full intensity range (only 17 sublevels).
     * 
     * magicfact is (N - 1)/16 so that we get numbers in the matrix from 0 to
     * N - 1: mod N gives numbers in 0 to N - 1, don't ever want all
     * pixels incremented to the next level (this is reserved for the
     * pixel value with mod N == 0 at the next level).
     */

 magicfact=(N-1)/((double)side*(double)side);

 for(i=0;i<side;i++)
 {
  for(j=0;j<side;j++)
  {
   magic[i*side+j]=(int)(0.5+dither[i*side+j]*magicfact);
  }
 }
}





static void dithermap(int levels,int * pal,int * divN,int * modN,
                                       int * magic,int * dither,int side)
{
 double N;
 register int i;
 int levelsq, levelsc;
    
 levelsq=levels*levels;    /* squared */
 levelsc=levels*levelsq;   /* and cubed */

 N=255.0/((double)(levels-1));    /* Get size of each step */

 for(i=0;i<levelsc;i++) 
 {
  pal[i]=(((int)(0.5+((double)(i%levels))*N))<<8) |
         (((int)(0.5+((double)((i/levels)%levels))*N))<<16) |
         (((int)(0.5+((double)((i/levelsq)%levels))*N))<<24);
 }

 make_square(N,divN,modN,magic,dither,side);
}


/*
 * Algorithm:
 *      Compute gamma compensation map.
 *      N = 255.0 / (levels - 1) is number of pixel values per level.
 *      Compute bwmap for levels entries.
 *      Call make_square to get divN, modN, and magic.
 * Note:
 *      Call ditherbw( x, y, val, divN, modN, magic ) to get index into 
 *      bwmap for a given color/location pair, or use
 *          row = y % 16; col = x % 16;
 *          divN[val] + (modN[val]>magic[col][row] ? 1 : 0)
 *      if you don't want function call overhead.
 *      On a 1-bit display, use
 *          divN[val] > magic[col][row] ? 1 : 0
 */


static void bwdithermap(int levels,int * pal,int * divN,int * modN,
                                   int * magic,int * dither,int side)
{
 double N;
 register int i;
 int x;
    
 N=255.0/((double)(levels-1));    /* Get size of each step */

 for(i=0;i<levels;i++)
 {
  x=(int)(0.5+i*N);
  pal[i]=(x<<8)|(x<<16)|(x<<24);
 }
 make_square(N,divN,modN,magic,dither,side);
}




os_error * fxrdither(imagestr * sim,imagestr * dim)
{
 os_error * err;
 int        x;
 int        y;
 int        xpix;
 int        ypix;
 int        dbpp;
 int        sbpp;
 int        r;
 int        g;
 int        b;
 char       rtab[256];
 char       gtab[256];
 char       btab[256];

 int        grey;

 int        smask;
 int        sshift;
 int        dshift;

 int        s;
 int        d;
 int      * sdata;
 int      * ddata;
 char     * sp;
 char     * dp;
 int        sbyte;
 int        index;

/* char       dcmap[512]; */ /* 8x8x8 index with r+g*8+b*64 */
                             /*       return colour number  */

 int        modN[256];
 int        divN[256];
 int        magic[16*16];
 int        levels;
 int        row;
 int        col;
 int        msize;
 int        mlimit;

 err=NULL;

 msize=16;
 mlimit=msize*msize;

 xpix=sim->xpix;
 ypix=sim->ypix;
 dbpp=dim->bpp;
 sbpp=sim->bpp;

 if(dbpp>8) return(fxrthreshold(sim,dim));

 grey=imgrey(sim);
 imsplitpalette(rtab,gtab,btab,sim);


 if(grey)
 {
  if(dbpp==8) levels=256;
  else
  if(dbpp==4) levels=16;
  else
  if(dbpp==2) levels=4;
  else        levels=2;

  bwdithermap(levels,dim->ipal.word,divN,modN,magic,dither8,msize);
 }
 else
 {
  if(dbpp==16) levels=32;
  else
  if(dbpp==8)  levels=5;
  else
  /* if(dbpp==4)*/ levels=2;
  dithermap(levels,dim->ipal.word,divN,modN,magic,dither8,msize);
 } 


 if(sbpp==1)  {smask=0x1;}
 else
 if(sbpp==2)  {smask=0x3;}
 else
 if(sbpp==4)  {smask=0xF;}
 else
 if(sbpp==8)  {smask=0xFF;}
 else         {smask=0x7FFF;}



 r=g=b=0; /* compiler */


 row=0;

 for(y=0;y<ypix;y++)
 {
  err=longproctick2(y,ypix);
  if(err) break;

  err=imfind2rw(sim,y,&sdata,dim,y,&ddata);
  if(err) break;
  sp=(char*)sdata;
  dp=(char*)ddata;
  col=0;

  sshift=dshift=0;

  s=*sdata++;
  d=0;

  for(x=0;x<xpix;x++)
  {
    switch(sbpp)
    {
     case 1:
     case 2:
     case 4:
     case 8:
            sbyte=(s>>sshift)&smask;
            sshift+=sbpp;
            if(sshift>=32)
            {
             s=*sdata++;
             sshift=0;
            }
            r=rtab[sbyte];
            g=gtab[sbyte];
            b=btab[sbyte];
            break;

     case 16:
             sbyte=(s>>sshift)&smask;
             sshift+=sbpp;
             if(sshift>=32)
             {
              s=*sdata++;
              sshift=0;
             }
             r=(sbyte&0x1F)<<3;
             g=(sbyte&0x3E0)>>2;
             b=(sbyte&0x7C00)>>7;
             break;

     case 24:
             r=*sp++;
             g=*sp++;
             b=*sp++;
             break;

     case 32:
             r=s&0xFF;
             g=(s>>8)&0xFF;
             b=(s>>16)&0xFF;
             s=*sdata++;       /* should be here */
             break;
    }


    if(grey) index=DMAP(r,col,row);
    else     index=(DMAP(r,col,row))+
                   (DMAP(g,col,row))*levels+
                   (DMAP(b,col,row))*levels*levels; 

    switch(dbpp)
    {
     case 1:
     case 2:
     case 4:
     case 8:
     case 16:
            d|=(index<<dshift);
            dshift+=dbpp;
            if(dshift>=32)
            {
             *ddata++=d;
             dshift=0;
             d=0;
            }
            break;


     case 24:
             break;

     case 32:
             break;
    }

   if(++col>=msize) col=0;
  }

  if(dshift) *ddata=d;

  row+=msize;
  if(row>=mlimit) row=0;
 }
 return(err);
}


