/*->c.fx */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"


#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "mlo.h"
#include "redraw.h"
#include "colour.h"
#include "units.h"
#include "config.h"
#include "deb.h"



#include "resource.h"
#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewo.h"
#include "viewr.h"
#include "select.h"

#include "im.h"
#include "bm.h"
#include "edit.h"

#include "hist.h"
#include "user.h"
#include "med.h"
#include "long.h"
#include "undo.h"


#include "fx.h"


/* filters */




os_error * setupfilterarea(viewstr * view,spanstr ** sp,int * ylop,int * yhip)
{
 os_error * err;
 boxstr     area;
 filestr  * file;
 framestr * frame;
 imagestr * im;
 int        fn;
 int        xlo;
 int        xhi;
 int        ylo;
 int        yhi;
 int        depth;
 int        i;


 err=NULL;

 file=(filestr*)view->file;

 if(file->frames && file->framen)
 {
  fn=view->frame;

  frame=&file->frames[fn];
 /* if(!frame->im) return(1); */
  im=((frame->xim)->sim[IM]);


  if(!croparea(view,&area))
  {
   ylo=area.y;
   yhi=area.y+area.h;
   xlo=area.x;
   xhi=area.x+area.w;
  }
  else
  {
   ylo=0;
   yhi=im->ypix;
   xlo=0;
   xhi=im->xpix;
  }

  *ylop=ylo;
  *yhip=yhi;

  depth=(yhi-ylo);

  err=flex_alloc((flex_ptr)sp,depth*sizeof(spanstr));
  if(!err)
  {
   for(i=0;i<depth;i++)
   {
    (*sp)[i].xlo=xlo;
    (*sp)[i].xhi=xhi;
   }
  }
 }


 return(err);
}



os_error * freefilterarea(spanstr ** sp)
{
 return(flex_free((flex_ptr)sp));
}





os_error * mapfx(viewstr * view,filestr * file,int mode)
{
 os_error  * err;
 spanstr   * sp;
 int         ylo;
 int         yhi;
 imagestr  * sim;
 imagestr  * dim;
 ximagestr * sxim;
 ximagestr * dxim;


 err=setupfilterarea(view,&sp,&ylo,&yhi);
 if(!err)
 {
  if(file->frames && file->framen)
  {
   sxim=file->frames[view->frame].xim;
   sim=(sxim->sim[IM]);

   longprocstart(NULL,0,yhi-ylo,view);

   err=viewdeleteimagefileframe(file,view->frame);
 
   undostart(sxim);

   if(undosteps) err=ximcopy(sxim,&dxim);
   else              dxim=sxim;

   dim=(dxim->sim[IM]);

   err=mapim(dim,ylo,yhi,&sp,mode);

   if(undosteps)
   {
    if(err)
    {
     ximtrash(&dxim);
    }
    else
    {
     undolink(sxim,dxim);
     file->frames[view->frame].xim=dxim;
    }
   }

   viewcreateimagefileframe(file,view->frame);
   refreshviewfileframe(file,view->frame);
   modifyview(view);

   longprocend();
  }
  freefilterarea(&sp);
 }

 return(err);
}




static os_error * medfx(viewstr * view,filestr * file,int mode)
{
 os_error  * err;
 spanstr   * sp;
 int         ylo;
 int         yhi;
 imagestr  * sim;
 imagestr  * dim;
 ximagestr * sxim;
 ximagestr * dxim;


 err=setupfilterarea(view,&sp,&ylo,&yhi);
 if(!err)
 {
  if(file->frames && file->framen)
  {
   sxim=file->frames[view->frame].xim;
   sim=(sxim->sim[IM]);

   longprocstart(NULL,0,yhi-ylo,view);

   err=viewdeleteimagefileframe(file,view->frame);

   undostart(sxim);

   if(undosteps) err=ximcopy(sxim,&dxim);
   else          dxim=sxim;

   if(!err)
   {
    dim=(dxim->sim[IM]);

    err=medim(dim,ylo,yhi,&sp,mode);

    if(undosteps)
    {
     if(err) ximtrash(&dxim);
     else
     {
      undolink(sxim,dxim);
      file->frames[view->frame].xim=dxim;
     }
    }
   }

   viewcreateimagefileframe(file,view->frame);
   refreshviewfileframe(file,view->frame);
   modifyview(view);

   longprocend();
  }
  freefilterarea(&sp);
 }

 return(err);
}


/***************************************************************************/

#define MAXNOISE 128

static int noiseamp;
static int noisemode;
static int tnoiseamp;
static int tnoisemode;


static os_error * fxaddnoise(viewstr * view,filestr * file)
{
 os_error  * err;
 spanstr   * sp;
 int         ylo;
 int         yhi;
 imagestr  * sim;
 imagestr  * dim;
 ximagestr * sxim;
 ximagestr * dxim;

 err=setupfilterarea(view,&sp,&ylo,&yhi);
 if(!err)
 {
  if(file->frames && file->framen)
  {
   sxim=file->frames[view->frame].xim;
   sim=(sxim->sim[IM]);

   longprocstart(NULL,0,yhi-ylo,view);

   err=viewdeleteimagefileframe(file,view->frame);

   undostart(sxim);

   if(undosteps) err=ximcopy(sxim,&dxim);
   else          dxim=sxim;

   if(!err)
   {
    dim=(dxim->sim[IM]);

    err=addnoise(dim,ylo,yhi,&sp,noiseamp,noisemode);

    if(undosteps)
    {
     if(err) ximtrash(&dxim);
     else
     {
      undolink(sxim,dxim);
      file->frames[view->frame].xim=dxim;
     }
    }
   }

   viewcreateimagefileframe(file,view->frame);
   refreshviewfileframe(file,view->frame);
   modifyview(view);

   longprocend();
  }
  freefilterarea(&sp);
 }

 return(err);
}



static os_error * noiseclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  noiseamp=tnoiseamp;
  noisemode=tnoisemode;
  fxaddnoise(menuview,menufile);
 }

 return(err);
}

static os_error * noiseredrawsub(wimp_w handle,wimp_redrawstr * redrawstr,
                                                                     int more)
{
 os_error * err;

 err=NULL;

 while(more)
 {
  redrawslider(redrawstr,0,handle,WIMPRED,tnoiseamp,MAXNOISE);
  err=wimp_get_rectangle(redrawstr,&more);
 }

 return(err);
}


static os_error * noiseredraw(wimp_w handle,uservalue userhandle)
{
 os_error     * err;
 wimp_redrawstr redrawstr;
 int            more;
 redrawstr.w=handle;
 err=wimp_redraw_wind(&redrawstr,&more);
 if(!err) err=noiseredrawsub(handle,&redrawstr,more);
 return(err);
 USE(userhandle);
}

static os_error * wrnoise(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdnoise(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}


static dbiconstr noiseicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL, 0,
				2,	NULL,         DBACTION, 0,   0,  DBCANCEL,ESCAPE,0,0,					NULL, 0,

    0, &tnoiseamp,   DBSLIDER,0,    0,      1,   -1, MAXNOISE, 0, NULL,   0,

    5, &tnoiseamp,   DBWRITE,  0,  DBASSOCINC, -1, -1, -1,  -1, rdnoise,wrnoise,

   11, &tnoiseamp,   DBINC   ,0,    0,      1,  -1, MAXNOISE,  0,  NULL,   0,
   14, &tnoiseamp,   DBDEC   ,0,    0,      1,  -1, MAXNOISE,  0,  NULL,   0,

    3, &tnoisemode,  DBTOGGLE,0,    0,      1,0,0,0,               NULL,   0,


   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};


static dboxstr noisebox=
{
 0,
 TNOISE,
 DBFIX,
 0,
 noiseclose,
 NULL,
 NULL,
 noiseredraw,
 noiseicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * fxopennoise(wimp_w parent)
{
 os_error * err;

 tnoiseamp=noiseamp;
 tnoisemode=noisemode;

 if(noisebox.handle) dbclose(&noisebox,DBCANCEL);
 err=dodboxparent(&noisebox,1,parent);

 return(err);
}


/***************************************************************************/


static int filterid[]=
{
 0,           /* user filters */
 ID_FILTER_INVERT,
 ID_FILTER_HISTOGRAM,
 ID_FILTER_MAXIMUM,
 ID_FILTER_MINIMUM,
 ID_FILTER_MEDIAN,
 ID_FILTER_AVERAGE,
 ID_FILTER_NOISE
};




os_error * filtersetup(void)
{
 int unshade;
 int i;

 unshade=(menufile->frames && menufile->framen);

 for(i=1;i<8;i++)
 {
  unshademenust(MFILTER,filterid[i],unshade);
 }

 return(NULL);
}



os_error * filterdynamic(int * menu,char * handle)
{
 os_error * err;

 err=NULL;

 switch(menu[0])
 {
  case -1:
         filtersetup();
         err=userdynamic(menu+1,handle);
         break;

 }

 return(err);
}




os_error * filterdecode(int * menu,wimp_w handle)
{
 os_error * err;

 err=NULL;

 cprintf("filter decode %d",menu[0]);

 switch(menu[0])
 {
  case 0:           /* user filters */
         err=userdecode(menu+1,handle);
         break;

  case ID_FILTER_INVERT:           /* invert */
         err=mapfx(menuview,menufile,MIMINVERT);
         break;

  case ID_FILTER_HISTOGRAM:
         err=histogram(menuview->handle);
         break;

  case ID_FILTER_MAXIMUM:
         err=medfx(menuview,menufile,MMMAX);
         break;

  case ID_FILTER_MINIMUM:
         err=medfx(menuview,menufile,MMMIN);
         break;

  case ID_FILTER_MEDIAN:
         err=medfx(menuview,menufile,MMMED);
         break;

  case ID_FILTER_AVERAGE:
         err=medfx(menuview,menufile,MMAV);
         break;

  case ID_FILTER_NOISE:
         err=fxopennoise(menuview->handle);
         break;

 }
 return(err);
}

